<?php


/**
 * Base class that represents a query for the 'security_loginFailure' table.
 *
 * Fallas de ingreso
 *
 * @method LoginFailureQuery orderById($order = Criteria::ASC) Order by the id column
 * @method LoginFailureQuery orderByUsername($order = Criteria::ASC) Order by the username column
 * @method LoginFailureQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method LoginFailureQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method LoginFailureQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method LoginFailureQuery orderByIp($order = Criteria::ASC) Order by the ip column
 * @method LoginFailureQuery orderByAttemptat($order = Criteria::ASC) Order by the attemptAt column
 * @method LoginFailureQuery orderByBlocked($order = Criteria::ASC) Order by the blocked column
 *
 * @method LoginFailureQuery groupById() Group by the id column
 * @method LoginFailureQuery groupByUsername() Group by the username column
 * @method LoginFailureQuery groupByPassword() Group by the password column
 * @method LoginFailureQuery groupByObjecttype() Group by the objectType column
 * @method LoginFailureQuery groupByObjectid() Group by the objectId column
 * @method LoginFailureQuery groupByIp() Group by the ip column
 * @method LoginFailureQuery groupByAttemptat() Group by the attemptAt column
 * @method LoginFailureQuery groupByBlocked() Group by the blocked column
 *
 * @method LoginFailureQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method LoginFailureQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method LoginFailureQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method LoginFailure findOne(PropelPDO $con = null) Return the first LoginFailure matching the query
 * @method LoginFailure findOneOrCreate(PropelPDO $con = null) Return the first LoginFailure matching the query, or a new LoginFailure object populated from the query conditions when no match is found
 *
 * @method LoginFailure findOneById(int $id) Return the first LoginFailure filtered by the id column
 * @method LoginFailure findOneByUsername(string $username) Return the first LoginFailure filtered by the username column
 * @method LoginFailure findOneByPassword(string $password) Return the first LoginFailure filtered by the password column
 * @method LoginFailure findOneByObjecttype(string $objectType) Return the first LoginFailure filtered by the objectType column
 * @method LoginFailure findOneByObjectid(int $objectId) Return the first LoginFailure filtered by the objectId column
 * @method LoginFailure findOneByIp(string $ip) Return the first LoginFailure filtered by the ip column
 * @method LoginFailure findOneByAttemptat(string $attemptAt) Return the first LoginFailure filtered by the attemptAt column
 * @method LoginFailure findOneByBlocked(boolean $blocked) Return the first LoginFailure filtered by the blocked column
 *
 * @method array findById(int $id) Return LoginFailure objects filtered by the id column
 * @method array findByUsername(string $username) Return LoginFailure objects filtered by the username column
 * @method array findByPassword(string $password) Return LoginFailure objects filtered by the password column
 * @method array findByObjecttype(string $objectType) Return LoginFailure objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return LoginFailure objects filtered by the objectId column
 * @method array findByIp(string $ip) Return LoginFailure objects filtered by the ip column
 * @method array findByAttemptat(string $attemptAt) Return LoginFailure objects filtered by the attemptAt column
 * @method array findByBlocked(boolean $blocked) Return LoginFailure objects filtered by the blocked column
 *
 * @package    propel.generator.security.classes.om
 */
abstract class BaseLoginFailureQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseLoginFailureQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'LoginFailure', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new LoginFailureQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     LoginFailureQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return LoginFailureQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof LoginFailureQuery) {
            return $criteria;
        }
        $query = new LoginFailureQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   LoginFailure|LoginFailure[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = LoginFailurePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(LoginFailurePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   LoginFailure A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `USERNAME`, `PASSWORD`, `OBJECTTYPE`, `OBJECTID`, `IP`, `ATTEMPTAT`, `BLOCKED` FROM `security_loginFailure` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new LoginFailure();
            $obj->hydrate($row);
            LoginFailurePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return LoginFailure|LoginFailure[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|LoginFailure[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(LoginFailurePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(LoginFailurePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(LoginFailurePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the username column
     *
     * Example usage:
     * <code>
     * $query->filterByUsername('fooValue');   // WHERE username = 'fooValue'
     * $query->filterByUsername('%fooValue%'); // WHERE username LIKE '%fooValue%'
     * </code>
     *
     * @param     string $username The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByUsername($username = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($username)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $username)) {
                $username = str_replace('*', '%', $username);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::USERNAME, $username, $comparison);
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%'); // WHERE password LIKE '%fooValue%'
     * </code>
     *
     * @param     string $password The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByPassword($password = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $password)) {
                $password = str_replace('*', '%', $password);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::PASSWORD, $password, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(LoginFailurePeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(LoginFailurePeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the ip column
     *
     * Example usage:
     * <code>
     * $query->filterByIp('fooValue');   // WHERE ip = 'fooValue'
     * $query->filterByIp('%fooValue%'); // WHERE ip LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ip The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByIp($ip = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ip)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ip)) {
                $ip = str_replace('*', '%', $ip);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::IP, $ip, $comparison);
    }

    /**
     * Filter the query on the attemptAt column
     *
     * Example usage:
     * <code>
     * $query->filterByAttemptat('2011-03-14'); // WHERE attemptAt = '2011-03-14'
     * $query->filterByAttemptat('now'); // WHERE attemptAt = '2011-03-14'
     * $query->filterByAttemptat(array('max' => 'yesterday')); // WHERE attemptAt > '2011-03-13'
     * </code>
     *
     * @param     mixed $attemptat The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByAttemptat($attemptat = null, $comparison = null)
    {
        if (is_array($attemptat)) {
            $useMinMax = false;
            if (isset($attemptat['min'])) {
                $this->addUsingAlias(LoginFailurePeer::ATTEMPTAT, $attemptat['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($attemptat['max'])) {
                $this->addUsingAlias(LoginFailurePeer::ATTEMPTAT, $attemptat['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LoginFailurePeer::ATTEMPTAT, $attemptat, $comparison);
    }

    /**
     * Filter the query on the blocked column
     *
     * Example usage:
     * <code>
     * $query->filterByBlocked(true); // WHERE blocked = true
     * $query->filterByBlocked('yes'); // WHERE blocked = true
     * </code>
     *
     * @param     boolean|string $blocked The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function filterByBlocked($blocked = null, $comparison = null)
    {
        if (is_string($blocked)) {
            $blocked = in_array(strtolower($blocked), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(LoginFailurePeer::BLOCKED, $blocked, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   LoginFailure $loginFailure Object to remove from the list of results
     *
     * @return LoginFailureQuery The current query, for fluid interface
     */
    public function prune($loginFailure = null)
    {
        if ($loginFailure) {
            $this->addUsingAlias(LoginFailurePeer::ID, $loginFailure->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
