<?php

/**
 * SecurityBlockedIpsListAction
 *
 * Listado de IPs bloquadas extendiendo BaseListAction
 *
 * @package security
 */

class SecurityBlockedIpsListAction extends BaseListAction {
	
	function __construct() {
		parent::__construct('BlockedIp');
	}
	
 /**
	* Acciones a ejecutar antes de obtener la coleccion de objetos
	*/
	protected function preList() {
		parent::preList();

		//aplicar filtros internos
		if (!isset($_GET['filters']['history']))
			$this->filters['selectDistinctIp'] = true;
		$this->filters['orderByBlockedat'] = "desc";
	
	}

 /**
	* Acciones a ejecutar despues de obtener la coleccion de objetos
	*/
	protected function postList() {

		//Deseteo filtros internos
		unset($this->filters['selectDistinctIp']);
		unset($this->filters['orderByBlockedat']);

		parent::postList();
		
	}

}
