<?php


/**
 * Base class that represents a row from the 'resources_resource' table.
 *
 * Recursos
 *
 * @package    propel.generator.resources.classes.om
 */
abstract class BaseResource extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ResourcePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ResourcePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     * @var        string
     */
    protected $title;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the path field.
     * @var        string
     */
    protected $path;

    /**
     * @var        PropelObjectCollection|InspectionPhoto[] Collection to store aggregation of InspectionPhoto objects.
     */
    protected $collInspectionPhotos;
    protected $collInspectionPhotosPartial;

    /**
     * @var        PropelObjectCollection|Inspection[] Collection to store aggregation of Inspection objects.
     */
    protected $collInspections;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $inspectionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $inspectionPhotosScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion del recurso
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     * Titulo
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [description] column value.
     * Descripcion
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [path] column value.
     * URI del recurso
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Set the value of [id] column.
     * Identificacion del recurso
     * @param int $v new value
     * @return Resource The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ResourcePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [title] column.
     * Titulo
     * @param string $v new value
     * @return Resource The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[] = ResourcePeer::TITLE;
        }


        return $this;
    } // setTitle()

    /**
     * Set the value of [description] column.
     * Descripcion
     * @param string $v new value
     * @return Resource The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ResourcePeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [path] column.
     * URI del recurso
     * @param string $v new value
     * @return Resource The current object (for fluent API support)
     */
    public function setPath($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->path !== $v) {
            $this->path = $v;
            $this->modifiedColumns[] = ResourcePeer::PATH;
        }


        return $this;
    } // setPath()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->title = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->description = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->path = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 4; // 4 = ResourcePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Resource object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResourcePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ResourcePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collInspectionPhotos = null;

            $this->collInspections = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResourcePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ResourceQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResourcePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ResourcePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->inspectionsScheduledForDeletion !== null) {
                if (!$this->inspectionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->inspectionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    InspectionPhotoQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->inspectionsScheduledForDeletion = null;
                }

                foreach ($this->getInspections() as $inspection) {
                    if ($inspection->isModified()) {
                        $inspection->save($con);
                    }
                }
            }

            if ($this->inspectionPhotosScheduledForDeletion !== null) {
                if (!$this->inspectionPhotosScheduledForDeletion->isEmpty()) {
                    InspectionPhotoQuery::create()
                        ->filterByPrimaryKeys($this->inspectionPhotosScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->inspectionPhotosScheduledForDeletion = null;
                }
            }

            if ($this->collInspectionPhotos !== null) {
                foreach ($this->collInspectionPhotos as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ResourcePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ResourcePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ResourcePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ResourcePeer::TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`TITLE`';
        }
        if ($this->isColumnModified(ResourcePeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ResourcePeer::PATH)) {
            $modifiedColumns[':p' . $index++]  = '`PATH`';
        }

        $sql = sprintf(
            'INSERT INTO `resources_resource` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`TITLE`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`PATH`':
                        $stmt->bindValue($identifier, $this->path, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = ResourcePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collInspectionPhotos !== null) {
                    foreach ($this->collInspectionPhotos as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ResourcePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getTitle();
                break;
            case 2:
                return $this->getDescription();
                break;
            case 3:
                return $this->getPath();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Resource'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Resource'][$this->getPrimaryKey()] = true;
        $keys = ResourcePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getDescription(),
            $keys[3] => $this->getPath(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collInspectionPhotos) {
                $result['InspectionPhotos'] = $this->collInspectionPhotos->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ResourcePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setDescription($value);
                break;
            case 3:
                $this->setPath($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ResourcePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setTitle($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setDescription($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setPath($arr[$keys[3]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ResourcePeer::DATABASE_NAME);

        if ($this->isColumnModified(ResourcePeer::ID)) $criteria->add(ResourcePeer::ID, $this->id);
        if ($this->isColumnModified(ResourcePeer::TITLE)) $criteria->add(ResourcePeer::TITLE, $this->title);
        if ($this->isColumnModified(ResourcePeer::DESCRIPTION)) $criteria->add(ResourcePeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ResourcePeer::PATH)) $criteria->add(ResourcePeer::PATH, $this->path);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ResourcePeer::DATABASE_NAME);
        $criteria->add(ResourcePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Resource (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setPath($this->getPath());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getInspectionPhotos() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addInspectionPhoto($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Resource Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ResourcePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ResourcePeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('InspectionPhoto' == $relationName) {
            $this->initInspectionPhotos();
        }
    }

    /**
     * Clears out the collInspectionPhotos collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addInspectionPhotos()
     */
    public function clearInspectionPhotos()
    {
        $this->collInspectionPhotos = null; // important to set this to null since that means it is uninitialized
        $this->collInspectionPhotosPartial = null;
    }

    /**
     * reset is the collInspectionPhotos collection loaded partially
     *
     * @return void
     */
    public function resetPartialInspectionPhotos($v = true)
    {
        $this->collInspectionPhotosPartial = $v;
    }

    /**
     * Initializes the collInspectionPhotos collection.
     *
     * By default this just sets the collInspectionPhotos collection to an empty array (like clearcollInspectionPhotos());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initInspectionPhotos($overrideExisting = true)
    {
        if (null !== $this->collInspectionPhotos && !$overrideExisting) {
            return;
        }
        $this->collInspectionPhotos = new PropelObjectCollection();
        $this->collInspectionPhotos->setModel('InspectionPhoto');
    }

    /**
     * Gets an array of InspectionPhoto objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Resource is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|InspectionPhoto[] List of InspectionPhoto objects
     * @throws PropelException
     */
    public function getInspectionPhotos($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collInspectionPhotosPartial && !$this->isNew();
        if (null === $this->collInspectionPhotos || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collInspectionPhotos) {
                // return empty collection
                $this->initInspectionPhotos();
            } else {
                $collInspectionPhotos = InspectionPhotoQuery::create(null, $criteria)
                    ->filterByResource($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collInspectionPhotosPartial && count($collInspectionPhotos)) {
                      $this->initInspectionPhotos(false);

                      foreach($collInspectionPhotos as $obj) {
                        if (false == $this->collInspectionPhotos->contains($obj)) {
                          $this->collInspectionPhotos->append($obj);
                        }
                      }

                      $this->collInspectionPhotosPartial = true;
                    }

                    return $collInspectionPhotos;
                }

                if($partial && $this->collInspectionPhotos) {
                    foreach($this->collInspectionPhotos as $obj) {
                        if($obj->isNew()) {
                            $collInspectionPhotos[] = $obj;
                        }
                    }
                }

                $this->collInspectionPhotos = $collInspectionPhotos;
                $this->collInspectionPhotosPartial = false;
            }
        }

        return $this->collInspectionPhotos;
    }

    /**
     * Sets a collection of InspectionPhoto objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $inspectionPhotos A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setInspectionPhotos(PropelCollection $inspectionPhotos, PropelPDO $con = null)
    {
        $this->inspectionPhotosScheduledForDeletion = $this->getInspectionPhotos(new Criteria(), $con)->diff($inspectionPhotos);

        foreach ($this->inspectionPhotosScheduledForDeletion as $inspectionPhotoRemoved) {
            $inspectionPhotoRemoved->setResource(null);
        }

        $this->collInspectionPhotos = null;
        foreach ($inspectionPhotos as $inspectionPhoto) {
            $this->addInspectionPhoto($inspectionPhoto);
        }

        $this->collInspectionPhotos = $inspectionPhotos;
        $this->collInspectionPhotosPartial = false;
    }

    /**
     * Returns the number of related InspectionPhoto objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related InspectionPhoto objects.
     * @throws PropelException
     */
    public function countInspectionPhotos(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collInspectionPhotosPartial && !$this->isNew();
        if (null === $this->collInspectionPhotos || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collInspectionPhotos) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getInspectionPhotos());
                }
                $query = InspectionPhotoQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByResource($this)
                    ->count($con);
            }
        } else {
            return count($this->collInspectionPhotos);
        }
    }

    /**
     * Method called to associate a InspectionPhoto object to this object
     * through the InspectionPhoto foreign key attribute.
     *
     * @param    InspectionPhoto $l InspectionPhoto
     * @return Resource The current object (for fluent API support)
     */
    public function addInspectionPhoto(InspectionPhoto $l)
    {
        if ($this->collInspectionPhotos === null) {
            $this->initInspectionPhotos();
            $this->collInspectionPhotosPartial = true;
        }
        if (!$this->collInspectionPhotos->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddInspectionPhoto($l);
        }

        return $this;
    }

    /**
     * @param	InspectionPhoto $inspectionPhoto The inspectionPhoto object to add.
     */
    protected function doAddInspectionPhoto($inspectionPhoto)
    {
        $this->collInspectionPhotos[]= $inspectionPhoto;
        $inspectionPhoto->setResource($this);
    }

    /**
     * @param	InspectionPhoto $inspectionPhoto The inspectionPhoto object to remove.
     */
    public function removeInspectionPhoto($inspectionPhoto)
    {
        if ($this->getInspectionPhotos()->contains($inspectionPhoto)) {
            $this->collInspectionPhotos->remove($this->collInspectionPhotos->search($inspectionPhoto));
            if (null === $this->inspectionPhotosScheduledForDeletion) {
                $this->inspectionPhotosScheduledForDeletion = clone $this->collInspectionPhotos;
                $this->inspectionPhotosScheduledForDeletion->clear();
            }
            $this->inspectionPhotosScheduledForDeletion[]= $inspectionPhoto;
            $inspectionPhoto->setResource(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Resource is new, it will return
     * an empty collection; or if this Resource has previously
     * been saved, it will retrieve related InspectionPhotos from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Resource.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|InspectionPhoto[] List of InspectionPhoto objects
     */
    public function getInspectionPhotosJoinInspection($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = InspectionPhotoQuery::create(null, $criteria);
        $query->joinWith('Inspection', $join_behavior);

        return $this->getInspectionPhotos($query, $con);
    }

    /**
     * Clears out the collInspections collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addInspections()
     */
    public function clearInspections()
    {
        $this->collInspections = null; // important to set this to null since that means it is uninitialized
        $this->collInspectionsPartial = null;
    }

    /**
     * Initializes the collInspections collection.
     *
     * By default this just sets the collInspections collection to an empty collection (like clearInspections());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initInspections()
    {
        $this->collInspections = new PropelObjectCollection();
        $this->collInspections->setModel('Inspection');
    }

    /**
     * Gets a collection of Inspection objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Resource is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Inspection[] List of Inspection objects
     */
    public function getInspections($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collInspections || null !== $criteria) {
            if ($this->isNew() && null === $this->collInspections) {
                // return empty collection
                $this->initInspections();
            } else {
                $collInspections = InspectionQuery::create(null, $criteria)
                    ->filterByResource($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collInspections;
                }
                $this->collInspections = $collInspections;
            }
        }

        return $this->collInspections;
    }

    /**
     * Sets a collection of Inspection objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $inspections A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setInspections(PropelCollection $inspections, PropelPDO $con = null)
    {
        $this->clearInspections();
        $currentInspections = $this->getInspections();

        $this->inspectionsScheduledForDeletion = $currentInspections->diff($inspections);

        foreach ($inspections as $inspection) {
            if (!$currentInspections->contains($inspection)) {
                $this->doAddInspection($inspection);
            }
        }

        $this->collInspections = $inspections;
    }

    /**
     * Gets the number of Inspection objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Inspection objects
     */
    public function countInspections($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collInspections || null !== $criteria) {
            if ($this->isNew() && null === $this->collInspections) {
                return 0;
            } else {
                $query = InspectionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByResource($this)
                    ->count($con);
            }
        } else {
            return count($this->collInspections);
        }
    }

    /**
     * Associate a Inspection object to this object
     * through the constructions_inspectionPhoto cross reference table.
     *
     * @param  Inspection $inspection The InspectionPhoto object to relate
     * @return void
     */
    public function addInspection(Inspection $inspection)
    {
        if ($this->collInspections === null) {
            $this->initInspections();
        }
        if (!$this->collInspections->contains($inspection)) { // only add it if the **same** object is not already associated
            $this->doAddInspection($inspection);

            $this->collInspections[]= $inspection;
        }
    }

    /**
     * @param	Inspection $inspection The inspection object to add.
     */
    protected function doAddInspection($inspection)
    {
        $inspectionPhoto = new InspectionPhoto();
        $inspectionPhoto->setInspection($inspection);
        $this->addInspectionPhoto($inspectionPhoto);
    }

    /**
     * Remove a Inspection object to this object
     * through the constructions_inspectionPhoto cross reference table.
     *
     * @param Inspection $inspection The InspectionPhoto object to relate
     * @return void
     */
    public function removeInspection(Inspection $inspection)
    {
        if ($this->getInspections()->contains($inspection)) {
            $this->collInspections->remove($this->collInspections->search($inspection));
            if (null === $this->inspectionsScheduledForDeletion) {
                $this->inspectionsScheduledForDeletion = clone $this->collInspections;
                $this->inspectionsScheduledForDeletion->clear();
            }
            $this->inspectionsScheduledForDeletion[]= $inspection;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->title = null;
        $this->description = null;
        $this->path = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collInspectionPhotos) {
                foreach ($this->collInspectionPhotos as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collInspections) {
                foreach ($this->collInspections as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collInspectionPhotos instanceof PropelCollection) {
            $this->collInspectionPhotos->clearIterator();
        }
        $this->collInspectionPhotos = null;
        if ($this->collInspections instanceof PropelCollection) {
            $this->collInspections->clearIterator();
        }
        $this->collInspections = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ResourcePeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
