<?php



/**
 * This class defines the structure of the 'regions_region' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.regions.classes.map
 */
class RegionTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'regions.classes.map.RegionTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('regions_region');
        $this->setPhpName('Region');
        $this->setClassname('Region');
        $this->setPackage('regions.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 100, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('TYPE', 'Type', 'INTEGER', true, 2, null);
        $this->addColumn('POSTALCODE', 'Postalcode', 'INTEGER', false, 6, null);
        $this->addColumn('LATITUDE', 'Latitude', 'NUMERIC', false, 12, null);
        $this->addColumn('LONGITUDE', 'Longitude', 'NUMERIC', false, 12, null);
        $this->addColumn('POPULATION', 'Population', 'DOUBLE', false, null, null);
        $this->addColumn('POPULATIONYEAR', 'Populationyear', 'INTEGER', false, null, null);
        $this->addColumn('AREA', 'Area', 'DOUBLE', false, null, null);
        $this->addColumn('CAPITAL', 'Capital', 'VARCHAR', false, 100, null);
        $this->addColumn('TREE_LEFT', 'TreeLeft', 'INTEGER', false, null, null);
        $this->addColumn('TREE_RIGHT', 'TreeRight', 'INTEGER', false, null, null);
        $this->addColumn('TREE_LEVEL', 'TreeLevel', 'INTEGER', false, null, null);
        $this->addColumn('SCOPE', 'Scope', 'INTEGER', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Construction', 'Construction', RelationMap::ONE_TO_MANY, array('id' => 'regionId', ), 'CASCADE', null, 'Constructions');
        $this->addRelation('ObjectiveRegion', 'ObjectiveRegion', RelationMap::ONE_TO_MANY, array('id' => 'regionId', ), null, null, 'ObjectiveRegions');
        $this->addRelation('ProjectRegion', 'ProjectRegion', RelationMap::ONE_TO_MANY, array('id' => 'regionId', ), null, null, 'ProjectRegions');
        $this->addRelation('ProjectIndicator', 'ProjectIndicator', RelationMap::ONE_TO_MANY, array('id' => 'regionId', ), null, null, 'ProjectIndicators');
        $this->addRelation('RegionPoint', 'RegionPoint', RelationMap::ONE_TO_MANY, array('id' => 'regionId', ), null, null, 'RegionPoints');
        $this->addRelation('Objective', 'Objective', RelationMap::MANY_TO_MANY, array(), null, null, 'Objectives');
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_MANY, array(), null, null, 'Projects');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'nested_set' => array('left_column' => 'tree_left', 'right_column' => 'tree_right', 'level_column' => 'tree_level', 'use_scope' => 'true', 'scope_column' => 'scope', 'method_proxies' => 'false', ),
        );
    } // getBehaviors()

} // RegionTableMap
