<?php


/**
 * Base class that represents a query for the 'projects_project' table.
 *
 * Project
 *
 * @method ProjectQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectQuery orderByObjectiveid($order = Criteria::ASC) Order by the objectiveId column
 * @method ProjectQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method ProjectQuery orderByCodeaux($order = Criteria::ASC) Order by the codeAux column
 * @method ProjectQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ProjectQuery orderByImpact($order = Criteria::ASC) Order by the impact column
 * @method ProjectQuery orderByUniquegoal($order = Criteria::ASC) Order by the uniqueGoal column
 * @method ProjectQuery orderByGoalexpirationdate($order = Criteria::ASC) Order by the goalExpirationDate column
 * @method ProjectQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectQuery orderByBudgetplanned($order = Criteria::ASC) Order by the budgetPlanned column
 * @method ProjectQuery orderByBudget($order = Criteria::ASC) Order by the budget column
 * @method ProjectQuery orderByExchangerate($order = Criteria::ASC) Order by the exchangeRate column
 * @method ProjectQuery orderByVisibility($order = Criteria::ASC) Order by the visibility column
 * @method ProjectQuery orderByCoordinateneed($order = Criteria::ASC) Order by the coordinateNeed column
 * @method ProjectQuery orderByFrequency($order = Criteria::ASC) Order by the frequency column
 * @method ProjectQuery orderByFinished($order = Criteria::ASC) Order by the finished column
 * @method ProjectQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectQuery orderByPostalcode($order = Criteria::ASC) Order by the postalCode column
 * @method ProjectQuery orderByUniquegoalnumeric($order = Criteria::ASC) Order by the uniqueGoalNumeric column
 * @method ProjectQuery orderByGoalprogress($order = Criteria::ASC) Order by the goalProgress column
 * @method ProjectQuery orderByLatitude($order = Criteria::ASC) Order by the latitude column
 * @method ProjectQuery orderByLongitude($order = Criteria::ASC) Order by the longitude column
 * @method ProjectQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method ProjectQuery orderByRegionid($order = Criteria::ASC) Order by the regionId column
 * @method ProjectQuery orderByOldregionid($order = Criteria::ASC) Order by the oldRegionId column
 * @method ProjectQuery orderByLastmodification($order = Criteria::ASC) Order by the lastModification column
 * @method ProjectQuery orderByAddress($order = Criteria::ASC) Order by the address column
 * @method ProjectQuery orderByStreet($order = Criteria::ASC) Order by the street column
 * @method ProjectQuery orderByNumber($order = Criteria::ASC) Order by the number column
 * @method ProjectQuery orderByPriority($order = Criteria::ASC) Order by the priority column
 * @method ProjectQuery orderByModifications($order = Criteria::ASC) Order by the modifications column
 * @method ProjectQuery orderByPlannedstart($order = Criteria::ASC) Order by the plannedStart column
 * @method ProjectQuery orderByPlannedend($order = Criteria::ASC) Order by the plannedEnd column
 * @method ProjectQuery orderByRealstart($order = Criteria::ASC) Order by the realStart column
 * @method ProjectQuery orderByRealend($order = Criteria::ASC) Order by the realEnd column
 * @method ProjectQuery orderByCancelled($order = Criteria::ASC) Order by the cancelled column
 * @method ProjectQuery orderByIsconstruction($order = Criteria::ASC) Order by the isConstruction column
 * @method ProjectQuery orderByRelevance($order = Criteria::ASC) Order by the relevance column
 * @method ProjectQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ProjectQuery orderByOrder($order = Criteria::ASC) Order by the order column
 * @method ProjectQuery orderByWeight($order = Criteria::ASC) Order by the weight column
 * @method ProjectQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ProjectQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 * @method ProjectQuery orderByIndicatorid($order = Criteria::ASC) Order by the indicatorId column
 * @method ProjectQuery orderByPrimarysource($order = Criteria::ASC) Order by the primarySource column
 * @method ProjectQuery orderByAdditionalsource($order = Criteria::ASC) Order by the additionalSource column
 * @method ProjectQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ProjectQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method ProjectQuery orderBySubproject($order = Criteria::ASC) Order by the subproject column
 * @method ProjectQuery orderByOngoing($order = Criteria::ASC) Order by the ongoing column
 * @method ProjectQuery orderByRelatedareas($order = Criteria::ASC) Order by the relatedAreas column
 * @method ProjectQuery orderByGoal($order = Criteria::ASC) Order by the goal column
 * @method ProjectQuery orderByLegal($order = Criteria::ASC) Order by the legal column
 * @method ProjectQuery orderByExecresp($order = Criteria::ASC) Order by the execResp column
 * @method ProjectQuery orderByExectenure($order = Criteria::ASC) Order by the execTenure column
 * @method ProjectQuery orderByExecdependency($order = Criteria::ASC) Order by the execDependency column
 * @method ProjectQuery orderByExeccontact($order = Criteria::ASC) Order by the execContact column
 * @method ProjectQuery orderBySubsecretary($order = Criteria::ASC) Order by the subsecretary column
 * @method ProjectQuery orderByBudgetrequested($order = Criteria::ASC) Order by the budgetRequested column
 * @method ProjectQuery orderByBudgetsanctioned($order = Criteria::ASC) Order by the budgetSanctioned column
 * @method ProjectQuery orderByBelgrano($order = Criteria::ASC) Order by the belgrano column
 * @method ProjectQuery orderByClasification($order = Criteria::ASC) Order by the clasification column
 * @method ProjectQuery orderByPress($order = Criteria::ASC) Order by the press column
 * @method ProjectQuery orderByPriorityarea($order = Criteria::ASC) Order by the priorityArea column
 * @method ProjectQuery orderByBeneficiario($order = Criteria::ASC) Order by the beneficiario column
 * @method ProjectQuery orderByRequirecontractor($order = Criteria::ASC) Order by the requireContractor column
 * @method ProjectQuery orderByPurchasetype($order = Criteria::ASC) Order by the purchaseType column
 * @method ProjectQuery orderByConstructiontype($order = Criteria::ASC) Order by the constructionType column
 * @method ProjectQuery orderByRequireexraresources($order = Criteria::ASC) Order by the requireExraResources column
 * @method ProjectQuery orderByImplementationpartner($order = Criteria::ASC) Order by the implementationPartner column
 * @method ProjectQuery orderByRiskfactors($order = Criteria::ASC) Order by the riskFactors column
 * @method ProjectQuery orderByOwnfinance($order = Criteria::ASC) Order by the ownFinance column
 * @method ProjectQuery orderByProvincefinance($order = Criteria::ASC) Order by the provinceFinance column
 * @method ProjectQuery orderByNationfinance($order = Criteria::ASC) Order by the nationFinance column
 * @method ProjectQuery orderByOtherfinance($order = Criteria::ASC) Order by the otherFinance column
 * @method ProjectQuery orderByFinancedetail($order = Criteria::ASC) Order by the financeDetail column
 * @method ProjectQuery orderByFinanceprogram($order = Criteria::ASC) Order by the financeProgram column
 * @method ProjectQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method ProjectQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 * @method ProjectQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ProjectQuery groupById() Group by the id column
 * @method ProjectQuery groupByObjectiveid() Group by the objectiveId column
 * @method ProjectQuery groupByCode() Group by the code column
 * @method ProjectQuery groupByCodeaux() Group by the codeAux column
 * @method ProjectQuery groupByName() Group by the name column
 * @method ProjectQuery groupByDescription() Group by the description column
 * @method ProjectQuery groupByImpact() Group by the impact column
 * @method ProjectQuery groupByUniquegoal() Group by the uniqueGoal column
 * @method ProjectQuery groupByGoalexpirationdate() Group by the goalExpirationDate column
 * @method ProjectQuery groupByDate() Group by the date column
 * @method ProjectQuery groupByBudgetplanned() Group by the budgetPlanned column
 * @method ProjectQuery groupByBudget() Group by the budget column
 * @method ProjectQuery groupByExchangerate() Group by the exchangeRate column
 * @method ProjectQuery groupByVisibility() Group by the visibility column
 * @method ProjectQuery groupByCoordinateneed() Group by the coordinateNeed column
 * @method ProjectQuery groupByFrequency() Group by the frequency column
 * @method ProjectQuery groupByFinished() Group by the finished column
 * @method ProjectQuery groupByNotes() Group by the notes column
 * @method ProjectQuery groupByPostalcode() Group by the postalCode column
 * @method ProjectQuery groupByUniquegoalnumeric() Group by the uniqueGoalNumeric column
 * @method ProjectQuery groupByGoalprogress() Group by the goalProgress column
 * @method ProjectQuery groupByLatitude() Group by the latitude column
 * @method ProjectQuery groupByLongitude() Group by the longitude column
 * @method ProjectQuery groupByOldid() Group by the oldId column
 * @method ProjectQuery groupByRegionid() Group by the regionId column
 * @method ProjectQuery groupByOldregionid() Group by the oldRegionId column
 * @method ProjectQuery groupByLastmodification() Group by the lastModification column
 * @method ProjectQuery groupByAddress() Group by the address column
 * @method ProjectQuery groupByStreet() Group by the street column
 * @method ProjectQuery groupByNumber() Group by the number column
 * @method ProjectQuery groupByPriority() Group by the priority column
 * @method ProjectQuery groupByModifications() Group by the modifications column
 * @method ProjectQuery groupByPlannedstart() Group by the plannedStart column
 * @method ProjectQuery groupByPlannedend() Group by the plannedEnd column
 * @method ProjectQuery groupByRealstart() Group by the realStart column
 * @method ProjectQuery groupByRealend() Group by the realEnd column
 * @method ProjectQuery groupByCancelled() Group by the cancelled column
 * @method ProjectQuery groupByIsconstruction() Group by the isConstruction column
 * @method ProjectQuery groupByRelevance() Group by the relevance column
 * @method ProjectQuery groupByUserid() Group by the userId column
 * @method ProjectQuery groupByOrder() Group by the order column
 * @method ProjectQuery groupByWeight() Group by the weight column
 * @method ProjectQuery groupByUpdated() Group by the updated column
 * @method ProjectQuery groupByResponsiblecode() Group by the responsibleCode column
 * @method ProjectQuery groupByIndicatorid() Group by the indicatorId column
 * @method ProjectQuery groupByPrimarysource() Group by the primarySource column
 * @method ProjectQuery groupByAdditionalsource() Group by the additionalSource column
 * @method ProjectQuery groupByStartingyear() Group by the startingYear column
 * @method ProjectQuery groupByEndingyear() Group by the endingYear column
 * @method ProjectQuery groupBySubproject() Group by the subproject column
 * @method ProjectQuery groupByOngoing() Group by the ongoing column
 * @method ProjectQuery groupByRelatedareas() Group by the relatedAreas column
 * @method ProjectQuery groupByGoal() Group by the goal column
 * @method ProjectQuery groupByLegal() Group by the legal column
 * @method ProjectQuery groupByExecresp() Group by the execResp column
 * @method ProjectQuery groupByExectenure() Group by the execTenure column
 * @method ProjectQuery groupByExecdependency() Group by the execDependency column
 * @method ProjectQuery groupByExeccontact() Group by the execContact column
 * @method ProjectQuery groupBySubsecretary() Group by the subsecretary column
 * @method ProjectQuery groupByBudgetrequested() Group by the budgetRequested column
 * @method ProjectQuery groupByBudgetsanctioned() Group by the budgetSanctioned column
 * @method ProjectQuery groupByBelgrano() Group by the belgrano column
 * @method ProjectQuery groupByClasification() Group by the clasification column
 * @method ProjectQuery groupByPress() Group by the press column
 * @method ProjectQuery groupByPriorityarea() Group by the priorityArea column
 * @method ProjectQuery groupByBeneficiario() Group by the beneficiario column
 * @method ProjectQuery groupByRequirecontractor() Group by the requireContractor column
 * @method ProjectQuery groupByPurchasetype() Group by the purchaseType column
 * @method ProjectQuery groupByConstructiontype() Group by the constructionType column
 * @method ProjectQuery groupByRequireexraresources() Group by the requireExraResources column
 * @method ProjectQuery groupByImplementationpartner() Group by the implementationPartner column
 * @method ProjectQuery groupByRiskfactors() Group by the riskFactors column
 * @method ProjectQuery groupByOwnfinance() Group by the ownFinance column
 * @method ProjectQuery groupByProvincefinance() Group by the provinceFinance column
 * @method ProjectQuery groupByNationfinance() Group by the nationFinance column
 * @method ProjectQuery groupByOtherfinance() Group by the otherFinance column
 * @method ProjectQuery groupByFinancedetail() Group by the financeDetail column
 * @method ProjectQuery groupByFinanceprogram() Group by the financeProgram column
 * @method ProjectQuery groupByCreatedAt() Group by the created_at column
 * @method ProjectQuery groupByUpdatedAt() Group by the updated_at column
 * @method ProjectQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ProjectQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method ProjectQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method ProjectQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method ProjectQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ProjectQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ProjectQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ProjectQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method ProjectQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method ProjectQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method ProjectQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ProjectQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ProjectQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ProjectQuery leftJoinConstruction($relationAlias = null) Adds a LEFT JOIN clause to the query using the Construction relation
 * @method ProjectQuery rightJoinConstruction($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Construction relation
 * @method ProjectQuery innerJoinConstruction($relationAlias = null) Adds a INNER JOIN clause to the query using the Construction relation
 *
 * @method ProjectQuery leftJoinGuarantee($relationAlias = null) Adds a LEFT JOIN clause to the query using the Guarantee relation
 * @method ProjectQuery rightJoinGuarantee($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Guarantee relation
 * @method ProjectQuery innerJoinGuarantee($relationAlias = null) Adds a INNER JOIN clause to the query using the Guarantee relation
 *
 * @method ProjectQuery leftJoinAdministrativeAct($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdministrativeAct relation
 * @method ProjectQuery rightJoinAdministrativeAct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdministrativeAct relation
 * @method ProjectQuery innerJoinAdministrativeAct($relationAlias = null) Adds a INNER JOIN clause to the query using the AdministrativeAct relation
 *
 * @method ProjectQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method ProjectQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method ProjectQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method ProjectQuery leftJoinProjectRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectRegion relation
 * @method ProjectQuery rightJoinProjectRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectRegion relation
 * @method ProjectQuery innerJoinProjectRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectRegion relation
 *
 * @method ProjectQuery leftJoinProjectMilestone($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectMilestone relation
 * @method ProjectQuery rightJoinProjectMilestone($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectMilestone relation
 * @method ProjectQuery innerJoinProjectMilestone($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectMilestone relation
 *
 * @method ProjectQuery leftJoinProjectIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectIndicator relation
 * @method ProjectQuery rightJoinProjectIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectIndicator relation
 * @method ProjectQuery innerJoinProjectIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectIndicator relation
 *
 * @method ProjectQuery leftJoinProjectActivity($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivity relation
 * @method ProjectQuery rightJoinProjectActivity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivity relation
 * @method ProjectQuery innerJoinProjectActivity($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivity relation
 *
 * @method ProjectQuery leftJoinProjectDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectDocument relation
 * @method ProjectQuery rightJoinProjectDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectDocument relation
 * @method ProjectQuery innerJoinProjectDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectDocument relation
 *
 * @method ProjectQuery leftJoinProjectContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectContractor relation
 * @method ProjectQuery rightJoinProjectContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectContractor relation
 * @method ProjectQuery innerJoinProjectContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectContractor relation
 *
 * @method ProjectQuery leftJoinProjectLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectLog relation
 * @method ProjectQuery rightJoinProjectLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectLog relation
 * @method ProjectQuery innerJoinProjectLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectLog relation
 *
 * @method ProjectQuery leftJoinProjectMilestoneLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectMilestoneLog relation
 * @method ProjectQuery rightJoinProjectMilestoneLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectMilestoneLog relation
 * @method ProjectQuery innerJoinProjectMilestoneLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectMilestoneLog relation
 *
 * @method ProjectQuery leftJoinProjectActivityLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivityLog relation
 * @method ProjectQuery rightJoinProjectActivityLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivityLog relation
 * @method ProjectQuery innerJoinProjectActivityLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivityLog relation
 *
 * @method Project findOne(PropelPDO $con = null) Return the first Project matching the query
 * @method Project findOneOrCreate(PropelPDO $con = null) Return the first Project matching the query, or a new Project object populated from the query conditions when no match is found
 *
 * @method Project findOneById(int $id) Return the first Project filtered by the id column
 * @method Project findOneByObjectiveid(int $objectiveId) Return the first Project filtered by the objectiveId column
 * @method Project findOneByCode(string $code) Return the first Project filtered by the code column
 * @method Project findOneByCodeaux(string $codeAux) Return the first Project filtered by the codeAux column
 * @method Project findOneByName(string $name) Return the first Project filtered by the name column
 * @method Project findOneByDescription(string $description) Return the first Project filtered by the description column
 * @method Project findOneByImpact(string $impact) Return the first Project filtered by the impact column
 * @method Project findOneByUniquegoal(string $uniqueGoal) Return the first Project filtered by the uniqueGoal column
 * @method Project findOneByGoalexpirationdate(string $goalExpirationDate) Return the first Project filtered by the goalExpirationDate column
 * @method Project findOneByDate(string $date) Return the first Project filtered by the date column
 * @method Project findOneByBudgetplanned(double $budgetPlanned) Return the first Project filtered by the budgetPlanned column
 * @method Project findOneByBudget(double $budget) Return the first Project filtered by the budget column
 * @method Project findOneByExchangerate(double $exchangeRate) Return the first Project filtered by the exchangeRate column
 * @method Project findOneByVisibility(int $visibility) Return the first Project filtered by the visibility column
 * @method Project findOneByCoordinateneed(string $coordinateNeed) Return the first Project filtered by the coordinateNeed column
 * @method Project findOneByFrequency(string $frequency) Return the first Project filtered by the frequency column
 * @method Project findOneByFinished(boolean $finished) Return the first Project filtered by the finished column
 * @method Project findOneByNotes(string $notes) Return the first Project filtered by the notes column
 * @method Project findOneByPostalcode(string $postalCode) Return the first Project filtered by the postalCode column
 * @method Project findOneByUniquegoalnumeric(int $uniqueGoalNumeric) Return the first Project filtered by the uniqueGoalNumeric column
 * @method Project findOneByGoalprogress(int $goalProgress) Return the first Project filtered by the goalProgress column
 * @method Project findOneByLatitude(double $latitude) Return the first Project filtered by the latitude column
 * @method Project findOneByLongitude(double $longitude) Return the first Project filtered by the longitude column
 * @method Project findOneByOldid(int $oldId) Return the first Project filtered by the oldId column
 * @method Project findOneByRegionid(int $regionId) Return the first Project filtered by the regionId column
 * @method Project findOneByOldregionid(int $oldRegionId) Return the first Project filtered by the oldRegionId column
 * @method Project findOneByLastmodification(string $lastModification) Return the first Project filtered by the lastModification column
 * @method Project findOneByAddress(string $address) Return the first Project filtered by the address column
 * @method Project findOneByStreet(string $street) Return the first Project filtered by the street column
 * @method Project findOneByNumber(int $number) Return the first Project filtered by the number column
 * @method Project findOneByPriority(int $priority) Return the first Project filtered by the priority column
 * @method Project findOneByModifications(int $modifications) Return the first Project filtered by the modifications column
 * @method Project findOneByPlannedstart(string $plannedStart) Return the first Project filtered by the plannedStart column
 * @method Project findOneByPlannedend(string $plannedEnd) Return the first Project filtered by the plannedEnd column
 * @method Project findOneByRealstart(string $realStart) Return the first Project filtered by the realStart column
 * @method Project findOneByRealend(string $realEnd) Return the first Project filtered by the realEnd column
 * @method Project findOneByCancelled(boolean $cancelled) Return the first Project filtered by the cancelled column
 * @method Project findOneByIsconstruction(boolean $isConstruction) Return the first Project filtered by the isConstruction column
 * @method Project findOneByRelevance(string $relevance) Return the first Project filtered by the relevance column
 * @method Project findOneByUserid(int $userId) Return the first Project filtered by the userId column
 * @method Project findOneByOrder(int $order) Return the first Project filtered by the order column
 * @method Project findOneByWeight(string $weight) Return the first Project filtered by the weight column
 * @method Project findOneByUpdated(string $updated) Return the first Project filtered by the updated column
 * @method Project findOneByResponsiblecode(int $responsibleCode) Return the first Project filtered by the responsibleCode column
 * @method Project findOneByIndicatorid(int $indicatorId) Return the first Project filtered by the indicatorId column
 * @method Project findOneByPrimarysource(string $primarySource) Return the first Project filtered by the primarySource column
 * @method Project findOneByAdditionalsource(string $additionalSource) Return the first Project filtered by the additionalSource column
 * @method Project findOneByStartingyear(int $startingYear) Return the first Project filtered by the startingYear column
 * @method Project findOneByEndingyear(int $endingYear) Return the first Project filtered by the endingYear column
 * @method Project findOneBySubproject(string $subproject) Return the first Project filtered by the subproject column
 * @method Project findOneByOngoing(string $ongoing) Return the first Project filtered by the ongoing column
 * @method Project findOneByRelatedareas(string $relatedAreas) Return the first Project filtered by the relatedAreas column
 * @method Project findOneByGoal(string $goal) Return the first Project filtered by the goal column
 * @method Project findOneByLegal(string $legal) Return the first Project filtered by the legal column
 * @method Project findOneByExecresp(string $execResp) Return the first Project filtered by the execResp column
 * @method Project findOneByExectenure(string $execTenure) Return the first Project filtered by the execTenure column
 * @method Project findOneByExecdependency(string $execDependency) Return the first Project filtered by the execDependency column
 * @method Project findOneByExeccontact(string $execContact) Return the first Project filtered by the execContact column
 * @method Project findOneBySubsecretary(string $subsecretary) Return the first Project filtered by the subsecretary column
 * @method Project findOneByBudgetrequested(double $budgetRequested) Return the first Project filtered by the budgetRequested column
 * @method Project findOneByBudgetsanctioned(double $budgetSanctioned) Return the first Project filtered by the budgetSanctioned column
 * @method Project findOneByBelgrano(boolean $belgrano) Return the first Project filtered by the belgrano column
 * @method Project findOneByClasification(int $clasification) Return the first Project filtered by the clasification column
 * @method Project findOneByPress(boolean $press) Return the first Project filtered by the press column
 * @method Project findOneByPriorityarea(int $priorityArea) Return the first Project filtered by the priorityArea column
 * @method Project findOneByBeneficiario(string $beneficiario) Return the first Project filtered by the beneficiario column
 * @method Project findOneByRequirecontractor(boolean $requireContractor) Return the first Project filtered by the requireContractor column
 * @method Project findOneByPurchasetype(int $purchaseType) Return the first Project filtered by the purchaseType column
 * @method Project findOneByConstructiontype(int $constructionType) Return the first Project filtered by the constructionType column
 * @method Project findOneByRequireexraresources(boolean $requireExraResources) Return the first Project filtered by the requireExraResources column
 * @method Project findOneByImplementationpartner(string $implementationPartner) Return the first Project filtered by the implementationPartner column
 * @method Project findOneByRiskfactors(string $riskFactors) Return the first Project filtered by the riskFactors column
 * @method Project findOneByOwnfinance(int $ownFinance) Return the first Project filtered by the ownFinance column
 * @method Project findOneByProvincefinance(int $provinceFinance) Return the first Project filtered by the provinceFinance column
 * @method Project findOneByNationfinance(int $nationFinance) Return the first Project filtered by the nationFinance column
 * @method Project findOneByOtherfinance(int $otherFinance) Return the first Project filtered by the otherFinance column
 * @method Project findOneByFinancedetail(string $financeDetail) Return the first Project filtered by the financeDetail column
 * @method Project findOneByFinanceprogram(string $financeProgram) Return the first Project filtered by the financeProgram column
 * @method Project findOneByCreatedAt(string $created_at) Return the first Project filtered by the created_at column
 * @method Project findOneByUpdatedAt(string $updated_at) Return the first Project filtered by the updated_at column
 * @method Project findOneByDeletedAt(string $deleted_at) Return the first Project filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Project objects filtered by the id column
 * @method array findByObjectiveid(int $objectiveId) Return Project objects filtered by the objectiveId column
 * @method array findByCode(string $code) Return Project objects filtered by the code column
 * @method array findByCodeaux(string $codeAux) Return Project objects filtered by the codeAux column
 * @method array findByName(string $name) Return Project objects filtered by the name column
 * @method array findByDescription(string $description) Return Project objects filtered by the description column
 * @method array findByImpact(string $impact) Return Project objects filtered by the impact column
 * @method array findByUniquegoal(string $uniqueGoal) Return Project objects filtered by the uniqueGoal column
 * @method array findByGoalexpirationdate(string $goalExpirationDate) Return Project objects filtered by the goalExpirationDate column
 * @method array findByDate(string $date) Return Project objects filtered by the date column
 * @method array findByBudgetplanned(double $budgetPlanned) Return Project objects filtered by the budgetPlanned column
 * @method array findByBudget(double $budget) Return Project objects filtered by the budget column
 * @method array findByExchangerate(double $exchangeRate) Return Project objects filtered by the exchangeRate column
 * @method array findByVisibility(int $visibility) Return Project objects filtered by the visibility column
 * @method array findByCoordinateneed(string $coordinateNeed) Return Project objects filtered by the coordinateNeed column
 * @method array findByFrequency(string $frequency) Return Project objects filtered by the frequency column
 * @method array findByFinished(boolean $finished) Return Project objects filtered by the finished column
 * @method array findByNotes(string $notes) Return Project objects filtered by the notes column
 * @method array findByPostalcode(string $postalCode) Return Project objects filtered by the postalCode column
 * @method array findByUniquegoalnumeric(int $uniqueGoalNumeric) Return Project objects filtered by the uniqueGoalNumeric column
 * @method array findByGoalprogress(int $goalProgress) Return Project objects filtered by the goalProgress column
 * @method array findByLatitude(double $latitude) Return Project objects filtered by the latitude column
 * @method array findByLongitude(double $longitude) Return Project objects filtered by the longitude column
 * @method array findByOldid(int $oldId) Return Project objects filtered by the oldId column
 * @method array findByRegionid(int $regionId) Return Project objects filtered by the regionId column
 * @method array findByOldregionid(int $oldRegionId) Return Project objects filtered by the oldRegionId column
 * @method array findByLastmodification(string $lastModification) Return Project objects filtered by the lastModification column
 * @method array findByAddress(string $address) Return Project objects filtered by the address column
 * @method array findByStreet(string $street) Return Project objects filtered by the street column
 * @method array findByNumber(int $number) Return Project objects filtered by the number column
 * @method array findByPriority(int $priority) Return Project objects filtered by the priority column
 * @method array findByModifications(int $modifications) Return Project objects filtered by the modifications column
 * @method array findByPlannedstart(string $plannedStart) Return Project objects filtered by the plannedStart column
 * @method array findByPlannedend(string $plannedEnd) Return Project objects filtered by the plannedEnd column
 * @method array findByRealstart(string $realStart) Return Project objects filtered by the realStart column
 * @method array findByRealend(string $realEnd) Return Project objects filtered by the realEnd column
 * @method array findByCancelled(boolean $cancelled) Return Project objects filtered by the cancelled column
 * @method array findByIsconstruction(boolean $isConstruction) Return Project objects filtered by the isConstruction column
 * @method array findByRelevance(string $relevance) Return Project objects filtered by the relevance column
 * @method array findByUserid(int $userId) Return Project objects filtered by the userId column
 * @method array findByOrder(int $order) Return Project objects filtered by the order column
 * @method array findByWeight(string $weight) Return Project objects filtered by the weight column
 * @method array findByUpdated(string $updated) Return Project objects filtered by the updated column
 * @method array findByResponsiblecode(int $responsibleCode) Return Project objects filtered by the responsibleCode column
 * @method array findByIndicatorid(int $indicatorId) Return Project objects filtered by the indicatorId column
 * @method array findByPrimarysource(string $primarySource) Return Project objects filtered by the primarySource column
 * @method array findByAdditionalsource(string $additionalSource) Return Project objects filtered by the additionalSource column
 * @method array findByStartingyear(int $startingYear) Return Project objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return Project objects filtered by the endingYear column
 * @method array findBySubproject(string $subproject) Return Project objects filtered by the subproject column
 * @method array findByOngoing(string $ongoing) Return Project objects filtered by the ongoing column
 * @method array findByRelatedareas(string $relatedAreas) Return Project objects filtered by the relatedAreas column
 * @method array findByGoal(string $goal) Return Project objects filtered by the goal column
 * @method array findByLegal(string $legal) Return Project objects filtered by the legal column
 * @method array findByExecresp(string $execResp) Return Project objects filtered by the execResp column
 * @method array findByExectenure(string $execTenure) Return Project objects filtered by the execTenure column
 * @method array findByExecdependency(string $execDependency) Return Project objects filtered by the execDependency column
 * @method array findByExeccontact(string $execContact) Return Project objects filtered by the execContact column
 * @method array findBySubsecretary(string $subsecretary) Return Project objects filtered by the subsecretary column
 * @method array findByBudgetrequested(double $budgetRequested) Return Project objects filtered by the budgetRequested column
 * @method array findByBudgetsanctioned(double $budgetSanctioned) Return Project objects filtered by the budgetSanctioned column
 * @method array findByBelgrano(boolean $belgrano) Return Project objects filtered by the belgrano column
 * @method array findByClasification(int $clasification) Return Project objects filtered by the clasification column
 * @method array findByPress(boolean $press) Return Project objects filtered by the press column
 * @method array findByPriorityarea(int $priorityArea) Return Project objects filtered by the priorityArea column
 * @method array findByBeneficiario(string $beneficiario) Return Project objects filtered by the beneficiario column
 * @method array findByRequirecontractor(boolean $requireContractor) Return Project objects filtered by the requireContractor column
 * @method array findByPurchasetype(int $purchaseType) Return Project objects filtered by the purchaseType column
 * @method array findByConstructiontype(int $constructionType) Return Project objects filtered by the constructionType column
 * @method array findByRequireexraresources(boolean $requireExraResources) Return Project objects filtered by the requireExraResources column
 * @method array findByImplementationpartner(string $implementationPartner) Return Project objects filtered by the implementationPartner column
 * @method array findByRiskfactors(string $riskFactors) Return Project objects filtered by the riskFactors column
 * @method array findByOwnfinance(int $ownFinance) Return Project objects filtered by the ownFinance column
 * @method array findByProvincefinance(int $provinceFinance) Return Project objects filtered by the provinceFinance column
 * @method array findByNationfinance(int $nationFinance) Return Project objects filtered by the nationFinance column
 * @method array findByOtherfinance(int $otherFinance) Return Project objects filtered by the otherFinance column
 * @method array findByFinancedetail(string $financeDetail) Return Project objects filtered by the financeDetail column
 * @method array findByFinanceprogram(string $financeProgram) Return Project objects filtered by the financeProgram column
 * @method array findByCreatedAt(string $created_at) Return Project objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return Project objects filtered by the updated_at column
 * @method array findByDeletedAt(string $deleted_at) Return Project objects filtered by the deleted_at column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseProjectQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Project', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectQuery) {
            return $criteria;
        }
        $query = new ProjectQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Project|Project[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Project A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `OBJECTIVEID`, `CODE`, `CODEAUX`, `NAME`, `DESCRIPTION`, `IMPACT`, `UNIQUEGOAL`, `GOALEXPIRATIONDATE`, `DATE`, `BUDGETPLANNED`, `BUDGET`, `EXCHANGERATE`, `VISIBILITY`, `COORDINATENEED`, `FREQUENCY`, `FINISHED`, `NOTES`, `POSTALCODE`, `UNIQUEGOALNUMERIC`, `GOALPROGRESS`, `LATITUDE`, `LONGITUDE`, `OLDID`, `REGIONID`, `OLDREGIONID`, `LASTMODIFICATION`, `ADDRESS`, `STREET`, `NUMBER`, `PRIORITY`, `MODIFICATIONS`, `PLANNEDSTART`, `PLANNEDEND`, `REALSTART`, `REALEND`, `CANCELLED`, `ISCONSTRUCTION`, `RELEVANCE`, `USERID`, `ORDER`, `WEIGHT`, `UPDATED`, `RESPONSIBLECODE`, `INDICATORID`, `PRIMARYSOURCE`, `ADDITIONALSOURCE`, `STARTINGYEAR`, `ENDINGYEAR`, `SUBPROJECT`, `ONGOING`, `RELATEDAREAS`, `GOAL`, `LEGAL`, `EXECRESP`, `EXECTENURE`, `EXECDEPENDENCY`, `EXECCONTACT`, `SUBSECRETARY`, `BUDGETREQUESTED`, `BUDGETSANCTIONED`, `BELGRANO`, `CLASIFICATION`, `PRESS`, `PRIORITYAREA`, `BENEFICIARIO`, `REQUIRECONTRACTOR`, `PURCHASETYPE`, `CONSTRUCTIONTYPE`, `REQUIREEXRARESOURCES`, `IMPLEMENTATIONPARTNER`, `RISKFACTORS`, `OWNFINANCE`, `PROVINCEFINANCE`, `NATIONFINANCE`, `OTHERFINANCE`, `FINANCEDETAIL`, `FINANCEPROGRAM`, `CREATED_AT`, `UPDATED_AT`, `DELETED_AT` FROM `projects_project` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Project();
            $obj->hydrate($row);
            ProjectPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Project|Project[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Project[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the objectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectiveid(1234); // WHERE objectiveId = 1234
     * $query->filterByObjectiveid(array(12, 34)); // WHERE objectiveId IN (12, 34)
     * $query->filterByObjectiveid(array('min' => 12)); // WHERE objectiveId > 12
     * </code>
     *
     * @see       filterByObjective()
     *
     * @param     mixed $objectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByObjectiveid($objectiveid = null, $comparison = null)
    {
        if (is_array($objectiveid)) {
            $useMinMax = false;
            if (isset($objectiveid['min'])) {
                $this->addUsingAlias(ProjectPeer::OBJECTIVEID, $objectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectiveid['max'])) {
                $this->addUsingAlias(ProjectPeer::OBJECTIVEID, $objectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::OBJECTIVEID, $objectiveid, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%'); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $code)) {
                $code = str_replace('*', '%', $code);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::CODE, $code, $comparison);
    }

    /**
     * Filter the query on the codeAux column
     *
     * Example usage:
     * <code>
     * $query->filterByCodeaux('fooValue');   // WHERE codeAux = 'fooValue'
     * $query->filterByCodeaux('%fooValue%'); // WHERE codeAux LIKE '%fooValue%'
     * </code>
     *
     * @param     string $codeaux The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByCodeaux($codeaux = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($codeaux)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $codeaux)) {
                $codeaux = str_replace('*', '%', $codeaux);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::CODEAUX, $codeaux, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the impact column
     *
     * Example usage:
     * <code>
     * $query->filterByImpact('fooValue');   // WHERE impact = 'fooValue'
     * $query->filterByImpact('%fooValue%'); // WHERE impact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $impact The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByImpact($impact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($impact)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $impact)) {
                $impact = str_replace('*', '%', $impact);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::IMPACT, $impact, $comparison);
    }

    /**
     * Filter the query on the uniqueGoal column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoal('fooValue');   // WHERE uniqueGoal = 'fooValue'
     * $query->filterByUniquegoal('%fooValue%'); // WHERE uniqueGoal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $uniquegoal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByUniquegoal($uniquegoal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($uniquegoal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $uniquegoal)) {
                $uniquegoal = str_replace('*', '%', $uniquegoal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::UNIQUEGOAL, $uniquegoal, $comparison);
    }

    /**
     * Filter the query on the goalExpirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalexpirationdate('2011-03-14'); // WHERE goalExpirationDate = '2011-03-14'
     * $query->filterByGoalexpirationdate('now'); // WHERE goalExpirationDate = '2011-03-14'
     * $query->filterByGoalexpirationdate(array('max' => 'yesterday')); // WHERE goalExpirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $goalexpirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByGoalexpirationdate($goalexpirationdate = null, $comparison = null)
    {
        if (is_array($goalexpirationdate)) {
            $useMinMax = false;
            if (isset($goalexpirationdate['min'])) {
                $this->addUsingAlias(ProjectPeer::GOALEXPIRATIONDATE, $goalexpirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalexpirationdate['max'])) {
                $this->addUsingAlias(ProjectPeer::GOALEXPIRATIONDATE, $goalexpirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::GOALEXPIRATIONDATE, $goalexpirationdate, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the budgetPlanned column
     *
     * Example usage:
     * <code>
     * $query->filterByBudgetplanned(1234); // WHERE budgetPlanned = 1234
     * $query->filterByBudgetplanned(array(12, 34)); // WHERE budgetPlanned IN (12, 34)
     * $query->filterByBudgetplanned(array('min' => 12)); // WHERE budgetPlanned > 12
     * </code>
     *
     * @param     mixed $budgetplanned The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBudgetplanned($budgetplanned = null, $comparison = null)
    {
        if (is_array($budgetplanned)) {
            $useMinMax = false;
            if (isset($budgetplanned['min'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETPLANNED, $budgetplanned['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budgetplanned['max'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETPLANNED, $budgetplanned['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::BUDGETPLANNED, $budgetplanned, $comparison);
    }

    /**
     * Filter the query on the budget column
     *
     * Example usage:
     * <code>
     * $query->filterByBudget(1234); // WHERE budget = 1234
     * $query->filterByBudget(array(12, 34)); // WHERE budget IN (12, 34)
     * $query->filterByBudget(array('min' => 12)); // WHERE budget > 12
     * </code>
     *
     * @param     mixed $budget The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBudget($budget = null, $comparison = null)
    {
        if (is_array($budget)) {
            $useMinMax = false;
            if (isset($budget['min'])) {
                $this->addUsingAlias(ProjectPeer::BUDGET, $budget['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budget['max'])) {
                $this->addUsingAlias(ProjectPeer::BUDGET, $budget['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::BUDGET, $budget, $comparison);
    }

    /**
     * Filter the query on the exchangeRate column
     *
     * Example usage:
     * <code>
     * $query->filterByExchangerate(1234); // WHERE exchangeRate = 1234
     * $query->filterByExchangerate(array(12, 34)); // WHERE exchangeRate IN (12, 34)
     * $query->filterByExchangerate(array('min' => 12)); // WHERE exchangeRate > 12
     * </code>
     *
     * @param     mixed $exchangerate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByExchangerate($exchangerate = null, $comparison = null)
    {
        if (is_array($exchangerate)) {
            $useMinMax = false;
            if (isset($exchangerate['min'])) {
                $this->addUsingAlias(ProjectPeer::EXCHANGERATE, $exchangerate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($exchangerate['max'])) {
                $this->addUsingAlias(ProjectPeer::EXCHANGERATE, $exchangerate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::EXCHANGERATE, $exchangerate, $comparison);
    }

    /**
     * Filter the query on the visibility column
     *
     * Example usage:
     * <code>
     * $query->filterByVisibility(1234); // WHERE visibility = 1234
     * $query->filterByVisibility(array(12, 34)); // WHERE visibility IN (12, 34)
     * $query->filterByVisibility(array('min' => 12)); // WHERE visibility > 12
     * </code>
     *
     * @param     mixed $visibility The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByVisibility($visibility = null, $comparison = null)
    {
        if (is_array($visibility)) {
            $useMinMax = false;
            if (isset($visibility['min'])) {
                $this->addUsingAlias(ProjectPeer::VISIBILITY, $visibility['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($visibility['max'])) {
                $this->addUsingAlias(ProjectPeer::VISIBILITY, $visibility['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::VISIBILITY, $visibility, $comparison);
    }

    /**
     * Filter the query on the coordinateNeed column
     *
     * Example usage:
     * <code>
     * $query->filterByCoordinateneed('fooValue');   // WHERE coordinateNeed = 'fooValue'
     * $query->filterByCoordinateneed('%fooValue%'); // WHERE coordinateNeed LIKE '%fooValue%'
     * </code>
     *
     * @param     string $coordinateneed The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByCoordinateneed($coordinateneed = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($coordinateneed)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $coordinateneed)) {
                $coordinateneed = str_replace('*', '%', $coordinateneed);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::COORDINATENEED, $coordinateneed, $comparison);
    }

    /**
     * Filter the query on the frequency column
     *
     * Example usage:
     * <code>
     * $query->filterByFrequency('fooValue');   // WHERE frequency = 'fooValue'
     * $query->filterByFrequency('%fooValue%'); // WHERE frequency LIKE '%fooValue%'
     * </code>
     *
     * @param     string $frequency The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByFrequency($frequency = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($frequency)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $frequency)) {
                $frequency = str_replace('*', '%', $frequency);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::FREQUENCY, $frequency, $comparison);
    }

    /**
     * Filter the query on the finished column
     *
     * Example usage:
     * <code>
     * $query->filterByFinished(true); // WHERE finished = true
     * $query->filterByFinished('yes'); // WHERE finished = true
     * </code>
     *
     * @param     boolean|string $finished The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByFinished($finished = null, $comparison = null)
    {
        if (is_string($finished)) {
            $finished = in_array(strtolower($finished), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::FINISHED, $finished, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the postalCode column
     *
     * Example usage:
     * <code>
     * $query->filterByPostalcode('fooValue');   // WHERE postalCode = 'fooValue'
     * $query->filterByPostalcode('%fooValue%'); // WHERE postalCode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $postalcode The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPostalcode($postalcode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postalcode)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $postalcode)) {
                $postalcode = str_replace('*', '%', $postalcode);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::POSTALCODE, $postalcode, $comparison);
    }

    /**
     * Filter the query on the uniqueGoalNumeric column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoalnumeric(1234); // WHERE uniqueGoalNumeric = 1234
     * $query->filterByUniquegoalnumeric(array(12, 34)); // WHERE uniqueGoalNumeric IN (12, 34)
     * $query->filterByUniquegoalnumeric(array('min' => 12)); // WHERE uniqueGoalNumeric > 12
     * </code>
     *
     * @param     mixed $uniquegoalnumeric The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByUniquegoalnumeric($uniquegoalnumeric = null, $comparison = null)
    {
        if (is_array($uniquegoalnumeric)) {
            $useMinMax = false;
            if (isset($uniquegoalnumeric['min'])) {
                $this->addUsingAlias(ProjectPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uniquegoalnumeric['max'])) {
                $this->addUsingAlias(ProjectPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric, $comparison);
    }

    /**
     * Filter the query on the goalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalprogress(1234); // WHERE goalProgress = 1234
     * $query->filterByGoalprogress(array(12, 34)); // WHERE goalProgress IN (12, 34)
     * $query->filterByGoalprogress(array('min' => 12)); // WHERE goalProgress > 12
     * </code>
     *
     * @param     mixed $goalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByGoalprogress($goalprogress = null, $comparison = null)
    {
        if (is_array($goalprogress)) {
            $useMinMax = false;
            if (isset($goalprogress['min'])) {
                $this->addUsingAlias(ProjectPeer::GOALPROGRESS, $goalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalprogress['max'])) {
                $this->addUsingAlias(ProjectPeer::GOALPROGRESS, $goalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::GOALPROGRESS, $goalprogress, $comparison);
    }

    /**
     * Filter the query on the latitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLatitude(1234); // WHERE latitude = 1234
     * $query->filterByLatitude(array(12, 34)); // WHERE latitude IN (12, 34)
     * $query->filterByLatitude(array('min' => 12)); // WHERE latitude > 12
     * </code>
     *
     * @param     mixed $latitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByLatitude($latitude = null, $comparison = null)
    {
        if (is_array($latitude)) {
            $useMinMax = false;
            if (isset($latitude['min'])) {
                $this->addUsingAlias(ProjectPeer::LATITUDE, $latitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($latitude['max'])) {
                $this->addUsingAlias(ProjectPeer::LATITUDE, $latitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::LATITUDE, $latitude, $comparison);
    }

    /**
     * Filter the query on the longitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLongitude(1234); // WHERE longitude = 1234
     * $query->filterByLongitude(array(12, 34)); // WHERE longitude IN (12, 34)
     * $query->filterByLongitude(array('min' => 12)); // WHERE longitude > 12
     * </code>
     *
     * @param     mixed $longitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByLongitude($longitude = null, $comparison = null)
    {
        if (is_array($longitude)) {
            $useMinMax = false;
            if (isset($longitude['min'])) {
                $this->addUsingAlias(ProjectPeer::LONGITUDE, $longitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($longitude['max'])) {
                $this->addUsingAlias(ProjectPeer::LONGITUDE, $longitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::LONGITUDE, $longitude, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(ProjectPeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(ProjectPeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the regionId column
     *
     * Example usage:
     * <code>
     * $query->filterByRegionid(1234); // WHERE regionId = 1234
     * $query->filterByRegionid(array(12, 34)); // WHERE regionId IN (12, 34)
     * $query->filterByRegionid(array('min' => 12)); // WHERE regionId > 12
     * </code>
     *
     * @param     mixed $regionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRegionid($regionid = null, $comparison = null)
    {
        if (is_array($regionid)) {
            $useMinMax = false;
            if (isset($regionid['min'])) {
                $this->addUsingAlias(ProjectPeer::REGIONID, $regionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($regionid['max'])) {
                $this->addUsingAlias(ProjectPeer::REGIONID, $regionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::REGIONID, $regionid, $comparison);
    }

    /**
     * Filter the query on the oldRegionId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldregionid(1234); // WHERE oldRegionId = 1234
     * $query->filterByOldregionid(array(12, 34)); // WHERE oldRegionId IN (12, 34)
     * $query->filterByOldregionid(array('min' => 12)); // WHERE oldRegionId > 12
     * </code>
     *
     * @param     mixed $oldregionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOldregionid($oldregionid = null, $comparison = null)
    {
        if (is_array($oldregionid)) {
            $useMinMax = false;
            if (isset($oldregionid['min'])) {
                $this->addUsingAlias(ProjectPeer::OLDREGIONID, $oldregionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldregionid['max'])) {
                $this->addUsingAlias(ProjectPeer::OLDREGIONID, $oldregionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::OLDREGIONID, $oldregionid, $comparison);
    }

    /**
     * Filter the query on the lastModification column
     *
     * Example usage:
     * <code>
     * $query->filterByLastmodification('2011-03-14'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification('now'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification(array('max' => 'yesterday')); // WHERE lastModification > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastmodification The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByLastmodification($lastmodification = null, $comparison = null)
    {
        if (is_array($lastmodification)) {
            $useMinMax = false;
            if (isset($lastmodification['min'])) {
                $this->addUsingAlias(ProjectPeer::LASTMODIFICATION, $lastmodification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastmodification['max'])) {
                $this->addUsingAlias(ProjectPeer::LASTMODIFICATION, $lastmodification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::LASTMODIFICATION, $lastmodification, $comparison);
    }

    /**
     * Filter the query on the address column
     *
     * Example usage:
     * <code>
     * $query->filterByAddress('fooValue');   // WHERE address = 'fooValue'
     * $query->filterByAddress('%fooValue%'); // WHERE address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $address The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByAddress($address = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($address)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $address)) {
                $address = str_replace('*', '%', $address);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::ADDRESS, $address, $comparison);
    }

    /**
     * Filter the query on the street column
     *
     * Example usage:
     * <code>
     * $query->filterByStreet('fooValue');   // WHERE street = 'fooValue'
     * $query->filterByStreet('%fooValue%'); // WHERE street LIKE '%fooValue%'
     * </code>
     *
     * @param     string $street The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByStreet($street = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($street)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $street)) {
                $street = str_replace('*', '%', $street);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::STREET, $street, $comparison);
    }

    /**
     * Filter the query on the number column
     *
     * Example usage:
     * <code>
     * $query->filterByNumber(1234); // WHERE number = 1234
     * $query->filterByNumber(array(12, 34)); // WHERE number IN (12, 34)
     * $query->filterByNumber(array('min' => 12)); // WHERE number > 12
     * </code>
     *
     * @param     mixed $number The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByNumber($number = null, $comparison = null)
    {
        if (is_array($number)) {
            $useMinMax = false;
            if (isset($number['min'])) {
                $this->addUsingAlias(ProjectPeer::NUMBER, $number['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($number['max'])) {
                $this->addUsingAlias(ProjectPeer::NUMBER, $number['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::NUMBER, $number, $comparison);
    }

    /**
     * Filter the query on the priority column
     *
     * Example usage:
     * <code>
     * $query->filterByPriority(1234); // WHERE priority = 1234
     * $query->filterByPriority(array(12, 34)); // WHERE priority IN (12, 34)
     * $query->filterByPriority(array('min' => 12)); // WHERE priority > 12
     * </code>
     *
     * @param     mixed $priority The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPriority($priority = null, $comparison = null)
    {
        if (is_array($priority)) {
            $useMinMax = false;
            if (isset($priority['min'])) {
                $this->addUsingAlias(ProjectPeer::PRIORITY, $priority['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priority['max'])) {
                $this->addUsingAlias(ProjectPeer::PRIORITY, $priority['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PRIORITY, $priority, $comparison);
    }

    /**
     * Filter the query on the modifications column
     *
     * Example usage:
     * <code>
     * $query->filterByModifications(1234); // WHERE modifications = 1234
     * $query->filterByModifications(array(12, 34)); // WHERE modifications IN (12, 34)
     * $query->filterByModifications(array('min' => 12)); // WHERE modifications > 12
     * </code>
     *
     * @param     mixed $modifications The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByModifications($modifications = null, $comparison = null)
    {
        if (is_array($modifications)) {
            $useMinMax = false;
            if (isset($modifications['min'])) {
                $this->addUsingAlias(ProjectPeer::MODIFICATIONS, $modifications['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($modifications['max'])) {
                $this->addUsingAlias(ProjectPeer::MODIFICATIONS, $modifications['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::MODIFICATIONS, $modifications, $comparison);
    }

    /**
     * Filter the query on the plannedStart column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedstart('2011-03-14'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart('now'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart(array('max' => 'yesterday')); // WHERE plannedStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPlannedstart($plannedstart = null, $comparison = null)
    {
        if (is_array($plannedstart)) {
            $useMinMax = false;
            if (isset($plannedstart['min'])) {
                $this->addUsingAlias(ProjectPeer::PLANNEDSTART, $plannedstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedstart['max'])) {
                $this->addUsingAlias(ProjectPeer::PLANNEDSTART, $plannedstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PLANNEDSTART, $plannedstart, $comparison);
    }

    /**
     * Filter the query on the plannedEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedend('2011-03-14'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend('now'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend(array('max' => 'yesterday')); // WHERE plannedEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPlannedend($plannedend = null, $comparison = null)
    {
        if (is_array($plannedend)) {
            $useMinMax = false;
            if (isset($plannedend['min'])) {
                $this->addUsingAlias(ProjectPeer::PLANNEDEND, $plannedend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedend['max'])) {
                $this->addUsingAlias(ProjectPeer::PLANNEDEND, $plannedend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PLANNEDEND, $plannedend, $comparison);
    }

    /**
     * Filter the query on the realStart column
     *
     * Example usage:
     * <code>
     * $query->filterByRealstart('2011-03-14'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart('now'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart(array('max' => 'yesterday')); // WHERE realStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $realstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRealstart($realstart = null, $comparison = null)
    {
        if (is_array($realstart)) {
            $useMinMax = false;
            if (isset($realstart['min'])) {
                $this->addUsingAlias(ProjectPeer::REALSTART, $realstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realstart['max'])) {
                $this->addUsingAlias(ProjectPeer::REALSTART, $realstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::REALSTART, $realstart, $comparison);
    }

    /**
     * Filter the query on the realEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByRealend('2011-03-14'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend('now'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend(array('max' => 'yesterday')); // WHERE realEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $realend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRealend($realend = null, $comparison = null)
    {
        if (is_array($realend)) {
            $useMinMax = false;
            if (isset($realend['min'])) {
                $this->addUsingAlias(ProjectPeer::REALEND, $realend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realend['max'])) {
                $this->addUsingAlias(ProjectPeer::REALEND, $realend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::REALEND, $realend, $comparison);
    }

    /**
     * Filter the query on the cancelled column
     *
     * Example usage:
     * <code>
     * $query->filterByCancelled(true); // WHERE cancelled = true
     * $query->filterByCancelled('yes'); // WHERE cancelled = true
     * </code>
     *
     * @param     boolean|string $cancelled The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByCancelled($cancelled = null, $comparison = null)
    {
        if (is_string($cancelled)) {
            $cancelled = in_array(strtolower($cancelled), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::CANCELLED, $cancelled, $comparison);
    }

    /**
     * Filter the query on the isConstruction column
     *
     * Example usage:
     * <code>
     * $query->filterByIsconstruction(true); // WHERE isConstruction = true
     * $query->filterByIsconstruction('yes'); // WHERE isConstruction = true
     * </code>
     *
     * @param     boolean|string $isconstruction The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByIsconstruction($isconstruction = null, $comparison = null)
    {
        if (is_string($isconstruction)) {
            $isConstruction = in_array(strtolower($isconstruction), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::ISCONSTRUCTION, $isconstruction, $comparison);
    }

    /**
     * Filter the query on the relevance column
     *
     * Example usage:
     * <code>
     * $query->filterByRelevance('fooValue');   // WHERE relevance = 'fooValue'
     * $query->filterByRelevance('%fooValue%'); // WHERE relevance LIKE '%fooValue%'
     * </code>
     *
     * @param     string $relevance The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRelevance($relevance = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($relevance)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $relevance)) {
                $relevance = str_replace('*', '%', $relevance);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::RELEVANCE, $relevance, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ProjectPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ProjectPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the order column
     *
     * Example usage:
     * <code>
     * $query->filterByOrder(1234); // WHERE order = 1234
     * $query->filterByOrder(array(12, 34)); // WHERE order IN (12, 34)
     * $query->filterByOrder(array('min' => 12)); // WHERE order > 12
     * </code>
     *
     * @param     mixed $order The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOrder($order = null, $comparison = null)
    {
        if (is_array($order)) {
            $useMinMax = false;
            if (isset($order['min'])) {
                $this->addUsingAlias(ProjectPeer::ORDER, $order['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($order['max'])) {
                $this->addUsingAlias(ProjectPeer::ORDER, $order['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::ORDER, $order, $comparison);
    }

    /**
     * Filter the query on the weight column
     *
     * Example usage:
     * <code>
     * $query->filterByWeight(1234); // WHERE weight = 1234
     * $query->filterByWeight(array(12, 34)); // WHERE weight IN (12, 34)
     * $query->filterByWeight(array('min' => 12)); // WHERE weight > 12
     * </code>
     *
     * @param     mixed $weight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByWeight($weight = null, $comparison = null)
    {
        if (is_array($weight)) {
            $useMinMax = false;
            if (isset($weight['min'])) {
                $this->addUsingAlias(ProjectPeer::WEIGHT, $weight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($weight['max'])) {
                $this->addUsingAlias(ProjectPeer::WEIGHT, $weight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::WEIGHT, $weight, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ProjectPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ProjectPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ProjectPeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ProjectPeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query on the indicatorId column
     *
     * Example usage:
     * <code>
     * $query->filterByIndicatorid(1234); // WHERE indicatorId = 1234
     * $query->filterByIndicatorid(array(12, 34)); // WHERE indicatorId IN (12, 34)
     * $query->filterByIndicatorid(array('min' => 12)); // WHERE indicatorId > 12
     * </code>
     *
     * @see       filterByIndicator()
     *
     * @param     mixed $indicatorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByIndicatorid($indicatorid = null, $comparison = null)
    {
        if (is_array($indicatorid)) {
            $useMinMax = false;
            if (isset($indicatorid['min'])) {
                $this->addUsingAlias(ProjectPeer::INDICATORID, $indicatorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($indicatorid['max'])) {
                $this->addUsingAlias(ProjectPeer::INDICATORID, $indicatorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::INDICATORID, $indicatorid, $comparison);
    }

    /**
     * Filter the query on the primarySource column
     *
     * Example usage:
     * <code>
     * $query->filterByPrimarysource('fooValue');   // WHERE primarySource = 'fooValue'
     * $query->filterByPrimarysource('%fooValue%'); // WHERE primarySource LIKE '%fooValue%'
     * </code>
     *
     * @param     string $primarysource The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPrimarysource($primarysource = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($primarysource)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $primarysource)) {
                $primarysource = str_replace('*', '%', $primarysource);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PRIMARYSOURCE, $primarysource, $comparison);
    }

    /**
     * Filter the query on the additionalSource column
     *
     * Example usage:
     * <code>
     * $query->filterByAdditionalsource('fooValue');   // WHERE additionalSource = 'fooValue'
     * $query->filterByAdditionalsource('%fooValue%'); // WHERE additionalSource LIKE '%fooValue%'
     * </code>
     *
     * @param     string $additionalsource The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByAdditionalsource($additionalsource = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($additionalsource)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $additionalsource)) {
                $additionalsource = str_replace('*', '%', $additionalsource);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::ADDITIONALSOURCE, $additionalsource, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ProjectPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ProjectPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ProjectPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ProjectPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the subproject column
     *
     * Example usage:
     * <code>
     * $query->filterBySubproject('fooValue');   // WHERE subproject = 'fooValue'
     * $query->filterBySubproject('%fooValue%'); // WHERE subproject LIKE '%fooValue%'
     * </code>
     *
     * @param     string $subproject The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterBySubproject($subproject = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subproject)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $subproject)) {
                $subproject = str_replace('*', '%', $subproject);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::SUBPROJECT, $subproject, $comparison);
    }

    /**
     * Filter the query on the ongoing column
     *
     * Example usage:
     * <code>
     * $query->filterByOngoing('fooValue');   // WHERE ongoing = 'fooValue'
     * $query->filterByOngoing('%fooValue%'); // WHERE ongoing LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ongoing The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOngoing($ongoing = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ongoing)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ongoing)) {
                $ongoing = str_replace('*', '%', $ongoing);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::ONGOING, $ongoing, $comparison);
    }

    /**
     * Filter the query on the relatedAreas column
     *
     * Example usage:
     * <code>
     * $query->filterByRelatedareas('fooValue');   // WHERE relatedAreas = 'fooValue'
     * $query->filterByRelatedareas('%fooValue%'); // WHERE relatedAreas LIKE '%fooValue%'
     * </code>
     *
     * @param     string $relatedareas The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRelatedareas($relatedareas = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($relatedareas)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $relatedareas)) {
                $relatedareas = str_replace('*', '%', $relatedareas);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::RELATEDAREAS, $relatedareas, $comparison);
    }

    /**
     * Filter the query on the goal column
     *
     * Example usage:
     * <code>
     * $query->filterByGoal('fooValue');   // WHERE goal = 'fooValue'
     * $query->filterByGoal('%fooValue%'); // WHERE goal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $goal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByGoal($goal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($goal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $goal)) {
                $goal = str_replace('*', '%', $goal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::GOAL, $goal, $comparison);
    }

    /**
     * Filter the query on the legal column
     *
     * Example usage:
     * <code>
     * $query->filterByLegal('fooValue');   // WHERE legal = 'fooValue'
     * $query->filterByLegal('%fooValue%'); // WHERE legal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $legal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByLegal($legal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($legal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $legal)) {
                $legal = str_replace('*', '%', $legal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::LEGAL, $legal, $comparison);
    }

    /**
     * Filter the query on the execResp column
     *
     * Example usage:
     * <code>
     * $query->filterByExecresp('fooValue');   // WHERE execResp = 'fooValue'
     * $query->filterByExecresp('%fooValue%'); // WHERE execResp LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execresp The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByExecresp($execresp = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execresp)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execresp)) {
                $execresp = str_replace('*', '%', $execresp);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::EXECRESP, $execresp, $comparison);
    }

    /**
     * Filter the query on the execTenure column
     *
     * Example usage:
     * <code>
     * $query->filterByExectenure('fooValue');   // WHERE execTenure = 'fooValue'
     * $query->filterByExectenure('%fooValue%'); // WHERE execTenure LIKE '%fooValue%'
     * </code>
     *
     * @param     string $exectenure The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByExectenure($exectenure = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($exectenure)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $exectenure)) {
                $exectenure = str_replace('*', '%', $exectenure);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::EXECTENURE, $exectenure, $comparison);
    }

    /**
     * Filter the query on the execDependency column
     *
     * Example usage:
     * <code>
     * $query->filterByExecdependency('fooValue');   // WHERE execDependency = 'fooValue'
     * $query->filterByExecdependency('%fooValue%'); // WHERE execDependency LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execdependency The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByExecdependency($execdependency = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execdependency)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execdependency)) {
                $execdependency = str_replace('*', '%', $execdependency);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::EXECDEPENDENCY, $execdependency, $comparison);
    }

    /**
     * Filter the query on the execContact column
     *
     * Example usage:
     * <code>
     * $query->filterByExeccontact('fooValue');   // WHERE execContact = 'fooValue'
     * $query->filterByExeccontact('%fooValue%'); // WHERE execContact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execcontact The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByExeccontact($execcontact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execcontact)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execcontact)) {
                $execcontact = str_replace('*', '%', $execcontact);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::EXECCONTACT, $execcontact, $comparison);
    }

    /**
     * Filter the query on the subsecretary column
     *
     * Example usage:
     * <code>
     * $query->filterBySubsecretary('fooValue');   // WHERE subsecretary = 'fooValue'
     * $query->filterBySubsecretary('%fooValue%'); // WHERE subsecretary LIKE '%fooValue%'
     * </code>
     *
     * @param     string $subsecretary The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterBySubsecretary($subsecretary = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subsecretary)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $subsecretary)) {
                $subsecretary = str_replace('*', '%', $subsecretary);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::SUBSECRETARY, $subsecretary, $comparison);
    }

    /**
     * Filter the query on the budgetRequested column
     *
     * Example usage:
     * <code>
     * $query->filterByBudgetrequested(1234); // WHERE budgetRequested = 1234
     * $query->filterByBudgetrequested(array(12, 34)); // WHERE budgetRequested IN (12, 34)
     * $query->filterByBudgetrequested(array('min' => 12)); // WHERE budgetRequested > 12
     * </code>
     *
     * @param     mixed $budgetrequested The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBudgetrequested($budgetrequested = null, $comparison = null)
    {
        if (is_array($budgetrequested)) {
            $useMinMax = false;
            if (isset($budgetrequested['min'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETREQUESTED, $budgetrequested['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budgetrequested['max'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETREQUESTED, $budgetrequested['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::BUDGETREQUESTED, $budgetrequested, $comparison);
    }

    /**
     * Filter the query on the budgetSanctioned column
     *
     * Example usage:
     * <code>
     * $query->filterByBudgetsanctioned(1234); // WHERE budgetSanctioned = 1234
     * $query->filterByBudgetsanctioned(array(12, 34)); // WHERE budgetSanctioned IN (12, 34)
     * $query->filterByBudgetsanctioned(array('min' => 12)); // WHERE budgetSanctioned > 12
     * </code>
     *
     * @param     mixed $budgetsanctioned The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBudgetsanctioned($budgetsanctioned = null, $comparison = null)
    {
        if (is_array($budgetsanctioned)) {
            $useMinMax = false;
            if (isset($budgetsanctioned['min'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETSANCTIONED, $budgetsanctioned['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budgetsanctioned['max'])) {
                $this->addUsingAlias(ProjectPeer::BUDGETSANCTIONED, $budgetsanctioned['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::BUDGETSANCTIONED, $budgetsanctioned, $comparison);
    }

    /**
     * Filter the query on the belgrano column
     *
     * Example usage:
     * <code>
     * $query->filterByBelgrano(true); // WHERE belgrano = true
     * $query->filterByBelgrano('yes'); // WHERE belgrano = true
     * </code>
     *
     * @param     boolean|string $belgrano The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBelgrano($belgrano = null, $comparison = null)
    {
        if (is_string($belgrano)) {
            $belgrano = in_array(strtolower($belgrano), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::BELGRANO, $belgrano, $comparison);
    }

    /**
     * Filter the query on the clasification column
     *
     * Example usage:
     * <code>
     * $query->filterByClasification(1234); // WHERE clasification = 1234
     * $query->filterByClasification(array(12, 34)); // WHERE clasification IN (12, 34)
     * $query->filterByClasification(array('min' => 12)); // WHERE clasification > 12
     * </code>
     *
     * @param     mixed $clasification The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByClasification($clasification = null, $comparison = null)
    {
        if (is_array($clasification)) {
            $useMinMax = false;
            if (isset($clasification['min'])) {
                $this->addUsingAlias(ProjectPeer::CLASIFICATION, $clasification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($clasification['max'])) {
                $this->addUsingAlias(ProjectPeer::CLASIFICATION, $clasification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::CLASIFICATION, $clasification, $comparison);
    }

    /**
     * Filter the query on the press column
     *
     * Example usage:
     * <code>
     * $query->filterByPress(true); // WHERE press = true
     * $query->filterByPress('yes'); // WHERE press = true
     * </code>
     *
     * @param     boolean|string $press The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPress($press = null, $comparison = null)
    {
        if (is_string($press)) {
            $press = in_array(strtolower($press), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::PRESS, $press, $comparison);
    }

    /**
     * Filter the query on the priorityArea column
     *
     * Example usage:
     * <code>
     * $query->filterByPriorityarea(1234); // WHERE priorityArea = 1234
     * $query->filterByPriorityarea(array(12, 34)); // WHERE priorityArea IN (12, 34)
     * $query->filterByPriorityarea(array('min' => 12)); // WHERE priorityArea > 12
     * </code>
     *
     * @param     mixed $priorityarea The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPriorityarea($priorityarea = null, $comparison = null)
    {
        if (is_array($priorityarea)) {
            $useMinMax = false;
            if (isset($priorityarea['min'])) {
                $this->addUsingAlias(ProjectPeer::PRIORITYAREA, $priorityarea['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priorityarea['max'])) {
                $this->addUsingAlias(ProjectPeer::PRIORITYAREA, $priorityarea['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PRIORITYAREA, $priorityarea, $comparison);
    }

    /**
     * Filter the query on the beneficiario column
     *
     * Example usage:
     * <code>
     * $query->filterByBeneficiario('fooValue');   // WHERE beneficiario = 'fooValue'
     * $query->filterByBeneficiario('%fooValue%'); // WHERE beneficiario LIKE '%fooValue%'
     * </code>
     *
     * @param     string $beneficiario The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByBeneficiario($beneficiario = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($beneficiario)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $beneficiario)) {
                $beneficiario = str_replace('*', '%', $beneficiario);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::BENEFICIARIO, $beneficiario, $comparison);
    }

    /**
     * Filter the query on the requireContractor column
     *
     * Example usage:
     * <code>
     * $query->filterByRequirecontractor(true); // WHERE requireContractor = true
     * $query->filterByRequirecontractor('yes'); // WHERE requireContractor = true
     * </code>
     *
     * @param     boolean|string $requirecontractor The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRequirecontractor($requirecontractor = null, $comparison = null)
    {
        if (is_string($requirecontractor)) {
            $requireContractor = in_array(strtolower($requirecontractor), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::REQUIRECONTRACTOR, $requirecontractor, $comparison);
    }

    /**
     * Filter the query on the purchaseType column
     *
     * Example usage:
     * <code>
     * $query->filterByPurchasetype(1234); // WHERE purchaseType = 1234
     * $query->filterByPurchasetype(array(12, 34)); // WHERE purchaseType IN (12, 34)
     * $query->filterByPurchasetype(array('min' => 12)); // WHERE purchaseType > 12
     * </code>
     *
     * @param     mixed $purchasetype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByPurchasetype($purchasetype = null, $comparison = null)
    {
        if (is_array($purchasetype)) {
            $useMinMax = false;
            if (isset($purchasetype['min'])) {
                $this->addUsingAlias(ProjectPeer::PURCHASETYPE, $purchasetype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($purchasetype['max'])) {
                $this->addUsingAlias(ProjectPeer::PURCHASETYPE, $purchasetype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PURCHASETYPE, $purchasetype, $comparison);
    }

    /**
     * Filter the query on the constructionType column
     *
     * Example usage:
     * <code>
     * $query->filterByConstructiontype(1234); // WHERE constructionType = 1234
     * $query->filterByConstructiontype(array(12, 34)); // WHERE constructionType IN (12, 34)
     * $query->filterByConstructiontype(array('min' => 12)); // WHERE constructionType > 12
     * </code>
     *
     * @param     mixed $constructiontype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByConstructiontype($constructiontype = null, $comparison = null)
    {
        if (is_array($constructiontype)) {
            $useMinMax = false;
            if (isset($constructiontype['min'])) {
                $this->addUsingAlias(ProjectPeer::CONSTRUCTIONTYPE, $constructiontype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($constructiontype['max'])) {
                $this->addUsingAlias(ProjectPeer::CONSTRUCTIONTYPE, $constructiontype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::CONSTRUCTIONTYPE, $constructiontype, $comparison);
    }

    /**
     * Filter the query on the requireExraResources column
     *
     * Example usage:
     * <code>
     * $query->filterByRequireexraresources(true); // WHERE requireExraResources = true
     * $query->filterByRequireexraresources('yes'); // WHERE requireExraResources = true
     * </code>
     *
     * @param     boolean|string $requireexraresources The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRequireexraresources($requireexraresources = null, $comparison = null)
    {
        if (is_string($requireexraresources)) {
            $requireExraResources = in_array(strtolower($requireexraresources), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectPeer::REQUIREEXRARESOURCES, $requireexraresources, $comparison);
    }

    /**
     * Filter the query on the implementationPartner column
     *
     * Example usage:
     * <code>
     * $query->filterByImplementationpartner('fooValue');   // WHERE implementationPartner = 'fooValue'
     * $query->filterByImplementationpartner('%fooValue%'); // WHERE implementationPartner LIKE '%fooValue%'
     * </code>
     *
     * @param     string $implementationpartner The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByImplementationpartner($implementationpartner = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($implementationpartner)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $implementationpartner)) {
                $implementationpartner = str_replace('*', '%', $implementationpartner);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::IMPLEMENTATIONPARTNER, $implementationpartner, $comparison);
    }

    /**
     * Filter the query on the riskFactors column
     *
     * Example usage:
     * <code>
     * $query->filterByRiskfactors('fooValue');   // WHERE riskFactors = 'fooValue'
     * $query->filterByRiskfactors('%fooValue%'); // WHERE riskFactors LIKE '%fooValue%'
     * </code>
     *
     * @param     string $riskfactors The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByRiskfactors($riskfactors = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($riskfactors)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $riskfactors)) {
                $riskfactors = str_replace('*', '%', $riskfactors);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::RISKFACTORS, $riskfactors, $comparison);
    }

    /**
     * Filter the query on the ownFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnfinance(1234); // WHERE ownFinance = 1234
     * $query->filterByOwnfinance(array(12, 34)); // WHERE ownFinance IN (12, 34)
     * $query->filterByOwnfinance(array('min' => 12)); // WHERE ownFinance > 12
     * </code>
     *
     * @param     mixed $ownfinance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOwnfinance($ownfinance = null, $comparison = null)
    {
        if (is_array($ownfinance)) {
            $useMinMax = false;
            if (isset($ownfinance['min'])) {
                $this->addUsingAlias(ProjectPeer::OWNFINANCE, $ownfinance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ownfinance['max'])) {
                $this->addUsingAlias(ProjectPeer::OWNFINANCE, $ownfinance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::OWNFINANCE, $ownfinance, $comparison);
    }

    /**
     * Filter the query on the provinceFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByProvincefinance(1234); // WHERE provinceFinance = 1234
     * $query->filterByProvincefinance(array(12, 34)); // WHERE provinceFinance IN (12, 34)
     * $query->filterByProvincefinance(array('min' => 12)); // WHERE provinceFinance > 12
     * </code>
     *
     * @param     mixed $provincefinance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByProvincefinance($provincefinance = null, $comparison = null)
    {
        if (is_array($provincefinance)) {
            $useMinMax = false;
            if (isset($provincefinance['min'])) {
                $this->addUsingAlias(ProjectPeer::PROVINCEFINANCE, $provincefinance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($provincefinance['max'])) {
                $this->addUsingAlias(ProjectPeer::PROVINCEFINANCE, $provincefinance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::PROVINCEFINANCE, $provincefinance, $comparison);
    }

    /**
     * Filter the query on the nationFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByNationfinance(1234); // WHERE nationFinance = 1234
     * $query->filterByNationfinance(array(12, 34)); // WHERE nationFinance IN (12, 34)
     * $query->filterByNationfinance(array('min' => 12)); // WHERE nationFinance > 12
     * </code>
     *
     * @param     mixed $nationfinance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByNationfinance($nationfinance = null, $comparison = null)
    {
        if (is_array($nationfinance)) {
            $useMinMax = false;
            if (isset($nationfinance['min'])) {
                $this->addUsingAlias(ProjectPeer::NATIONFINANCE, $nationfinance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($nationfinance['max'])) {
                $this->addUsingAlias(ProjectPeer::NATIONFINANCE, $nationfinance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::NATIONFINANCE, $nationfinance, $comparison);
    }

    /**
     * Filter the query on the otherFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByOtherfinance(1234); // WHERE otherFinance = 1234
     * $query->filterByOtherfinance(array(12, 34)); // WHERE otherFinance IN (12, 34)
     * $query->filterByOtherfinance(array('min' => 12)); // WHERE otherFinance > 12
     * </code>
     *
     * @param     mixed $otherfinance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByOtherfinance($otherfinance = null, $comparison = null)
    {
        if (is_array($otherfinance)) {
            $useMinMax = false;
            if (isset($otherfinance['min'])) {
                $this->addUsingAlias(ProjectPeer::OTHERFINANCE, $otherfinance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($otherfinance['max'])) {
                $this->addUsingAlias(ProjectPeer::OTHERFINANCE, $otherfinance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::OTHERFINANCE, $otherfinance, $comparison);
    }

    /**
     * Filter the query on the financeDetail column
     *
     * Example usage:
     * <code>
     * $query->filterByFinancedetail('fooValue');   // WHERE financeDetail = 'fooValue'
     * $query->filterByFinancedetail('%fooValue%'); // WHERE financeDetail LIKE '%fooValue%'
     * </code>
     *
     * @param     string $financedetail The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByFinancedetail($financedetail = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($financedetail)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $financedetail)) {
                $financedetail = str_replace('*', '%', $financedetail);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::FINANCEDETAIL, $financedetail, $comparison);
    }

    /**
     * Filter the query on the financeProgram column
     *
     * Example usage:
     * <code>
     * $query->filterByFinanceprogram('fooValue');   // WHERE financeProgram = 'fooValue'
     * $query->filterByFinanceprogram('%fooValue%'); // WHERE financeProgram LIKE '%fooValue%'
     * </code>
     *
     * @param     string $financeprogram The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByFinanceprogram($financeprogram = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($financeprogram)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $financeprogram)) {
                $financeprogram = str_replace('*', '%', $financeprogram);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectPeer::FINANCEPROGRAM, $financeprogram, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(ProjectPeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(ProjectPeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(ProjectPeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(ProjectPeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ProjectPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ProjectPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(ProjectPeer::OBJECTIVEID, $objective->getId(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectPeer::OBJECTIVEID, $objective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ProjectPeer::RESPONSIBLECODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectPeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(ProjectPeer::INDICATORID, $indicator->getId(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectPeer::INDICATORID, $indicator->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ProjectPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Construction object
     *
     * @param   Construction|PropelObjectCollection $construction  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByConstruction($construction, $comparison = null)
    {
        if ($construction instanceof Construction) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $construction->getProyectid(), $comparison);
        } elseif ($construction instanceof PropelObjectCollection) {
            return $this
                ->useConstructionQuery()
                ->filterByPrimaryKeys($construction->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByConstruction() only accepts arguments of type Construction or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Construction relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinConstruction($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Construction');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Construction');
        }

        return $this;
    }

    /**
     * Use the Construction relation Construction object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ConstructionQuery A secondary query class using the current class as primary query
     */
    public function useConstructionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinConstruction($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Construction', 'ConstructionQuery');
    }

    /**
     * Filter the query by a related Guarantee object
     *
     * @param   Guarantee|PropelObjectCollection $guarantee  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByGuarantee($guarantee, $comparison = null)
    {
        if ($guarantee instanceof Guarantee) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $guarantee->getProjectid(), $comparison);
        } elseif ($guarantee instanceof PropelObjectCollection) {
            return $this
                ->useGuaranteeQuery()
                ->filterByPrimaryKeys($guarantee->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByGuarantee() only accepts arguments of type Guarantee or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Guarantee relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinGuarantee($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Guarantee');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Guarantee');
        }

        return $this;
    }

    /**
     * Use the Guarantee relation Guarantee object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   GuaranteeQuery A secondary query class using the current class as primary query
     */
    public function useGuaranteeQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinGuarantee($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Guarantee', 'GuaranteeQuery');
    }

    /**
     * Filter the query by a related AdministrativeAct object
     *
     * @param   AdministrativeAct|PropelObjectCollection $administrativeAct  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdministrativeAct($administrativeAct, $comparison = null)
    {
        if ($administrativeAct instanceof AdministrativeAct) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $administrativeAct->getProjectid(), $comparison);
        } elseif ($administrativeAct instanceof PropelObjectCollection) {
            return $this
                ->useAdministrativeActQuery()
                ->filterByPrimaryKeys($administrativeAct->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAdministrativeAct() only accepts arguments of type AdministrativeAct or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdministrativeAct relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinAdministrativeAct($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdministrativeAct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdministrativeAct');
        }

        return $this;
    }

    /**
     * Use the AdministrativeAct relation AdministrativeAct object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdministrativeActQuery A secondary query class using the current class as primary query
     */
    public function useAdministrativeActQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinAdministrativeAct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdministrativeAct', 'AdministrativeActQuery');
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $mission->getProjectid(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            return $this
                ->useMissionQuery()
                ->filterByPrimaryKeys($mission->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related ProjectRegion object
     *
     * @param   ProjectRegion|PropelObjectCollection $projectRegion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectRegion($projectRegion, $comparison = null)
    {
        if ($projectRegion instanceof ProjectRegion) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectRegion->getProjectid(), $comparison);
        } elseif ($projectRegion instanceof PropelObjectCollection) {
            return $this
                ->useProjectRegionQuery()
                ->filterByPrimaryKeys($projectRegion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectRegion() only accepts arguments of type ProjectRegion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectRegion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectRegion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectRegion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectRegion');
        }

        return $this;
    }

    /**
     * Use the ProjectRegion relation ProjectRegion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectRegionQuery A secondary query class using the current class as primary query
     */
    public function useProjectRegionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectRegion', 'ProjectRegionQuery');
    }

    /**
     * Filter the query by a related ProjectMilestone object
     *
     * @param   ProjectMilestone|PropelObjectCollection $projectMilestone  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectMilestone($projectMilestone, $comparison = null)
    {
        if ($projectMilestone instanceof ProjectMilestone) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectMilestone->getProjectid(), $comparison);
        } elseif ($projectMilestone instanceof PropelObjectCollection) {
            return $this
                ->useProjectMilestoneQuery()
                ->filterByPrimaryKeys($projectMilestone->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectMilestone() only accepts arguments of type ProjectMilestone or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectMilestone relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectMilestone($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectMilestone');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectMilestone');
        }

        return $this;
    }

    /**
     * Use the ProjectMilestone relation ProjectMilestone object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectMilestoneQuery A secondary query class using the current class as primary query
     */
    public function useProjectMilestoneQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectMilestone($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectMilestone', 'ProjectMilestoneQuery');
    }

    /**
     * Filter the query by a related ProjectIndicator object
     *
     * @param   ProjectIndicator|PropelObjectCollection $projectIndicator  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectIndicator($projectIndicator, $comparison = null)
    {
        if ($projectIndicator instanceof ProjectIndicator) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectIndicator->getProjectid(), $comparison);
        } elseif ($projectIndicator instanceof PropelObjectCollection) {
            return $this
                ->useProjectIndicatorQuery()
                ->filterByPrimaryKeys($projectIndicator->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectIndicator() only accepts arguments of type ProjectIndicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectIndicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectIndicator($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectIndicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectIndicator');
        }

        return $this;
    }

    /**
     * Use the ProjectIndicator relation ProjectIndicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectIndicatorQuery A secondary query class using the current class as primary query
     */
    public function useProjectIndicatorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectIndicator', 'ProjectIndicatorQuery');
    }

    /**
     * Filter the query by a related ProjectActivity object
     *
     * @param   ProjectActivity|PropelObjectCollection $projectActivity  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivity($projectActivity, $comparison = null)
    {
        if ($projectActivity instanceof ProjectActivity) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectActivity->getProjectid(), $comparison);
        } elseif ($projectActivity instanceof PropelObjectCollection) {
            return $this
                ->useProjectActivityQuery()
                ->filterByPrimaryKeys($projectActivity->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectActivity() only accepts arguments of type ProjectActivity or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivity relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectActivity($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivity');
        }

        return $this;
    }

    /**
     * Use the ProjectActivity relation ProjectActivity object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectActivity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivity', 'ProjectActivityQuery');
    }

    /**
     * Filter the query by a related ProjectDocument object
     *
     * @param   ProjectDocument|PropelObjectCollection $projectDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectDocument($projectDocument, $comparison = null)
    {
        if ($projectDocument instanceof ProjectDocument) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectDocument->getProjectId(), $comparison);
        } elseif ($projectDocument instanceof PropelObjectCollection) {
            return $this
                ->useProjectDocumentQuery()
                ->filterByPrimaryKeys($projectDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectDocument() only accepts arguments of type ProjectDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectDocument');
        }

        return $this;
    }

    /**
     * Use the ProjectDocument relation ProjectDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectDocumentQuery A secondary query class using the current class as primary query
     */
    public function useProjectDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectDocument', 'ProjectDocumentQuery');
    }

    /**
     * Filter the query by a related ProjectContractor object
     *
     * @param   ProjectContractor|PropelObjectCollection $projectContractor  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectContractor($projectContractor, $comparison = null)
    {
        if ($projectContractor instanceof ProjectContractor) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectContractor->getProjectId(), $comparison);
        } elseif ($projectContractor instanceof PropelObjectCollection) {
            return $this
                ->useProjectContractorQuery()
                ->filterByPrimaryKeys($projectContractor->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectContractor() only accepts arguments of type ProjectContractor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectContractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectContractor($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectContractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectContractor');
        }

        return $this;
    }

    /**
     * Use the ProjectContractor relation ProjectContractor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectContractorQuery A secondary query class using the current class as primary query
     */
    public function useProjectContractorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectContractor', 'ProjectContractorQuery');
    }

    /**
     * Filter the query by a related ProjectLog object
     *
     * @param   ProjectLog|PropelObjectCollection $projectLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectLog($projectLog, $comparison = null)
    {
        if ($projectLog instanceof ProjectLog) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectLog->getProjectid(), $comparison);
        } elseif ($projectLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectLogQuery()
                ->filterByPrimaryKeys($projectLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectLog() only accepts arguments of type ProjectLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectLog');
        }

        return $this;
    }

    /**
     * Use the ProjectLog relation ProjectLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectLog', 'ProjectLogQuery');
    }

    /**
     * Filter the query by a related ProjectMilestoneLog object
     *
     * @param   ProjectMilestoneLog|PropelObjectCollection $projectMilestoneLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectMilestoneLog($projectMilestoneLog, $comparison = null)
    {
        if ($projectMilestoneLog instanceof ProjectMilestoneLog) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectMilestoneLog->getProjectid(), $comparison);
        } elseif ($projectMilestoneLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectMilestoneLogQuery()
                ->filterByPrimaryKeys($projectMilestoneLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectMilestoneLog() only accepts arguments of type ProjectMilestoneLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectMilestoneLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectMilestoneLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectMilestoneLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectMilestoneLog');
        }

        return $this;
    }

    /**
     * Use the ProjectMilestoneLog relation ProjectMilestoneLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectMilestoneLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectMilestoneLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectMilestoneLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectMilestoneLog', 'ProjectMilestoneLogQuery');
    }

    /**
     * Filter the query by a related ProjectActivityLog object
     *
     * @param   ProjectActivityLog|PropelObjectCollection $projectActivityLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivityLog($projectActivityLog, $comparison = null)
    {
        if ($projectActivityLog instanceof ProjectActivityLog) {
            return $this
                ->addUsingAlias(ProjectPeer::ID, $projectActivityLog->getProjectid(), $comparison);
        } elseif ($projectActivityLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectActivityLogQuery()
                ->filterByPrimaryKeys($projectActivityLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectActivityLog() only accepts arguments of type ProjectActivityLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivityLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function joinProjectActivityLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivityLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivityLog');
        }

        return $this;
    }

    /**
     * Use the ProjectActivityLog relation ProjectActivityLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectActivityLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivityLog', 'ProjectActivityLogQuery');
    }

    /**
     * Filter the query by a related Region object
     * using the projects_region table as cross reference
     *
     * @param   Region $region the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     */
    public function filterByRegion($region, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectRegionQuery()
            ->filterByRegion($region, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Document object
     * using the projects_document table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Contractor object
     * using the projects_contractor table as cross reference
     *
     * @param   Contractor $contractor the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectQuery The current query, for fluid interface
     */
    public function filterByContractor($contractor, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectContractorQuery()
            ->filterByContractor($contractor, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Project $project Object to remove from the list of results
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function prune($project = null)
    {
        if ($project) {
            $this->addUsingAlias(ProjectPeer::ID, $project->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ProjectQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ProjectPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ProjectQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(ProjectPeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(ProjectPeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(ProjectPeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(ProjectPeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(ProjectPeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     ProjectQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(ProjectPeer::CREATED_AT);
    }
    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ProjectQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ProjectQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ProjectPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ProjectPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
