<?php

class ProjectsEditAction extends BaseSelectAction {

	function __construct($entityClassName = "Project") {
		parent::__construct($entityClassName);
	}

	function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);
		$this->smarty->assign('priorityTypes', Project::getPriorities());
		$this->smarty->assign('positions', PositionQuery::create()->find());
		$this->smarty->assign('objectives', ObjectiveQuery::create()->find());
		$this->smarty->assign('minorChanges', ConfigModule::get('projects', 'useMinorChanges'));

		// Caso edicion desde show.
		if (isset($_GET['show'])) {
			$this->smarty->assign('show',1);
			// Para menu de navegacion.
			$thi->smarty->assign('dependency',$this->entity->getObjective()->getAffiliate());
		}

		if (isset($_GET['id'])) {
			// Voy a editar un proyecto.
			if (isset($this->entity)) {
				$this->entity->prepareDocuments($this->smarty);
				$this->entity->prepareContractors($this->smarty);
				$this->entity->prepareRegions($this->smarty, $this->entity->getId());
			}
			$this->smarty->assign('action', 'edit');

		} else {
			// Voy a crear un nuevo proyecto.
			$this->entity->setStartingYear($_SESSION['planning']['startingYear']);
			$this->entity->setEndingYear($_SESSION['planning']['endingYear']);

			if (isset($_GET['filters']['fromObjectives']))
				$this->entity->setObjectiveId($_GET['filters']['objectiveId']);

			$this->entity->preparePositions($this->smarty);
			$this->smarty->assign('action', 'create');
		}
		
		// Esta funcion asigna datos tanto para edit como para create.
		$this->entity->prepareFinancingSources($this->smarty);


		$isConstruction = ($this->entity->isNew() && $_GET['isConstruction'])
			|| $this->entity->getIsConstruction();
		$this->smarty->assign('isConstruction', $isConstruction);

		$construction = $this->entity->getConstruction();
		if (!$construction) $construction = new Construction();
		$this->smarty->assign('construction', $construction);

		$constructionHasProgressRecords = $construction
			&& $construction->countConstructionProgresss() > 0;
		$this->smarty->assign('constructionHasProgressRecords',
			$constructionHasProgressRecords);

		$this->smarty->assign('saveReturn', $_GET['saveReturn']);
	}
	
}
