<?php

trait PanelMissionAccessRedirect {

	private function checkAccess($mission, $accessTypes) {

		if ($mission->isNew()) return;

		$loggedUser = Common::getLoggedUser();
		if (!is_array($accessTypes)) $accessTypes = [$accessTypes];

		foreach ($accessTypes as $accessType) {
			$hasAccess = 'userHas'.ucfirst(strtolower($accessType)).'Access';
			if (!$mission->$hasAccess($loggedUser)) {
				header('Location: Main.php?do=securityNoPermission');
				die;
			}
		}
	}

	function checkReadAccess($mission) {
		return $this->checkAccess($mission, 'read');
	}

	function checkWriteAccess($mission) {
		return $this->checkAccess($mission, ['read', 'write']);
	}
}
