<?php



/**
 * This class defines the structure of the 'positions_position' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.positions.classes.map
 */
class PositionTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'positions.classes.map.PositionTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('positions_position');
        $this->setPhpName('Position');
        $this->setClassname('Position');
        $this->setPackage('positions.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('CODE', 'Code', 'INTEGER', true, null, null);
        $this->addForeignKey('USERGROUPID', 'Usergroupid', 'INTEGER', 'users_group', 'ID', false, null, null);
        $this->addForeignKey('VERSIONID', 'Versionid', 'INTEGER', 'positions_version', 'ID', true, null, null);
        $this->addColumn('INTERNALCODE', 'Internalcode', 'VARCHAR', false, 255, null);
        $this->addColumn('OWNERNAME', 'Ownername', 'VARCHAR', false, 150, null);
        $this->addColumn('OWNERNAMEFEMALE', 'Ownernamefemale', 'VARCHAR', false, 150, null);
        $this->addColumn('TYPE', 'Type', 'INTEGER', true, null, null);
        $this->addColumn('KIND', 'Kind', 'VARCHAR', true, 50, 'hierarchical');
        $this->addColumn('ADDRESS', 'Address', 'LONGVARCHAR', false, null, null);
        $this->addColumn('TELEPHONE', 'Telephone', 'VARCHAR', false, 150, null);
        $this->addColumn('EMAIL', 'Email', 'VARCHAR', false, 150, null);
        $this->addColumn('BUDGET', 'Budget', 'FLOAT', false, null, 0);
        $this->addColumn('PERSONNEL', 'Personnel', 'INTEGER', false, null, 0);
        $this->addColumn('HIRED', 'Hired', 'INTEGER', false, null, 0);
        $this->addColumn('CONSULTANT', 'Consultant', 'INTEGER', false, null, 0);
        $this->addColumn('OTHER', 'Other', 'INTEGER', false, null, 0);
        $this->addColumn('PLANNING', 'Planning', 'BOOLEAN', false, 1, null);
        $this->addColumn('ORDER', 'Order', 'INTEGER', false, null, 0);
        $this->addColumn('TREE_LEFT', 'TreeLeft', 'INTEGER', false, null, null);
        $this->addColumn('TREE_RIGHT', 'TreeRight', 'INTEGER', false, null, null);
        $this->addColumn('TREE_LEVEL', 'TreeLevel', 'INTEGER', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Group', 'Group', RelationMap::MANY_TO_ONE, array('userGroupId' => 'id', ), null, null);
        $this->addRelation('PositionVersion', 'PositionVersion', RelationMap::MANY_TO_ONE, array('versionId' => 'id', ), null, null);
        $this->addRelation('Indicator', 'Indicator', RelationMap::ONE_TO_MANY, array('id' => 'positionId', ), 'CASCADE', null, 'Indicators');
        $this->addRelation('Objective', 'Objective', RelationMap::ONE_TO_MANY, array('code' => 'responsibleCode', ), null, null, 'Objectives');
        $this->addRelation('ObjectivePosition', 'ObjectivePosition', RelationMap::ONE_TO_MANY, array('id' => 'positionId', ), null, null, 'ObjectivePositions');
        $this->addRelation('ObjectiveLog', 'ObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'responsibleCode', ), null, null, 'ObjectiveLogs');
        $this->addRelation('AlertDigest', 'AlertDigest', RelationMap::ONE_TO_MANY, array('code' => 'positionCode', ), null, null, 'AlertDigests');
        $this->addRelation('PositionTenure', 'PositionTenure', RelationMap::ONE_TO_MANY, array('code' => 'positionCode', ), null, null, 'PositionTenures');
        $this->addRelation('PositionDocument', 'PositionDocument', RelationMap::ONE_TO_MANY, array('id' => 'positionId', ), 'CASCADE', null, 'PositionDocuments');
        $this->addRelation('Project', 'Project', RelationMap::ONE_TO_MANY, array('code' => 'responsibleCode', ), null, null, 'Projects');
        $this->addRelation('ProjectActivity', 'ProjectActivity', RelationMap::ONE_TO_MANY, array('code' => 'responsibleCode', ), null, null, 'ProjectActivitys');
        $this->addRelation('ProjectLog', 'ProjectLog', RelationMap::ONE_TO_MANY, array('code' => 'responsibleCode', ), null, null, 'ProjectLogs');
        $this->addRelation('ProjectActivityLog', 'ProjectActivityLog', RelationMap::ONE_TO_MANY, array('code' => 'responsibleCode', ), null, null, 'ProjectActivityLogs');
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'nested_set' => array('left_column' => 'tree_left', 'right_column' => 'tree_right', 'level_column' => 'tree_level', 'use_scope' => 'true', 'scope_column' => 'versionId', 'method_proxies' => 'false', ),
        );
    } // getBehaviors()

} // PositionTableMap
