<?php


/**
 * Skeleton subclass for performing query and update operations on the 'positions_position' table.
 *
 * Cargos
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.positions.classes
 */
class PositionQuery extends BasePositionQuery {

	private $useUserGroupIdAutoFilter = false;

	/**
	 * Aplica filtros automaticos por defecto
	 * @return query con filtrado de dependencias ordenado por versiones
	 */
	protected function preSelect(\PropelPDO $con) {
		parent::preSelect($con);
		$this->orderByVersionid(Criteria::DESC);

		$loginUser = Common::getLoggedUser();
		if (!$loginUser->isAdmin() && $this->useUserGroupIdAutoFilter) {
			$groupIds = $loginUser->getUserGroupIds();
			$this->filterByUsergroupid($groupIds);
		}
	}

	/**
	 * Deshabilita el filtro automatico por grupo de usuarios
	 */
	function disableUserGroupIdAutoFilter() {
		$this->useUserGroupIdAutoFilter = false;
		return $this;
	}

 	/**
	 * Aplica orden de positions por versiones
	 * @return query orden de versiones
	*/
	public static function createOrderedByVersion() {
		return self::create()->orderByVersionid(Criteria::DESC);
	}

 	/**
	 * Aplica filtro para los position que planifican
	 * @return query orden de versiones
	*/
  	public function filterByDoPlanning() {
		$treeRootType = ConfigModule::get("positions","treeRootType");
		$planningType = array_keys(ConfigModule::get("objectives","positionsTypes"));
		array_push($planningType, $treeRootType);

		return $this->filterByType($planningType)
					->_or()
					->filterByPlanning(1);
	}

 	/**
	 * Aplica filtro segun codigo de position y respectivo grupo de usuarios
	 *
	 * @params $code integer code de position para filtrar pro grupo
	 * @return query filtrado por gruopos de usuario
	*/
	public function filterByGroupCode($code) {
		if (!empty($code) && $code != 0) {
			$position = PositionQuery::create()->findOneByCode($code);
			$this->filterByUsergroupid($position->getUsergroupid());
		}
	}

	/**
	 * Aplica filtro por versiones
	 * @return query filtro por versiones
	*/
	public function filterByLastVersion() {
		return $this->filterByVersionid(PositionVersionQuery::getLastVersionId());
	}

	function filterByLoggedUserGroupWithDesc() {
		$loggedUser = Common::getLoggedUser();
		if (!empty($loggedUser) && !$loggedUser->isAdmin()) {

			$groupIds = $loggedUser->getUserGroupIds();

			$positions = static::create()
				->filterByLastVersion()
				->filterByUsergroupid($groupIds)
				->find();

			$positionsWithDescQuery = PositionQuery::create()
				->filterByLastVersion();

			$positionsLevelCrit = null;
			foreach ($positions as $position) {

				$leftCrit = new Criterion($positionsWithDescQuery, PositionPeer::LEFT_COL,
						$position->getLeftValue(), Criteria::GREATER_EQUAL);
				$rightCrit = new Criterion($positionsWithDescQuery, PositionPeer::LEFT_COL,
						$position->getRightValue(), Criteria::LESS_EQUAL);
				$aux = $leftCrit->addAnd($rightCrit);

				$positionsLevelCrit = $positionsLevelCrit ? $positionsLevelCrit->addOr($aux) : $aux;
			}

			if ($positionsLevelCrit) {
				$respWithDescCodes = $positionsWithDescQuery->add($positionsLevelCrit)
					->select('code')
					->find()
					->toArray();
			} else {
				$respWithDescCodes = [];
			}


			$this->filterByCode($respWithDescCodes);
		}

		return $this;
	}

	/**
	 * Filtra las dependencias por las que tienen objetivos asociados.
	 * @return PositionQuery $this
	 */
	public function filterByHasObjective() {
		$objectivePositions = ObjectivePositionQuery::create()->find();

		$positionsIds = null;
		foreach($objectivePositions as $objectivePosition){
			$positionsIds[] = $objectivePosition->getPositionid();
		}

		if (!is_null($positionsIds))
			$this->filterById($positionsIds);

		return $this;
	}

} // PositionQuery
