<?php

/**
 * PositionsChartShowAction
 *
 * Muestra organigrama
 *
 * @package positions
 */

class PositionsChartShowAction extends BaseAction
{

    /**
     * Acciones a ejecutar antes generar el display
     */
    protected function exec()
    {
        parent::exec();

        $this->smarty->assign('positionHeader', true);
        $this->smarty->assign('includeJQuery', true);

        $versions = PositionQuery::create()->select('versionid')->setDistinct()->find()->toArray();
        $this->smarty->assign('versions', $versions);
        //por defecto muestra la última versión
        $version = count($versions)-1;

        if (isset($_GET['version']) && in_array($_GET['version'], $versions))
            $version = $_GET['version'];

        $this->smarty->assign('version', $version);

        // Obtengo too el arbol de positions segun la version definida
        $tree = PositionQuery::create()->orderByBranch()->findTree($version);
        $this->smarty->assign('positions', $tree);

        if (!empty($_GET['positionId']))
        {
            $node = PositionQuery::create()->findOneById($_GET['positionId']);
            if (!empty($node))
            {
                $this->smarty->assign('position', $node);
                $root = PositionQuery::create()->findRoot($node);
                if ($root->getId() == $_GET['positionId'])
                    $this->smarty->assign('root', $root->getId());
            }
            else
                $this->smarty->assign('invalidId', true);
        }
        else
        {
            $this->smarty->assign('position', PositionQuery::create()->findRoot($tree[0]));
            //shortVersion true: se muestran dos niveles desplegados, false: todos los niveles,
            $this->smarty->assign('shortVersion', true);
        }

    }

}

