<?php



/**
 * This class defines the structure of the 'panel_missionCommitment' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.panel.classes.map
 */
class MissionCommitmentTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'panel.classes.map.MissionCommitmentTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('panel_missionCommitment');
        $this->setPhpName('MissionCommitment');
        $this->setClassname('MissionCommitment');
        $this->setPackage('panel.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('MISSIONID', 'Missionid', 'INTEGER', 'panel_mission', 'ID', false, null, null);
        $this->addForeignKey('PARTICIPANTID', 'Participantid', 'INTEGER', 'panel_missionParticipant', 'ID', false, null, null);
        $this->addColumn('RESPONSIBLE', 'Responsible', 'CHAR', false, 255, null);
        $this->addColumn('COMMITMENT', 'Commitment', 'LONGVARCHAR', false, null, null);
        $this->addColumn('ACHIEVED', 'Achieved', 'BOOLEAN', false, 1, null);
        $this->addColumn('DATE', 'Date', 'DATE', true, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Mission', 'Mission', RelationMap::MANY_TO_ONE, array('missionId' => 'id', ), 'CASCADE', null);
        $this->addRelation('MissionParticipant', 'MissionParticipant', RelationMap::MANY_TO_ONE, array('participantId' => 'id', ), null, null);
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // MissionCommitmentTableMap
