<?php

set_time_limit(720);

require_once 'AlertManager.php';

/**
 * Esta accion esta pensada para ser corrida con cron.
 * Para ello se puede usar las siguientes lineas:
 *
 * cd /ruta/del/main/; php Main.php do=panelSendAlert 1>> alert_log 2>> alert_log;
 *
 * Con eso redireccionamos la salida estandar y la de errores al archivo alert_log.
 *
 * Recordar comentar la linea $manager->setTestMode(); cuando se quiera activar efectivamente.
 */

class PanelSendAlertDigestAction extends BaseAction {

	protected $debugMode = true;

	function exec() {

		$this->debugMode = $_REQUEST['debug'];

		if ( (!$this->debugMode && empty($_POST['do'])) || !Common::getLoggedUser()->isSupervisor()) {
			die('inaccesible');
		}

		if (parent::exec() === false) {
			return false;
		}

		$this->template->template = "TemplatePlain.tpl";

		$alertManager = new AlertManager();

		$positions = PositionQuery::create()
			->filterByLastVersion()
			->find();

		$digestMail = $alertManager->createAlertDigestMail($positions);

		if ($this->debugMode) {
			$this->smarty->assign('mailTo', $digestMail->getMailTo());
			$this->smarty->assign('alertBody', $digestMail->getBody());
			$this->smarty->display('PanelSendAlertDigestDebug.tpl');
		} else {
			$result = $digestMail->send();
		}

		die;
	}
}
