<?php


/**
 * Base static class for performing query and update operations on the 'objectives_policyGuideline' table.
 *
 * Policy Guidelines
 *
 * @package propel.generator.objectives.classes.om
 */
abstract class BasePolicyGuidelinePeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'objectives_policyGuideline';

    /** the related Propel class for this table */
    const OM_CLASS = 'PolicyGuideline';

    /** the related TableMap class for this table */
    const TM_CLASS = 'PolicyGuidelineTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 12;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 12;

    /** the column name for the ID field */
    const ID = 'objectives_policyGuideline.ID';

    /** the column name for the NAME field */
    const NAME = 'objectives_policyGuideline.NAME';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'objectives_policyGuideline.DESCRIPTION';

    /** the column name for the EXCHANGERATE field */
    const EXCHANGERATE = 'objectives_policyGuideline.EXCHANGERATE';

    /** the column name for the USERID field */
    const USERID = 'objectives_policyGuideline.USERID';

    /** the column name for the OBJECTTYPE field */
    const OBJECTTYPE = 'objectives_policyGuideline.OBJECTTYPE';

    /** the column name for the OBJECTID field */
    const OBJECTID = 'objectives_policyGuideline.OBJECTID';

    /** the column name for the STARTINGYEAR field */
    const STARTINGYEAR = 'objectives_policyGuideline.STARTINGYEAR';

    /** the column name for the ENDINGYEAR field */
    const ENDINGYEAR = 'objectives_policyGuideline.ENDINGYEAR';

    /** the column name for the UPDATED field */
    const UPDATED = 'objectives_policyGuideline.UPDATED';

    /** the column name for the CHANGES field */
    const CHANGES = 'objectives_policyGuideline.CHANGES';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'objectives_policyGuideline.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of PolicyGuideline objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array PolicyGuideline[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. PolicyGuidelinePeer::$fieldNames[PolicyGuidelinePeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Description', 'Exchangerate', 'Userid', 'Objecttype', 'Objectid', 'Startingyear', 'Endingyear', 'Updated', 'Changes', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'description', 'exchangerate', 'userid', 'objecttype', 'objectid', 'startingyear', 'endingyear', 'updated', 'changes', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (PolicyGuidelinePeer::ID, PolicyGuidelinePeer::NAME, PolicyGuidelinePeer::DESCRIPTION, PolicyGuidelinePeer::EXCHANGERATE, PolicyGuidelinePeer::USERID, PolicyGuidelinePeer::OBJECTTYPE, PolicyGuidelinePeer::OBJECTID, PolicyGuidelinePeer::STARTINGYEAR, PolicyGuidelinePeer::ENDINGYEAR, PolicyGuidelinePeer::UPDATED, PolicyGuidelinePeer::CHANGES, PolicyGuidelinePeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'DESCRIPTION', 'EXCHANGERATE', 'USERID', 'OBJECTTYPE', 'OBJECTID', 'STARTINGYEAR', 'ENDINGYEAR', 'UPDATED', 'CHANGES', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'description', 'exchangeRate', 'userId', 'objectType', 'objectId', 'startingYear', 'endingYear', 'updated', 'changes', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. PolicyGuidelinePeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Description' => 2, 'Exchangerate' => 3, 'Userid' => 4, 'Objecttype' => 5, 'Objectid' => 6, 'Startingyear' => 7, 'Endingyear' => 8, 'Updated' => 9, 'Changes' => 10, 'DeletedAt' => 11, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'description' => 2, 'exchangerate' => 3, 'userid' => 4, 'objecttype' => 5, 'objectid' => 6, 'startingyear' => 7, 'endingyear' => 8, 'updated' => 9, 'changes' => 10, 'deletedAt' => 11, ),
        BasePeer::TYPE_COLNAME => array (PolicyGuidelinePeer::ID => 0, PolicyGuidelinePeer::NAME => 1, PolicyGuidelinePeer::DESCRIPTION => 2, PolicyGuidelinePeer::EXCHANGERATE => 3, PolicyGuidelinePeer::USERID => 4, PolicyGuidelinePeer::OBJECTTYPE => 5, PolicyGuidelinePeer::OBJECTID => 6, PolicyGuidelinePeer::STARTINGYEAR => 7, PolicyGuidelinePeer::ENDINGYEAR => 8, PolicyGuidelinePeer::UPDATED => 9, PolicyGuidelinePeer::CHANGES => 10, PolicyGuidelinePeer::DELETED_AT => 11, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'DESCRIPTION' => 2, 'EXCHANGERATE' => 3, 'USERID' => 4, 'OBJECTTYPE' => 5, 'OBJECTID' => 6, 'STARTINGYEAR' => 7, 'ENDINGYEAR' => 8, 'UPDATED' => 9, 'CHANGES' => 10, 'DELETED_AT' => 11, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'description' => 2, 'exchangeRate' => 3, 'userId' => 4, 'objectType' => 5, 'objectId' => 6, 'startingYear' => 7, 'endingYear' => 8, 'updated' => 9, 'changes' => 10, 'deleted_at' => 11, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = PolicyGuidelinePeer::getFieldNames($toType);
        $key = isset(PolicyGuidelinePeer::$fieldKeys[$fromType][$name]) ? PolicyGuidelinePeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(PolicyGuidelinePeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, PolicyGuidelinePeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return PolicyGuidelinePeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. PolicyGuidelinePeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(PolicyGuidelinePeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PolicyGuidelinePeer::ID);
            $criteria->addSelectColumn(PolicyGuidelinePeer::NAME);
            $criteria->addSelectColumn(PolicyGuidelinePeer::DESCRIPTION);
            $criteria->addSelectColumn(PolicyGuidelinePeer::EXCHANGERATE);
            $criteria->addSelectColumn(PolicyGuidelinePeer::USERID);
            $criteria->addSelectColumn(PolicyGuidelinePeer::OBJECTTYPE);
            $criteria->addSelectColumn(PolicyGuidelinePeer::OBJECTID);
            $criteria->addSelectColumn(PolicyGuidelinePeer::STARTINGYEAR);
            $criteria->addSelectColumn(PolicyGuidelinePeer::ENDINGYEAR);
            $criteria->addSelectColumn(PolicyGuidelinePeer::UPDATED);
            $criteria->addSelectColumn(PolicyGuidelinePeer::CHANGES);
            $criteria->addSelectColumn(PolicyGuidelinePeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.EXCHANGERATE');
            $criteria->addSelectColumn($alias . '.USERID');
            $criteria->addSelectColumn($alias . '.OBJECTTYPE');
            $criteria->addSelectColumn($alias . '.OBJECTID');
            $criteria->addSelectColumn($alias . '.STARTINGYEAR');
            $criteria->addSelectColumn($alias . '.ENDINGYEAR');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.CHANGES');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PolicyGuidelinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PolicyGuidelinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 PolicyGuideline
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = PolicyGuidelinePeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return PolicyGuidelinePeer::populateObjects(PolicyGuidelinePeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            PolicyGuidelinePeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);
        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      PolicyGuideline $obj A PolicyGuideline object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            PolicyGuidelinePeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A PolicyGuideline object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof PolicyGuideline) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or PolicyGuideline object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(PolicyGuidelinePeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   PolicyGuideline Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(PolicyGuidelinePeer::$instances[$key])) {
                return PolicyGuidelinePeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        PolicyGuidelinePeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to objectives_policyGuideline
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in PolicyGuidelineIndicatorsPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PolicyGuidelineIndicatorsPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = PolicyGuidelinePeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = PolicyGuidelinePeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PolicyGuidelinePeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (PolicyGuideline object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = PolicyGuidelinePeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PolicyGuidelinePeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            PolicyGuidelinePeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PolicyGuidelinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PolicyGuidelinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PolicyGuidelinePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of PolicyGuideline objects pre-filled with their User objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of PolicyGuideline objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);
        }

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol = PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;
        UserPeer::addSelectColumns($criteria);

        $criteria->addJoin(PolicyGuidelinePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PolicyGuidelinePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = PolicyGuidelinePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PolicyGuidelinePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (PolicyGuideline) to $obj2 (User)
                $obj2->addPolicyGuideline($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PolicyGuidelinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PolicyGuidelinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PolicyGuidelinePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of PolicyGuideline objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of PolicyGuideline objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);
        }

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol2 = PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + UserPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(PolicyGuidelinePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled()) {
            $criteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PolicyGuidelinePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = PolicyGuidelinePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PolicyGuidelinePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined User rows

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (PolicyGuideline) to the collection in $obj2 (User)
                $obj2->addPolicyGuideline($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(PolicyGuidelinePeer::DATABASE_NAME)->getTable(PolicyGuidelinePeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BasePolicyGuidelinePeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BasePolicyGuidelinePeer::TABLE_NAME)) {
        $dbMap->addTableObject(new PolicyGuidelineTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return PolicyGuidelinePeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a PolicyGuideline or Criteria object.
     *
     * @param      mixed $values Criteria or PolicyGuideline object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from PolicyGuideline object
        }

        if ($criteria->containsKey(PolicyGuidelinePeer::ID) && $criteria->keyContainsValue(PolicyGuidelinePeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PolicyGuidelinePeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a PolicyGuideline or Criteria object.
     *
     * @param      mixed $values Criteria or PolicyGuideline object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(PolicyGuidelinePeer::ID);
            $value = $criteria->remove(PolicyGuidelinePeer::ID);
            if ($value) {
                $selectCriteria->add(PolicyGuidelinePeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(PolicyGuidelinePeer::TABLE_NAME);
            }

        } else { // $values is PolicyGuideline object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the objectives_policyGuideline table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += PolicyGuidelinePeer::doOnDeleteCascade(new Criteria(PolicyGuidelinePeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(PolicyGuidelinePeer::TABLE_NAME, $con, PolicyGuidelinePeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PolicyGuidelinePeer::clearInstancePool();
            PolicyGuidelinePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a PolicyGuideline or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or PolicyGuideline object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof PolicyGuideline) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);
            $criteria->add(PolicyGuidelinePeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += PolicyGuidelinePeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                PolicyGuidelinePeer::clearInstancePool();
            } elseif ($values instanceof PolicyGuideline) { // it's a model object
                PolicyGuidelinePeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    PolicyGuidelinePeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            PolicyGuidelinePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = PolicyGuidelinePeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related PolicyGuidelineIndicators objects
            $criteria = new Criteria(PolicyGuidelineIndicatorsPeer::DATABASE_NAME);

            $criteria->add(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $obj->getId());
            $affectedRows += PolicyGuidelineIndicatorsPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given PolicyGuideline object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      PolicyGuideline $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(PolicyGuidelinePeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(PolicyGuidelinePeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(PolicyGuidelinePeer::DATABASE_NAME, PolicyGuidelinePeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return PolicyGuideline
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = PolicyGuidelinePeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);
        $criteria->add(PolicyGuidelinePeer::ID, $pk);

        $v = PolicyGuidelinePeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return PolicyGuideline[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);
            $criteria->add(PolicyGuidelinePeer::ID, $pks, Criteria::IN);
            $objs = PolicyGuidelinePeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        PolicyGuidelineQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        PolicyGuidelinePeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        PolicyGuidelineQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return PolicyGuidelineQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a PolicyGuideline or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or PolicyGuideline object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof PolicyGuideline) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(PolicyGuidelinePeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(PolicyGuidelinePeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on PolicyGuidelinePeer::$softDelete
     *
     * @param			 mixed $values Criteria or PolicyGuideline object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (PolicyGuidelinePeer::isSoftDeleteEnabled()) {
            return PolicyGuidelinePeer::doSoftDelete($values, $con);
        } else {
            return PolicyGuidelinePeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the objectives_policyGuideline table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(PolicyGuidelinePeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(PolicyGuidelinePeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on PolicyGuidelinePeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (PolicyGuidelinePeer::isSoftDeleteEnabled()) {
            return PolicyGuidelinePeer::doSoftDeleteAll($con);
        } else {
            return PolicyGuidelinePeer::doForceDeleteAll($con);
        }
    }

} // BasePolicyGuidelinePeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BasePolicyGuidelinePeer::buildTableMap();

