<?php


/**
 * Base class that represents a row from the 'objectives_policyGuideline' table.
 *
 * Policy Guidelines
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BasePolicyGuideline extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'PolicyGuidelinePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        PolicyGuidelinePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the exchangerate field.
     * @var        double
     */
    protected $exchangerate;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        PropelObjectCollection|PolicyGuidelineIndicators[] Collection to store aggregation of PolicyGuidelineIndicators objects.
     */
    protected $collPolicyGuidelineIndicatorss;
    protected $collPolicyGuidelineIndicatorssPartial;

    /**
     * @var        PropelObjectCollection|StrategicObjective[] Collection to store aggregation of StrategicObjective objects.
     */
    protected $collStrategicObjectives;
    protected $collStrategicObjectivesPartial;

    /**
     * @var        PropelObjectCollection|Objective[] Collection to store aggregation of Objective objects.
     */
    protected $collObjectives;
    protected $collObjectivesPartial;

    /**
     * @var        PropelObjectCollection|PolicyGuidelineLog[] Collection to store aggregation of PolicyGuidelineLog objects.
     */
    protected $collPolicyGuidelineLogs;
    protected $collPolicyGuidelineLogsPartial;

    /**
     * @var        PropelObjectCollection|StrategicObjectiveLog[] Collection to store aggregation of StrategicObjectiveLog objects.
     */
    protected $collStrategicObjectiveLogs;
    protected $collStrategicObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveLog[] Collection to store aggregation of ObjectiveLog objects.
     */
    protected $collObjectiveLogs;
    protected $collObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|Indicator[] Collection to store aggregation of Indicator objects.
     */
    protected $collIndicators;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelineIndicatorssScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $strategicObjectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelineLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $strategicObjectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveLogsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Policy Guideline Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Policy Guideline Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Policy Guideline Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [exchangerate] column value.
     * Exchange Rate
     * @return double
     */
    public function getExchangerate()
    {
        return $this->exchangerate;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [objecttype] column value.
     * Tipo de usuario
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id del usuario
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Endign year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Policy Guideline Id
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Policy Guideline Name
     * @param string $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Policy Guideline Description
     * @param string $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [exchangerate] column.
     * Exchange Rate
     * @param double $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setExchangerate($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->exchangerate !== $v) {
            $this->exchangerate = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::EXCHANGERATE;
        }


        return $this;
    } // setExchangerate()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [objecttype] column.
     * Tipo de usuario
     * @param string $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id del usuario
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Endign year
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = PolicyGuidelinePeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = PolicyGuidelinePeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = PolicyGuidelinePeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->description = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->exchangerate = ($row[$startcol + 3] !== null) ? (double) $row[$startcol + 3] : null;
            $this->userid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->objecttype = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->objectid = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->startingyear = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->endingyear = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->updated = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->changes = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->deleted_at = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating PolicyGuideline object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = PolicyGuidelinePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aUser = null;
            $this->collPolicyGuidelineIndicatorss = null;

            $this->collStrategicObjectives = null;

            $this->collObjectives = null;

            $this->collPolicyGuidelineLogs = null;

            $this->collStrategicObjectiveLogs = null;

            $this->collObjectiveLogs = null;

            $this->collIndicators = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = PolicyGuidelineQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && PolicyGuidelineQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                PolicyGuidelinePeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                PolicyGuidelinePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->indicatorsScheduledForDeletion !== null) {
                if (!$this->indicatorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->indicatorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    PolicyGuidelineIndicatorsQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->indicatorsScheduledForDeletion = null;
                }

                foreach ($this->getIndicators() as $indicator) {
                    if ($indicator->isModified()) {
                        $indicator->save($con);
                    }
                }
            }

            if ($this->policyGuidelineIndicatorssScheduledForDeletion !== null) {
                if (!$this->policyGuidelineIndicatorssScheduledForDeletion->isEmpty()) {
                    PolicyGuidelineIndicatorsQuery::create()
                        ->filterByPrimaryKeys($this->policyGuidelineIndicatorssScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->policyGuidelineIndicatorssScheduledForDeletion = null;
                }
            }

            if ($this->collPolicyGuidelineIndicatorss !== null) {
                foreach ($this->collPolicyGuidelineIndicatorss as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->strategicObjectivesScheduledForDeletion !== null) {
                if (!$this->strategicObjectivesScheduledForDeletion->isEmpty()) {
                    foreach ($this->strategicObjectivesScheduledForDeletion as $strategicObjective) {
                        // need to save related object because we set the relation to null
                        $strategicObjective->save($con);
                    }
                    $this->strategicObjectivesScheduledForDeletion = null;
                }
            }

            if ($this->collStrategicObjectives !== null) {
                foreach ($this->collStrategicObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectivesScheduledForDeletion !== null) {
                if (!$this->objectivesScheduledForDeletion->isEmpty()) {
                    ObjectiveQuery::create()
                        ->filterByPrimaryKeys($this->objectivesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectivesScheduledForDeletion = null;
                }
            }

            if ($this->collObjectives !== null) {
                foreach ($this->collObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->policyGuidelineLogsScheduledForDeletion !== null) {
                if (!$this->policyGuidelineLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->policyGuidelineLogsScheduledForDeletion as $policyGuidelineLog) {
                        // need to save related object because we set the relation to null
                        $policyGuidelineLog->save($con);
                    }
                    $this->policyGuidelineLogsScheduledForDeletion = null;
                }
            }

            if ($this->collPolicyGuidelineLogs !== null) {
                foreach ($this->collPolicyGuidelineLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->strategicObjectiveLogsScheduledForDeletion !== null) {
                if (!$this->strategicObjectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLog) {
                        // need to save related object because we set the relation to null
                        $strategicObjectiveLog->save($con);
                    }
                    $this->strategicObjectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collStrategicObjectiveLogs !== null) {
                foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveLogsScheduledForDeletion !== null) {
                if (!$this->objectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLog) {
                        // need to save related object because we set the relation to null
                        $objectiveLog->save($con);
                    }
                    $this->objectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveLogs !== null) {
                foreach ($this->collObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = PolicyGuidelinePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . PolicyGuidelinePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(PolicyGuidelinePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::EXCHANGERATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXCHANGERATE`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(PolicyGuidelinePeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `objectives_policyGuideline` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`EXCHANGERATE`':
                        $stmt->bindValue($identifier, $this->exchangerate, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }


            if (($retval = PolicyGuidelinePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collPolicyGuidelineIndicatorss !== null) {
                    foreach ($this->collPolicyGuidelineIndicatorss as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collStrategicObjectives !== null) {
                    foreach ($this->collStrategicObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectives !== null) {
                    foreach ($this->collObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPolicyGuidelineLogs !== null) {
                    foreach ($this->collPolicyGuidelineLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collStrategicObjectiveLogs !== null) {
                    foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveLogs !== null) {
                    foreach ($this->collObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PolicyGuidelinePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getDescription();
                break;
            case 3:
                return $this->getExchangerate();
                break;
            case 4:
                return $this->getUserid();
                break;
            case 5:
                return $this->getObjecttype();
                break;
            case 6:
                return $this->getObjectid();
                break;
            case 7:
                return $this->getStartingyear();
                break;
            case 8:
                return $this->getEndingyear();
                break;
            case 9:
                return $this->getUpdated();
                break;
            case 10:
                return $this->getChanges();
                break;
            case 11:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['PolicyGuideline'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['PolicyGuideline'][$this->getPrimaryKey()] = true;
        $keys = PolicyGuidelinePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getDescription(),
            $keys[3] => $this->getExchangerate(),
            $keys[4] => $this->getUserid(),
            $keys[5] => $this->getObjecttype(),
            $keys[6] => $this->getObjectid(),
            $keys[7] => $this->getStartingyear(),
            $keys[8] => $this->getEndingyear(),
            $keys[9] => $this->getUpdated(),
            $keys[10] => $this->getChanges(),
            $keys[11] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collPolicyGuidelineIndicatorss) {
                $result['PolicyGuidelineIndicatorss'] = $this->collPolicyGuidelineIndicatorss->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStrategicObjectives) {
                $result['StrategicObjectives'] = $this->collStrategicObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectives) {
                $result['Objectives'] = $this->collObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPolicyGuidelineLogs) {
                $result['PolicyGuidelineLogs'] = $this->collPolicyGuidelineLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStrategicObjectiveLogs) {
                $result['StrategicObjectiveLogs'] = $this->collStrategicObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveLogs) {
                $result['ObjectiveLogs'] = $this->collObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PolicyGuidelinePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setDescription($value);
                break;
            case 3:
                $this->setExchangerate($value);
                break;
            case 4:
                $this->setUserid($value);
                break;
            case 5:
                $this->setObjecttype($value);
                break;
            case 6:
                $this->setObjectid($value);
                break;
            case 7:
                $this->setStartingyear($value);
                break;
            case 8:
                $this->setEndingyear($value);
                break;
            case 9:
                $this->setUpdated($value);
                break;
            case 10:
                $this->setChanges($value);
                break;
            case 11:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = PolicyGuidelinePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setDescription($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setExchangerate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setUserid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setObjecttype($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setObjectid($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setStartingyear($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setEndingyear($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setUpdated($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setChanges($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setDeletedAt($arr[$keys[11]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);

        if ($this->isColumnModified(PolicyGuidelinePeer::ID)) $criteria->add(PolicyGuidelinePeer::ID, $this->id);
        if ($this->isColumnModified(PolicyGuidelinePeer::NAME)) $criteria->add(PolicyGuidelinePeer::NAME, $this->name);
        if ($this->isColumnModified(PolicyGuidelinePeer::DESCRIPTION)) $criteria->add(PolicyGuidelinePeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(PolicyGuidelinePeer::EXCHANGERATE)) $criteria->add(PolicyGuidelinePeer::EXCHANGERATE, $this->exchangerate);
        if ($this->isColumnModified(PolicyGuidelinePeer::USERID)) $criteria->add(PolicyGuidelinePeer::USERID, $this->userid);
        if ($this->isColumnModified(PolicyGuidelinePeer::OBJECTTYPE)) $criteria->add(PolicyGuidelinePeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(PolicyGuidelinePeer::OBJECTID)) $criteria->add(PolicyGuidelinePeer::OBJECTID, $this->objectid);
        if ($this->isColumnModified(PolicyGuidelinePeer::STARTINGYEAR)) $criteria->add(PolicyGuidelinePeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(PolicyGuidelinePeer::ENDINGYEAR)) $criteria->add(PolicyGuidelinePeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(PolicyGuidelinePeer::UPDATED)) $criteria->add(PolicyGuidelinePeer::UPDATED, $this->updated);
        if ($this->isColumnModified(PolicyGuidelinePeer::CHANGES)) $criteria->add(PolicyGuidelinePeer::CHANGES, $this->changes);
        if ($this->isColumnModified(PolicyGuidelinePeer::DELETED_AT)) $criteria->add(PolicyGuidelinePeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(PolicyGuidelinePeer::DATABASE_NAME);
        $criteria->add(PolicyGuidelinePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of PolicyGuideline (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setExchangerate($this->getExchangerate());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getPolicyGuidelineIndicatorss() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPolicyGuidelineIndicators($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStrategicObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStrategicObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPolicyGuidelineLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPolicyGuidelineLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStrategicObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStrategicObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return PolicyGuideline Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return PolicyGuidelinePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new PolicyGuidelinePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return PolicyGuideline The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addPolicyGuideline($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addPolicyGuidelines($this);
             */
        }

        return $this->aUser;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('PolicyGuidelineIndicators' == $relationName) {
            $this->initPolicyGuidelineIndicatorss();
        }
        if ('StrategicObjective' == $relationName) {
            $this->initStrategicObjectives();
        }
        if ('Objective' == $relationName) {
            $this->initObjectives();
        }
        if ('PolicyGuidelineLog' == $relationName) {
            $this->initPolicyGuidelineLogs();
        }
        if ('StrategicObjectiveLog' == $relationName) {
            $this->initStrategicObjectiveLogs();
        }
        if ('ObjectiveLog' == $relationName) {
            $this->initObjectiveLogs();
        }
    }

    /**
     * Clears out the collPolicyGuidelineIndicatorss collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelineIndicatorss()
     */
    public function clearPolicyGuidelineIndicatorss()
    {
        $this->collPolicyGuidelineIndicatorss = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelineIndicatorssPartial = null;
    }

    /**
     * reset is the collPolicyGuidelineIndicatorss collection loaded partially
     *
     * @return void
     */
    public function resetPartialPolicyGuidelineIndicatorss($v = true)
    {
        $this->collPolicyGuidelineIndicatorssPartial = $v;
    }

    /**
     * Initializes the collPolicyGuidelineIndicatorss collection.
     *
     * By default this just sets the collPolicyGuidelineIndicatorss collection to an empty array (like clearcollPolicyGuidelineIndicatorss());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPolicyGuidelineIndicatorss($overrideExisting = true)
    {
        if (null !== $this->collPolicyGuidelineIndicatorss && !$overrideExisting) {
            return;
        }
        $this->collPolicyGuidelineIndicatorss = new PropelObjectCollection();
        $this->collPolicyGuidelineIndicatorss->setModel('PolicyGuidelineIndicators');
    }

    /**
     * Gets an array of PolicyGuidelineIndicators objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PolicyGuidelineIndicators[] List of PolicyGuidelineIndicators objects
     * @throws PropelException
     */
    public function getPolicyGuidelineIndicatorss($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineIndicatorssPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineIndicatorss || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineIndicatorss) {
                // return empty collection
                $this->initPolicyGuidelineIndicatorss();
            } else {
                $collPolicyGuidelineIndicatorss = PolicyGuidelineIndicatorsQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPolicyGuidelineIndicatorssPartial && count($collPolicyGuidelineIndicatorss)) {
                      $this->initPolicyGuidelineIndicatorss(false);

                      foreach($collPolicyGuidelineIndicatorss as $obj) {
                        if (false == $this->collPolicyGuidelineIndicatorss->contains($obj)) {
                          $this->collPolicyGuidelineIndicatorss->append($obj);
                        }
                      }

                      $this->collPolicyGuidelineIndicatorssPartial = true;
                    }

                    return $collPolicyGuidelineIndicatorss;
                }

                if($partial && $this->collPolicyGuidelineIndicatorss) {
                    foreach($this->collPolicyGuidelineIndicatorss as $obj) {
                        if($obj->isNew()) {
                            $collPolicyGuidelineIndicatorss[] = $obj;
                        }
                    }
                }

                $this->collPolicyGuidelineIndicatorss = $collPolicyGuidelineIndicatorss;
                $this->collPolicyGuidelineIndicatorssPartial = false;
            }
        }

        return $this->collPolicyGuidelineIndicatorss;
    }

    /**
     * Sets a collection of PolicyGuidelineIndicators objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelineIndicatorss A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelineIndicatorss(PropelCollection $policyGuidelineIndicatorss, PropelPDO $con = null)
    {
        $this->policyGuidelineIndicatorssScheduledForDeletion = $this->getPolicyGuidelineIndicatorss(new Criteria(), $con)->diff($policyGuidelineIndicatorss);

        foreach ($this->policyGuidelineIndicatorssScheduledForDeletion as $policyGuidelineIndicatorsRemoved) {
            $policyGuidelineIndicatorsRemoved->setPolicyGuideline(null);
        }

        $this->collPolicyGuidelineIndicatorss = null;
        foreach ($policyGuidelineIndicatorss as $policyGuidelineIndicators) {
            $this->addPolicyGuidelineIndicators($policyGuidelineIndicators);
        }

        $this->collPolicyGuidelineIndicatorss = $policyGuidelineIndicatorss;
        $this->collPolicyGuidelineIndicatorssPartial = false;
    }

    /**
     * Returns the number of related PolicyGuidelineIndicators objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PolicyGuidelineIndicators objects.
     * @throws PropelException
     */
    public function countPolicyGuidelineIndicatorss(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineIndicatorssPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineIndicatorss || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineIndicatorss) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPolicyGuidelineIndicatorss());
                }
                $query = PolicyGuidelineIndicatorsQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelineIndicatorss);
        }
    }

    /**
     * Method called to associate a PolicyGuidelineIndicators object to this object
     * through the PolicyGuidelineIndicators foreign key attribute.
     *
     * @param    PolicyGuidelineIndicators $l PolicyGuidelineIndicators
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addPolicyGuidelineIndicators(PolicyGuidelineIndicators $l)
    {
        if ($this->collPolicyGuidelineIndicatorss === null) {
            $this->initPolicyGuidelineIndicatorss();
            $this->collPolicyGuidelineIndicatorssPartial = true;
        }
        if (!$this->collPolicyGuidelineIndicatorss->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuidelineIndicators($l);
        }

        return $this;
    }

    /**
     * @param	PolicyGuidelineIndicators $policyGuidelineIndicators The policyGuidelineIndicators object to add.
     */
    protected function doAddPolicyGuidelineIndicators($policyGuidelineIndicators)
    {
        $this->collPolicyGuidelineIndicatorss[]= $policyGuidelineIndicators;
        $policyGuidelineIndicators->setPolicyGuideline($this);
    }

    /**
     * @param	PolicyGuidelineIndicators $policyGuidelineIndicators The policyGuidelineIndicators object to remove.
     */
    public function removePolicyGuidelineIndicators($policyGuidelineIndicators)
    {
        if ($this->getPolicyGuidelineIndicatorss()->contains($policyGuidelineIndicators)) {
            $this->collPolicyGuidelineIndicatorss->remove($this->collPolicyGuidelineIndicatorss->search($policyGuidelineIndicators));
            if (null === $this->policyGuidelineIndicatorssScheduledForDeletion) {
                $this->policyGuidelineIndicatorssScheduledForDeletion = clone $this->collPolicyGuidelineIndicatorss;
                $this->policyGuidelineIndicatorssScheduledForDeletion->clear();
            }
            $this->policyGuidelineIndicatorssScheduledForDeletion[]= $policyGuidelineIndicators;
            $policyGuidelineIndicators->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related PolicyGuidelineIndicatorss from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PolicyGuidelineIndicators[] List of PolicyGuidelineIndicators objects
     */
    public function getPolicyGuidelineIndicatorssJoinIndicator($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PolicyGuidelineIndicatorsQuery::create(null, $criteria);
        $query->joinWith('Indicator', $join_behavior);

        return $this->getPolicyGuidelineIndicatorss($query, $con);
    }

    /**
     * Clears out the collStrategicObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStrategicObjectives()
     */
    public function clearStrategicObjectives()
    {
        $this->collStrategicObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collStrategicObjectivesPartial = null;
    }

    /**
     * reset is the collStrategicObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialStrategicObjectives($v = true)
    {
        $this->collStrategicObjectivesPartial = $v;
    }

    /**
     * Initializes the collStrategicObjectives collection.
     *
     * By default this just sets the collStrategicObjectives collection to an empty array (like clearcollStrategicObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStrategicObjectives($overrideExisting = true)
    {
        if (null !== $this->collStrategicObjectives && !$overrideExisting) {
            return;
        }
        $this->collStrategicObjectives = new PropelObjectCollection();
        $this->collStrategicObjectives->setModel('StrategicObjective');
    }

    /**
     * Gets an array of StrategicObjective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|StrategicObjective[] List of StrategicObjective objects
     * @throws PropelException
     */
    public function getStrategicObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectivesPartial && !$this->isNew();
        if (null === $this->collStrategicObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectives) {
                // return empty collection
                $this->initStrategicObjectives();
            } else {
                $collStrategicObjectives = StrategicObjectiveQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collStrategicObjectivesPartial && count($collStrategicObjectives)) {
                      $this->initStrategicObjectives(false);

                      foreach($collStrategicObjectives as $obj) {
                        if (false == $this->collStrategicObjectives->contains($obj)) {
                          $this->collStrategicObjectives->append($obj);
                        }
                      }

                      $this->collStrategicObjectivesPartial = true;
                    }

                    return $collStrategicObjectives;
                }

                if($partial && $this->collStrategicObjectives) {
                    foreach($this->collStrategicObjectives as $obj) {
                        if($obj->isNew()) {
                            $collStrategicObjectives[] = $obj;
                        }
                    }
                }

                $this->collStrategicObjectives = $collStrategicObjectives;
                $this->collStrategicObjectivesPartial = false;
            }
        }

        return $this->collStrategicObjectives;
    }

    /**
     * Sets a collection of StrategicObjective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $strategicObjectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setStrategicObjectives(PropelCollection $strategicObjectives, PropelPDO $con = null)
    {
        $this->strategicObjectivesScheduledForDeletion = $this->getStrategicObjectives(new Criteria(), $con)->diff($strategicObjectives);

        foreach ($this->strategicObjectivesScheduledForDeletion as $strategicObjectiveRemoved) {
            $strategicObjectiveRemoved->setPolicyGuideline(null);
        }

        $this->collStrategicObjectives = null;
        foreach ($strategicObjectives as $strategicObjective) {
            $this->addStrategicObjective($strategicObjective);
        }

        $this->collStrategicObjectives = $strategicObjectives;
        $this->collStrategicObjectivesPartial = false;
    }

    /**
     * Returns the number of related StrategicObjective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related StrategicObjective objects.
     * @throws PropelException
     */
    public function countStrategicObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectivesPartial && !$this->isNew();
        if (null === $this->collStrategicObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getStrategicObjectives());
                }
                $query = StrategicObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collStrategicObjectives);
        }
    }

    /**
     * Method called to associate a StrategicObjective object to this object
     * through the StrategicObjective foreign key attribute.
     *
     * @param    StrategicObjective $l StrategicObjective
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addStrategicObjective(StrategicObjective $l)
    {
        if ($this->collStrategicObjectives === null) {
            $this->initStrategicObjectives();
            $this->collStrategicObjectivesPartial = true;
        }
        if (!$this->collStrategicObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddStrategicObjective($l);
        }

        return $this;
    }

    /**
     * @param	StrategicObjective $strategicObjective The strategicObjective object to add.
     */
    protected function doAddStrategicObjective($strategicObjective)
    {
        $this->collStrategicObjectives[]= $strategicObjective;
        $strategicObjective->setPolicyGuideline($this);
    }

    /**
     * @param	StrategicObjective $strategicObjective The strategicObjective object to remove.
     */
    public function removeStrategicObjective($strategicObjective)
    {
        if ($this->getStrategicObjectives()->contains($strategicObjective)) {
            $this->collStrategicObjectives->remove($this->collStrategicObjectives->search($strategicObjective));
            if (null === $this->strategicObjectivesScheduledForDeletion) {
                $this->strategicObjectivesScheduledForDeletion = clone $this->collStrategicObjectives;
                $this->strategicObjectivesScheduledForDeletion->clear();
            }
            $this->strategicObjectivesScheduledForDeletion[]= $strategicObjective;
            $strategicObjective->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related StrategicObjectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjective[] List of StrategicObjective objects
     */
    public function getStrategicObjectivesJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getStrategicObjectives($query, $con);
    }

    /**
     * Clears out the collObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectives()
     */
    public function clearObjectives()
    {
        $this->collObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivesPartial = null;
    }

    /**
     * reset is the collObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectives($v = true)
    {
        $this->collObjectivesPartial = $v;
    }

    /**
     * Initializes the collObjectives collection.
     *
     * By default this just sets the collObjectives collection to an empty array (like clearcollObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectives($overrideExisting = true)
    {
        if (null !== $this->collObjectives && !$overrideExisting) {
            return;
        }
        $this->collObjectives = new PropelObjectCollection();
        $this->collObjectives->setModel('Objective');
    }

    /**
     * Gets an array of Objective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Objective[] List of Objective objects
     * @throws PropelException
     */
    public function getObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                // return empty collection
                $this->initObjectives();
            } else {
                $collObjectives = ObjectiveQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectivesPartial && count($collObjectives)) {
                      $this->initObjectives(false);

                      foreach($collObjectives as $obj) {
                        if (false == $this->collObjectives->contains($obj)) {
                          $this->collObjectives->append($obj);
                        }
                      }

                      $this->collObjectivesPartial = true;
                    }

                    return $collObjectives;
                }

                if($partial && $this->collObjectives) {
                    foreach($this->collObjectives as $obj) {
                        if($obj->isNew()) {
                            $collObjectives[] = $obj;
                        }
                    }
                }

                $this->collObjectives = $collObjectives;
                $this->collObjectivesPartial = false;
            }
        }

        return $this->collObjectives;
    }

    /**
     * Sets a collection of Objective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectives(PropelCollection $objectives, PropelPDO $con = null)
    {
        $this->objectivesScheduledForDeletion = $this->getObjectives(new Criteria(), $con)->diff($objectives);

        foreach ($this->objectivesScheduledForDeletion as $objectiveRemoved) {
            $objectiveRemoved->setPolicyGuideline(null);
        }

        $this->collObjectives = null;
        foreach ($objectives as $objective) {
            $this->addObjective($objective);
        }

        $this->collObjectives = $objectives;
        $this->collObjectivesPartial = false;
    }

    /**
     * Returns the number of related Objective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Objective objects.
     * @throws PropelException
     */
    public function countObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectives());
                }
                $query = ObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectives);
        }
    }

    /**
     * Method called to associate a Objective object to this object
     * through the Objective foreign key attribute.
     *
     * @param    Objective $l Objective
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addObjective(Objective $l)
    {
        if ($this->collObjectives === null) {
            $this->initObjectives();
            $this->collObjectivesPartial = true;
        }
        if (!$this->collObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjective($l);
        }

        return $this;
    }

    /**
     * @param	Objective $objective The objective object to add.
     */
    protected function doAddObjective($objective)
    {
        $this->collObjectives[]= $objective;
        $objective->setPolicyGuideline($this);
    }

    /**
     * @param	Objective $objective The objective object to remove.
     */
    public function removeObjective($objective)
    {
        if ($this->getObjectives()->contains($objective)) {
            $this->collObjectives->remove($this->collObjectives->search($objective));
            if (null === $this->objectivesScheduledForDeletion) {
                $this->objectivesScheduledForDeletion = clone $this->collObjectives;
                $this->objectivesScheduledForDeletion->clear();
            }
            $this->objectivesScheduledForDeletion[]= $objective;
            $objective->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectives($query, $con);
    }

    /**
     * Clears out the collPolicyGuidelineLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelineLogs()
     */
    public function clearPolicyGuidelineLogs()
    {
        $this->collPolicyGuidelineLogs = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelineLogsPartial = null;
    }

    /**
     * reset is the collPolicyGuidelineLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialPolicyGuidelineLogs($v = true)
    {
        $this->collPolicyGuidelineLogsPartial = $v;
    }

    /**
     * Initializes the collPolicyGuidelineLogs collection.
     *
     * By default this just sets the collPolicyGuidelineLogs collection to an empty array (like clearcollPolicyGuidelineLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPolicyGuidelineLogs($overrideExisting = true)
    {
        if (null !== $this->collPolicyGuidelineLogs && !$overrideExisting) {
            return;
        }
        $this->collPolicyGuidelineLogs = new PropelObjectCollection();
        $this->collPolicyGuidelineLogs->setModel('PolicyGuidelineLog');
    }

    /**
     * Gets an array of PolicyGuidelineLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PolicyGuidelineLog[] List of PolicyGuidelineLog objects
     * @throws PropelException
     */
    public function getPolicyGuidelineLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineLogsPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineLogs) {
                // return empty collection
                $this->initPolicyGuidelineLogs();
            } else {
                $collPolicyGuidelineLogs = PolicyGuidelineLogQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPolicyGuidelineLogsPartial && count($collPolicyGuidelineLogs)) {
                      $this->initPolicyGuidelineLogs(false);

                      foreach($collPolicyGuidelineLogs as $obj) {
                        if (false == $this->collPolicyGuidelineLogs->contains($obj)) {
                          $this->collPolicyGuidelineLogs->append($obj);
                        }
                      }

                      $this->collPolicyGuidelineLogsPartial = true;
                    }

                    return $collPolicyGuidelineLogs;
                }

                if($partial && $this->collPolicyGuidelineLogs) {
                    foreach($this->collPolicyGuidelineLogs as $obj) {
                        if($obj->isNew()) {
                            $collPolicyGuidelineLogs[] = $obj;
                        }
                    }
                }

                $this->collPolicyGuidelineLogs = $collPolicyGuidelineLogs;
                $this->collPolicyGuidelineLogsPartial = false;
            }
        }

        return $this->collPolicyGuidelineLogs;
    }

    /**
     * Sets a collection of PolicyGuidelineLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelineLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelineLogs(PropelCollection $policyGuidelineLogs, PropelPDO $con = null)
    {
        $this->policyGuidelineLogsScheduledForDeletion = $this->getPolicyGuidelineLogs(new Criteria(), $con)->diff($policyGuidelineLogs);

        foreach ($this->policyGuidelineLogsScheduledForDeletion as $policyGuidelineLogRemoved) {
            $policyGuidelineLogRemoved->setPolicyGuideline(null);
        }

        $this->collPolicyGuidelineLogs = null;
        foreach ($policyGuidelineLogs as $policyGuidelineLog) {
            $this->addPolicyGuidelineLog($policyGuidelineLog);
        }

        $this->collPolicyGuidelineLogs = $policyGuidelineLogs;
        $this->collPolicyGuidelineLogsPartial = false;
    }

    /**
     * Returns the number of related PolicyGuidelineLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PolicyGuidelineLog objects.
     * @throws PropelException
     */
    public function countPolicyGuidelineLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineLogsPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPolicyGuidelineLogs());
                }
                $query = PolicyGuidelineLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelineLogs);
        }
    }

    /**
     * Method called to associate a PolicyGuidelineLog object to this object
     * through the PolicyGuidelineLog foreign key attribute.
     *
     * @param    PolicyGuidelineLog $l PolicyGuidelineLog
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addPolicyGuidelineLog(PolicyGuidelineLog $l)
    {
        if ($this->collPolicyGuidelineLogs === null) {
            $this->initPolicyGuidelineLogs();
            $this->collPolicyGuidelineLogsPartial = true;
        }
        if (!$this->collPolicyGuidelineLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuidelineLog($l);
        }

        return $this;
    }

    /**
     * @param	PolicyGuidelineLog $policyGuidelineLog The policyGuidelineLog object to add.
     */
    protected function doAddPolicyGuidelineLog($policyGuidelineLog)
    {
        $this->collPolicyGuidelineLogs[]= $policyGuidelineLog;
        $policyGuidelineLog->setPolicyGuideline($this);
    }

    /**
     * @param	PolicyGuidelineLog $policyGuidelineLog The policyGuidelineLog object to remove.
     */
    public function removePolicyGuidelineLog($policyGuidelineLog)
    {
        if ($this->getPolicyGuidelineLogs()->contains($policyGuidelineLog)) {
            $this->collPolicyGuidelineLogs->remove($this->collPolicyGuidelineLogs->search($policyGuidelineLog));
            if (null === $this->policyGuidelineLogsScheduledForDeletion) {
                $this->policyGuidelineLogsScheduledForDeletion = clone $this->collPolicyGuidelineLogs;
                $this->policyGuidelineLogsScheduledForDeletion->clear();
            }
            $this->policyGuidelineLogsScheduledForDeletion[]= $policyGuidelineLog;
            $policyGuidelineLog->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related PolicyGuidelineLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PolicyGuidelineLog[] List of PolicyGuidelineLog objects
     */
    public function getPolicyGuidelineLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PolicyGuidelineLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getPolicyGuidelineLogs($query, $con);
    }

    /**
     * Clears out the collStrategicObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStrategicObjectiveLogs()
     */
    public function clearStrategicObjectiveLogs()
    {
        $this->collStrategicObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collStrategicObjectiveLogsPartial = null;
    }

    /**
     * reset is the collStrategicObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialStrategicObjectiveLogs($v = true)
    {
        $this->collStrategicObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collStrategicObjectiveLogs collection.
     *
     * By default this just sets the collStrategicObjectiveLogs collection to an empty array (like clearcollStrategicObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStrategicObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collStrategicObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collStrategicObjectiveLogs = new PropelObjectCollection();
        $this->collStrategicObjectiveLogs->setModel('StrategicObjectiveLog');
    }

    /**
     * Gets an array of StrategicObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     * @throws PropelException
     */
    public function getStrategicObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                // return empty collection
                $this->initStrategicObjectiveLogs();
            } else {
                $collStrategicObjectiveLogs = StrategicObjectiveLogQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collStrategicObjectiveLogsPartial && count($collStrategicObjectiveLogs)) {
                      $this->initStrategicObjectiveLogs(false);

                      foreach($collStrategicObjectiveLogs as $obj) {
                        if (false == $this->collStrategicObjectiveLogs->contains($obj)) {
                          $this->collStrategicObjectiveLogs->append($obj);
                        }
                      }

                      $this->collStrategicObjectiveLogsPartial = true;
                    }

                    return $collStrategicObjectiveLogs;
                }

                if($partial && $this->collStrategicObjectiveLogs) {
                    foreach($this->collStrategicObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collStrategicObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collStrategicObjectiveLogs = $collStrategicObjectiveLogs;
                $this->collStrategicObjectiveLogsPartial = false;
            }
        }

        return $this->collStrategicObjectiveLogs;
    }

    /**
     * Sets a collection of StrategicObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $strategicObjectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setStrategicObjectiveLogs(PropelCollection $strategicObjectiveLogs, PropelPDO $con = null)
    {
        $this->strategicObjectiveLogsScheduledForDeletion = $this->getStrategicObjectiveLogs(new Criteria(), $con)->diff($strategicObjectiveLogs);

        foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLogRemoved) {
            $strategicObjectiveLogRemoved->setPolicyGuideline(null);
        }

        $this->collStrategicObjectiveLogs = null;
        foreach ($strategicObjectiveLogs as $strategicObjectiveLog) {
            $this->addStrategicObjectiveLog($strategicObjectiveLog);
        }

        $this->collStrategicObjectiveLogs = $strategicObjectiveLogs;
        $this->collStrategicObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related StrategicObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related StrategicObjectiveLog objects.
     * @throws PropelException
     */
    public function countStrategicObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getStrategicObjectiveLogs());
                }
                $query = StrategicObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collStrategicObjectiveLogs);
        }
    }

    /**
     * Method called to associate a StrategicObjectiveLog object to this object
     * through the StrategicObjectiveLog foreign key attribute.
     *
     * @param    StrategicObjectiveLog $l StrategicObjectiveLog
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addStrategicObjectiveLog(StrategicObjectiveLog $l)
    {
        if ($this->collStrategicObjectiveLogs === null) {
            $this->initStrategicObjectiveLogs();
            $this->collStrategicObjectiveLogsPartial = true;
        }
        if (!$this->collStrategicObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddStrategicObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to add.
     */
    protected function doAddStrategicObjectiveLog($strategicObjectiveLog)
    {
        $this->collStrategicObjectiveLogs[]= $strategicObjectiveLog;
        $strategicObjectiveLog->setPolicyGuideline($this);
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to remove.
     */
    public function removeStrategicObjectiveLog($strategicObjectiveLog)
    {
        if ($this->getStrategicObjectiveLogs()->contains($strategicObjectiveLog)) {
            $this->collStrategicObjectiveLogs->remove($this->collStrategicObjectiveLogs->search($strategicObjectiveLog));
            if (null === $this->strategicObjectiveLogsScheduledForDeletion) {
                $this->strategicObjectiveLogsScheduledForDeletion = clone $this->collStrategicObjectiveLogs;
                $this->strategicObjectiveLogsScheduledForDeletion->clear();
            }
            $this->strategicObjectiveLogsScheduledForDeletion[]= $strategicObjectiveLog;
            $strategicObjectiveLog->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveLogs()
     */
    public function clearObjectiveLogs()
    {
        $this->collObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveLogsPartial = null;
    }

    /**
     * reset is the collObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveLogs($v = true)
    {
        $this->collObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collObjectiveLogs collection.
     *
     * By default this just sets the collObjectiveLogs collection to an empty array (like clearcollObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collObjectiveLogs = new PropelObjectCollection();
        $this->collObjectiveLogs->setModel('ObjectiveLog');
    }

    /**
     * Gets an array of ObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     * @throws PropelException
     */
    public function getObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                // return empty collection
                $this->initObjectiveLogs();
            } else {
                $collObjectiveLogs = ObjectiveLogQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveLogsPartial && count($collObjectiveLogs)) {
                      $this->initObjectiveLogs(false);

                      foreach($collObjectiveLogs as $obj) {
                        if (false == $this->collObjectiveLogs->contains($obj)) {
                          $this->collObjectiveLogs->append($obj);
                        }
                      }

                      $this->collObjectiveLogsPartial = true;
                    }

                    return $collObjectiveLogs;
                }

                if($partial && $this->collObjectiveLogs) {
                    foreach($this->collObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collObjectiveLogs = $collObjectiveLogs;
                $this->collObjectiveLogsPartial = false;
            }
        }

        return $this->collObjectiveLogs;
    }

    /**
     * Sets a collection of ObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveLogs(PropelCollection $objectiveLogs, PropelPDO $con = null)
    {
        $this->objectiveLogsScheduledForDeletion = $this->getObjectiveLogs(new Criteria(), $con)->diff($objectiveLogs);

        foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLogRemoved) {
            $objectiveLogRemoved->setPolicyGuideline(null);
        }

        $this->collObjectiveLogs = null;
        foreach ($objectiveLogs as $objectiveLog) {
            $this->addObjectiveLog($objectiveLog);
        }

        $this->collObjectiveLogs = $objectiveLogs;
        $this->collObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveLog objects.
     * @throws PropelException
     */
    public function countObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveLogs());
                }
                $query = ObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveLogs);
        }
    }

    /**
     * Method called to associate a ObjectiveLog object to this object
     * through the ObjectiveLog foreign key attribute.
     *
     * @param    ObjectiveLog $l ObjectiveLog
     * @return PolicyGuideline The current object (for fluent API support)
     */
    public function addObjectiveLog(ObjectiveLog $l)
    {
        if ($this->collObjectiveLogs === null) {
            $this->initObjectiveLogs();
            $this->collObjectiveLogsPartial = true;
        }
        if (!$this->collObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to add.
     */
    protected function doAddObjectiveLog($objectiveLog)
    {
        $this->collObjectiveLogs[]= $objectiveLog;
        $objectiveLog->setPolicyGuideline($this);
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to remove.
     */
    public function removeObjectiveLog($objectiveLog)
    {
        if ($this->getObjectiveLogs()->contains($objectiveLog)) {
            $this->collObjectiveLogs->remove($this->collObjectiveLogs->search($objectiveLog));
            if (null === $this->objectiveLogsScheduledForDeletion) {
                $this->objectiveLogsScheduledForDeletion = clone $this->collObjectiveLogs;
                $this->objectiveLogsScheduledForDeletion->clear();
            }
            $this->objectiveLogsScheduledForDeletion[]= $objectiveLog;
            $objectiveLog->setPolicyGuideline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PolicyGuideline is new, it will return
     * an empty collection; or if this PolicyGuideline has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PolicyGuideline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicators()
     */
    public function clearIndicators()
    {
        $this->collIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorsPartial = null;
    }

    /**
     * Initializes the collIndicators collection.
     *
     * By default this just sets the collIndicators collection to an empty collection (like clearIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIndicators()
    {
        $this->collIndicators = new PropelObjectCollection();
        $this->collIndicators->setModel('Indicator');
    }

    /**
     * Gets a collection of Indicator objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this PolicyGuideline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     */
    public function getIndicators($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIndicators || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicators) {
                // return empty collection
                $this->initIndicators();
            } else {
                $collIndicators = IndicatorQuery::create(null, $criteria)
                    ->filterByPolicyGuideline($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIndicators;
                }
                $this->collIndicators = $collIndicators;
            }
        }

        return $this->collIndicators;
    }

    /**
     * Sets a collection of Indicator objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicators(PropelCollection $indicators, PropelPDO $con = null)
    {
        $this->clearIndicators();
        $currentIndicators = $this->getIndicators();

        $this->indicatorsScheduledForDeletion = $currentIndicators->diff($indicators);

        foreach ($indicators as $indicator) {
            if (!$currentIndicators->contains($indicator)) {
                $this->doAddIndicator($indicator);
            }
        }

        $this->collIndicators = $indicators;
    }

    /**
     * Gets the number of Indicator objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Indicator objects
     */
    public function countIndicators($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIndicators || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicators) {
                return 0;
            } else {
                $query = IndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPolicyGuideline($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicators);
        }
    }

    /**
     * Associate a Indicator object to this object
     * through the objectives_policyGuidelineIndicators cross reference table.
     *
     * @param  Indicator $indicator The PolicyGuidelineIndicators object to relate
     * @return void
     */
    public function addIndicator(Indicator $indicator)
    {
        if ($this->collIndicators === null) {
            $this->initIndicators();
        }
        if (!$this->collIndicators->contains($indicator)) { // only add it if the **same** object is not already associated
            $this->doAddIndicator($indicator);

            $this->collIndicators[]= $indicator;
        }
    }

    /**
     * @param	Indicator $indicator The indicator object to add.
     */
    protected function doAddIndicator($indicator)
    {
        $policyGuidelineIndicators = new PolicyGuidelineIndicators();
        $policyGuidelineIndicators->setIndicator($indicator);
        $this->addPolicyGuidelineIndicators($policyGuidelineIndicators);
    }

    /**
     * Remove a Indicator object to this object
     * through the objectives_policyGuidelineIndicators cross reference table.
     *
     * @param Indicator $indicator The PolicyGuidelineIndicators object to relate
     * @return void
     */
    public function removeIndicator(Indicator $indicator)
    {
        if ($this->getIndicators()->contains($indicator)) {
            $this->collIndicators->remove($this->collIndicators->search($indicator));
            if (null === $this->indicatorsScheduledForDeletion) {
                $this->indicatorsScheduledForDeletion = clone $this->collIndicators;
                $this->indicatorsScheduledForDeletion->clear();
            }
            $this->indicatorsScheduledForDeletion[]= $indicator;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->description = null;
        $this->exchangerate = null;
        $this->userid = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->updated = null;
        $this->changes = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collPolicyGuidelineIndicatorss) {
                foreach ($this->collPolicyGuidelineIndicatorss as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStrategicObjectives) {
                foreach ($this->collStrategicObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectives) {
                foreach ($this->collObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPolicyGuidelineLogs) {
                foreach ($this->collPolicyGuidelineLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStrategicObjectiveLogs) {
                foreach ($this->collStrategicObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveLogs) {
                foreach ($this->collObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIndicators) {
                foreach ($this->collIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collPolicyGuidelineIndicatorss instanceof PropelCollection) {
            $this->collPolicyGuidelineIndicatorss->clearIterator();
        }
        $this->collPolicyGuidelineIndicatorss = null;
        if ($this->collStrategicObjectives instanceof PropelCollection) {
            $this->collStrategicObjectives->clearIterator();
        }
        $this->collStrategicObjectives = null;
        if ($this->collObjectives instanceof PropelCollection) {
            $this->collObjectives->clearIterator();
        }
        $this->collObjectives = null;
        if ($this->collPolicyGuidelineLogs instanceof PropelCollection) {
            $this->collPolicyGuidelineLogs->clearIterator();
        }
        $this->collPolicyGuidelineLogs = null;
        if ($this->collStrategicObjectiveLogs instanceof PropelCollection) {
            $this->collStrategicObjectiveLogs->clearIterator();
        }
        $this->collStrategicObjectiveLogs = null;
        if ($this->collObjectiveLogs instanceof PropelCollection) {
            $this->collObjectiveLogs->clearIterator();
        }
        $this->collObjectiveLogs = null;
        if ($this->collIndicators instanceof PropelCollection) {
            $this->collIndicators->clearIterator();
        }
        $this->collIndicators = null;
        $this->aUser = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = PolicyGuidelinePeer::isSoftDeleteEnabled()) {
            PolicyGuidelinePeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            PolicyGuidelinePeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
