<?php

/**
 * MediasTypeEditFieldXAction
 * Edita nombre tipo de medio
 *
 * @package    medias
 */

class MediasTypeEditFieldXAction extends BaseAction {

	function MediasTypeEditFieldXAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);

		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$module = "Medias";
		$smarty->assign("module",$module);

		$moduleConfig = Common::getModuleConfiguration($module);
		$smarty->assign("moduleConfig",$moduleConfig);

		$mediaType = MediaTypeQuery::create()->findOneById($_POST['id']);

		$exist = MediaTypeQuery::create()->filterById($_POST['id'], Criteria::NOT_EQUAL)->filterByName($_POST['paramValue'])->count();
		if ($exist) {
			$smarty->assign("paramValue", $mediaType->getName());
			$smarty->assign("errorTagId", "messageEdit");
			$smarty->assign("message", "Nombre existente, No se pudo guardar");
			return $mapping->findForwardConfig('failure');
		}

		if (!empty($_POST['paramName']) && !empty($_POST['paramValue'])) {
			$mediaType->setByName($_POST['paramName'], $_POST['paramValue'], BasePeer::TYPE_FIELDNAME);
			$mediaType->save();
			$smarty->assign("mediaType", $mediaType);
		}

		if (!empty($_POST['paramName']))
			$smarty->assign("paramValue", $mediaType->getByName($_POST['paramName'], BasePeer::TYPE_FIELDNAME));

		return $mapping->findForwardConfig('success');
	}

}
