|-counter name="numericIndicatorValuesGraphId" assign="graphId"-|
<style>
	#numericIndicatorValuesGraph-|-$graphId-| svg {
		width: 100%;
		height: 300px;
	}
</style>
<div id="numericIndicatorValuesGraph-|-$graphId-|"></div>
<script>

var dateFormat = d3.time.format('|-$dateFormat-|');
nv.addGraph(function() {
	var chart = nv.models.lineChart()
		.margin({ left: 100 })
		.useInteractiveGuideline(true)
		.transitionDuration(350)
		.interpolate("basis")
		.showLegend(true)
		.showYAxis(true)
		.showXAxis(true);

	chart.xAxis
		.axisLabel('##indicators,36,Date## (|-$dateFormatLabel-|)')
		.tickFormat(function(d) {
			var date = new Date(d * 1000);
			return dateFormat(date)
			return dateFormat(new Date(d * 1000))
		});

	chart.yAxis
		.axisLabel('##indicators,37,Value##')
		.tickFormat(d3.format('.02f'));

	var myData = indicatorValuesData();

	d3.select('#numericIndicatorValuesGraph-|-$graphId-|')
		.append('svg')
		.datum(myData)
		.call(chart);

	// Update the chart when window resizes.
	//nv.utils.windowResize(function() { chart.update() });

	return chart;
});

var indicatorValuesData = function() {
	return [
		{
			values: |-$graphValues.expected-|,
			key: '|-$numericIndicator-|',
			color: 'blue'
		}
	];
};
</script>
