<?php



/**
 * This class defines the structure of the 'indicators_indicator' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.indicators.classes.map
 */
class IndicatorTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'indicators.classes.map.IndicatorTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('indicators_indicator');
        $this->setPhpName('Indicator');
        $this->setClassname('Indicator');
        $this->setPackage('indicators.classes');
        $this->setUseIdGenerator(true);
        $this->setSingleTableInheritance(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 180, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('DESCRIPTION', 'Description', 'VARCHAR', false, 255, null);
        $this->addColumn('ARCHIVED', 'Archived', 'BOOLEAN', false, 1, false);
        $this->addColumn('METHODOLOGY', 'Methodology', 'LONGVARCHAR', false, null, null);
        $this->addColumn('DECIMALS', 'Decimals', 'TINYINT', false, null, 0);
        $this->addColumn('GOAL', 'Goal', 'FLOAT', false, null, null);
        $this->addColumn('GOALDATE', 'Goaldate', 'TIMESTAMP', false, null, null);
        $this->addColumn('IDEALBEHAVIOR', 'Idealbehavior', 'TINYINT', false, null, null);
        $this->addForeignKey('POSITIONID', 'Positionid', 'INTEGER', 'positions_position', 'ID', false, null, null);
        $this->addForeignKey('OBJECTIVEID', 'Objectiveid', 'INTEGER', 'objectives_objective', 'ID', false, null, null);
        $this->addColumn('DUEDATE', 'Duedate', 'DATE', false, null, null);
        $this->addColumn('FINISHEDDATE', 'Finisheddate', 'DATE', false, null, null);
        $this->addColumn('CLASSKEY', 'Classkey', 'INTEGER', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Position', 'Position', RelationMap::MANY_TO_ONE, array('positionId' => 'id', ), 'CASCADE', null);
        $this->addRelation('Objective', 'Objective', RelationMap::MANY_TO_ONE, array('objectiveId' => 'id', ), 'CASCADE', null);
        $this->addRelation('IndicatorValue', 'IndicatorValue', RelationMap::ONE_TO_MANY, array('id' => 'numericIndicatorId', ), 'CASCADE', null, 'IndicatorValues');
        $this->addRelation('IndicatorGraphSerie', 'IndicatorGraphSerie', RelationMap::ONE_TO_MANY, array('id' => 'indicatorId', ), 'CASCADE', null, 'IndicatorGraphSeries');
        $this->addRelation('PolicyGuidelineIndicators', 'PolicyGuidelineIndicators', RelationMap::ONE_TO_MANY, array('id' => 'indicatorId', ), 'CASCADE', null, 'PolicyGuidelineIndicatorss');
        $this->addRelation('Project', 'Project', RelationMap::ONE_TO_MANY, array('id' => 'indicatorId', ), null, null, 'Projects');
        $this->addRelation('IndicatorGraph', 'IndicatorGraph', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'IndicatorGraphs');
        $this->addRelation('PolicyGuideline', 'PolicyGuideline', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'PolicyGuidelines');
    } // buildRelations()

} // IndicatorTableMap
