<?php

use Egytca\Statements\Factory as StmntFactory;
use Egytca\Status\OnTheFly\Query\FinishedVsDueDateStatusQuery;

/**
 * Boolean Indicator
 */
class BooleanIndicatorQuery extends BaseBooleanIndicatorQuery {

	use FinishedVsDueDateStatusQuery;

	function stmntForUnmetDueDate($value, $comparison = null) {

		$peer = $this->getModelPeerName();

		$sqlMinDate = "'" . $value['min'] . "'";
		$sqlMaxDate = "'" . $value['max'] . "'";

		$dueDateColumn = $peer::DUEDATE;
		$dueDateBoundaries = StmntFactory::create($dueDateColumn, '>=', $sqlMinDate)
			->andWith(StmntFactory::create($dueDateColumn, '<=', $sqlMaxDate));

		$finishedDateColumn = $peer::FINISHEDDATE;
		$finishedDateIsNull = StmntFactory::create($finishedDateColumn, 'IS NULL');

		return $finishedDateIsNull->andWith($dueDateBoundaries);
	}

	function filterByUnmetDueDate($value, $comparison = null) {
		return $this->where($this->stmntForUnmetDueDate($value, $comparison)->toString());
	}
}
