<?php

/**
 * IndicatorsGraphEditAction
 *
 * Edicion de graficos de indicadores extendiendo BaseSelectAction
 *
 * @package indicators
 */

class IndicatorsNumericGraphEditAction extends BaseSelectAction {

 /**
	* Constructor
	*/
	function __construct($entityClassName = 'IndicatorGraph') {
		parent::__construct($entityClassName);
	}

	protected function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);

		global $system;
		$dateFormatLabel = $system['config']['system']['parameters']['dateFormat']['value'];
		$dateFormat = preg_replace("/(^|-)/", "$1%", $dateFormatLabel);

		$this->smarty->assign('dateFormatLabel', $dateFormatLabel);
		$this->smarty->assign('dateFormat', $dateFormat);

		$allNumericIndicators = NumericIndicatorQuery::create()->find();
		$this->smarty->assign('allNumericIndicators', $allNumericIndicators);
	}

}
