<?php
/**
 * HeadlinesTagsDoEditXAction
 *
 * Crea o guarda cambios de etiquetas (HeadlineTag)
 *
 * @package    headlines
 */

class HeadlinesTagsDoEditXAction extends BaseDoEditAction {
	
	function __construct() {
		parent::__construct('HeadlineTag');
	}

	function preUpdate(){
		parent::preUpdate();

		// Si viene de inplace edit
		if ((!empty($_POST['paramName']) && !empty($_POST['paramValue'])))
			$this->entityParams[$_POST['paramName']] = $_POST['paramValue'];

	}

 /**
	* Acciones a tomar antes de guardar el objeto
	*/
	function preSave(){
		parent::preSave();

		if ($this->entity->isNew()) {
			$exist = HeadlineTagQuery::create()->filterByName($this->entityParams['name'])->count();
			if ($exist) {
				$this->smarty->assign("errorTagId", "messageEdit");
				$this->smarty->assign("message", "Nombre existente, No se pudo guardar");
				return false;
			}
		}
		else {
			$exist = HeadlineTagQuery::create()->filterById($_POST['id'], Criteria::NOT_EQUAL)->filterByName($_POST['paramValue'])->count();
			if ($exist) {
				$headlineTag = HeadlineTagQuery::create()->findOneById($_POST['id']);
					$this->entity->reload();
				$this->smarty->assign("paramValue", $this->entity->getName());
				$this->smarty->assign("errorTagId", "messageEdit");
				$this->smarty->assign("message", "Nombre existente, No se pudo guardar");
				return false;
			}
		}
		$action = $this->entity->isNew() ? 'create' : 'edit';
		$this->smarty->assign('action',$action);
	}

 /**
	* Acciones a tomar despues de guardar el objeto
	*/
	function postSave(){
		parent::postSave();

		$this->smarty->assign('headlineTag',$this->entity);
	}

}
