<?php


/**
 * Base static class for performing query and update operations on the 'constructions_inspection' table.
 *
 * Inspecciones a la obra
 *
 * @package propel.generator.constructions.classes.om
 */
abstract class BaseInspectionPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'constructions_inspection';

    /** the related Propel class for this table */
    const OM_CLASS = 'Inspection';

    /** the related TableMap class for this table */
    const TM_CLASS = 'InspectionTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 14;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 14;

    /** the column name for the ID field */
    const ID = 'constructions_inspection.ID';

    /** the column name for the CONSTRUCTIONID field */
    const CONSTRUCTIONID = 'constructions_inspection.CONSTRUCTIONID';

    /** the column name for the INSPECTORID field */
    const INSPECTORID = 'constructions_inspection.INSPECTORID';

    /** the column name for the VISITDATE field */
    const VISITDATE = 'constructions_inspection.VISITDATE';

    /** the column name for the ENDDATE field */
    const ENDDATE = 'constructions_inspection.ENDDATE';

    /** the column name for the ENDDATEMINISTRY field */
    const ENDDATEMINISTRY = 'constructions_inspection.ENDDATEMINISTRY';

    /** the column name for the WORKSHOP field */
    const WORKSHOP = 'constructions_inspection.WORKSHOP';

    /** the column name for the PROGRESSINSPECTOR field */
    const PROGRESSINSPECTOR = 'constructions_inspection.PROGRESSINSPECTOR';

    /** the column name for the WORKINGRATE field */
    const WORKINGRATE = 'constructions_inspection.WORKINGRATE';

    /** the column name for the PROGRESS field */
    const PROGRESS = 'constructions_inspection.PROGRESS';

    /** the column name for the CONCLUSION field */
    const CONCLUSION = 'constructions_inspection.CONCLUSION';

    /** the column name for the WORKERS field */
    const WORKERS = 'constructions_inspection.WORKERS';

    /** the column name for the STATUS field */
    const STATUS = 'constructions_inspection.STATUS';

    /** the column name for the OTHERCOMMENTS field */
    const OTHERCOMMENTS = 'constructions_inspection.OTHERCOMMENTS';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Inspection objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Inspection[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. InspectionPeer::$fieldNames[InspectionPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Constructionid', 'Inspectorid', 'Visitdate', 'Enddate', 'Enddateministry', 'Workshop', 'Progressinspector', 'Workingrate', 'Progress', 'Conclusion', 'Workers', 'Status', 'Othercomments', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'constructionid', 'inspectorid', 'visitdate', 'enddate', 'enddateministry', 'workshop', 'progressinspector', 'workingrate', 'progress', 'conclusion', 'workers', 'status', 'othercomments', ),
        BasePeer::TYPE_COLNAME => array (InspectionPeer::ID, InspectionPeer::CONSTRUCTIONID, InspectionPeer::INSPECTORID, InspectionPeer::VISITDATE, InspectionPeer::ENDDATE, InspectionPeer::ENDDATEMINISTRY, InspectionPeer::WORKSHOP, InspectionPeer::PROGRESSINSPECTOR, InspectionPeer::WORKINGRATE, InspectionPeer::PROGRESS, InspectionPeer::CONCLUSION, InspectionPeer::WORKERS, InspectionPeer::STATUS, InspectionPeer::OTHERCOMMENTS, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'CONSTRUCTIONID', 'INSPECTORID', 'VISITDATE', 'ENDDATE', 'ENDDATEMINISTRY', 'WORKSHOP', 'PROGRESSINSPECTOR', 'WORKINGRATE', 'PROGRESS', 'CONCLUSION', 'WORKERS', 'STATUS', 'OTHERCOMMENTS', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'constructionId', 'inspectorId', 'visitDate', 'endDate', 'endDateMinistry', 'workshop', 'progressInspector', 'workingRate', 'progress', 'conclusion', 'workers', 'status', 'otherComments', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. InspectionPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Constructionid' => 1, 'Inspectorid' => 2, 'Visitdate' => 3, 'Enddate' => 4, 'Enddateministry' => 5, 'Workshop' => 6, 'Progressinspector' => 7, 'Workingrate' => 8, 'Progress' => 9, 'Conclusion' => 10, 'Workers' => 11, 'Status' => 12, 'Othercomments' => 13, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'constructionid' => 1, 'inspectorid' => 2, 'visitdate' => 3, 'enddate' => 4, 'enddateministry' => 5, 'workshop' => 6, 'progressinspector' => 7, 'workingrate' => 8, 'progress' => 9, 'conclusion' => 10, 'workers' => 11, 'status' => 12, 'othercomments' => 13, ),
        BasePeer::TYPE_COLNAME => array (InspectionPeer::ID => 0, InspectionPeer::CONSTRUCTIONID => 1, InspectionPeer::INSPECTORID => 2, InspectionPeer::VISITDATE => 3, InspectionPeer::ENDDATE => 4, InspectionPeer::ENDDATEMINISTRY => 5, InspectionPeer::WORKSHOP => 6, InspectionPeer::PROGRESSINSPECTOR => 7, InspectionPeer::WORKINGRATE => 8, InspectionPeer::PROGRESS => 9, InspectionPeer::CONCLUSION => 10, InspectionPeer::WORKERS => 11, InspectionPeer::STATUS => 12, InspectionPeer::OTHERCOMMENTS => 13, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'CONSTRUCTIONID' => 1, 'INSPECTORID' => 2, 'VISITDATE' => 3, 'ENDDATE' => 4, 'ENDDATEMINISTRY' => 5, 'WORKSHOP' => 6, 'PROGRESSINSPECTOR' => 7, 'WORKINGRATE' => 8, 'PROGRESS' => 9, 'CONCLUSION' => 10, 'WORKERS' => 11, 'STATUS' => 12, 'OTHERCOMMENTS' => 13, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'constructionId' => 1, 'inspectorId' => 2, 'visitDate' => 3, 'endDate' => 4, 'endDateMinistry' => 5, 'workshop' => 6, 'progressInspector' => 7, 'workingRate' => 8, 'progress' => 9, 'conclusion' => 10, 'workers' => 11, 'status' => 12, 'otherComments' => 13, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = InspectionPeer::getFieldNames($toType);
        $key = isset(InspectionPeer::$fieldKeys[$fromType][$name]) ? InspectionPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(InspectionPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, InspectionPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return InspectionPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. InspectionPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(InspectionPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(InspectionPeer::ID);
            $criteria->addSelectColumn(InspectionPeer::CONSTRUCTIONID);
            $criteria->addSelectColumn(InspectionPeer::INSPECTORID);
            $criteria->addSelectColumn(InspectionPeer::VISITDATE);
            $criteria->addSelectColumn(InspectionPeer::ENDDATE);
            $criteria->addSelectColumn(InspectionPeer::ENDDATEMINISTRY);
            $criteria->addSelectColumn(InspectionPeer::WORKSHOP);
            $criteria->addSelectColumn(InspectionPeer::PROGRESSINSPECTOR);
            $criteria->addSelectColumn(InspectionPeer::WORKINGRATE);
            $criteria->addSelectColumn(InspectionPeer::PROGRESS);
            $criteria->addSelectColumn(InspectionPeer::CONCLUSION);
            $criteria->addSelectColumn(InspectionPeer::WORKERS);
            $criteria->addSelectColumn(InspectionPeer::STATUS);
            $criteria->addSelectColumn(InspectionPeer::OTHERCOMMENTS);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.CONSTRUCTIONID');
            $criteria->addSelectColumn($alias . '.INSPECTORID');
            $criteria->addSelectColumn($alias . '.VISITDATE');
            $criteria->addSelectColumn($alias . '.ENDDATE');
            $criteria->addSelectColumn($alias . '.ENDDATEMINISTRY');
            $criteria->addSelectColumn($alias . '.WORKSHOP');
            $criteria->addSelectColumn($alias . '.PROGRESSINSPECTOR');
            $criteria->addSelectColumn($alias . '.WORKINGRATE');
            $criteria->addSelectColumn($alias . '.PROGRESS');
            $criteria->addSelectColumn($alias . '.CONCLUSION');
            $criteria->addSelectColumn($alias . '.WORKERS');
            $criteria->addSelectColumn($alias . '.STATUS');
            $criteria->addSelectColumn($alias . '.OTHERCOMMENTS');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(InspectionPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Inspection
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = InspectionPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return InspectionPeer::populateObjects(InspectionPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            InspectionPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Inspection $obj A Inspection object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            InspectionPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Inspection object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Inspection) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Inspection object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(InspectionPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Inspection Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(InspectionPeer::$instances[$key])) {
                return InspectionPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        InspectionPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to constructions_inspection
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in InspectionPhotoPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        InspectionPhotoPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = InspectionPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = InspectionPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                InspectionPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Inspection object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = InspectionPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = InspectionPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + InspectionPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = InspectionPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            InspectionPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Construction table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinConstruction(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Inspector table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinInspector(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Inspection objects pre-filled with their Construction objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Inspection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinConstruction(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(InspectionPeer::DATABASE_NAME);
        }

        InspectionPeer::addSelectColumns($criteria);
        $startcol = InspectionPeer::NUM_HYDRATE_COLUMNS;
        ConstructionPeer::addSelectColumns($criteria);

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = InspectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = InspectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                InspectionPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ConstructionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ConstructionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ConstructionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ConstructionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Inspection) to $obj2 (Construction)
                $obj2->addInspection($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Inspection objects pre-filled with their Inspector objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Inspection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinInspector(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(InspectionPeer::DATABASE_NAME);
        }

        InspectionPeer::addSelectColumns($criteria);
        $startcol = InspectionPeer::NUM_HYDRATE_COLUMNS;
        InspectorPeer::addSelectColumns($criteria);

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = InspectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = InspectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                InspectionPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = InspectorPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = InspectorPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = InspectorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    InspectorPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Inspection) to $obj2 (Inspector)
                $obj2->addInspection($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Inspection objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Inspection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(InspectionPeer::DATABASE_NAME);
        }

        InspectionPeer::addSelectColumns($criteria);
        $startcol2 = InspectionPeer::NUM_HYDRATE_COLUMNS;

        ConstructionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ConstructionPeer::NUM_HYDRATE_COLUMNS;

        InspectorPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + InspectorPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = InspectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = InspectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                InspectionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Construction rows

            $key2 = ConstructionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ConstructionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ConstructionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ConstructionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Inspection) to the collection in $obj2 (Construction)
                $obj2->addInspection($obj1);
            } // if joined row not null

            // Add objects for joined Inspector rows

            $key3 = InspectorPeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = InspectorPeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = InspectorPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    InspectorPeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (Inspection) to the collection in $obj3 (Inspector)
                $obj3->addInspection($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Construction table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptConstruction(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Inspector table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptInspector(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            InspectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Inspection objects pre-filled with all related objects except Construction.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Inspection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptConstruction(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(InspectionPeer::DATABASE_NAME);
        }

        InspectionPeer::addSelectColumns($criteria);
        $startcol2 = InspectionPeer::NUM_HYDRATE_COLUMNS;

        InspectorPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + InspectorPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(InspectionPeer::INSPECTORID, InspectorPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = InspectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = InspectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                InspectionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Inspector rows

                $key2 = InspectorPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = InspectorPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = InspectorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    InspectorPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Inspection) to the collection in $obj2 (Inspector)
                $obj2->addInspection($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Inspection objects pre-filled with all related objects except Inspector.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Inspection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptInspector(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(InspectionPeer::DATABASE_NAME);
        }

        InspectionPeer::addSelectColumns($criteria);
        $startcol2 = InspectionPeer::NUM_HYDRATE_COLUMNS;

        ConstructionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ConstructionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(InspectionPeer::CONSTRUCTIONID, ConstructionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = InspectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = InspectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = InspectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                InspectionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Construction rows

                $key2 = ConstructionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ConstructionPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ConstructionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ConstructionPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Inspection) to the collection in $obj2 (Construction)
                $obj2->addInspection($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(InspectionPeer::DATABASE_NAME)->getTable(InspectionPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseInspectionPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseInspectionPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new InspectionTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return InspectionPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a Inspection or Criteria object.
     *
     * @param      mixed $values Criteria or Inspection object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Inspection object
        }

        if ($criteria->containsKey(InspectionPeer::ID) && $criteria->keyContainsValue(InspectionPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.InspectionPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Inspection or Criteria object.
     *
     * @param      mixed $values Criteria or Inspection object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(InspectionPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(InspectionPeer::ID);
            $value = $criteria->remove(InspectionPeer::ID);
            if ($value) {
                $selectCriteria->add(InspectionPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(InspectionPeer::TABLE_NAME);
            }

        } else { // $values is Inspection object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the constructions_inspection table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += InspectionPeer::doOnDeleteCascade(new Criteria(InspectionPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(InspectionPeer::TABLE_NAME, $con, InspectionPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            InspectionPeer::clearInstancePool();
            InspectionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Inspection or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Inspection object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Inspection) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(InspectionPeer::DATABASE_NAME);
            $criteria->add(InspectionPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(InspectionPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += InspectionPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                InspectionPeer::clearInstancePool();
            } elseif ($values instanceof Inspection) { // it's a model object
                InspectionPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    InspectionPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            InspectionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = InspectionPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related InspectionPhoto objects
            $criteria = new Criteria(InspectionPhotoPeer::DATABASE_NAME);

            $criteria->add(InspectionPhotoPeer::INSPECTIONID, $obj->getId());
            $affectedRows += InspectionPhotoPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Inspection object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Inspection $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(InspectionPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(InspectionPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(InspectionPeer::DATABASE_NAME, InspectionPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Inspection
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = InspectionPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(InspectionPeer::DATABASE_NAME);
        $criteria->add(InspectionPeer::ID, $pk);

        $v = InspectionPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Inspection[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(InspectionPeer::DATABASE_NAME);
            $criteria->add(InspectionPeer::ID, $pks, Criteria::IN);
            $objs = InspectionPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseInspectionPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseInspectionPeer::buildTableMap();

