<?php


/**
 * Base class that represents a query for the 'campaigns_campaign' table.
 *
 * Base de Campaigns
 *
 * @method CampaignQuery orderById($order = Criteria::ASC) Order by the id column
 * @method CampaignQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method CampaignQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method CampaignQuery orderByStartdate($order = Criteria::ASC) Order by the startDate column
 * @method CampaignQuery orderByFinishdate($order = Criteria::ASC) Order by the finishDate column
 * @method CampaignQuery orderByClientid($order = Criteria::ASC) Order by the clientId column
 * @method CampaignQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method CampaignQuery orderByLangcode($order = Criteria::ASC) Order by the langCode column
 * @method CampaignQuery orderByDefaultkeywords($order = Criteria::ASC) Order by the defaultKeywords column
 * @method CampaignQuery orderByResponsible($order = Criteria::ASC) Order by the responsible column
 * @method CampaignQuery orderBySources($order = Criteria::ASC) Order by the sources column
 * @method CampaignQuery orderBySearchqueries($order = Criteria::ASC) Order by the searchQueries column
 * @method CampaignQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method CampaignQuery groupById() Group by the id column
 * @method CampaignQuery groupByName() Group by the name column
 * @method CampaignQuery groupByType() Group by the type column
 * @method CampaignQuery groupByStartdate() Group by the startDate column
 * @method CampaignQuery groupByFinishdate() Group by the finishDate column
 * @method CampaignQuery groupByClientid() Group by the clientId column
 * @method CampaignQuery groupByDescription() Group by the description column
 * @method CampaignQuery groupByLangcode() Group by the langCode column
 * @method CampaignQuery groupByDefaultkeywords() Group by the defaultKeywords column
 * @method CampaignQuery groupByResponsible() Group by the responsible column
 * @method CampaignQuery groupBySources() Group by the sources column
 * @method CampaignQuery groupBySearchqueries() Group by the searchQueries column
 * @method CampaignQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method CampaignQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method CampaignQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method CampaignQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method CampaignQuery leftJoinCampaignParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignParticipant relation
 * @method CampaignQuery rightJoinCampaignParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignParticipant relation
 * @method CampaignQuery innerJoinCampaignParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignParticipant relation
 *
 * @method CampaignQuery leftJoinCampaignCommitment($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignCommitment relation
 * @method CampaignQuery rightJoinCampaignCommitment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignCommitment relation
 * @method CampaignQuery innerJoinCampaignCommitment($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignCommitment relation
 *
 * @method CampaignQuery leftJoinCampaignDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignDocument relation
 * @method CampaignQuery rightJoinCampaignDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignDocument relation
 * @method CampaignQuery innerJoinCampaignDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignDocument relation
 *
 * @method Campaign findOne(PropelPDO $con = null) Return the first Campaign matching the query
 * @method Campaign findOneOrCreate(PropelPDO $con = null) Return the first Campaign matching the query, or a new Campaign object populated from the query conditions when no match is found
 *
 * @method Campaign findOneById(int $id) Return the first Campaign filtered by the id column
 * @method Campaign findOneByName(string $name) Return the first Campaign filtered by the name column
 * @method Campaign findOneByType(int $type) Return the first Campaign filtered by the type column
 * @method Campaign findOneByStartdate(string $startDate) Return the first Campaign filtered by the startDate column
 * @method Campaign findOneByFinishdate(string $finishDate) Return the first Campaign filtered by the finishDate column
 * @method Campaign findOneByClientid(int $clientId) Return the first Campaign filtered by the clientId column
 * @method Campaign findOneByDescription(string $description) Return the first Campaign filtered by the description column
 * @method Campaign findOneByLangcode(string $langCode) Return the first Campaign filtered by the langCode column
 * @method Campaign findOneByDefaultkeywords(string $defaultKeywords) Return the first Campaign filtered by the defaultKeywords column
 * @method Campaign findOneByResponsible(string $responsible) Return the first Campaign filtered by the responsible column
 * @method Campaign findOneBySources(int $sources) Return the first Campaign filtered by the sources column
 * @method Campaign findOneBySearchqueries(array $searchQueries) Return the first Campaign filtered by the searchQueries column
 * @method Campaign findOneByDeletedAt(string $deleted_at) Return the first Campaign filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Campaign objects filtered by the id column
 * @method array findByName(string $name) Return Campaign objects filtered by the name column
 * @method array findByType(int $type) Return Campaign objects filtered by the type column
 * @method array findByStartdate(string $startDate) Return Campaign objects filtered by the startDate column
 * @method array findByFinishdate(string $finishDate) Return Campaign objects filtered by the finishDate column
 * @method array findByClientid(int $clientId) Return Campaign objects filtered by the clientId column
 * @method array findByDescription(string $description) Return Campaign objects filtered by the description column
 * @method array findByLangcode(string $langCode) Return Campaign objects filtered by the langCode column
 * @method array findByDefaultkeywords(string $defaultKeywords) Return Campaign objects filtered by the defaultKeywords column
 * @method array findByResponsible(string $responsible) Return Campaign objects filtered by the responsible column
 * @method array findBySources(int $sources) Return Campaign objects filtered by the sources column
 * @method array findBySearchqueries(array $searchQueries) Return Campaign objects filtered by the searchQueries column
 * @method array findByDeletedAt(string $deleted_at) Return Campaign objects filtered by the deleted_at column
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseCampaignQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Campaign', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new CampaignQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     CampaignQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return CampaignQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof CampaignQuery) {
            return $criteria;
        }
        $query = new CampaignQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Campaign|Campaign[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = CampaignPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Campaign A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `TYPE`, `STARTDATE`, `FINISHDATE`, `CLIENTID`, `DESCRIPTION`, `LANGCODE`, `DEFAULTKEYWORDS`, `RESPONSIBLE`, `SOURCES`, `SEARCHQUERIES`, `DELETED_AT` FROM `campaigns_campaign` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Campaign();
            $obj->hydrate($row);
            CampaignPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Campaign|Campaign[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Campaign[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(CampaignPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(CampaignPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(CampaignPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(CampaignPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(CampaignPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the startDate column
     *
     * Example usage:
     * <code>
     * $query->filterByStartdate('2011-03-14'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate('now'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate(array('max' => 'yesterday')); // WHERE startDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $startdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByStartdate($startdate = null, $comparison = null)
    {
        if (is_array($startdate)) {
            $useMinMax = false;
            if (isset($startdate['min'])) {
                $this->addUsingAlias(CampaignPeer::STARTDATE, $startdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startdate['max'])) {
                $this->addUsingAlias(CampaignPeer::STARTDATE, $startdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::STARTDATE, $startdate, $comparison);
    }

    /**
     * Filter the query on the finishDate column
     *
     * Example usage:
     * <code>
     * $query->filterByFinishdate('2011-03-14'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate('now'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate(array('max' => 'yesterday')); // WHERE finishDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $finishdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByFinishdate($finishdate = null, $comparison = null)
    {
        if (is_array($finishdate)) {
            $useMinMax = false;
            if (isset($finishdate['min'])) {
                $this->addUsingAlias(CampaignPeer::FINISHDATE, $finishdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($finishdate['max'])) {
                $this->addUsingAlias(CampaignPeer::FINISHDATE, $finishdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::FINISHDATE, $finishdate, $comparison);
    }

    /**
     * Filter the query on the clientId column
     *
     * Example usage:
     * <code>
     * $query->filterByClientid(1234); // WHERE clientId = 1234
     * $query->filterByClientid(array(12, 34)); // WHERE clientId IN (12, 34)
     * $query->filterByClientid(array('min' => 12)); // WHERE clientId > 12
     * </code>
     *
     * @param     mixed $clientid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByClientid($clientid = null, $comparison = null)
    {
        if (is_array($clientid)) {
            $useMinMax = false;
            if (isset($clientid['min'])) {
                $this->addUsingAlias(CampaignPeer::CLIENTID, $clientid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($clientid['max'])) {
                $this->addUsingAlias(CampaignPeer::CLIENTID, $clientid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::CLIENTID, $clientid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the langCode column
     *
     * Example usage:
     * <code>
     * $query->filterByLangcode('fooValue');   // WHERE langCode = 'fooValue'
     * $query->filterByLangcode('%fooValue%'); // WHERE langCode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $langcode The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByLangcode($langcode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($langcode)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $langcode)) {
                $langcode = str_replace('*', '%', $langcode);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignPeer::LANGCODE, $langcode, $comparison);
    }

    /**
     * Filter the query on the defaultKeywords column
     *
     * Example usage:
     * <code>
     * $query->filterByDefaultkeywords('fooValue');   // WHERE defaultKeywords = 'fooValue'
     * $query->filterByDefaultkeywords('%fooValue%'); // WHERE defaultKeywords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $defaultkeywords The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByDefaultkeywords($defaultkeywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($defaultkeywords)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $defaultkeywords)) {
                $defaultkeywords = str_replace('*', '%', $defaultkeywords);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignPeer::DEFAULTKEYWORDS, $defaultkeywords, $comparison);
    }

    /**
     * Filter the query on the responsible column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsible('fooValue');   // WHERE responsible = 'fooValue'
     * $query->filterByResponsible('%fooValue%'); // WHERE responsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $responsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByResponsible($responsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($responsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $responsible)) {
                $responsible = str_replace('*', '%', $responsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignPeer::RESPONSIBLE, $responsible, $comparison);
    }

    /**
     * Filter the query on the sources column
     *
     * Example usage:
     * <code>
     * $query->filterBySources(1234); // WHERE sources = 1234
     * $query->filterBySources(array(12, 34)); // WHERE sources IN (12, 34)
     * $query->filterBySources(array('min' => 12)); // WHERE sources > 12
     * </code>
     *
     * @param     mixed $sources The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterBySources($sources = null, $comparison = null)
    {
        if (is_array($sources)) {
            $useMinMax = false;
            if (isset($sources['min'])) {
                $this->addUsingAlias(CampaignPeer::SOURCES, $sources['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($sources['max'])) {
                $this->addUsingAlias(CampaignPeer::SOURCES, $sources['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::SOURCES, $sources, $comparison);
    }

    /**
     * Filter the query on the searchQueries column
     *
     * @param     array $searchqueries The values to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterBySearchqueries($searchqueries = null, $comparison = null)
    {
        $key = $this->getAliasedColName(CampaignPeer::SEARCHQUERIES);
        if (null === $comparison || $comparison == Criteria::CONTAINS_ALL) {
            foreach ($searchqueries as $value) {
                $value = '%| ' . $value . ' |%';
                if ($this->containsKey($key)) {
                    $this->addAnd($key, $value, Criteria::LIKE);
                } else {
                    $this->add($key, $value, Criteria::LIKE);
                }
            }

            return $this;
        } elseif ($comparison == Criteria::CONTAINS_SOME) {
            foreach ($searchqueries as $value) {
                $value = '%| ' . $value . ' |%';
                if ($this->containsKey($key)) {
                    $this->addOr($key, $value, Criteria::LIKE);
                } else {
                    $this->add($key, $value, Criteria::LIKE);
                }
            }

            return $this;
        } elseif ($comparison == Criteria::CONTAINS_NONE) {
            foreach ($searchqueries as $value) {
                $value = '%| ' . $value . ' |%';
                if ($this->containsKey($key)) {
                    $this->addAnd($key, $value, Criteria::NOT_LIKE);
                } else {
                    $this->add($key, $value, Criteria::NOT_LIKE);
                }
            }
            $this->addOr($key, null, Criteria::ISNULL);

            return $this;
        }

        return $this->addUsingAlias(CampaignPeer::SEARCHQUERIES, $searchqueries, $comparison);
    }

    /**
     * Filter the query on the searchQueries column
     * @param     mixed $searchqueries The value to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::CONTAINS_ALL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterBySearchquerie($searchqueries = null, $comparison = null)
    {
        if (null === $comparison || $comparison == Criteria::CONTAINS_ALL) {
            if (is_scalar($searchqueries)) {
                $searchqueries = '%| ' . $searchqueries . ' |%';
                $comparison = Criteria::LIKE;
            }
        } elseif ($comparison == Criteria::CONTAINS_NONE) {
            $searchqueries = '%| ' . $searchqueries . ' |%';
            $comparison = Criteria::NOT_LIKE;
            $key = $this->getAliasedColName(CampaignPeer::SEARCHQUERIES);
            if ($this->containsKey($key)) {
                $this->addAnd($key, $searchqueries, $comparison);
            } else {
                $this->addAnd($key, $searchqueries, $comparison);
            }
            $this->addOr($key, null, Criteria::ISNULL);

            return $this;
        }

        return $this->addUsingAlias(CampaignPeer::SEARCHQUERIES, $searchqueries, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(CampaignPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(CampaignPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related CampaignParticipant object
     *
     * @param   CampaignParticipant|PropelObjectCollection $campaignParticipant  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignParticipant($campaignParticipant, $comparison = null)
    {
        if ($campaignParticipant instanceof CampaignParticipant) {
            return $this
                ->addUsingAlias(CampaignPeer::ID, $campaignParticipant->getCampaignid(), $comparison);
        } elseif ($campaignParticipant instanceof PropelObjectCollection) {
            return $this
                ->useCampaignParticipantQuery()
                ->filterByPrimaryKeys($campaignParticipant->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCampaignParticipant() only accepts arguments of type CampaignParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function joinCampaignParticipant($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignParticipant');
        }

        return $this;
    }

    /**
     * Use the CampaignParticipant relation CampaignParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignParticipantQuery A secondary query class using the current class as primary query
     */
    public function useCampaignParticipantQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCampaignParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignParticipant', 'CampaignParticipantQuery');
    }

    /**
     * Filter the query by a related CampaignCommitment object
     *
     * @param   CampaignCommitment|PropelObjectCollection $campaignCommitment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignCommitment($campaignCommitment, $comparison = null)
    {
        if ($campaignCommitment instanceof CampaignCommitment) {
            return $this
                ->addUsingAlias(CampaignPeer::ID, $campaignCommitment->getCampaignid(), $comparison);
        } elseif ($campaignCommitment instanceof PropelObjectCollection) {
            return $this
                ->useCampaignCommitmentQuery()
                ->filterByPrimaryKeys($campaignCommitment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCampaignCommitment() only accepts arguments of type CampaignCommitment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignCommitment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function joinCampaignCommitment($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignCommitment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignCommitment');
        }

        return $this;
    }

    /**
     * Use the CampaignCommitment relation CampaignCommitment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignCommitmentQuery A secondary query class using the current class as primary query
     */
    public function useCampaignCommitmentQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCampaignCommitment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignCommitment', 'CampaignCommitmentQuery');
    }

    /**
     * Filter the query by a related CampaignDocument object
     *
     * @param   CampaignDocument|PropelObjectCollection $campaignDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignDocument($campaignDocument, $comparison = null)
    {
        if ($campaignDocument instanceof CampaignDocument) {
            return $this
                ->addUsingAlias(CampaignPeer::ID, $campaignDocument->getCampaignid(), $comparison);
        } elseif ($campaignDocument instanceof PropelObjectCollection) {
            return $this
                ->useCampaignDocumentQuery()
                ->filterByPrimaryKeys($campaignDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCampaignDocument() only accepts arguments of type CampaignDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function joinCampaignDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignDocument');
        }

        return $this;
    }

    /**
     * Use the CampaignDocument relation CampaignDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignDocumentQuery A secondary query class using the current class as primary query
     */
    public function useCampaignDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCampaignDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignDocument', 'CampaignDocumentQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the campaigns_campaignDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useCampaignDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Campaign $campaign Object to remove from the list of results
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function prune($campaign = null)
    {
        if ($campaign) {
            $this->addUsingAlias(CampaignPeer::ID, $campaign->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (CampaignQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(CampaignPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            CampaignPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (CampaignQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see CampaignQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return CampaignQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return CampaignPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return CampaignPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
