<?php

namespace Egytca;

use Exception;

class Utils {

	public static function ensureWritable($path) {
		
		if (!file_exists($path)) {
			$success = mkdir($path, 0755, true);
			if (!$success) {
				throw new Exception("el directorio $path no existe.".
					" creacion automatica fallo. verifique permisos");
			}
		}

		if (!self::isWritable($path)) {
			throw new Exception("no se puede escribir en $path, verifique permisos");
		}
	}

	/**
	 * Returns true if $path is writable or false otherwise
	 *
	 * @param string $path
	 * @return boolean
	 */
	public static function isWritable($path) {
		$testfile = $path.'/'.uniqid().'.test';
		file_put_contents($testfile, 'asd');
		$return = file_exists($testfile);
		unlink($testfile);
		return $return;
	}

	static function getAngularDateFormat() {
		global $system;
		$format = $system['config']['system']['parameters']['dateFormat']['value'];

		// order matters
		$format = str_replace('y', 'yy', $format);
		$format = str_replace('Y', 'yyyy', $format);
		$format = str_replace('m', 'MM', $format);
		$format = str_replace('d', 'dd', $format);

		return $format;
	}
}