
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- positions_position
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `positions_position`;

CREATE TABLE `positions_position`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(255) NOT NULL COMMENT 'Position Name',
    `code` INTEGER NOT NULL COMMENT 'Codigo del cargo, usado para poder generar nuevas versiones del mismo cargo, el cual mantiene el code pero genera una nueva version',
    `userGroupId` INTEGER COMMENT 'Id del grupo de usuarios con acceso a los datos de la position',
    `versionId` INTEGER NOT NULL COMMENT 'Version',
    `internalCode` VARCHAR(255) COMMENT 'Codigo del cargo',
    `ownerName` VARCHAR(150) COMMENT 'Titulo de la persona que ocupa el cargo (Presidente)',
    `ownerNameFemale` VARCHAR(150) COMMENT 'Titulo de la persona que ocupa el cargo en femenino',
    `type` INTEGER NOT NULL,
    `kind` VARCHAR(50) DEFAULT 'hierarchical' NOT NULL,
    `address` TEXT COMMENT 'Address',
    `telephone` VARCHAR(150) COMMENT 'Telephone',
    `email` VARCHAR(150) COMMENT 'e-mail',
    `budget` FLOAT DEFAULT 0 COMMENT 'Budget (Presupuesto)',
    `personnel` INTEGER DEFAULT 0 COMMENT 'Planta permanente',
    `hired` INTEGER DEFAULT 0 COMMENT 'Contratados',
    `consultant` INTEGER DEFAULT 0 COMMENT 'Asesores',
    `other` INTEGER DEFAULT 0 COMMENT 'Otros',
    `planning` TINYINT(1) COMMENT 'Indica si va a inicio de planificacion',
    `order` INTEGER DEFAULT 0 COMMENT 'Orden de aparicion en home',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `positions_position_U_1` (`code`, `versionId`),
    INDEX `positions_position_FI_1` (`userGroupId`),
    INDEX `positions_position_FI_2` (`versionId`),
    CONSTRAINT `positions_position_FK_1`
        FOREIGN KEY (`userGroupId`)
        REFERENCES `users_group` (`id`),
    CONSTRAINT `positions_position_FK_2`
        FOREIGN KEY (`versionId`)
        REFERENCES `positions_version` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Cargos';

-- ---------------------------------------------------------------------
-- positions_version
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `positions_version`;

CREATE TABLE `positions_version`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `dateFrom` DATETIME COMMENT 'Fecha de inicio de validez del organigrama',
    `dateTo` DATETIME COMMENT 'Fecha de fin de validez del organigrama',
    `description` TEXT COMMENT 'Descripcion de la version',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Versiones de organigramas';

-- ---------------------------------------------------------------------
-- positions_positionTenure
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `positions_positionTenure`;

CREATE TABLE `positions_positionTenure`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `userId` INTEGER COMMENT 'Id de la persona que ejerce el cargo',
    `name` VARCHAR(150) COMMENT 'Nombre de la persona que ejerce el cargo',
    `dateFrom` DATETIME NOT NULL COMMENT 'Fecha en que se asumio el cargo',
    `dateTo` DATETIME COMMENT 'Fecha en que abandono el cargo',
    `positionCode` INTEGER NOT NULL COMMENT 'Id del cargo',
    `ownerName` VARCHAR(150) COMMENT 'Titulo de la persona que ocupa el cargo (Presidente)',
    `objectType` VARCHAR(50) NOT NULL COMMENT 'Tipo de tenure',
    `objectId` INTEGER NOT NULL COMMENT 'Id del tenure',
    PRIMARY KEY (`id`),
    INDEX `positions_positionTenure_FI_1` (`positionCode`),
    CONSTRAINT `positions_positionTenure_FK_1`
        FOREIGN KEY (`positionCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Ejercicio del cargo';

-- ---------------------------------------------------------------------
-- positions_document
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `positions_document`;

CREATE TABLE `positions_document`
(
    `positionId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`positionId`,`documentId`),
    INDEX `positions_document_FI_2` (`documentId`),
    CONSTRAINT `positions_document_FK_1`
        FOREIGN KEY (`positionId`)
        REFERENCES `positions_position` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `positions_document_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
