
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- objectives_policyGuideline
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_policyGuideline`;

CREATE TABLE `objectives_policyGuideline`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Policy Guideline Id',
    `name` TEXT(255) NOT NULL COMMENT 'Policy Guideline Name',
    `description` TEXT COMMENT 'Policy Guideline Description',
    `exchangeRate` FLOAT COMMENT 'Exchange Rate',
    `userId` INTEGER COMMENT 'User Id ',
    `objectType` VARCHAR(50) NOT NULL COMMENT 'Tipo de usuario',
    `objectId` INTEGER NOT NULL COMMENT 'Id del usuario',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Endign year',
    `updated` DATETIME COMMENT 'Updated',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `objectives_policyGuideline_FI_1` (`userId`),
    CONSTRAINT `objectives_policyGuideline_FK_1`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Policy Guidelines';

-- ---------------------------------------------------------------------
-- objectives_policyGuidelineIndicators
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_policyGuidelineIndicators`;

CREATE TABLE `objectives_policyGuidelineIndicators`
(
    `indicatorId` INTEGER(4) NOT NULL COMMENT 'Id Indicador',
    `policyGuidelineId` INTEGER(5) NOT NULL COMMENT 'PolicyGuideline Id',
    PRIMARY KEY (`indicatorId`,`policyGuidelineId`),
    INDEX `objectives_policyGuidelineIndicators_FI_1` (`policyGuidelineId`),
    CONSTRAINT `objectives_policyGuidelineIndicators_FK_1`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `objectives_policyGuidelineIndicators_FK_2`
        FOREIGN KEY (`indicatorId`)
        REFERENCES `indicators_indicator` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion PolicyGuideline e Indicadores';

-- ---------------------------------------------------------------------
-- objectives_strategic
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_strategic`;

CREATE TABLE `objectives_strategic`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Objective Id',
    `policyGuidelineId` INTEGER COMMENT 'Policy Guideline Id',
    `name` TEXT(255) NOT NULL COMMENT 'Objective Name',
    `description` TEXT COMMENT 'Objective Description',
    `userId` INTEGER COMMENT 'User Id ',
    `affiliateId` INTEGER DEFAULT 0 NOT NULL COMMENT 'Affiliate Id',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `oldId` INTEGER COMMENT 'Old Id',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `objectives_strategic_FI_1` (`policyGuidelineId`),
    INDEX `objectives_strategic_FI_2` (`userId`),
    CONSTRAINT `objectives_strategic_FK_1`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`),
    CONSTRAINT `objectives_strategic_FK_2`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Strategic Objective';

-- ---------------------------------------------------------------------
-- objectives_objective
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_objective`;

CREATE TABLE `objectives_objective`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Objective Id',
    `name` VARCHAR(255) NOT NULL COMMENT 'Objective Name',
    `policyGuidelineId` INTEGER NOT NULL COMMENT 'Strategic Objective Id',
    `strategicObjectiveId` INTEGER NOT NULL COMMENT 'Strategic Objective Id',
    `affiliateId` INTEGER DEFAULT 0 NOT NULL COMMENT 'Affiliate Id',
    `description` TEXT COMMENT 'Objective Description',
    `date` DATE COMMENT 'Objective Date',
    `expirationDate` DATE COMMENT 'Objective Expiration Date (Fecha Vencimiento)',
    `achieved` TINYINT(1) COMMENT 'is Objective achieved?',
    `notes` TEXT COMMENT 'Objective Notes',
    `responsibleCode` INTEGER COMMENT 'Position Code',
    `userId` INTEGER COMMENT 'User Id ',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `oldId` INTEGER COMMENT 'Old Id',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `objectives_objective_FI_1` (`strategicObjectiveId`),
    INDEX `objectives_objective_FI_2` (`policyGuidelineId`),
    INDEX `objectives_objective_FI_3` (`userId`),
    INDEX `objectives_objective_FI_4` (`responsibleCode`),
    CONSTRAINT `objectives_objective_FK_1`
        FOREIGN KEY (`strategicObjectiveId`)
        REFERENCES `objectives_strategic` (`id`),
    CONSTRAINT `objectives_objective_FK_2`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`),
    CONSTRAINT `objectives_objective_FK_3`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`),
    CONSTRAINT `objectives_objective_FK_4`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM COMMENT='Objective';

-- ---------------------------------------------------------------------
-- objectives_region
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_region`;

CREATE TABLE `objectives_region`
(
    `regionId` INTEGER NOT NULL,
    `objectiveId` INTEGER NOT NULL,
    PRIMARY KEY (`regionId`,`objectiveId`),
    INDEX `objectives_region_FI_2` (`objectiveId`),
    CONSTRAINT `objectives_region_FK_1`
        FOREIGN KEY (`regionId`)
        REFERENCES `regions_region` (`id`),
    CONSTRAINT `objectives_region_FK_2`
        FOREIGN KEY (`objectiveId`)
        REFERENCES `objectives_objective` (`id`)
) ENGINE=MyISAM COMMENT='Asociacion entre Regiones y Objetivos';

-- ---------------------------------------------------------------------
-- objectives_policyGuidelineLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_policyGuidelineLog`;

CREATE TABLE `objectives_policyGuidelineLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Policy Guideline Id',
    `policyGuidelineId` INTEGER COMMENT 'Policy Guideline Id',
    `name` TEXT(255) NOT NULL COMMENT 'Policy Guideline Name',
    `description` TEXT COMMENT 'Policy Guideline Description',
    `userId` INTEGER COMMENT 'User Id ',
    `updated` DATETIME COMMENT 'Updated',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    PRIMARY KEY (`id`),
    INDEX `objectives_policyGuidelineLog_FI_1` (`policyGuidelineId`),
    INDEX `objectives_policyGuidelineLog_FI_2` (`userId`),
    CONSTRAINT `objectives_policyGuidelineLog_FK_1`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`),
    CONSTRAINT `objectives_policyGuidelineLog_FK_2`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Policy Guidelines';

-- ---------------------------------------------------------------------
-- objectives_strategicLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_strategicLog`;

CREATE TABLE `objectives_strategicLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Objective Id',
    `strategicId` INTEGER COMMENT 'Strategic Objective Id',
    `policyGuidelineId` INTEGER COMMENT 'Policy Guideline Id',
    `name` TEXT(255) NOT NULL COMMENT 'Objective Name',
    `description` TEXT COMMENT 'Objective Description',
    `exchangeRate` FLOAT COMMENT 'Exchange Rate',
    `userId` INTEGER COMMENT 'User Id ',
    `affiliateId` INTEGER NOT NULL COMMENT 'Affiliate Id',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `oldId` INTEGER COMMENT 'Old Id',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    PRIMARY KEY (`id`),
    INDEX `objectives_strategicLog_FI_1` (`strategicId`),
    INDEX `objectives_strategicLog_FI_2` (`policyGuidelineId`),
    INDEX `objectives_strategicLog_FI_3` (`userId`),
    CONSTRAINT `objectives_strategicLog_FK_1`
        FOREIGN KEY (`strategicId`)
        REFERENCES `objectives_strategic` (`id`),
    CONSTRAINT `objectives_strategicLog_FK_2`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`),
    CONSTRAINT `objectives_strategicLog_FK_3`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Strategic Objective Log';

-- ---------------------------------------------------------------------
-- objectives_objectiveLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `objectives_objectiveLog`;

CREATE TABLE `objectives_objectiveLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Objective Id',
    `objectiveId` INTEGER NOT NULL COMMENT 'Objective Id',
    `name` VARCHAR(255) NOT NULL COMMENT 'Objective Name',
    `policyGuidelineId` INTEGER COMMENT 'Policy Guideline Id',
    `strategicObjectiveId` INTEGER NOT NULL COMMENT 'Strategic Objective Id',
    `affiliateId` INTEGER NOT NULL COMMENT 'Affiliate Id',
    `description` TEXT COMMENT 'Objective Description',
    `date` DATE COMMENT 'Objective Date',
    `expirationDate` DATE COMMENT 'Objective Expiration Date (Fecha Vencimiento)',
    `achieved` TINYINT(1) COMMENT 'is Objective achieved?',
    `notes` TEXT COMMENT 'Objective Notes',
    `responsibleCode` INTEGER COMMENT 'Position Code',
    `userId` INTEGER COMMENT 'User Id ',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `oldId` INTEGER COMMENT 'Old Id',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    PRIMARY KEY (`id`),
    INDEX `objectives_objectiveLog_FI_1` (`strategicObjectiveId`),
    INDEX `objectives_objectiveLog_FI_2` (`objectiveId`),
    INDEX `objectives_objectiveLog_FI_3` (`policyGuidelineId`),
    INDEX `objectives_objectiveLog_FI_4` (`userId`),
    INDEX `objectives_objectiveLog_FI_5` (`responsibleCode`),
    CONSTRAINT `objectives_objectiveLog_FK_1`
        FOREIGN KEY (`strategicObjectiveId`)
        REFERENCES `objectives_strategic` (`id`),
    CONSTRAINT `objectives_objectiveLog_FK_2`
        FOREIGN KEY (`objectiveId`)
        REFERENCES `objectives_objective` (`id`),
    CONSTRAINT `objectives_objectiveLog_FK_3`
        FOREIGN KEY (`policyGuidelineId`)
        REFERENCES `objectives_policyGuideline` (`id`),
    CONSTRAINT `objectives_objectiveLog_FK_4`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`),
    CONSTRAINT `objectives_objectiveLog_FK_5`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`id`)
) ENGINE=MyISAM COMMENT='Objective Log';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
