<?php


/**
 * Base class that represents a row from the 'users_user' table.
 *
 * Users
 *
 * @package    propel.generator.users.classes.om
 */
abstract class BaseUser extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'UserPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        UserPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the username field.
     * @var        string
     */
    protected $username;

    /**
     * The value for the password field.
     * @var        string
     */
    protected $password;

    /**
     * The value for the passwordupdated field.
     * @var        string
     */
    protected $passwordupdated;

    /**
     * The value for the active field.
     * @var        boolean
     */
    protected $active;

    /**
     * The value for the created field.
     * @var        string
     */
    protected $created;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the levelid field.
     * @var        int
     */
    protected $levelid;

    /**
     * The value for the lastlogin field.
     * @var        string
     */
    protected $lastlogin;

    /**
     * The value for the timezone field.
     * @var        string
     */
    protected $timezone;

    /**
     * The value for the recoveryhash field.
     * @var        string
     */
    protected $recoveryhash;

    /**
     * The value for the recoveryhashcreatedon field.
     * @var        string
     */
    protected $recoveryhashcreatedon;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the surname field.
     * @var        string
     */
    protected $surname;

    /**
     * The value for the documenttype field.
     * @var        int
     */
    protected $documenttype;

    /**
     * The value for the document field.
     * @var        string
     */
    protected $document;

    /**
     * The value for the gender field.
     * @var        int
     */
    protected $gender;

    /**
     * The value for the birthdate field.
     * @var        string
     */
    protected $birthdate;

    /**
     * The value for the mailaddress field.
     * @var        string
     */
    protected $mailaddress;

    /**
     * The value for the mailaddressalt field.
     * @var        string
     */
    protected $mailaddressalt;

    /**
     * The value for the session field.
     * @var        string
     */
    protected $session;

    /**
     * The value for the blockedat field.
     * @var        string
     */
    protected $blockedat;

    /**
     * The value for the lastaction field.
     * @var        string
     */
    protected $lastaction;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * @var        Level
     */
    protected $aLevel;

    /**
     * @var        PropelObjectCollection|ActionLog[] Collection to store aggregation of ActionLog objects.
     */
    protected $collActionLogs;
    protected $collActionLogsPartial;

    /**
     * @var        PropelObjectCollection|AlertSubscriptionUser[] Collection to store aggregation of AlertSubscriptionUser objects.
     */
    protected $collAlertSubscriptionUsers;
    protected $collAlertSubscriptionUsersPartial;

    /**
     * @var        PropelObjectCollection|Inspector[] Collection to store aggregation of Inspector objects.
     */
    protected $collInspectors;
    protected $collInspectorsPartial;

    /**
     * @var        PropelObjectCollection|PolicyGuideline[] Collection to store aggregation of PolicyGuideline objects.
     */
    protected $collPolicyGuidelines;
    protected $collPolicyGuidelinesPartial;

    /**
     * @var        PropelObjectCollection|StrategicObjective[] Collection to store aggregation of StrategicObjective objects.
     */
    protected $collStrategicObjectives;
    protected $collStrategicObjectivesPartial;

    /**
     * @var        PropelObjectCollection|Objective[] Collection to store aggregation of Objective objects.
     */
    protected $collObjectives;
    protected $collObjectivesPartial;

    /**
     * @var        PropelObjectCollection|PolicyGuidelineLog[] Collection to store aggregation of PolicyGuidelineLog objects.
     */
    protected $collPolicyGuidelineLogs;
    protected $collPolicyGuidelineLogsPartial;

    /**
     * @var        PropelObjectCollection|StrategicObjectiveLog[] Collection to store aggregation of StrategicObjectiveLog objects.
     */
    protected $collStrategicObjectiveLogs;
    protected $collStrategicObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveLog[] Collection to store aggregation of ObjectiveLog objects.
     */
    protected $collObjectiveLogs;
    protected $collObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;
    protected $collProjectsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivity[] Collection to store aggregation of ProjectActivity objects.
     */
    protected $collProjectActivitys;
    protected $collProjectActivitysPartial;

    /**
     * @var        PropelObjectCollection|ProjectLog[] Collection to store aggregation of ProjectLog objects.
     */
    protected $collProjectLogs;
    protected $collProjectLogsPartial;

    /**
     * @var        PropelObjectCollection|ProjectMilestoneLog[] Collection to store aggregation of ProjectMilestoneLog objects.
     */
    protected $collProjectMilestoneLogs;
    protected $collProjectMilestoneLogsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivityLog[] Collection to store aggregation of ProjectActivityLog objects.
     */
    protected $collProjectActivityLogs;
    protected $collProjectActivityLogsPartial;

    /**
     * @var        PropelObjectCollection|UserGroup[] Collection to store aggregation of UserGroup objects.
     */
    protected $collUserGroups;
    protected $collUserGroupsPartial;

    /**
     * @var        PropelObjectCollection|AlertSubscription[] Collection to store aggregation of AlertSubscription objects.
     */
    protected $collAlertSubscriptions;

    /**
     * @var        PropelObjectCollection|Group[] Collection to store aggregation of Group objects.
     */
    protected $collGroups;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $alertSubscriptionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $groupsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actionLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $alertSubscriptionUsersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $inspectorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $strategicObjectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelineLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $strategicObjectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivitysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectMilestoneLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivityLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $userGroupsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * User Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [username] column value.
     * username
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Get the [password] column value.
     * password
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [optionally formatted] temporal [passwordupdated] column value.
     * Fecha de actualizacion de la clave
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPasswordupdated($format = '%Y/%m/%d')
    {
        if ($this->passwordupdated === null) {
            return null;
        }

        if ($this->passwordupdated === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->passwordupdated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->passwordupdated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [active] column value.
     * Is user active?
     * @return boolean
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [optionally formatted] temporal [created] column value.
     * Creation date for
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreated($format = 'Y-m-d H:i:s')
    {
        if ($this->created === null) {
            return null;
        }

        if ($this->created === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Last update date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [levelid] column value.
     * User Level
     * @return int
     */
    public function getLevelid()
    {
        return $this->levelid;
    }

    /**
     * Get the [optionally formatted] temporal [lastlogin] column value.
     * Fecha del ultimo login del usuario
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastlogin($format = 'Y-m-d H:i:s')
    {
        if ($this->lastlogin === null) {
            return null;
        }

        if ($this->lastlogin === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->lastlogin);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->lastlogin, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [timezone] column value.
     * Timezone GMT del usuario
     * @return string
     */
    public function getTimezone()
    {
        return $this->timezone;
    }

    /**
     * Get the [recoveryhash] column value.
     * Hash enviado para la recuperacion de clave
     * @return string
     */
    public function getRecoveryhash()
    {
        return $this->recoveryhash;
    }

    /**
     * Get the [optionally formatted] temporal [recoveryhashcreatedon] column value.
     * Momento de la solicitud para la recuperacion de clave
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRecoveryhashcreatedon($format = 'Y-m-d H:i:s')
    {
        if ($this->recoveryhashcreatedon === null) {
            return null;
        }

        if ($this->recoveryhashcreatedon === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->recoveryhashcreatedon);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->recoveryhashcreatedon, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [name] column value.
     * Nombre
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [surname] column value.
     * Apellido
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * Get the [documenttype] column value.
     * Tipo de documento
     * @return int
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }

    /**
     * Get the [document] column value.
     * Numero de documento
     * @return string
     */
    public function getDocument()
    {
        return $this->document;
    }

    /**
     * Get the [gender] column value.
     * Genero
     * @return int
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Get the [optionally formatted] temporal [birthdate] column value.
     * Fecha de nacimiento
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getBirthdate($format = '%Y/%m/%d')
    {
        if ($this->birthdate === null) {
            return null;
        }

        if ($this->birthdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->birthdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->birthdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [mailaddress] column value.
     * Direccion electronica
     * @return string
     */
    public function getMailaddress()
    {
        return $this->mailaddress;
    }

    /**
     * Get the [mailaddressalt] column value.
     * Direccion electronica alternativa
     * @return string
     */
    public function getMailaddressalt()
    {
        return $this->mailaddressalt;
    }

    /**
     * Get the [session] column value.
     * Nombre de la sesion
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Get the [optionally formatted] temporal [blockedat] column value.
     * Fecha y hora del bloqueo
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getBlockedat($format = 'Y-m-d H:i:s')
    {
        if ($this->blockedat === null) {
            return null;
        }

        if ($this->blockedat === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->blockedat);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->blockedat, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [lastaction] column value.
     * Fecha y hora deultima accion solicitada
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastaction($format = 'Y-m-d H:i:s')
    {
        if ($this->lastaction === null) {
            return null;
        }

        if ($this->lastaction === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->lastaction);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->lastaction, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * User Id
     * @param int $v new value
     * @return User The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = UserPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [username] column.
     * username
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setUsername($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->username !== $v) {
            $this->username = $v;
            $this->modifiedColumns[] = UserPeer::USERNAME;
        }


        return $this;
    } // setUsername()

    /**
     * Set the value of [password] column.
     * password
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[] = UserPeer::PASSWORD;
        }


        return $this;
    } // setPassword()

    /**
     * Sets the value of [passwordupdated] column to a normalized version of the date/time value specified.
     * Fecha de actualizacion de la clave
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setPasswordupdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->passwordupdated !== null || $dt !== null) {
            $currentDateAsString = ($this->passwordupdated !== null && $tmpDt = new DateTime($this->passwordupdated)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->passwordupdated = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::PASSWORDUPDATED;
            }
        } // if either are not null


        return $this;
    } // setPasswordupdated()

    /**
     * Sets the value of the [active] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Is user active?
     * @param boolean|integer|string $v The new value
     * @return User The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[] = UserPeer::ACTIVE;
        }


        return $this;
    } // setActive()

    /**
     * Sets the value of [created] column to a normalized version of the date/time value specified.
     * Creation date for
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setCreated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created !== null || $dt !== null) {
            $currentDateAsString = ($this->created !== null && $tmpDt = new DateTime($this->created)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::CREATED;
            }
        } // if either are not null


        return $this;
    } // setCreated()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Last update date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [levelid] column.
     * User Level
     * @param int $v new value
     * @return User The current object (for fluent API support)
     */
    public function setLevelid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->levelid !== $v) {
            $this->levelid = $v;
            $this->modifiedColumns[] = UserPeer::LEVELID;
        }

        if ($this->aLevel !== null && $this->aLevel->getId() !== $v) {
            $this->aLevel = null;
        }


        return $this;
    } // setLevelid()

    /**
     * Sets the value of [lastlogin] column to a normalized version of the date/time value specified.
     * Fecha del ultimo login del usuario
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setLastlogin($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastlogin !== null || $dt !== null) {
            $currentDateAsString = ($this->lastlogin !== null && $tmpDt = new DateTime($this->lastlogin)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->lastlogin = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::LASTLOGIN;
            }
        } // if either are not null


        return $this;
    } // setLastlogin()

    /**
     * Set the value of [timezone] column.
     * Timezone GMT del usuario
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setTimezone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->timezone !== $v) {
            $this->timezone = $v;
            $this->modifiedColumns[] = UserPeer::TIMEZONE;
        }


        return $this;
    } // setTimezone()

    /**
     * Set the value of [recoveryhash] column.
     * Hash enviado para la recuperacion de clave
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setRecoveryhash($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->recoveryhash !== $v) {
            $this->recoveryhash = $v;
            $this->modifiedColumns[] = UserPeer::RECOVERYHASH;
        }


        return $this;
    } // setRecoveryhash()

    /**
     * Sets the value of [recoveryhashcreatedon] column to a normalized version of the date/time value specified.
     * Momento de la solicitud para la recuperacion de clave
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setRecoveryhashcreatedon($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->recoveryhashcreatedon !== null || $dt !== null) {
            $currentDateAsString = ($this->recoveryhashcreatedon !== null && $tmpDt = new DateTime($this->recoveryhashcreatedon)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->recoveryhashcreatedon = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::RECOVERYHASHCREATEDON;
            }
        } // if either are not null


        return $this;
    } // setRecoveryhashcreatedon()

    /**
     * Set the value of [name] column.
     * Nombre
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = UserPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [surname] column.
     * Apellido
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setSurname($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->surname !== $v) {
            $this->surname = $v;
            $this->modifiedColumns[] = UserPeer::SURNAME;
        }


        return $this;
    } // setSurname()

    /**
     * Set the value of [documenttype] column.
     * Tipo de documento
     * @param int $v new value
     * @return User The current object (for fluent API support)
     */
    public function setDocumenttype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->documenttype !== $v) {
            $this->documenttype = $v;
            $this->modifiedColumns[] = UserPeer::DOCUMENTTYPE;
        }


        return $this;
    } // setDocumenttype()

    /**
     * Set the value of [document] column.
     * Numero de documento
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setDocument($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->document !== $v) {
            $this->document = $v;
            $this->modifiedColumns[] = UserPeer::DOCUMENT;
        }


        return $this;
    } // setDocument()

    /**
     * Set the value of [gender] column.
     * Genero
     * @param int $v new value
     * @return User The current object (for fluent API support)
     */
    public function setGender($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->gender !== $v) {
            $this->gender = $v;
            $this->modifiedColumns[] = UserPeer::GENDER;
        }


        return $this;
    } // setGender()

    /**
     * Sets the value of [birthdate] column to a normalized version of the date/time value specified.
     * Fecha de nacimiento
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setBirthdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->birthdate !== null || $dt !== null) {
            $currentDateAsString = ($this->birthdate !== null && $tmpDt = new DateTime($this->birthdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->birthdate = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::BIRTHDATE;
            }
        } // if either are not null


        return $this;
    } // setBirthdate()

    /**
     * Set the value of [mailaddress] column.
     * Direccion electronica
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setMailaddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mailaddress !== $v) {
            $this->mailaddress = $v;
            $this->modifiedColumns[] = UserPeer::MAILADDRESS;
        }


        return $this;
    } // setMailaddress()

    /**
     * Set the value of [mailaddressalt] column.
     * Direccion electronica alternativa
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setMailaddressalt($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mailaddressalt !== $v) {
            $this->mailaddressalt = $v;
            $this->modifiedColumns[] = UserPeer::MAILADDRESSALT;
        }


        return $this;
    } // setMailaddressalt()

    /**
     * Set the value of [session] column.
     * Nombre de la sesion
     * @param string $v new value
     * @return User The current object (for fluent API support)
     */
    public function setSession($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->session !== $v) {
            $this->session = $v;
            $this->modifiedColumns[] = UserPeer::SESSION;
        }


        return $this;
    } // setSession()

    /**
     * Sets the value of [blockedat] column to a normalized version of the date/time value specified.
     * Fecha y hora del bloqueo
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setBlockedat($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->blockedat !== null || $dt !== null) {
            $currentDateAsString = ($this->blockedat !== null && $tmpDt = new DateTime($this->blockedat)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->blockedat = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::BLOCKEDAT;
            }
        } // if either are not null


        return $this;
    } // setBlockedat()

    /**
     * Sets the value of [lastaction] column to a normalized version of the date/time value specified.
     * Fecha y hora deultima accion solicitada
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setLastaction($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastaction !== null || $dt !== null) {
            $currentDateAsString = ($this->lastaction !== null && $tmpDt = new DateTime($this->lastaction)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->lastaction = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::LASTACTION;
            }
        } // if either are not null


        return $this;
    } // setLastaction()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return User The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = UserPeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->username = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->password = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->passwordupdated = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->active = ($row[$startcol + 4] !== null) ? (boolean) $row[$startcol + 4] : null;
            $this->created = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->updated = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->levelid = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->lastlogin = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->timezone = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->recoveryhash = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->recoveryhashcreatedon = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->name = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->surname = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->documenttype = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->document = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
            $this->gender = ($row[$startcol + 16] !== null) ? (int) $row[$startcol + 16] : null;
            $this->birthdate = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
            $this->mailaddress = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
            $this->mailaddressalt = ($row[$startcol + 19] !== null) ? (string) $row[$startcol + 19] : null;
            $this->session = ($row[$startcol + 20] !== null) ? (string) $row[$startcol + 20] : null;
            $this->blockedat = ($row[$startcol + 21] !== null) ? (string) $row[$startcol + 21] : null;
            $this->lastaction = ($row[$startcol + 22] !== null) ? (string) $row[$startcol + 22] : null;
            $this->deleted_at = ($row[$startcol + 23] !== null) ? (string) $row[$startcol + 23] : null;
            $this->created_at = ($row[$startcol + 24] !== null) ? (string) $row[$startcol + 24] : null;
            $this->updated_at = ($row[$startcol + 25] !== null) ? (string) $row[$startcol + 25] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 26; // 26 = UserPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating User object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aLevel !== null && $this->levelid !== $this->aLevel->getId()) {
            $this->aLevel = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(UserPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = UserPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aLevel = null;
            $this->collActionLogs = null;

            $this->collAlertSubscriptionUsers = null;

            $this->collInspectors = null;

            $this->collPolicyGuidelines = null;

            $this->collStrategicObjectives = null;

            $this->collObjectives = null;

            $this->collPolicyGuidelineLogs = null;

            $this->collStrategicObjectiveLogs = null;

            $this->collObjectiveLogs = null;

            $this->collProjects = null;

            $this->collProjectActivitys = null;

            $this->collProjectLogs = null;

            $this->collProjectMilestoneLogs = null;

            $this->collProjectActivityLogs = null;

            $this->collUserGroups = null;

            $this->collAlertSubscriptions = null;
            $this->collGroups = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(UserPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = UserQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && UserQuery::isSoftDeleteEnabled()) {
                $this->keepUpdateDateUnchanged();
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                UserPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(UserPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(UserPeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(UserPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(UserPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                UserPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aLevel !== null) {
                if ($this->aLevel->isModified() || $this->aLevel->isNew()) {
                    $affectedRows += $this->aLevel->save($con);
                }
                $this->setLevel($this->aLevel);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->alertSubscriptionsScheduledForDeletion !== null) {
                if (!$this->alertSubscriptionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->alertSubscriptionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    AlertSubscriptionUserQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->alertSubscriptionsScheduledForDeletion = null;
                }

                foreach ($this->getAlertSubscriptions() as $alertSubscription) {
                    if ($alertSubscription->isModified()) {
                        $alertSubscription->save($con);
                    }
                }
            }

            if ($this->groupsScheduledForDeletion !== null) {
                if (!$this->groupsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->groupsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    UserGroupQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->groupsScheduledForDeletion = null;
                }

                foreach ($this->getGroups() as $group) {
                    if ($group->isModified()) {
                        $group->save($con);
                    }
                }
            }

            if ($this->actionLogsScheduledForDeletion !== null) {
                if (!$this->actionLogsScheduledForDeletion->isEmpty()) {
                    ActionLogQuery::create()
                        ->filterByPrimaryKeys($this->actionLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actionLogsScheduledForDeletion = null;
                }
            }

            if ($this->collActionLogs !== null) {
                foreach ($this->collActionLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->alertSubscriptionUsersScheduledForDeletion !== null) {
                if (!$this->alertSubscriptionUsersScheduledForDeletion->isEmpty()) {
                    AlertSubscriptionUserQuery::create()
                        ->filterByPrimaryKeys($this->alertSubscriptionUsersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->alertSubscriptionUsersScheduledForDeletion = null;
                }
            }

            if ($this->collAlertSubscriptionUsers !== null) {
                foreach ($this->collAlertSubscriptionUsers as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->inspectorsScheduledForDeletion !== null) {
                if (!$this->inspectorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->inspectorsScheduledForDeletion as $inspector) {
                        // need to save related object because we set the relation to null
                        $inspector->save($con);
                    }
                    $this->inspectorsScheduledForDeletion = null;
                }
            }

            if ($this->collInspectors !== null) {
                foreach ($this->collInspectors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->policyGuidelinesScheduledForDeletion !== null) {
                if (!$this->policyGuidelinesScheduledForDeletion->isEmpty()) {
                    foreach ($this->policyGuidelinesScheduledForDeletion as $policyGuideline) {
                        // need to save related object because we set the relation to null
                        $policyGuideline->save($con);
                    }
                    $this->policyGuidelinesScheduledForDeletion = null;
                }
            }

            if ($this->collPolicyGuidelines !== null) {
                foreach ($this->collPolicyGuidelines as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->strategicObjectivesScheduledForDeletion !== null) {
                if (!$this->strategicObjectivesScheduledForDeletion->isEmpty()) {
                    foreach ($this->strategicObjectivesScheduledForDeletion as $strategicObjective) {
                        // need to save related object because we set the relation to null
                        $strategicObjective->save($con);
                    }
                    $this->strategicObjectivesScheduledForDeletion = null;
                }
            }

            if ($this->collStrategicObjectives !== null) {
                foreach ($this->collStrategicObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectivesScheduledForDeletion !== null) {
                if (!$this->objectivesScheduledForDeletion->isEmpty()) {
                    foreach ($this->objectivesScheduledForDeletion as $objective) {
                        // need to save related object because we set the relation to null
                        $objective->save($con);
                    }
                    $this->objectivesScheduledForDeletion = null;
                }
            }

            if ($this->collObjectives !== null) {
                foreach ($this->collObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->policyGuidelineLogsScheduledForDeletion !== null) {
                if (!$this->policyGuidelineLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->policyGuidelineLogsScheduledForDeletion as $policyGuidelineLog) {
                        // need to save related object because we set the relation to null
                        $policyGuidelineLog->save($con);
                    }
                    $this->policyGuidelineLogsScheduledForDeletion = null;
                }
            }

            if ($this->collPolicyGuidelineLogs !== null) {
                foreach ($this->collPolicyGuidelineLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->strategicObjectiveLogsScheduledForDeletion !== null) {
                if (!$this->strategicObjectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLog) {
                        // need to save related object because we set the relation to null
                        $strategicObjectiveLog->save($con);
                    }
                    $this->strategicObjectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collStrategicObjectiveLogs !== null) {
                foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveLogsScheduledForDeletion !== null) {
                if (!$this->objectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLog) {
                        // need to save related object because we set the relation to null
                        $objectiveLog->save($con);
                    }
                    $this->objectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveLogs !== null) {
                foreach ($this->collObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectsScheduledForDeletion as $project) {
                        // need to save related object because we set the relation to null
                        $project->save($con);
                    }
                    $this->projectsScheduledForDeletion = null;
                }
            }

            if ($this->collProjects !== null) {
                foreach ($this->collProjects as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivitysScheduledForDeletion !== null) {
                if (!$this->projectActivitysScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectActivitysScheduledForDeletion as $projectActivity) {
                        // need to save related object because we set the relation to null
                        $projectActivity->save($con);
                    }
                    $this->projectActivitysScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivitys !== null) {
                foreach ($this->collProjectActivitys as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectLogsScheduledForDeletion !== null) {
                if (!$this->projectLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectLogsScheduledForDeletion as $projectLog) {
                        // need to save related object because we set the relation to null
                        $projectLog->save($con);
                    }
                    $this->projectLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectLogs !== null) {
                foreach ($this->collProjectLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectMilestoneLogsScheduledForDeletion !== null) {
                if (!$this->projectMilestoneLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectMilestoneLogsScheduledForDeletion as $projectMilestoneLog) {
                        // need to save related object because we set the relation to null
                        $projectMilestoneLog->save($con);
                    }
                    $this->projectMilestoneLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectMilestoneLogs !== null) {
                foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivityLogsScheduledForDeletion !== null) {
                if (!$this->projectActivityLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectActivityLogsScheduledForDeletion as $projectActivityLog) {
                        // need to save related object because we set the relation to null
                        $projectActivityLog->save($con);
                    }
                    $this->projectActivityLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivityLogs !== null) {
                foreach ($this->collProjectActivityLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->userGroupsScheduledForDeletion !== null) {
                if (!$this->userGroupsScheduledForDeletion->isEmpty()) {
                    UserGroupQuery::create()
                        ->filterByPrimaryKeys($this->userGroupsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->userGroupsScheduledForDeletion = null;
                }
            }

            if ($this->collUserGroups !== null) {
                foreach ($this->collUserGroups as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = UserPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . UserPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(UserPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(UserPeer::USERNAME)) {
            $modifiedColumns[':p' . $index++]  = '`USERNAME`';
        }
        if ($this->isColumnModified(UserPeer::PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = '`PASSWORD`';
        }
        if ($this->isColumnModified(UserPeer::PASSWORDUPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`PASSWORDUPDATED`';
        }
        if ($this->isColumnModified(UserPeer::ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`ACTIVE`';
        }
        if ($this->isColumnModified(UserPeer::CREATED)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED`';
        }
        if ($this->isColumnModified(UserPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(UserPeer::LEVELID)) {
            $modifiedColumns[':p' . $index++]  = '`LEVELID`';
        }
        if ($this->isColumnModified(UserPeer::LASTLOGIN)) {
            $modifiedColumns[':p' . $index++]  = '`LASTLOGIN`';
        }
        if ($this->isColumnModified(UserPeer::TIMEZONE)) {
            $modifiedColumns[':p' . $index++]  = '`TIMEZONE`';
        }
        if ($this->isColumnModified(UserPeer::RECOVERYHASH)) {
            $modifiedColumns[':p' . $index++]  = '`RECOVERYHASH`';
        }
        if ($this->isColumnModified(UserPeer::RECOVERYHASHCREATEDON)) {
            $modifiedColumns[':p' . $index++]  = '`RECOVERYHASHCREATEDON`';
        }
        if ($this->isColumnModified(UserPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(UserPeer::SURNAME)) {
            $modifiedColumns[':p' . $index++]  = '`SURNAME`';
        }
        if ($this->isColumnModified(UserPeer::DOCUMENTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`DOCUMENTTYPE`';
        }
        if ($this->isColumnModified(UserPeer::DOCUMENT)) {
            $modifiedColumns[':p' . $index++]  = '`DOCUMENT`';
        }
        if ($this->isColumnModified(UserPeer::GENDER)) {
            $modifiedColumns[':p' . $index++]  = '`GENDER`';
        }
        if ($this->isColumnModified(UserPeer::BIRTHDATE)) {
            $modifiedColumns[':p' . $index++]  = '`BIRTHDATE`';
        }
        if ($this->isColumnModified(UserPeer::MAILADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`MAILADDRESS`';
        }
        if ($this->isColumnModified(UserPeer::MAILADDRESSALT)) {
            $modifiedColumns[':p' . $index++]  = '`MAILADDRESSALT`';
        }
        if ($this->isColumnModified(UserPeer::SESSION)) {
            $modifiedColumns[':p' . $index++]  = '`SESSION`';
        }
        if ($this->isColumnModified(UserPeer::BLOCKEDAT)) {
            $modifiedColumns[':p' . $index++]  = '`BLOCKEDAT`';
        }
        if ($this->isColumnModified(UserPeer::LASTACTION)) {
            $modifiedColumns[':p' . $index++]  = '`LASTACTION`';
        }
        if ($this->isColumnModified(UserPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }
        if ($this->isColumnModified(UserPeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(UserPeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `users_user` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`USERNAME`':
                        $stmt->bindValue($identifier, $this->username, PDO::PARAM_STR);
                        break;
                    case '`PASSWORD`':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case '`PASSWORDUPDATED`':
                        $stmt->bindValue($identifier, $this->passwordupdated, PDO::PARAM_STR);
                        break;
                    case '`ACTIVE`':
                        $stmt->bindValue($identifier, (int) $this->active, PDO::PARAM_INT);
                        break;
                    case '`CREATED`':
                        $stmt->bindValue($identifier, $this->created, PDO::PARAM_STR);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`LEVELID`':
                        $stmt->bindValue($identifier, $this->levelid, PDO::PARAM_INT);
                        break;
                    case '`LASTLOGIN`':
                        $stmt->bindValue($identifier, $this->lastlogin, PDO::PARAM_STR);
                        break;
                    case '`TIMEZONE`':
                        $stmt->bindValue($identifier, $this->timezone, PDO::PARAM_STR);
                        break;
                    case '`RECOVERYHASH`':
                        $stmt->bindValue($identifier, $this->recoveryhash, PDO::PARAM_STR);
                        break;
                    case '`RECOVERYHASHCREATEDON`':
                        $stmt->bindValue($identifier, $this->recoveryhashcreatedon, PDO::PARAM_STR);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`SURNAME`':
                        $stmt->bindValue($identifier, $this->surname, PDO::PARAM_STR);
                        break;
                    case '`DOCUMENTTYPE`':
                        $stmt->bindValue($identifier, $this->documenttype, PDO::PARAM_INT);
                        break;
                    case '`DOCUMENT`':
                        $stmt->bindValue($identifier, $this->document, PDO::PARAM_STR);
                        break;
                    case '`GENDER`':
                        $stmt->bindValue($identifier, $this->gender, PDO::PARAM_INT);
                        break;
                    case '`BIRTHDATE`':
                        $stmt->bindValue($identifier, $this->birthdate, PDO::PARAM_STR);
                        break;
                    case '`MAILADDRESS`':
                        $stmt->bindValue($identifier, $this->mailaddress, PDO::PARAM_STR);
                        break;
                    case '`MAILADDRESSALT`':
                        $stmt->bindValue($identifier, $this->mailaddressalt, PDO::PARAM_STR);
                        break;
                    case '`SESSION`':
                        $stmt->bindValue($identifier, $this->session, PDO::PARAM_STR);
                        break;
                    case '`BLOCKEDAT`':
                        $stmt->bindValue($identifier, $this->blockedat, PDO::PARAM_STR);
                        break;
                    case '`LASTACTION`':
                        $stmt->bindValue($identifier, $this->lastaction, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aLevel !== null) {
                if (!$this->aLevel->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aLevel->getValidationFailures());
                }
            }


            if (($retval = UserPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collActionLogs !== null) {
                    foreach ($this->collActionLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collAlertSubscriptionUsers !== null) {
                    foreach ($this->collAlertSubscriptionUsers as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collInspectors !== null) {
                    foreach ($this->collInspectors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPolicyGuidelines !== null) {
                    foreach ($this->collPolicyGuidelines as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collStrategicObjectives !== null) {
                    foreach ($this->collStrategicObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectives !== null) {
                    foreach ($this->collObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPolicyGuidelineLogs !== null) {
                    foreach ($this->collPolicyGuidelineLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collStrategicObjectiveLogs !== null) {
                    foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveLogs !== null) {
                    foreach ($this->collObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjects !== null) {
                    foreach ($this->collProjects as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivitys !== null) {
                    foreach ($this->collProjectActivitys as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectLogs !== null) {
                    foreach ($this->collProjectLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectMilestoneLogs !== null) {
                    foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivityLogs !== null) {
                    foreach ($this->collProjectActivityLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collUserGroups !== null) {
                    foreach ($this->collUserGroups as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = UserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getUsername();
                break;
            case 2:
                return $this->getPassword();
                break;
            case 3:
                return $this->getPasswordupdated();
                break;
            case 4:
                return $this->getActive();
                break;
            case 5:
                return $this->getCreated();
                break;
            case 6:
                return $this->getUpdated();
                break;
            case 7:
                return $this->getLevelid();
                break;
            case 8:
                return $this->getLastlogin();
                break;
            case 9:
                return $this->getTimezone();
                break;
            case 10:
                return $this->getRecoveryhash();
                break;
            case 11:
                return $this->getRecoveryhashcreatedon();
                break;
            case 12:
                return $this->getName();
                break;
            case 13:
                return $this->getSurname();
                break;
            case 14:
                return $this->getDocumenttype();
                break;
            case 15:
                return $this->getDocument();
                break;
            case 16:
                return $this->getGender();
                break;
            case 17:
                return $this->getBirthdate();
                break;
            case 18:
                return $this->getMailaddress();
                break;
            case 19:
                return $this->getMailaddressalt();
                break;
            case 20:
                return $this->getSession();
                break;
            case 21:
                return $this->getBlockedat();
                break;
            case 22:
                return $this->getLastaction();
                break;
            case 23:
                return $this->getDeletedAt();
                break;
            case 24:
                return $this->getCreatedAt();
                break;
            case 25:
                return $this->getUpdatedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['User'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['User'][$this->getPrimaryKey()] = true;
        $keys = UserPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getUsername(),
            $keys[2] => $this->getPassword(),
            $keys[3] => $this->getPasswordupdated(),
            $keys[4] => $this->getActive(),
            $keys[5] => $this->getCreated(),
            $keys[6] => $this->getUpdated(),
            $keys[7] => $this->getLevelid(),
            $keys[8] => $this->getLastlogin(),
            $keys[9] => $this->getTimezone(),
            $keys[10] => $this->getRecoveryhash(),
            $keys[11] => $this->getRecoveryhashcreatedon(),
            $keys[12] => $this->getName(),
            $keys[13] => $this->getSurname(),
            $keys[14] => $this->getDocumenttype(),
            $keys[15] => $this->getDocument(),
            $keys[16] => $this->getGender(),
            $keys[17] => $this->getBirthdate(),
            $keys[18] => $this->getMailaddress(),
            $keys[19] => $this->getMailaddressalt(),
            $keys[20] => $this->getSession(),
            $keys[21] => $this->getBlockedat(),
            $keys[22] => $this->getLastaction(),
            $keys[23] => $this->getDeletedAt(),
            $keys[24] => $this->getCreatedAt(),
            $keys[25] => $this->getUpdatedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aLevel) {
                $result['Level'] = $this->aLevel->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collActionLogs) {
                $result['ActionLogs'] = $this->collActionLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collAlertSubscriptionUsers) {
                $result['AlertSubscriptionUsers'] = $this->collAlertSubscriptionUsers->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collInspectors) {
                $result['Inspectors'] = $this->collInspectors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPolicyGuidelines) {
                $result['PolicyGuidelines'] = $this->collPolicyGuidelines->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStrategicObjectives) {
                $result['StrategicObjectives'] = $this->collStrategicObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectives) {
                $result['Objectives'] = $this->collObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPolicyGuidelineLogs) {
                $result['PolicyGuidelineLogs'] = $this->collPolicyGuidelineLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStrategicObjectiveLogs) {
                $result['StrategicObjectiveLogs'] = $this->collStrategicObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveLogs) {
                $result['ObjectiveLogs'] = $this->collObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjects) {
                $result['Projects'] = $this->collProjects->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivitys) {
                $result['ProjectActivitys'] = $this->collProjectActivitys->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectLogs) {
                $result['ProjectLogs'] = $this->collProjectLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectMilestoneLogs) {
                $result['ProjectMilestoneLogs'] = $this->collProjectMilestoneLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivityLogs) {
                $result['ProjectActivityLogs'] = $this->collProjectActivityLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collUserGroups) {
                $result['UserGroups'] = $this->collUserGroups->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = UserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setUsername($value);
                break;
            case 2:
                $this->setPassword($value);
                break;
            case 3:
                $this->setPasswordupdated($value);
                break;
            case 4:
                $this->setActive($value);
                break;
            case 5:
                $this->setCreated($value);
                break;
            case 6:
                $this->setUpdated($value);
                break;
            case 7:
                $this->setLevelid($value);
                break;
            case 8:
                $this->setLastlogin($value);
                break;
            case 9:
                $this->setTimezone($value);
                break;
            case 10:
                $this->setRecoveryhash($value);
                break;
            case 11:
                $this->setRecoveryhashcreatedon($value);
                break;
            case 12:
                $this->setName($value);
                break;
            case 13:
                $this->setSurname($value);
                break;
            case 14:
                $this->setDocumenttype($value);
                break;
            case 15:
                $this->setDocument($value);
                break;
            case 16:
                $this->setGender($value);
                break;
            case 17:
                $this->setBirthdate($value);
                break;
            case 18:
                $this->setMailaddress($value);
                break;
            case 19:
                $this->setMailaddressalt($value);
                break;
            case 20:
                $this->setSession($value);
                break;
            case 21:
                $this->setBlockedat($value);
                break;
            case 22:
                $this->setLastaction($value);
                break;
            case 23:
                $this->setDeletedAt($value);
                break;
            case 24:
                $this->setCreatedAt($value);
                break;
            case 25:
                $this->setUpdatedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = UserPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setUsername($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setPassword($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setPasswordupdated($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setActive($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setCreated($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setUpdated($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setLevelid($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setLastlogin($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setTimezone($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setRecoveryhash($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setRecoveryhashcreatedon($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setName($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setSurname($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setDocumenttype($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setDocument($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setGender($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setBirthdate($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setMailaddress($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setMailaddressalt($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setSession($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setBlockedat($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setLastaction($arr[$keys[22]]);
        if (array_key_exists($keys[23], $arr)) $this->setDeletedAt($arr[$keys[23]]);
        if (array_key_exists($keys[24], $arr)) $this->setCreatedAt($arr[$keys[24]]);
        if (array_key_exists($keys[25], $arr)) $this->setUpdatedAt($arr[$keys[25]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(UserPeer::DATABASE_NAME);

        if ($this->isColumnModified(UserPeer::ID)) $criteria->add(UserPeer::ID, $this->id);
        if ($this->isColumnModified(UserPeer::USERNAME)) $criteria->add(UserPeer::USERNAME, $this->username);
        if ($this->isColumnModified(UserPeer::PASSWORD)) $criteria->add(UserPeer::PASSWORD, $this->password);
        if ($this->isColumnModified(UserPeer::PASSWORDUPDATED)) $criteria->add(UserPeer::PASSWORDUPDATED, $this->passwordupdated);
        if ($this->isColumnModified(UserPeer::ACTIVE)) $criteria->add(UserPeer::ACTIVE, $this->active);
        if ($this->isColumnModified(UserPeer::CREATED)) $criteria->add(UserPeer::CREATED, $this->created);
        if ($this->isColumnModified(UserPeer::UPDATED)) $criteria->add(UserPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(UserPeer::LEVELID)) $criteria->add(UserPeer::LEVELID, $this->levelid);
        if ($this->isColumnModified(UserPeer::LASTLOGIN)) $criteria->add(UserPeer::LASTLOGIN, $this->lastlogin);
        if ($this->isColumnModified(UserPeer::TIMEZONE)) $criteria->add(UserPeer::TIMEZONE, $this->timezone);
        if ($this->isColumnModified(UserPeer::RECOVERYHASH)) $criteria->add(UserPeer::RECOVERYHASH, $this->recoveryhash);
        if ($this->isColumnModified(UserPeer::RECOVERYHASHCREATEDON)) $criteria->add(UserPeer::RECOVERYHASHCREATEDON, $this->recoveryhashcreatedon);
        if ($this->isColumnModified(UserPeer::NAME)) $criteria->add(UserPeer::NAME, $this->name);
        if ($this->isColumnModified(UserPeer::SURNAME)) $criteria->add(UserPeer::SURNAME, $this->surname);
        if ($this->isColumnModified(UserPeer::DOCUMENTTYPE)) $criteria->add(UserPeer::DOCUMENTTYPE, $this->documenttype);
        if ($this->isColumnModified(UserPeer::DOCUMENT)) $criteria->add(UserPeer::DOCUMENT, $this->document);
        if ($this->isColumnModified(UserPeer::GENDER)) $criteria->add(UserPeer::GENDER, $this->gender);
        if ($this->isColumnModified(UserPeer::BIRTHDATE)) $criteria->add(UserPeer::BIRTHDATE, $this->birthdate);
        if ($this->isColumnModified(UserPeer::MAILADDRESS)) $criteria->add(UserPeer::MAILADDRESS, $this->mailaddress);
        if ($this->isColumnModified(UserPeer::MAILADDRESSALT)) $criteria->add(UserPeer::MAILADDRESSALT, $this->mailaddressalt);
        if ($this->isColumnModified(UserPeer::SESSION)) $criteria->add(UserPeer::SESSION, $this->session);
        if ($this->isColumnModified(UserPeer::BLOCKEDAT)) $criteria->add(UserPeer::BLOCKEDAT, $this->blockedat);
        if ($this->isColumnModified(UserPeer::LASTACTION)) $criteria->add(UserPeer::LASTACTION, $this->lastaction);
        if ($this->isColumnModified(UserPeer::DELETED_AT)) $criteria->add(UserPeer::DELETED_AT, $this->deleted_at);
        if ($this->isColumnModified(UserPeer::CREATED_AT)) $criteria->add(UserPeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(UserPeer::UPDATED_AT)) $criteria->add(UserPeer::UPDATED_AT, $this->updated_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(UserPeer::DATABASE_NAME);
        $criteria->add(UserPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of User (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setUsername($this->getUsername());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setPasswordupdated($this->getPasswordupdated());
        $copyObj->setActive($this->getActive());
        $copyObj->setCreated($this->getCreated());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setLevelid($this->getLevelid());
        $copyObj->setLastlogin($this->getLastlogin());
        $copyObj->setTimezone($this->getTimezone());
        $copyObj->setRecoveryhash($this->getRecoveryhash());
        $copyObj->setRecoveryhashcreatedon($this->getRecoveryhashcreatedon());
        $copyObj->setName($this->getName());
        $copyObj->setSurname($this->getSurname());
        $copyObj->setDocumenttype($this->getDocumenttype());
        $copyObj->setDocument($this->getDocument());
        $copyObj->setGender($this->getGender());
        $copyObj->setBirthdate($this->getBirthdate());
        $copyObj->setMailaddress($this->getMailaddress());
        $copyObj->setMailaddressalt($this->getMailaddressalt());
        $copyObj->setSession($this->getSession());
        $copyObj->setBlockedat($this->getBlockedat());
        $copyObj->setLastaction($this->getLastaction());
        $copyObj->setDeletedAt($this->getDeletedAt());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getActionLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActionLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getAlertSubscriptionUsers() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAlertSubscriptionUser($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getInspectors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addInspector($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPolicyGuidelines() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPolicyGuideline($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStrategicObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStrategicObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPolicyGuidelineLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPolicyGuidelineLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStrategicObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStrategicObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjects() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProject($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivitys() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivity($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectMilestoneLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectMilestoneLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivityLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivityLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getUserGroups() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addUserGroup($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return User Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return UserPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new UserPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Level object.
     *
     * @param             Level $v
     * @return User The current object (for fluent API support)
     * @throws PropelException
     */
    public function setLevel(Level $v = null)
    {
        if ($v === null) {
            $this->setLevelid(NULL);
        } else {
            $this->setLevelid($v->getId());
        }

        $this->aLevel = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Level object, it will not be re-added.
        if ($v !== null) {
            $v->addUser($this);
        }


        return $this;
    }


    /**
     * Get the associated Level object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Level The associated Level object.
     * @throws PropelException
     */
    public function getLevel(PropelPDO $con = null)
    {
        if ($this->aLevel === null && ($this->levelid !== null)) {
            $this->aLevel = LevelQuery::create()->findPk($this->levelid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aLevel->addUsers($this);
             */
        }

        return $this->aLevel;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ActionLog' == $relationName) {
            $this->initActionLogs();
        }
        if ('AlertSubscriptionUser' == $relationName) {
            $this->initAlertSubscriptionUsers();
        }
        if ('Inspector' == $relationName) {
            $this->initInspectors();
        }
        if ('PolicyGuideline' == $relationName) {
            $this->initPolicyGuidelines();
        }
        if ('StrategicObjective' == $relationName) {
            $this->initStrategicObjectives();
        }
        if ('Objective' == $relationName) {
            $this->initObjectives();
        }
        if ('PolicyGuidelineLog' == $relationName) {
            $this->initPolicyGuidelineLogs();
        }
        if ('StrategicObjectiveLog' == $relationName) {
            $this->initStrategicObjectiveLogs();
        }
        if ('ObjectiveLog' == $relationName) {
            $this->initObjectiveLogs();
        }
        if ('Project' == $relationName) {
            $this->initProjects();
        }
        if ('ProjectActivity' == $relationName) {
            $this->initProjectActivitys();
        }
        if ('ProjectLog' == $relationName) {
            $this->initProjectLogs();
        }
        if ('ProjectMilestoneLog' == $relationName) {
            $this->initProjectMilestoneLogs();
        }
        if ('ProjectActivityLog' == $relationName) {
            $this->initProjectActivityLogs();
        }
        if ('UserGroup' == $relationName) {
            $this->initUserGroups();
        }
    }

    /**
     * Clears out the collActionLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActionLogs()
     */
    public function clearActionLogs()
    {
        $this->collActionLogs = null; // important to set this to null since that means it is uninitialized
        $this->collActionLogsPartial = null;
    }

    /**
     * reset is the collActionLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialActionLogs($v = true)
    {
        $this->collActionLogsPartial = $v;
    }

    /**
     * Initializes the collActionLogs collection.
     *
     * By default this just sets the collActionLogs collection to an empty array (like clearcollActionLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActionLogs($overrideExisting = true)
    {
        if (null !== $this->collActionLogs && !$overrideExisting) {
            return;
        }
        $this->collActionLogs = new PropelObjectCollection();
        $this->collActionLogs->setModel('ActionLog');
    }

    /**
     * Gets an array of ActionLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActionLog[] List of ActionLog objects
     * @throws PropelException
     */
    public function getActionLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActionLogsPartial && !$this->isNew();
        if (null === $this->collActionLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActionLogs) {
                // return empty collection
                $this->initActionLogs();
            } else {
                $collActionLogs = ActionLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActionLogsPartial && count($collActionLogs)) {
                      $this->initActionLogs(false);

                      foreach($collActionLogs as $obj) {
                        if (false == $this->collActionLogs->contains($obj)) {
                          $this->collActionLogs->append($obj);
                        }
                      }

                      $this->collActionLogsPartial = true;
                    }

                    return $collActionLogs;
                }

                if($partial && $this->collActionLogs) {
                    foreach($this->collActionLogs as $obj) {
                        if($obj->isNew()) {
                            $collActionLogs[] = $obj;
                        }
                    }
                }

                $this->collActionLogs = $collActionLogs;
                $this->collActionLogsPartial = false;
            }
        }

        return $this->collActionLogs;
    }

    /**
     * Sets a collection of ActionLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actionLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActionLogs(PropelCollection $actionLogs, PropelPDO $con = null)
    {
        $this->actionLogsScheduledForDeletion = $this->getActionLogs(new Criteria(), $con)->diff($actionLogs);

        foreach ($this->actionLogsScheduledForDeletion as $actionLogRemoved) {
            $actionLogRemoved->setUser(null);
        }

        $this->collActionLogs = null;
        foreach ($actionLogs as $actionLog) {
            $this->addActionLog($actionLog);
        }

        $this->collActionLogs = $actionLogs;
        $this->collActionLogsPartial = false;
    }

    /**
     * Returns the number of related ActionLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActionLog objects.
     * @throws PropelException
     */
    public function countActionLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActionLogsPartial && !$this->isNew();
        if (null === $this->collActionLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActionLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActionLogs());
                }
                $query = ActionLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collActionLogs);
        }
    }

    /**
     * Method called to associate a ActionLog object to this object
     * through the ActionLog foreign key attribute.
     *
     * @param    ActionLog $l ActionLog
     * @return User The current object (for fluent API support)
     */
    public function addActionLog(ActionLog $l)
    {
        if ($this->collActionLogs === null) {
            $this->initActionLogs();
            $this->collActionLogsPartial = true;
        }
        if (!$this->collActionLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActionLog($l);
        }

        return $this;
    }

    /**
     * @param	ActionLog $actionLog The actionLog object to add.
     */
    protected function doAddActionLog($actionLog)
    {
        $this->collActionLogs[]= $actionLog;
        $actionLog->setUser($this);
    }

    /**
     * @param	ActionLog $actionLog The actionLog object to remove.
     */
    public function removeActionLog($actionLog)
    {
        if ($this->getActionLogs()->contains($actionLog)) {
            $this->collActionLogs->remove($this->collActionLogs->search($actionLog));
            if (null === $this->actionLogsScheduledForDeletion) {
                $this->actionLogsScheduledForDeletion = clone $this->collActionLogs;
                $this->actionLogsScheduledForDeletion->clear();
            }
            $this->actionLogsScheduledForDeletion[]= $actionLog;
            $actionLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ActionLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActionLog[] List of ActionLog objects
     */
    public function getActionLogsJoinSecurityAction($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActionLogQuery::create(null, $criteria);
        $query->joinWith('SecurityAction', $join_behavior);

        return $this->getActionLogs($query, $con);
    }

    /**
     * Clears out the collAlertSubscriptionUsers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAlertSubscriptionUsers()
     */
    public function clearAlertSubscriptionUsers()
    {
        $this->collAlertSubscriptionUsers = null; // important to set this to null since that means it is uninitialized
        $this->collAlertSubscriptionUsersPartial = null;
    }

    /**
     * reset is the collAlertSubscriptionUsers collection loaded partially
     *
     * @return void
     */
    public function resetPartialAlertSubscriptionUsers($v = true)
    {
        $this->collAlertSubscriptionUsersPartial = $v;
    }

    /**
     * Initializes the collAlertSubscriptionUsers collection.
     *
     * By default this just sets the collAlertSubscriptionUsers collection to an empty array (like clearcollAlertSubscriptionUsers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAlertSubscriptionUsers($overrideExisting = true)
    {
        if (null !== $this->collAlertSubscriptionUsers && !$overrideExisting) {
            return;
        }
        $this->collAlertSubscriptionUsers = new PropelObjectCollection();
        $this->collAlertSubscriptionUsers->setModel('AlertSubscriptionUser');
    }

    /**
     * Gets an array of AlertSubscriptionUser objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AlertSubscriptionUser[] List of AlertSubscriptionUser objects
     * @throws PropelException
     */
    public function getAlertSubscriptionUsers($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAlertSubscriptionUsersPartial && !$this->isNew();
        if (null === $this->collAlertSubscriptionUsers || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAlertSubscriptionUsers) {
                // return empty collection
                $this->initAlertSubscriptionUsers();
            } else {
                $collAlertSubscriptionUsers = AlertSubscriptionUserQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAlertSubscriptionUsersPartial && count($collAlertSubscriptionUsers)) {
                      $this->initAlertSubscriptionUsers(false);

                      foreach($collAlertSubscriptionUsers as $obj) {
                        if (false == $this->collAlertSubscriptionUsers->contains($obj)) {
                          $this->collAlertSubscriptionUsers->append($obj);
                        }
                      }

                      $this->collAlertSubscriptionUsersPartial = true;
                    }

                    return $collAlertSubscriptionUsers;
                }

                if($partial && $this->collAlertSubscriptionUsers) {
                    foreach($this->collAlertSubscriptionUsers as $obj) {
                        if($obj->isNew()) {
                            $collAlertSubscriptionUsers[] = $obj;
                        }
                    }
                }

                $this->collAlertSubscriptionUsers = $collAlertSubscriptionUsers;
                $this->collAlertSubscriptionUsersPartial = false;
            }
        }

        return $this->collAlertSubscriptionUsers;
    }

    /**
     * Sets a collection of AlertSubscriptionUser objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $alertSubscriptionUsers A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAlertSubscriptionUsers(PropelCollection $alertSubscriptionUsers, PropelPDO $con = null)
    {
        $this->alertSubscriptionUsersScheduledForDeletion = $this->getAlertSubscriptionUsers(new Criteria(), $con)->diff($alertSubscriptionUsers);

        foreach ($this->alertSubscriptionUsersScheduledForDeletion as $alertSubscriptionUserRemoved) {
            $alertSubscriptionUserRemoved->setUser(null);
        }

        $this->collAlertSubscriptionUsers = null;
        foreach ($alertSubscriptionUsers as $alertSubscriptionUser) {
            $this->addAlertSubscriptionUser($alertSubscriptionUser);
        }

        $this->collAlertSubscriptionUsers = $alertSubscriptionUsers;
        $this->collAlertSubscriptionUsersPartial = false;
    }

    /**
     * Returns the number of related AlertSubscriptionUser objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AlertSubscriptionUser objects.
     * @throws PropelException
     */
    public function countAlertSubscriptionUsers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAlertSubscriptionUsersPartial && !$this->isNew();
        if (null === $this->collAlertSubscriptionUsers || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAlertSubscriptionUsers) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAlertSubscriptionUsers());
                }
                $query = AlertSubscriptionUserQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collAlertSubscriptionUsers);
        }
    }

    /**
     * Method called to associate a AlertSubscriptionUser object to this object
     * through the AlertSubscriptionUser foreign key attribute.
     *
     * @param    AlertSubscriptionUser $l AlertSubscriptionUser
     * @return User The current object (for fluent API support)
     */
    public function addAlertSubscriptionUser(AlertSubscriptionUser $l)
    {
        if ($this->collAlertSubscriptionUsers === null) {
            $this->initAlertSubscriptionUsers();
            $this->collAlertSubscriptionUsersPartial = true;
        }
        if (!$this->collAlertSubscriptionUsers->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAlertSubscriptionUser($l);
        }

        return $this;
    }

    /**
     * @param	AlertSubscriptionUser $alertSubscriptionUser The alertSubscriptionUser object to add.
     */
    protected function doAddAlertSubscriptionUser($alertSubscriptionUser)
    {
        $this->collAlertSubscriptionUsers[]= $alertSubscriptionUser;
        $alertSubscriptionUser->setUser($this);
    }

    /**
     * @param	AlertSubscriptionUser $alertSubscriptionUser The alertSubscriptionUser object to remove.
     */
    public function removeAlertSubscriptionUser($alertSubscriptionUser)
    {
        if ($this->getAlertSubscriptionUsers()->contains($alertSubscriptionUser)) {
            $this->collAlertSubscriptionUsers->remove($this->collAlertSubscriptionUsers->search($alertSubscriptionUser));
            if (null === $this->alertSubscriptionUsersScheduledForDeletion) {
                $this->alertSubscriptionUsersScheduledForDeletion = clone $this->collAlertSubscriptionUsers;
                $this->alertSubscriptionUsersScheduledForDeletion->clear();
            }
            $this->alertSubscriptionUsersScheduledForDeletion[]= $alertSubscriptionUser;
            $alertSubscriptionUser->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related AlertSubscriptionUsers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|AlertSubscriptionUser[] List of AlertSubscriptionUser objects
     */
    public function getAlertSubscriptionUsersJoinAlertSubscription($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = AlertSubscriptionUserQuery::create(null, $criteria);
        $query->joinWith('AlertSubscription', $join_behavior);

        return $this->getAlertSubscriptionUsers($query, $con);
    }

    /**
     * Clears out the collInspectors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addInspectors()
     */
    public function clearInspectors()
    {
        $this->collInspectors = null; // important to set this to null since that means it is uninitialized
        $this->collInspectorsPartial = null;
    }

    /**
     * reset is the collInspectors collection loaded partially
     *
     * @return void
     */
    public function resetPartialInspectors($v = true)
    {
        $this->collInspectorsPartial = $v;
    }

    /**
     * Initializes the collInspectors collection.
     *
     * By default this just sets the collInspectors collection to an empty array (like clearcollInspectors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initInspectors($overrideExisting = true)
    {
        if (null !== $this->collInspectors && !$overrideExisting) {
            return;
        }
        $this->collInspectors = new PropelObjectCollection();
        $this->collInspectors->setModel('Inspector');
    }

    /**
     * Gets an array of Inspector objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Inspector[] List of Inspector objects
     * @throws PropelException
     */
    public function getInspectors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collInspectorsPartial && !$this->isNew();
        if (null === $this->collInspectors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collInspectors) {
                // return empty collection
                $this->initInspectors();
            } else {
                $collInspectors = InspectorQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collInspectorsPartial && count($collInspectors)) {
                      $this->initInspectors(false);

                      foreach($collInspectors as $obj) {
                        if (false == $this->collInspectors->contains($obj)) {
                          $this->collInspectors->append($obj);
                        }
                      }

                      $this->collInspectorsPartial = true;
                    }

                    return $collInspectors;
                }

                if($partial && $this->collInspectors) {
                    foreach($this->collInspectors as $obj) {
                        if($obj->isNew()) {
                            $collInspectors[] = $obj;
                        }
                    }
                }

                $this->collInspectors = $collInspectors;
                $this->collInspectorsPartial = false;
            }
        }

        return $this->collInspectors;
    }

    /**
     * Sets a collection of Inspector objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $inspectors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setInspectors(PropelCollection $inspectors, PropelPDO $con = null)
    {
        $this->inspectorsScheduledForDeletion = $this->getInspectors(new Criteria(), $con)->diff($inspectors);

        foreach ($this->inspectorsScheduledForDeletion as $inspectorRemoved) {
            $inspectorRemoved->setUser(null);
        }

        $this->collInspectors = null;
        foreach ($inspectors as $inspector) {
            $this->addInspector($inspector);
        }

        $this->collInspectors = $inspectors;
        $this->collInspectorsPartial = false;
    }

    /**
     * Returns the number of related Inspector objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Inspector objects.
     * @throws PropelException
     */
    public function countInspectors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collInspectorsPartial && !$this->isNew();
        if (null === $this->collInspectors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collInspectors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getInspectors());
                }
                $query = InspectorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collInspectors);
        }
    }

    /**
     * Method called to associate a Inspector object to this object
     * through the Inspector foreign key attribute.
     *
     * @param    Inspector $l Inspector
     * @return User The current object (for fluent API support)
     */
    public function addInspector(Inspector $l)
    {
        if ($this->collInspectors === null) {
            $this->initInspectors();
            $this->collInspectorsPartial = true;
        }
        if (!$this->collInspectors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddInspector($l);
        }

        return $this;
    }

    /**
     * @param	Inspector $inspector The inspector object to add.
     */
    protected function doAddInspector($inspector)
    {
        $this->collInspectors[]= $inspector;
        $inspector->setUser($this);
    }

    /**
     * @param	Inspector $inspector The inspector object to remove.
     */
    public function removeInspector($inspector)
    {
        if ($this->getInspectors()->contains($inspector)) {
            $this->collInspectors->remove($this->collInspectors->search($inspector));
            if (null === $this->inspectorsScheduledForDeletion) {
                $this->inspectorsScheduledForDeletion = clone $this->collInspectors;
                $this->inspectorsScheduledForDeletion->clear();
            }
            $this->inspectorsScheduledForDeletion[]= $inspector;
            $inspector->setUser(null);
        }
    }

    /**
     * Clears out the collPolicyGuidelines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelines()
     */
    public function clearPolicyGuidelines()
    {
        $this->collPolicyGuidelines = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelinesPartial = null;
    }

    /**
     * reset is the collPolicyGuidelines collection loaded partially
     *
     * @return void
     */
    public function resetPartialPolicyGuidelines($v = true)
    {
        $this->collPolicyGuidelinesPartial = $v;
    }

    /**
     * Initializes the collPolicyGuidelines collection.
     *
     * By default this just sets the collPolicyGuidelines collection to an empty array (like clearcollPolicyGuidelines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPolicyGuidelines($overrideExisting = true)
    {
        if (null !== $this->collPolicyGuidelines && !$overrideExisting) {
            return;
        }
        $this->collPolicyGuidelines = new PropelObjectCollection();
        $this->collPolicyGuidelines->setModel('PolicyGuideline');
    }

    /**
     * Gets an array of PolicyGuideline objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PolicyGuideline[] List of PolicyGuideline objects
     * @throws PropelException
     */
    public function getPolicyGuidelines($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelinesPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelines || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelines) {
                // return empty collection
                $this->initPolicyGuidelines();
            } else {
                $collPolicyGuidelines = PolicyGuidelineQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPolicyGuidelinesPartial && count($collPolicyGuidelines)) {
                      $this->initPolicyGuidelines(false);

                      foreach($collPolicyGuidelines as $obj) {
                        if (false == $this->collPolicyGuidelines->contains($obj)) {
                          $this->collPolicyGuidelines->append($obj);
                        }
                      }

                      $this->collPolicyGuidelinesPartial = true;
                    }

                    return $collPolicyGuidelines;
                }

                if($partial && $this->collPolicyGuidelines) {
                    foreach($this->collPolicyGuidelines as $obj) {
                        if($obj->isNew()) {
                            $collPolicyGuidelines[] = $obj;
                        }
                    }
                }

                $this->collPolicyGuidelines = $collPolicyGuidelines;
                $this->collPolicyGuidelinesPartial = false;
            }
        }

        return $this->collPolicyGuidelines;
    }

    /**
     * Sets a collection of PolicyGuideline objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelines(PropelCollection $policyGuidelines, PropelPDO $con = null)
    {
        $this->policyGuidelinesScheduledForDeletion = $this->getPolicyGuidelines(new Criteria(), $con)->diff($policyGuidelines);

        foreach ($this->policyGuidelinesScheduledForDeletion as $policyGuidelineRemoved) {
            $policyGuidelineRemoved->setUser(null);
        }

        $this->collPolicyGuidelines = null;
        foreach ($policyGuidelines as $policyGuideline) {
            $this->addPolicyGuideline($policyGuideline);
        }

        $this->collPolicyGuidelines = $policyGuidelines;
        $this->collPolicyGuidelinesPartial = false;
    }

    /**
     * Returns the number of related PolicyGuideline objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PolicyGuideline objects.
     * @throws PropelException
     */
    public function countPolicyGuidelines(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelinesPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelines || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelines) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPolicyGuidelines());
                }
                $query = PolicyGuidelineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelines);
        }
    }

    /**
     * Method called to associate a PolicyGuideline object to this object
     * through the PolicyGuideline foreign key attribute.
     *
     * @param    PolicyGuideline $l PolicyGuideline
     * @return User The current object (for fluent API support)
     */
    public function addPolicyGuideline(PolicyGuideline $l)
    {
        if ($this->collPolicyGuidelines === null) {
            $this->initPolicyGuidelines();
            $this->collPolicyGuidelinesPartial = true;
        }
        if (!$this->collPolicyGuidelines->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuideline($l);
        }

        return $this;
    }

    /**
     * @param	PolicyGuideline $policyGuideline The policyGuideline object to add.
     */
    protected function doAddPolicyGuideline($policyGuideline)
    {
        $this->collPolicyGuidelines[]= $policyGuideline;
        $policyGuideline->setUser($this);
    }

    /**
     * @param	PolicyGuideline $policyGuideline The policyGuideline object to remove.
     */
    public function removePolicyGuideline($policyGuideline)
    {
        if ($this->getPolicyGuidelines()->contains($policyGuideline)) {
            $this->collPolicyGuidelines->remove($this->collPolicyGuidelines->search($policyGuideline));
            if (null === $this->policyGuidelinesScheduledForDeletion) {
                $this->policyGuidelinesScheduledForDeletion = clone $this->collPolicyGuidelines;
                $this->policyGuidelinesScheduledForDeletion->clear();
            }
            $this->policyGuidelinesScheduledForDeletion[]= $policyGuideline;
            $policyGuideline->setUser(null);
        }
    }

    /**
     * Clears out the collStrategicObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStrategicObjectives()
     */
    public function clearStrategicObjectives()
    {
        $this->collStrategicObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collStrategicObjectivesPartial = null;
    }

    /**
     * reset is the collStrategicObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialStrategicObjectives($v = true)
    {
        $this->collStrategicObjectivesPartial = $v;
    }

    /**
     * Initializes the collStrategicObjectives collection.
     *
     * By default this just sets the collStrategicObjectives collection to an empty array (like clearcollStrategicObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStrategicObjectives($overrideExisting = true)
    {
        if (null !== $this->collStrategicObjectives && !$overrideExisting) {
            return;
        }
        $this->collStrategicObjectives = new PropelObjectCollection();
        $this->collStrategicObjectives->setModel('StrategicObjective');
    }

    /**
     * Gets an array of StrategicObjective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|StrategicObjective[] List of StrategicObjective objects
     * @throws PropelException
     */
    public function getStrategicObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectivesPartial && !$this->isNew();
        if (null === $this->collStrategicObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectives) {
                // return empty collection
                $this->initStrategicObjectives();
            } else {
                $collStrategicObjectives = StrategicObjectiveQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collStrategicObjectivesPartial && count($collStrategicObjectives)) {
                      $this->initStrategicObjectives(false);

                      foreach($collStrategicObjectives as $obj) {
                        if (false == $this->collStrategicObjectives->contains($obj)) {
                          $this->collStrategicObjectives->append($obj);
                        }
                      }

                      $this->collStrategicObjectivesPartial = true;
                    }

                    return $collStrategicObjectives;
                }

                if($partial && $this->collStrategicObjectives) {
                    foreach($this->collStrategicObjectives as $obj) {
                        if($obj->isNew()) {
                            $collStrategicObjectives[] = $obj;
                        }
                    }
                }

                $this->collStrategicObjectives = $collStrategicObjectives;
                $this->collStrategicObjectivesPartial = false;
            }
        }

        return $this->collStrategicObjectives;
    }

    /**
     * Sets a collection of StrategicObjective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $strategicObjectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setStrategicObjectives(PropelCollection $strategicObjectives, PropelPDO $con = null)
    {
        $this->strategicObjectivesScheduledForDeletion = $this->getStrategicObjectives(new Criteria(), $con)->diff($strategicObjectives);

        foreach ($this->strategicObjectivesScheduledForDeletion as $strategicObjectiveRemoved) {
            $strategicObjectiveRemoved->setUser(null);
        }

        $this->collStrategicObjectives = null;
        foreach ($strategicObjectives as $strategicObjective) {
            $this->addStrategicObjective($strategicObjective);
        }

        $this->collStrategicObjectives = $strategicObjectives;
        $this->collStrategicObjectivesPartial = false;
    }

    /**
     * Returns the number of related StrategicObjective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related StrategicObjective objects.
     * @throws PropelException
     */
    public function countStrategicObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectivesPartial && !$this->isNew();
        if (null === $this->collStrategicObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getStrategicObjectives());
                }
                $query = StrategicObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collStrategicObjectives);
        }
    }

    /**
     * Method called to associate a StrategicObjective object to this object
     * through the StrategicObjective foreign key attribute.
     *
     * @param    StrategicObjective $l StrategicObjective
     * @return User The current object (for fluent API support)
     */
    public function addStrategicObjective(StrategicObjective $l)
    {
        if ($this->collStrategicObjectives === null) {
            $this->initStrategicObjectives();
            $this->collStrategicObjectivesPartial = true;
        }
        if (!$this->collStrategicObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddStrategicObjective($l);
        }

        return $this;
    }

    /**
     * @param	StrategicObjective $strategicObjective The strategicObjective object to add.
     */
    protected function doAddStrategicObjective($strategicObjective)
    {
        $this->collStrategicObjectives[]= $strategicObjective;
        $strategicObjective->setUser($this);
    }

    /**
     * @param	StrategicObjective $strategicObjective The strategicObjective object to remove.
     */
    public function removeStrategicObjective($strategicObjective)
    {
        if ($this->getStrategicObjectives()->contains($strategicObjective)) {
            $this->collStrategicObjectives->remove($this->collStrategicObjectives->search($strategicObjective));
            if (null === $this->strategicObjectivesScheduledForDeletion) {
                $this->strategicObjectivesScheduledForDeletion = clone $this->collStrategicObjectives;
                $this->strategicObjectivesScheduledForDeletion->clear();
            }
            $this->strategicObjectivesScheduledForDeletion[]= $strategicObjective;
            $strategicObjective->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related StrategicObjectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjective[] List of StrategicObjective objects
     */
    public function getStrategicObjectivesJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getStrategicObjectives($query, $con);
    }

    /**
     * Clears out the collObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectives()
     */
    public function clearObjectives()
    {
        $this->collObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivesPartial = null;
    }

    /**
     * reset is the collObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectives($v = true)
    {
        $this->collObjectivesPartial = $v;
    }

    /**
     * Initializes the collObjectives collection.
     *
     * By default this just sets the collObjectives collection to an empty array (like clearcollObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectives($overrideExisting = true)
    {
        if (null !== $this->collObjectives && !$overrideExisting) {
            return;
        }
        $this->collObjectives = new PropelObjectCollection();
        $this->collObjectives->setModel('Objective');
    }

    /**
     * Gets an array of Objective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Objective[] List of Objective objects
     * @throws PropelException
     */
    public function getObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                // return empty collection
                $this->initObjectives();
            } else {
                $collObjectives = ObjectiveQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectivesPartial && count($collObjectives)) {
                      $this->initObjectives(false);

                      foreach($collObjectives as $obj) {
                        if (false == $this->collObjectives->contains($obj)) {
                          $this->collObjectives->append($obj);
                        }
                      }

                      $this->collObjectivesPartial = true;
                    }

                    return $collObjectives;
                }

                if($partial && $this->collObjectives) {
                    foreach($this->collObjectives as $obj) {
                        if($obj->isNew()) {
                            $collObjectives[] = $obj;
                        }
                    }
                }

                $this->collObjectives = $collObjectives;
                $this->collObjectivesPartial = false;
            }
        }

        return $this->collObjectives;
    }

    /**
     * Sets a collection of Objective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectives(PropelCollection $objectives, PropelPDO $con = null)
    {
        $this->objectivesScheduledForDeletion = $this->getObjectives(new Criteria(), $con)->diff($objectives);

        foreach ($this->objectivesScheduledForDeletion as $objectiveRemoved) {
            $objectiveRemoved->setUser(null);
        }

        $this->collObjectives = null;
        foreach ($objectives as $objective) {
            $this->addObjective($objective);
        }

        $this->collObjectives = $objectives;
        $this->collObjectivesPartial = false;
    }

    /**
     * Returns the number of related Objective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Objective objects.
     * @throws PropelException
     */
    public function countObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectives());
                }
                $query = ObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectives);
        }
    }

    /**
     * Method called to associate a Objective object to this object
     * through the Objective foreign key attribute.
     *
     * @param    Objective $l Objective
     * @return User The current object (for fluent API support)
     */
    public function addObjective(Objective $l)
    {
        if ($this->collObjectives === null) {
            $this->initObjectives();
            $this->collObjectivesPartial = true;
        }
        if (!$this->collObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjective($l);
        }

        return $this;
    }

    /**
     * @param	Objective $objective The objective object to add.
     */
    protected function doAddObjective($objective)
    {
        $this->collObjectives[]= $objective;
        $objective->setUser($this);
    }

    /**
     * @param	Objective $objective The objective object to remove.
     */
    public function removeObjective($objective)
    {
        if ($this->getObjectives()->contains($objective)) {
            $this->collObjectives->remove($this->collObjectives->search($objective));
            if (null === $this->objectivesScheduledForDeletion) {
                $this->objectivesScheduledForDeletion = clone $this->collObjectives;
                $this->objectivesScheduledForDeletion->clear();
            }
            $this->objectivesScheduledForDeletion[]= $objective;
            $objective->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectives($query, $con);
    }

    /**
     * Clears out the collPolicyGuidelineLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelineLogs()
     */
    public function clearPolicyGuidelineLogs()
    {
        $this->collPolicyGuidelineLogs = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelineLogsPartial = null;
    }

    /**
     * reset is the collPolicyGuidelineLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialPolicyGuidelineLogs($v = true)
    {
        $this->collPolicyGuidelineLogsPartial = $v;
    }

    /**
     * Initializes the collPolicyGuidelineLogs collection.
     *
     * By default this just sets the collPolicyGuidelineLogs collection to an empty array (like clearcollPolicyGuidelineLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPolicyGuidelineLogs($overrideExisting = true)
    {
        if (null !== $this->collPolicyGuidelineLogs && !$overrideExisting) {
            return;
        }
        $this->collPolicyGuidelineLogs = new PropelObjectCollection();
        $this->collPolicyGuidelineLogs->setModel('PolicyGuidelineLog');
    }

    /**
     * Gets an array of PolicyGuidelineLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PolicyGuidelineLog[] List of PolicyGuidelineLog objects
     * @throws PropelException
     */
    public function getPolicyGuidelineLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineLogsPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineLogs) {
                // return empty collection
                $this->initPolicyGuidelineLogs();
            } else {
                $collPolicyGuidelineLogs = PolicyGuidelineLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPolicyGuidelineLogsPartial && count($collPolicyGuidelineLogs)) {
                      $this->initPolicyGuidelineLogs(false);

                      foreach($collPolicyGuidelineLogs as $obj) {
                        if (false == $this->collPolicyGuidelineLogs->contains($obj)) {
                          $this->collPolicyGuidelineLogs->append($obj);
                        }
                      }

                      $this->collPolicyGuidelineLogsPartial = true;
                    }

                    return $collPolicyGuidelineLogs;
                }

                if($partial && $this->collPolicyGuidelineLogs) {
                    foreach($this->collPolicyGuidelineLogs as $obj) {
                        if($obj->isNew()) {
                            $collPolicyGuidelineLogs[] = $obj;
                        }
                    }
                }

                $this->collPolicyGuidelineLogs = $collPolicyGuidelineLogs;
                $this->collPolicyGuidelineLogsPartial = false;
            }
        }

        return $this->collPolicyGuidelineLogs;
    }

    /**
     * Sets a collection of PolicyGuidelineLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelineLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelineLogs(PropelCollection $policyGuidelineLogs, PropelPDO $con = null)
    {
        $this->policyGuidelineLogsScheduledForDeletion = $this->getPolicyGuidelineLogs(new Criteria(), $con)->diff($policyGuidelineLogs);

        foreach ($this->policyGuidelineLogsScheduledForDeletion as $policyGuidelineLogRemoved) {
            $policyGuidelineLogRemoved->setUser(null);
        }

        $this->collPolicyGuidelineLogs = null;
        foreach ($policyGuidelineLogs as $policyGuidelineLog) {
            $this->addPolicyGuidelineLog($policyGuidelineLog);
        }

        $this->collPolicyGuidelineLogs = $policyGuidelineLogs;
        $this->collPolicyGuidelineLogsPartial = false;
    }

    /**
     * Returns the number of related PolicyGuidelineLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PolicyGuidelineLog objects.
     * @throws PropelException
     */
    public function countPolicyGuidelineLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineLogsPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPolicyGuidelineLogs());
                }
                $query = PolicyGuidelineLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelineLogs);
        }
    }

    /**
     * Method called to associate a PolicyGuidelineLog object to this object
     * through the PolicyGuidelineLog foreign key attribute.
     *
     * @param    PolicyGuidelineLog $l PolicyGuidelineLog
     * @return User The current object (for fluent API support)
     */
    public function addPolicyGuidelineLog(PolicyGuidelineLog $l)
    {
        if ($this->collPolicyGuidelineLogs === null) {
            $this->initPolicyGuidelineLogs();
            $this->collPolicyGuidelineLogsPartial = true;
        }
        if (!$this->collPolicyGuidelineLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuidelineLog($l);
        }

        return $this;
    }

    /**
     * @param	PolicyGuidelineLog $policyGuidelineLog The policyGuidelineLog object to add.
     */
    protected function doAddPolicyGuidelineLog($policyGuidelineLog)
    {
        $this->collPolicyGuidelineLogs[]= $policyGuidelineLog;
        $policyGuidelineLog->setUser($this);
    }

    /**
     * @param	PolicyGuidelineLog $policyGuidelineLog The policyGuidelineLog object to remove.
     */
    public function removePolicyGuidelineLog($policyGuidelineLog)
    {
        if ($this->getPolicyGuidelineLogs()->contains($policyGuidelineLog)) {
            $this->collPolicyGuidelineLogs->remove($this->collPolicyGuidelineLogs->search($policyGuidelineLog));
            if (null === $this->policyGuidelineLogsScheduledForDeletion) {
                $this->policyGuidelineLogsScheduledForDeletion = clone $this->collPolicyGuidelineLogs;
                $this->policyGuidelineLogsScheduledForDeletion->clear();
            }
            $this->policyGuidelineLogsScheduledForDeletion[]= $policyGuidelineLog;
            $policyGuidelineLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related PolicyGuidelineLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PolicyGuidelineLog[] List of PolicyGuidelineLog objects
     */
    public function getPolicyGuidelineLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PolicyGuidelineLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getPolicyGuidelineLogs($query, $con);
    }

    /**
     * Clears out the collStrategicObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStrategicObjectiveLogs()
     */
    public function clearStrategicObjectiveLogs()
    {
        $this->collStrategicObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collStrategicObjectiveLogsPartial = null;
    }

    /**
     * reset is the collStrategicObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialStrategicObjectiveLogs($v = true)
    {
        $this->collStrategicObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collStrategicObjectiveLogs collection.
     *
     * By default this just sets the collStrategicObjectiveLogs collection to an empty array (like clearcollStrategicObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStrategicObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collStrategicObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collStrategicObjectiveLogs = new PropelObjectCollection();
        $this->collStrategicObjectiveLogs->setModel('StrategicObjectiveLog');
    }

    /**
     * Gets an array of StrategicObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     * @throws PropelException
     */
    public function getStrategicObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                // return empty collection
                $this->initStrategicObjectiveLogs();
            } else {
                $collStrategicObjectiveLogs = StrategicObjectiveLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collStrategicObjectiveLogsPartial && count($collStrategicObjectiveLogs)) {
                      $this->initStrategicObjectiveLogs(false);

                      foreach($collStrategicObjectiveLogs as $obj) {
                        if (false == $this->collStrategicObjectiveLogs->contains($obj)) {
                          $this->collStrategicObjectiveLogs->append($obj);
                        }
                      }

                      $this->collStrategicObjectiveLogsPartial = true;
                    }

                    return $collStrategicObjectiveLogs;
                }

                if($partial && $this->collStrategicObjectiveLogs) {
                    foreach($this->collStrategicObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collStrategicObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collStrategicObjectiveLogs = $collStrategicObjectiveLogs;
                $this->collStrategicObjectiveLogsPartial = false;
            }
        }

        return $this->collStrategicObjectiveLogs;
    }

    /**
     * Sets a collection of StrategicObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $strategicObjectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setStrategicObjectiveLogs(PropelCollection $strategicObjectiveLogs, PropelPDO $con = null)
    {
        $this->strategicObjectiveLogsScheduledForDeletion = $this->getStrategicObjectiveLogs(new Criteria(), $con)->diff($strategicObjectiveLogs);

        foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLogRemoved) {
            $strategicObjectiveLogRemoved->setUser(null);
        }

        $this->collStrategicObjectiveLogs = null;
        foreach ($strategicObjectiveLogs as $strategicObjectiveLog) {
            $this->addStrategicObjectiveLog($strategicObjectiveLog);
        }

        $this->collStrategicObjectiveLogs = $strategicObjectiveLogs;
        $this->collStrategicObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related StrategicObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related StrategicObjectiveLog objects.
     * @throws PropelException
     */
    public function countStrategicObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getStrategicObjectiveLogs());
                }
                $query = StrategicObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collStrategicObjectiveLogs);
        }
    }

    /**
     * Method called to associate a StrategicObjectiveLog object to this object
     * through the StrategicObjectiveLog foreign key attribute.
     *
     * @param    StrategicObjectiveLog $l StrategicObjectiveLog
     * @return User The current object (for fluent API support)
     */
    public function addStrategicObjectiveLog(StrategicObjectiveLog $l)
    {
        if ($this->collStrategicObjectiveLogs === null) {
            $this->initStrategicObjectiveLogs();
            $this->collStrategicObjectiveLogsPartial = true;
        }
        if (!$this->collStrategicObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddStrategicObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to add.
     */
    protected function doAddStrategicObjectiveLog($strategicObjectiveLog)
    {
        $this->collStrategicObjectiveLogs[]= $strategicObjectiveLog;
        $strategicObjectiveLog->setUser($this);
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to remove.
     */
    public function removeStrategicObjectiveLog($strategicObjectiveLog)
    {
        if ($this->getStrategicObjectiveLogs()->contains($strategicObjectiveLog)) {
            $this->collStrategicObjectiveLogs->remove($this->collStrategicObjectiveLogs->search($strategicObjectiveLog));
            if (null === $this->strategicObjectiveLogsScheduledForDeletion) {
                $this->strategicObjectiveLogsScheduledForDeletion = clone $this->collStrategicObjectiveLogs;
                $this->strategicObjectiveLogsScheduledForDeletion->clear();
            }
            $this->strategicObjectiveLogsScheduledForDeletion[]= $strategicObjectiveLog;
            $strategicObjectiveLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveLogs()
     */
    public function clearObjectiveLogs()
    {
        $this->collObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveLogsPartial = null;
    }

    /**
     * reset is the collObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveLogs($v = true)
    {
        $this->collObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collObjectiveLogs collection.
     *
     * By default this just sets the collObjectiveLogs collection to an empty array (like clearcollObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collObjectiveLogs = new PropelObjectCollection();
        $this->collObjectiveLogs->setModel('ObjectiveLog');
    }

    /**
     * Gets an array of ObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     * @throws PropelException
     */
    public function getObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                // return empty collection
                $this->initObjectiveLogs();
            } else {
                $collObjectiveLogs = ObjectiveLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveLogsPartial && count($collObjectiveLogs)) {
                      $this->initObjectiveLogs(false);

                      foreach($collObjectiveLogs as $obj) {
                        if (false == $this->collObjectiveLogs->contains($obj)) {
                          $this->collObjectiveLogs->append($obj);
                        }
                      }

                      $this->collObjectiveLogsPartial = true;
                    }

                    return $collObjectiveLogs;
                }

                if($partial && $this->collObjectiveLogs) {
                    foreach($this->collObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collObjectiveLogs = $collObjectiveLogs;
                $this->collObjectiveLogsPartial = false;
            }
        }

        return $this->collObjectiveLogs;
    }

    /**
     * Sets a collection of ObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveLogs(PropelCollection $objectiveLogs, PropelPDO $con = null)
    {
        $this->objectiveLogsScheduledForDeletion = $this->getObjectiveLogs(new Criteria(), $con)->diff($objectiveLogs);

        foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLogRemoved) {
            $objectiveLogRemoved->setUser(null);
        }

        $this->collObjectiveLogs = null;
        foreach ($objectiveLogs as $objectiveLog) {
            $this->addObjectiveLog($objectiveLog);
        }

        $this->collObjectiveLogs = $objectiveLogs;
        $this->collObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveLog objects.
     * @throws PropelException
     */
    public function countObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveLogs());
                }
                $query = ObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveLogs);
        }
    }

    /**
     * Method called to associate a ObjectiveLog object to this object
     * through the ObjectiveLog foreign key attribute.
     *
     * @param    ObjectiveLog $l ObjectiveLog
     * @return User The current object (for fluent API support)
     */
    public function addObjectiveLog(ObjectiveLog $l)
    {
        if ($this->collObjectiveLogs === null) {
            $this->initObjectiveLogs();
            $this->collObjectiveLogsPartial = true;
        }
        if (!$this->collObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to add.
     */
    protected function doAddObjectiveLog($objectiveLog)
    {
        $this->collObjectiveLogs[]= $objectiveLog;
        $objectiveLog->setUser($this);
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to remove.
     */
    public function removeObjectiveLog($objectiveLog)
    {
        if ($this->getObjectiveLogs()->contains($objectiveLog)) {
            $this->collObjectiveLogs->remove($this->collObjectiveLogs->search($objectiveLog));
            if (null === $this->objectiveLogsScheduledForDeletion) {
                $this->objectiveLogsScheduledForDeletion = clone $this->collObjectiveLogs;
                $this->objectiveLogsScheduledForDeletion->clear();
            }
            $this->objectiveLogsScheduledForDeletion[]= $objectiveLog;
            $objectiveLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * reset is the collProjects collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjects($v = true)
    {
        $this->collProjectsPartial = $v;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty array (like clearcollProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjects($overrideExisting = true)
    {
        if (null !== $this->collProjects && !$overrideExisting) {
            return;
        }
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets an array of Project objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Project[] List of Project objects
     * @throws PropelException
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectsPartial && count($collProjects)) {
                      $this->initProjects(false);

                      foreach($collProjects as $obj) {
                        if (false == $this->collProjects->contains($obj)) {
                          $this->collProjects->append($obj);
                        }
                      }

                      $this->collProjectsPartial = true;
                    }

                    return $collProjects;
                }

                if($partial && $this->collProjects) {
                    foreach($this->collProjects as $obj) {
                        if($obj->isNew()) {
                            $collProjects[] = $obj;
                        }
                    }
                }

                $this->collProjects = $collProjects;
                $this->collProjectsPartial = false;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->projectsScheduledForDeletion = $this->getProjects(new Criteria(), $con)->diff($projects);

        foreach ($this->projectsScheduledForDeletion as $projectRemoved) {
            $projectRemoved->setUser(null);
        }

        $this->collProjects = null;
        foreach ($projects as $project) {
            $this->addProject($project);
        }

        $this->collProjects = $projects;
        $this->collProjectsPartial = false;
    }

    /**
     * Returns the number of related Project objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Project objects.
     * @throws PropelException
     */
    public function countProjects(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjects());
                }
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Method called to associate a Project object to this object
     * through the Project foreign key attribute.
     *
     * @param    Project $l Project
     * @return User The current object (for fluent API support)
     */
    public function addProject(Project $l)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
            $this->collProjectsPartial = true;
        }
        if (!$this->collProjects->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProject($l);
        }

        return $this;
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $this->collProjects[]= $project;
        $project->setUser($this);
    }

    /**
     * @param	Project $project The project object to remove.
     */
    public function removeProject($project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
            $project->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinIndicator($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Indicator', $join_behavior);

        return $this->getProjects($query, $con);
    }

    /**
     * Clears out the collProjectActivitys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivitys()
     */
    public function clearProjectActivitys()
    {
        $this->collProjectActivitys = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivitysPartial = null;
    }

    /**
     * reset is the collProjectActivitys collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivitys($v = true)
    {
        $this->collProjectActivitysPartial = $v;
    }

    /**
     * Initializes the collProjectActivitys collection.
     *
     * By default this just sets the collProjectActivitys collection to an empty array (like clearcollProjectActivitys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivitys($overrideExisting = true)
    {
        if (null !== $this->collProjectActivitys && !$overrideExisting) {
            return;
        }
        $this->collProjectActivitys = new PropelObjectCollection();
        $this->collProjectActivitys->setModel('ProjectActivity');
    }

    /**
     * Gets an array of ProjectActivity objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     * @throws PropelException
     */
    public function getProjectActivitys($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                // return empty collection
                $this->initProjectActivitys();
            } else {
                $collProjectActivitys = ProjectActivityQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivitysPartial && count($collProjectActivitys)) {
                      $this->initProjectActivitys(false);

                      foreach($collProjectActivitys as $obj) {
                        if (false == $this->collProjectActivitys->contains($obj)) {
                          $this->collProjectActivitys->append($obj);
                        }
                      }

                      $this->collProjectActivitysPartial = true;
                    }

                    return $collProjectActivitys;
                }

                if($partial && $this->collProjectActivitys) {
                    foreach($this->collProjectActivitys as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivitys[] = $obj;
                        }
                    }
                }

                $this->collProjectActivitys = $collProjectActivitys;
                $this->collProjectActivitysPartial = false;
            }
        }

        return $this->collProjectActivitys;
    }

    /**
     * Sets a collection of ProjectActivity objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivitys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivitys(PropelCollection $projectActivitys, PropelPDO $con = null)
    {
        $this->projectActivitysScheduledForDeletion = $this->getProjectActivitys(new Criteria(), $con)->diff($projectActivitys);

        foreach ($this->projectActivitysScheduledForDeletion as $projectActivityRemoved) {
            $projectActivityRemoved->setUser(null);
        }

        $this->collProjectActivitys = null;
        foreach ($projectActivitys as $projectActivity) {
            $this->addProjectActivity($projectActivity);
        }

        $this->collProjectActivitys = $projectActivitys;
        $this->collProjectActivitysPartial = false;
    }

    /**
     * Returns the number of related ProjectActivity objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivity objects.
     * @throws PropelException
     */
    public function countProjectActivitys(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivitys());
                }
                $query = ProjectActivityQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivitys);
        }
    }

    /**
     * Method called to associate a ProjectActivity object to this object
     * through the ProjectActivity foreign key attribute.
     *
     * @param    ProjectActivity $l ProjectActivity
     * @return User The current object (for fluent API support)
     */
    public function addProjectActivity(ProjectActivity $l)
    {
        if ($this->collProjectActivitys === null) {
            $this->initProjectActivitys();
            $this->collProjectActivitysPartial = true;
        }
        if (!$this->collProjectActivitys->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivity($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to add.
     */
    protected function doAddProjectActivity($projectActivity)
    {
        $this->collProjectActivitys[]= $projectActivity;
        $projectActivity->setUser($this);
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to remove.
     */
    public function removeProjectActivity($projectActivity)
    {
        if ($this->getProjectActivitys()->contains($projectActivity)) {
            $this->collProjectActivitys->remove($this->collProjectActivitys->search($projectActivity));
            if (null === $this->projectActivitysScheduledForDeletion) {
                $this->projectActivitysScheduledForDeletion = clone $this->collProjectActivitys;
                $this->projectActivitysScheduledForDeletion->clear();
            }
            $this->projectActivitysScheduledForDeletion[]= $projectActivity;
            $projectActivity->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }

    /**
     * Clears out the collProjectLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectLogs()
     */
    public function clearProjectLogs()
    {
        $this->collProjectLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectLogsPartial = null;
    }

    /**
     * reset is the collProjectLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectLogs($v = true)
    {
        $this->collProjectLogsPartial = $v;
    }

    /**
     * Initializes the collProjectLogs collection.
     *
     * By default this just sets the collProjectLogs collection to an empty array (like clearcollProjectLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectLogs = new PropelObjectCollection();
        $this->collProjectLogs->setModel('ProjectLog');
    }

    /**
     * Gets an array of ProjectLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     * @throws PropelException
     */
    public function getProjectLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                // return empty collection
                $this->initProjectLogs();
            } else {
                $collProjectLogs = ProjectLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectLogsPartial && count($collProjectLogs)) {
                      $this->initProjectLogs(false);

                      foreach($collProjectLogs as $obj) {
                        if (false == $this->collProjectLogs->contains($obj)) {
                          $this->collProjectLogs->append($obj);
                        }
                      }

                      $this->collProjectLogsPartial = true;
                    }

                    return $collProjectLogs;
                }

                if($partial && $this->collProjectLogs) {
                    foreach($this->collProjectLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectLogs = $collProjectLogs;
                $this->collProjectLogsPartial = false;
            }
        }

        return $this->collProjectLogs;
    }

    /**
     * Sets a collection of ProjectLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectLogs(PropelCollection $projectLogs, PropelPDO $con = null)
    {
        $this->projectLogsScheduledForDeletion = $this->getProjectLogs(new Criteria(), $con)->diff($projectLogs);

        foreach ($this->projectLogsScheduledForDeletion as $projectLogRemoved) {
            $projectLogRemoved->setUser(null);
        }

        $this->collProjectLogs = null;
        foreach ($projectLogs as $projectLog) {
            $this->addProjectLog($projectLog);
        }

        $this->collProjectLogs = $projectLogs;
        $this->collProjectLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectLog objects.
     * @throws PropelException
     */
    public function countProjectLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectLogs());
                }
                $query = ProjectLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectLogs);
        }
    }

    /**
     * Method called to associate a ProjectLog object to this object
     * through the ProjectLog foreign key attribute.
     *
     * @param    ProjectLog $l ProjectLog
     * @return User The current object (for fluent API support)
     */
    public function addProjectLog(ProjectLog $l)
    {
        if ($this->collProjectLogs === null) {
            $this->initProjectLogs();
            $this->collProjectLogsPartial = true;
        }
        if (!$this->collProjectLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to add.
     */
    protected function doAddProjectLog($projectLog)
    {
        $this->collProjectLogs[]= $projectLog;
        $projectLog->setUser($this);
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to remove.
     */
    public function removeProjectLog($projectLog)
    {
        if ($this->getProjectLogs()->contains($projectLog)) {
            $this->collProjectLogs->remove($this->collProjectLogs->search($projectLog));
            if (null === $this->projectLogsScheduledForDeletion) {
                $this->projectLogsScheduledForDeletion = clone $this->collProjectLogs;
                $this->projectLogsScheduledForDeletion->clear();
            }
            $this->projectLogsScheduledForDeletion[]= $projectLog;
            $projectLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }

    /**
     * Clears out the collProjectMilestoneLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectMilestoneLogs()
     */
    public function clearProjectMilestoneLogs()
    {
        $this->collProjectMilestoneLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectMilestoneLogsPartial = null;
    }

    /**
     * reset is the collProjectMilestoneLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectMilestoneLogs($v = true)
    {
        $this->collProjectMilestoneLogsPartial = $v;
    }

    /**
     * Initializes the collProjectMilestoneLogs collection.
     *
     * By default this just sets the collProjectMilestoneLogs collection to an empty array (like clearcollProjectMilestoneLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectMilestoneLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectMilestoneLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectMilestoneLogs = new PropelObjectCollection();
        $this->collProjectMilestoneLogs->setModel('ProjectMilestoneLog');
    }

    /**
     * Gets an array of ProjectMilestoneLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     * @throws PropelException
     */
    public function getProjectMilestoneLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                // return empty collection
                $this->initProjectMilestoneLogs();
            } else {
                $collProjectMilestoneLogs = ProjectMilestoneLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectMilestoneLogsPartial && count($collProjectMilestoneLogs)) {
                      $this->initProjectMilestoneLogs(false);

                      foreach($collProjectMilestoneLogs as $obj) {
                        if (false == $this->collProjectMilestoneLogs->contains($obj)) {
                          $this->collProjectMilestoneLogs->append($obj);
                        }
                      }

                      $this->collProjectMilestoneLogsPartial = true;
                    }

                    return $collProjectMilestoneLogs;
                }

                if($partial && $this->collProjectMilestoneLogs) {
                    foreach($this->collProjectMilestoneLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectMilestoneLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectMilestoneLogs = $collProjectMilestoneLogs;
                $this->collProjectMilestoneLogsPartial = false;
            }
        }

        return $this->collProjectMilestoneLogs;
    }

    /**
     * Sets a collection of ProjectMilestoneLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectMilestoneLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectMilestoneLogs(PropelCollection $projectMilestoneLogs, PropelPDO $con = null)
    {
        $this->projectMilestoneLogsScheduledForDeletion = $this->getProjectMilestoneLogs(new Criteria(), $con)->diff($projectMilestoneLogs);

        foreach ($this->projectMilestoneLogsScheduledForDeletion as $projectMilestoneLogRemoved) {
            $projectMilestoneLogRemoved->setUser(null);
        }

        $this->collProjectMilestoneLogs = null;
        foreach ($projectMilestoneLogs as $projectMilestoneLog) {
            $this->addProjectMilestoneLog($projectMilestoneLog);
        }

        $this->collProjectMilestoneLogs = $projectMilestoneLogs;
        $this->collProjectMilestoneLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectMilestoneLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectMilestoneLog objects.
     * @throws PropelException
     */
    public function countProjectMilestoneLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectMilestoneLogs());
                }
                $query = ProjectMilestoneLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectMilestoneLogs);
        }
    }

    /**
     * Method called to associate a ProjectMilestoneLog object to this object
     * through the ProjectMilestoneLog foreign key attribute.
     *
     * @param    ProjectMilestoneLog $l ProjectMilestoneLog
     * @return User The current object (for fluent API support)
     */
    public function addProjectMilestoneLog(ProjectMilestoneLog $l)
    {
        if ($this->collProjectMilestoneLogs === null) {
            $this->initProjectMilestoneLogs();
            $this->collProjectMilestoneLogsPartial = true;
        }
        if (!$this->collProjectMilestoneLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectMilestoneLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to add.
     */
    protected function doAddProjectMilestoneLog($projectMilestoneLog)
    {
        $this->collProjectMilestoneLogs[]= $projectMilestoneLog;
        $projectMilestoneLog->setUser($this);
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to remove.
     */
    public function removeProjectMilestoneLog($projectMilestoneLog)
    {
        if ($this->getProjectMilestoneLogs()->contains($projectMilestoneLog)) {
            $this->collProjectMilestoneLogs->remove($this->collProjectMilestoneLogs->search($projectMilestoneLog));
            if (null === $this->projectMilestoneLogsScheduledForDeletion) {
                $this->projectMilestoneLogsScheduledForDeletion = clone $this->collProjectMilestoneLogs;
                $this->projectMilestoneLogsScheduledForDeletion->clear();
            }
            $this->projectMilestoneLogsScheduledForDeletion[]= $projectMilestoneLog;
            $projectMilestoneLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinProjectMilestone($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('ProjectMilestone', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }

    /**
     * Clears out the collProjectActivityLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivityLogs()
     */
    public function clearProjectActivityLogs()
    {
        $this->collProjectActivityLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivityLogsPartial = null;
    }

    /**
     * reset is the collProjectActivityLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivityLogs($v = true)
    {
        $this->collProjectActivityLogsPartial = $v;
    }

    /**
     * Initializes the collProjectActivityLogs collection.
     *
     * By default this just sets the collProjectActivityLogs collection to an empty array (like clearcollProjectActivityLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivityLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectActivityLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectActivityLogs = new PropelObjectCollection();
        $this->collProjectActivityLogs->setModel('ProjectActivityLog');
    }

    /**
     * Gets an array of ProjectActivityLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     * @throws PropelException
     */
    public function getProjectActivityLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                // return empty collection
                $this->initProjectActivityLogs();
            } else {
                $collProjectActivityLogs = ProjectActivityLogQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivityLogsPartial && count($collProjectActivityLogs)) {
                      $this->initProjectActivityLogs(false);

                      foreach($collProjectActivityLogs as $obj) {
                        if (false == $this->collProjectActivityLogs->contains($obj)) {
                          $this->collProjectActivityLogs->append($obj);
                        }
                      }

                      $this->collProjectActivityLogsPartial = true;
                    }

                    return $collProjectActivityLogs;
                }

                if($partial && $this->collProjectActivityLogs) {
                    foreach($this->collProjectActivityLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivityLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectActivityLogs = $collProjectActivityLogs;
                $this->collProjectActivityLogsPartial = false;
            }
        }

        return $this->collProjectActivityLogs;
    }

    /**
     * Sets a collection of ProjectActivityLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivityLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivityLogs(PropelCollection $projectActivityLogs, PropelPDO $con = null)
    {
        $this->projectActivityLogsScheduledForDeletion = $this->getProjectActivityLogs(new Criteria(), $con)->diff($projectActivityLogs);

        foreach ($this->projectActivityLogsScheduledForDeletion as $projectActivityLogRemoved) {
            $projectActivityLogRemoved->setUser(null);
        }

        $this->collProjectActivityLogs = null;
        foreach ($projectActivityLogs as $projectActivityLog) {
            $this->addProjectActivityLog($projectActivityLog);
        }

        $this->collProjectActivityLogs = $projectActivityLogs;
        $this->collProjectActivityLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectActivityLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivityLog objects.
     * @throws PropelException
     */
    public function countProjectActivityLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivityLogs());
                }
                $query = ProjectActivityLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivityLogs);
        }
    }

    /**
     * Method called to associate a ProjectActivityLog object to this object
     * through the ProjectActivityLog foreign key attribute.
     *
     * @param    ProjectActivityLog $l ProjectActivityLog
     * @return User The current object (for fluent API support)
     */
    public function addProjectActivityLog(ProjectActivityLog $l)
    {
        if ($this->collProjectActivityLogs === null) {
            $this->initProjectActivityLogs();
            $this->collProjectActivityLogsPartial = true;
        }
        if (!$this->collProjectActivityLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivityLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to add.
     */
    protected function doAddProjectActivityLog($projectActivityLog)
    {
        $this->collProjectActivityLogs[]= $projectActivityLog;
        $projectActivityLog->setUser($this);
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to remove.
     */
    public function removeProjectActivityLog($projectActivityLog)
    {
        if ($this->getProjectActivityLogs()->contains($projectActivityLog)) {
            $this->collProjectActivityLogs->remove($this->collProjectActivityLogs->search($projectActivityLog));
            if (null === $this->projectActivityLogsScheduledForDeletion) {
                $this->projectActivityLogsScheduledForDeletion = clone $this->collProjectActivityLogs;
                $this->projectActivityLogsScheduledForDeletion->clear();
            }
            $this->projectActivityLogsScheduledForDeletion[]= $projectActivityLog;
            $projectActivityLog->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinProjectActivity($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('ProjectActivity', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }

    /**
     * Clears out the collUserGroups collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addUserGroups()
     */
    public function clearUserGroups()
    {
        $this->collUserGroups = null; // important to set this to null since that means it is uninitialized
        $this->collUserGroupsPartial = null;
    }

    /**
     * reset is the collUserGroups collection loaded partially
     *
     * @return void
     */
    public function resetPartialUserGroups($v = true)
    {
        $this->collUserGroupsPartial = $v;
    }

    /**
     * Initializes the collUserGroups collection.
     *
     * By default this just sets the collUserGroups collection to an empty array (like clearcollUserGroups());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initUserGroups($overrideExisting = true)
    {
        if (null !== $this->collUserGroups && !$overrideExisting) {
            return;
        }
        $this->collUserGroups = new PropelObjectCollection();
        $this->collUserGroups->setModel('UserGroup');
    }

    /**
     * Gets an array of UserGroup objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|UserGroup[] List of UserGroup objects
     * @throws PropelException
     */
    public function getUserGroups($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collUserGroupsPartial && !$this->isNew();
        if (null === $this->collUserGroups || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collUserGroups) {
                // return empty collection
                $this->initUserGroups();
            } else {
                $collUserGroups = UserGroupQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collUserGroupsPartial && count($collUserGroups)) {
                      $this->initUserGroups(false);

                      foreach($collUserGroups as $obj) {
                        if (false == $this->collUserGroups->contains($obj)) {
                          $this->collUserGroups->append($obj);
                        }
                      }

                      $this->collUserGroupsPartial = true;
                    }

                    return $collUserGroups;
                }

                if($partial && $this->collUserGroups) {
                    foreach($this->collUserGroups as $obj) {
                        if($obj->isNew()) {
                            $collUserGroups[] = $obj;
                        }
                    }
                }

                $this->collUserGroups = $collUserGroups;
                $this->collUserGroupsPartial = false;
            }
        }

        return $this->collUserGroups;
    }

    /**
     * Sets a collection of UserGroup objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $userGroups A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setUserGroups(PropelCollection $userGroups, PropelPDO $con = null)
    {
        $this->userGroupsScheduledForDeletion = $this->getUserGroups(new Criteria(), $con)->diff($userGroups);

        foreach ($this->userGroupsScheduledForDeletion as $userGroupRemoved) {
            $userGroupRemoved->setUser(null);
        }

        $this->collUserGroups = null;
        foreach ($userGroups as $userGroup) {
            $this->addUserGroup($userGroup);
        }

        $this->collUserGroups = $userGroups;
        $this->collUserGroupsPartial = false;
    }

    /**
     * Returns the number of related UserGroup objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related UserGroup objects.
     * @throws PropelException
     */
    public function countUserGroups(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collUserGroupsPartial && !$this->isNew();
        if (null === $this->collUserGroups || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collUserGroups) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getUserGroups());
                }
                $query = UserGroupQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collUserGroups);
        }
    }

    /**
     * Method called to associate a UserGroup object to this object
     * through the UserGroup foreign key attribute.
     *
     * @param    UserGroup $l UserGroup
     * @return User The current object (for fluent API support)
     */
    public function addUserGroup(UserGroup $l)
    {
        if ($this->collUserGroups === null) {
            $this->initUserGroups();
            $this->collUserGroupsPartial = true;
        }
        if (!$this->collUserGroups->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddUserGroup($l);
        }

        return $this;
    }

    /**
     * @param	UserGroup $userGroup The userGroup object to add.
     */
    protected function doAddUserGroup($userGroup)
    {
        $this->collUserGroups[]= $userGroup;
        $userGroup->setUser($this);
    }

    /**
     * @param	UserGroup $userGroup The userGroup object to remove.
     */
    public function removeUserGroup($userGroup)
    {
        if ($this->getUserGroups()->contains($userGroup)) {
            $this->collUserGroups->remove($this->collUserGroups->search($userGroup));
            if (null === $this->userGroupsScheduledForDeletion) {
                $this->userGroupsScheduledForDeletion = clone $this->collUserGroups;
                $this->userGroupsScheduledForDeletion->clear();
            }
            $this->userGroupsScheduledForDeletion[]= $userGroup;
            $userGroup->setUser(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this User is new, it will return
     * an empty collection; or if this User has previously
     * been saved, it will retrieve related UserGroups from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in User.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|UserGroup[] List of UserGroup objects
     */
    public function getUserGroupsJoinGroup($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = UserGroupQuery::create(null, $criteria);
        $query->joinWith('Group', $join_behavior);

        return $this->getUserGroups($query, $con);
    }

    /**
     * Clears out the collAlertSubscriptions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAlertSubscriptions()
     */
    public function clearAlertSubscriptions()
    {
        $this->collAlertSubscriptions = null; // important to set this to null since that means it is uninitialized
        $this->collAlertSubscriptionsPartial = null;
    }

    /**
     * Initializes the collAlertSubscriptions collection.
     *
     * By default this just sets the collAlertSubscriptions collection to an empty collection (like clearAlertSubscriptions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initAlertSubscriptions()
    {
        $this->collAlertSubscriptions = new PropelObjectCollection();
        $this->collAlertSubscriptions->setModel('AlertSubscription');
    }

    /**
     * Gets a collection of AlertSubscription objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|AlertSubscription[] List of AlertSubscription objects
     */
    public function getAlertSubscriptions($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collAlertSubscriptions || null !== $criteria) {
            if ($this->isNew() && null === $this->collAlertSubscriptions) {
                // return empty collection
                $this->initAlertSubscriptions();
            } else {
                $collAlertSubscriptions = AlertSubscriptionQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collAlertSubscriptions;
                }
                $this->collAlertSubscriptions = $collAlertSubscriptions;
            }
        }

        return $this->collAlertSubscriptions;
    }

    /**
     * Sets a collection of AlertSubscription objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $alertSubscriptions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAlertSubscriptions(PropelCollection $alertSubscriptions, PropelPDO $con = null)
    {
        $this->clearAlertSubscriptions();
        $currentAlertSubscriptions = $this->getAlertSubscriptions();

        $this->alertSubscriptionsScheduledForDeletion = $currentAlertSubscriptions->diff($alertSubscriptions);

        foreach ($alertSubscriptions as $alertSubscription) {
            if (!$currentAlertSubscriptions->contains($alertSubscription)) {
                $this->doAddAlertSubscription($alertSubscription);
            }
        }

        $this->collAlertSubscriptions = $alertSubscriptions;
    }

    /**
     * Gets the number of AlertSubscription objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related AlertSubscription objects
     */
    public function countAlertSubscriptions($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collAlertSubscriptions || null !== $criteria) {
            if ($this->isNew() && null === $this->collAlertSubscriptions) {
                return 0;
            } else {
                $query = AlertSubscriptionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collAlertSubscriptions);
        }
    }

    /**
     * Associate a AlertSubscription object to this object
     * through the common_alertSubscriptionUser cross reference table.
     *
     * @param  AlertSubscription $alertSubscription The AlertSubscriptionUser object to relate
     * @return void
     */
    public function addAlertSubscription(AlertSubscription $alertSubscription)
    {
        if ($this->collAlertSubscriptions === null) {
            $this->initAlertSubscriptions();
        }
        if (!$this->collAlertSubscriptions->contains($alertSubscription)) { // only add it if the **same** object is not already associated
            $this->doAddAlertSubscription($alertSubscription);

            $this->collAlertSubscriptions[]= $alertSubscription;
        }
    }

    /**
     * @param	AlertSubscription $alertSubscription The alertSubscription object to add.
     */
    protected function doAddAlertSubscription($alertSubscription)
    {
        $alertSubscriptionUser = new AlertSubscriptionUser();
        $alertSubscriptionUser->setAlertSubscription($alertSubscription);
        $this->addAlertSubscriptionUser($alertSubscriptionUser);
    }

    /**
     * Remove a AlertSubscription object to this object
     * through the common_alertSubscriptionUser cross reference table.
     *
     * @param AlertSubscription $alertSubscription The AlertSubscriptionUser object to relate
     * @return void
     */
    public function removeAlertSubscription(AlertSubscription $alertSubscription)
    {
        if ($this->getAlertSubscriptions()->contains($alertSubscription)) {
            $this->collAlertSubscriptions->remove($this->collAlertSubscriptions->search($alertSubscription));
            if (null === $this->alertSubscriptionsScheduledForDeletion) {
                $this->alertSubscriptionsScheduledForDeletion = clone $this->collAlertSubscriptions;
                $this->alertSubscriptionsScheduledForDeletion->clear();
            }
            $this->alertSubscriptionsScheduledForDeletion[]= $alertSubscription;
        }
    }

    /**
     * Clears out the collGroups collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGroups()
     */
    public function clearGroups()
    {
        $this->collGroups = null; // important to set this to null since that means it is uninitialized
        $this->collGroupsPartial = null;
    }

    /**
     * Initializes the collGroups collection.
     *
     * By default this just sets the collGroups collection to an empty collection (like clearGroups());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initGroups()
    {
        $this->collGroups = new PropelObjectCollection();
        $this->collGroups->setModel('Group');
    }

    /**
     * Gets a collection of Group objects related by a many-to-many relationship
     * to the current object by way of the users_userGroup cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this User is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Group[] List of Group objects
     */
    public function getGroups($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collGroups || null !== $criteria) {
            if ($this->isNew() && null === $this->collGroups) {
                // return empty collection
                $this->initGroups();
            } else {
                $collGroups = GroupQuery::create(null, $criteria)
                    ->filterByUser($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collGroups;
                }
                $this->collGroups = $collGroups;
            }
        }

        return $this->collGroups;
    }

    /**
     * Sets a collection of Group objects related by a many-to-many relationship
     * to the current object by way of the users_userGroup cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $groups A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGroups(PropelCollection $groups, PropelPDO $con = null)
    {
        $this->clearGroups();
        $currentGroups = $this->getGroups();

        $this->groupsScheduledForDeletion = $currentGroups->diff($groups);

        foreach ($groups as $group) {
            if (!$currentGroups->contains($group)) {
                $this->doAddGroup($group);
            }
        }

        $this->collGroups = $groups;
    }

    /**
     * Gets the number of Group objects related by a many-to-many relationship
     * to the current object by way of the users_userGroup cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Group objects
     */
    public function countGroups($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collGroups || null !== $criteria) {
            if ($this->isNew() && null === $this->collGroups) {
                return 0;
            } else {
                $query = GroupQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByUser($this)
                    ->count($con);
            }
        } else {
            return count($this->collGroups);
        }
    }

    /**
     * Associate a Group object to this object
     * through the users_userGroup cross reference table.
     *
     * @param  Group $group The UserGroup object to relate
     * @return void
     */
    public function addGroup(Group $group)
    {
        if ($this->collGroups === null) {
            $this->initGroups();
        }
        if (!$this->collGroups->contains($group)) { // only add it if the **same** object is not already associated
            $this->doAddGroup($group);

            $this->collGroups[]= $group;
        }
    }

    /**
     * @param	Group $group The group object to add.
     */
    protected function doAddGroup($group)
    {
        $userGroup = new UserGroup();
        $userGroup->setGroup($group);
        $this->addUserGroup($userGroup);
    }

    /**
     * Remove a Group object to this object
     * through the users_userGroup cross reference table.
     *
     * @param Group $group The UserGroup object to relate
     * @return void
     */
    public function removeGroup(Group $group)
    {
        if ($this->getGroups()->contains($group)) {
            $this->collGroups->remove($this->collGroups->search($group));
            if (null === $this->groupsScheduledForDeletion) {
                $this->groupsScheduledForDeletion = clone $this->collGroups;
                $this->groupsScheduledForDeletion->clear();
            }
            $this->groupsScheduledForDeletion[]= $group;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->username = null;
        $this->password = null;
        $this->passwordupdated = null;
        $this->active = null;
        $this->created = null;
        $this->updated = null;
        $this->levelid = null;
        $this->lastlogin = null;
        $this->timezone = null;
        $this->recoveryhash = null;
        $this->recoveryhashcreatedon = null;
        $this->name = null;
        $this->surname = null;
        $this->documenttype = null;
        $this->document = null;
        $this->gender = null;
        $this->birthdate = null;
        $this->mailaddress = null;
        $this->mailaddressalt = null;
        $this->session = null;
        $this->blockedat = null;
        $this->lastaction = null;
        $this->deleted_at = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collActionLogs) {
                foreach ($this->collActionLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAlertSubscriptionUsers) {
                foreach ($this->collAlertSubscriptionUsers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collInspectors) {
                foreach ($this->collInspectors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPolicyGuidelines) {
                foreach ($this->collPolicyGuidelines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStrategicObjectives) {
                foreach ($this->collStrategicObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectives) {
                foreach ($this->collObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPolicyGuidelineLogs) {
                foreach ($this->collPolicyGuidelineLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStrategicObjectiveLogs) {
                foreach ($this->collStrategicObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveLogs) {
                foreach ($this->collObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivitys) {
                foreach ($this->collProjectActivitys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectLogs) {
                foreach ($this->collProjectLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectMilestoneLogs) {
                foreach ($this->collProjectMilestoneLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivityLogs) {
                foreach ($this->collProjectActivityLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collUserGroups) {
                foreach ($this->collUserGroups as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAlertSubscriptions) {
                foreach ($this->collAlertSubscriptions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collGroups) {
                foreach ($this->collGroups as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collActionLogs instanceof PropelCollection) {
            $this->collActionLogs->clearIterator();
        }
        $this->collActionLogs = null;
        if ($this->collAlertSubscriptionUsers instanceof PropelCollection) {
            $this->collAlertSubscriptionUsers->clearIterator();
        }
        $this->collAlertSubscriptionUsers = null;
        if ($this->collInspectors instanceof PropelCollection) {
            $this->collInspectors->clearIterator();
        }
        $this->collInspectors = null;
        if ($this->collPolicyGuidelines instanceof PropelCollection) {
            $this->collPolicyGuidelines->clearIterator();
        }
        $this->collPolicyGuidelines = null;
        if ($this->collStrategicObjectives instanceof PropelCollection) {
            $this->collStrategicObjectives->clearIterator();
        }
        $this->collStrategicObjectives = null;
        if ($this->collObjectives instanceof PropelCollection) {
            $this->collObjectives->clearIterator();
        }
        $this->collObjectives = null;
        if ($this->collPolicyGuidelineLogs instanceof PropelCollection) {
            $this->collPolicyGuidelineLogs->clearIterator();
        }
        $this->collPolicyGuidelineLogs = null;
        if ($this->collStrategicObjectiveLogs instanceof PropelCollection) {
            $this->collStrategicObjectiveLogs->clearIterator();
        }
        $this->collStrategicObjectiveLogs = null;
        if ($this->collObjectiveLogs instanceof PropelCollection) {
            $this->collObjectiveLogs->clearIterator();
        }
        $this->collObjectiveLogs = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
        if ($this->collProjectActivitys instanceof PropelCollection) {
            $this->collProjectActivitys->clearIterator();
        }
        $this->collProjectActivitys = null;
        if ($this->collProjectLogs instanceof PropelCollection) {
            $this->collProjectLogs->clearIterator();
        }
        $this->collProjectLogs = null;
        if ($this->collProjectMilestoneLogs instanceof PropelCollection) {
            $this->collProjectMilestoneLogs->clearIterator();
        }
        $this->collProjectMilestoneLogs = null;
        if ($this->collProjectActivityLogs instanceof PropelCollection) {
            $this->collProjectActivityLogs->clearIterator();
        }
        $this->collProjectActivityLogs = null;
        if ($this->collUserGroups instanceof PropelCollection) {
            $this->collUserGroups->clearIterator();
        }
        $this->collUserGroups = null;
        if ($this->collAlertSubscriptions instanceof PropelCollection) {
            $this->collAlertSubscriptions->clearIterator();
        }
        $this->collAlertSubscriptions = null;
        if ($this->collGroups instanceof PropelCollection) {
            $this->collGroups->clearIterator();
        }
        $this->collGroups = null;
        $this->aLevel = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(UserPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = UserPeer::isSoftDeleteEnabled()) {
            UserPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            UserPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     User The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = UserPeer::UPDATED_AT;

        return $this;
    }

}
