<?php


/**
 * Base class that represents a query for the 'projects_activity' table.
 *
 * Activity
 *
 * @method ProjectActivityQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectActivityQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectActivityQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectActivityQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ProjectActivityQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectActivityQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ProjectActivityQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 * @method ProjectActivityQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ProjectActivityQuery orderByUniquegoalnumeric($order = Criteria::ASC) Order by the uniqueGoalNumeric column
 * @method ProjectActivityQuery orderByGoalprogress($order = Criteria::ASC) Order by the goalProgress column
 * @method ProjectActivityQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectActivityQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ProjectActivityQuery orderByLastmodification($order = Criteria::ASC) Order by the lastModification column
 * @method ProjectActivityQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method ProjectActivityQuery orderByPlannedstart($order = Criteria::ASC) Order by the plannedStart column
 * @method ProjectActivityQuery orderByPlannedend($order = Criteria::ASC) Order by the plannedEnd column
 * @method ProjectActivityQuery orderByRealstart($order = Criteria::ASC) Order by the realStart column
 * @method ProjectActivityQuery orderByRealend($order = Criteria::ASC) Order by the realEnd column
 * @method ProjectActivityQuery orderByCancelled($order = Criteria::ASC) Order by the cancelled column
 * @method ProjectActivityQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ProjectActivityQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method ProjectActivityQuery orderByPress($order = Criteria::ASC) Order by the press column
 * @method ProjectActivityQuery orderByBudget($order = Criteria::ASC) Order by the budget column
 * @method ProjectActivityQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 * @method ProjectActivityQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ProjectActivityQuery groupById() Group by the id column
 * @method ProjectActivityQuery groupByProjectid() Group by the projectId column
 * @method ProjectActivityQuery groupByName() Group by the name column
 * @method ProjectActivityQuery groupByDescription() Group by the description column
 * @method ProjectActivityQuery groupByDate() Group by the date column
 * @method ProjectActivityQuery groupByExpirationdate() Group by the expirationDate column
 * @method ProjectActivityQuery groupByCompleted() Group by the completed column
 * @method ProjectActivityQuery groupByUpdated() Group by the updated column
 * @method ProjectActivityQuery groupByUniquegoalnumeric() Group by the uniqueGoalNumeric column
 * @method ProjectActivityQuery groupByGoalprogress() Group by the goalProgress column
 * @method ProjectActivityQuery groupByNotes() Group by the notes column
 * @method ProjectActivityQuery groupByUserid() Group by the userId column
 * @method ProjectActivityQuery groupByLastmodification() Group by the lastModification column
 * @method ProjectActivityQuery groupByChanges() Group by the changes column
 * @method ProjectActivityQuery groupByPlannedstart() Group by the plannedStart column
 * @method ProjectActivityQuery groupByPlannedend() Group by the plannedEnd column
 * @method ProjectActivityQuery groupByRealstart() Group by the realStart column
 * @method ProjectActivityQuery groupByRealend() Group by the realEnd column
 * @method ProjectActivityQuery groupByCancelled() Group by the cancelled column
 * @method ProjectActivityQuery groupByStartingyear() Group by the startingYear column
 * @method ProjectActivityQuery groupByEndingyear() Group by the endingYear column
 * @method ProjectActivityQuery groupByPress() Group by the press column
 * @method ProjectActivityQuery groupByBudget() Group by the budget column
 * @method ProjectActivityQuery groupByResponsiblecode() Group by the responsibleCode column
 * @method ProjectActivityQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ProjectActivityQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectActivityQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectActivityQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectActivityQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectActivityQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectActivityQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectActivityQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ProjectActivityQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ProjectActivityQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ProjectActivityQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ProjectActivityQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ProjectActivityQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ProjectActivityQuery leftJoinActivityDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActivityDocument relation
 * @method ProjectActivityQuery rightJoinActivityDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActivityDocument relation
 * @method ProjectActivityQuery innerJoinActivityDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ActivityDocument relation
 *
 * @method ProjectActivityQuery leftJoinProjectActivityLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivityLog relation
 * @method ProjectActivityQuery rightJoinProjectActivityLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivityLog relation
 * @method ProjectActivityQuery innerJoinProjectActivityLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivityLog relation
 *
 * @method ProjectActivity findOne(PropelPDO $con = null) Return the first ProjectActivity matching the query
 * @method ProjectActivity findOneOrCreate(PropelPDO $con = null) Return the first ProjectActivity matching the query, or a new ProjectActivity object populated from the query conditions when no match is found
 *
 * @method ProjectActivity findOneById(int $id) Return the first ProjectActivity filtered by the id column
 * @method ProjectActivity findOneByProjectid(int $projectId) Return the first ProjectActivity filtered by the projectId column
 * @method ProjectActivity findOneByName(string $name) Return the first ProjectActivity filtered by the name column
 * @method ProjectActivity findOneByDescription(string $description) Return the first ProjectActivity filtered by the description column
 * @method ProjectActivity findOneByDate(string $date) Return the first ProjectActivity filtered by the date column
 * @method ProjectActivity findOneByExpirationdate(string $expirationDate) Return the first ProjectActivity filtered by the expirationDate column
 * @method ProjectActivity findOneByCompleted(boolean $completed) Return the first ProjectActivity filtered by the completed column
 * @method ProjectActivity findOneByUpdated(string $updated) Return the first ProjectActivity filtered by the updated column
 * @method ProjectActivity findOneByUniquegoalnumeric(int $uniqueGoalNumeric) Return the first ProjectActivity filtered by the uniqueGoalNumeric column
 * @method ProjectActivity findOneByGoalprogress(int $goalProgress) Return the first ProjectActivity filtered by the goalProgress column
 * @method ProjectActivity findOneByNotes(string $notes) Return the first ProjectActivity filtered by the notes column
 * @method ProjectActivity findOneByUserid(int $userId) Return the first ProjectActivity filtered by the userId column
 * @method ProjectActivity findOneByLastmodification(string $lastModification) Return the first ProjectActivity filtered by the lastModification column
 * @method ProjectActivity findOneByChanges(int $changes) Return the first ProjectActivity filtered by the changes column
 * @method ProjectActivity findOneByPlannedstart(string $plannedStart) Return the first ProjectActivity filtered by the plannedStart column
 * @method ProjectActivity findOneByPlannedend(string $plannedEnd) Return the first ProjectActivity filtered by the plannedEnd column
 * @method ProjectActivity findOneByRealstart(string $realStart) Return the first ProjectActivity filtered by the realStart column
 * @method ProjectActivity findOneByRealend(string $realEnd) Return the first ProjectActivity filtered by the realEnd column
 * @method ProjectActivity findOneByCancelled(boolean $cancelled) Return the first ProjectActivity filtered by the cancelled column
 * @method ProjectActivity findOneByStartingyear(int $startingYear) Return the first ProjectActivity filtered by the startingYear column
 * @method ProjectActivity findOneByEndingyear(int $endingYear) Return the first ProjectActivity filtered by the endingYear column
 * @method ProjectActivity findOneByPress(boolean $press) Return the first ProjectActivity filtered by the press column
 * @method ProjectActivity findOneByBudget(double $budget) Return the first ProjectActivity filtered by the budget column
 * @method ProjectActivity findOneByResponsiblecode(int $responsibleCode) Return the first ProjectActivity filtered by the responsibleCode column
 * @method ProjectActivity findOneByDeletedAt(string $deleted_at) Return the first ProjectActivity filtered by the deleted_at column
 *
 * @method array findById(int $id) Return ProjectActivity objects filtered by the id column
 * @method array findByProjectid(int $projectId) Return ProjectActivity objects filtered by the projectId column
 * @method array findByName(string $name) Return ProjectActivity objects filtered by the name column
 * @method array findByDescription(string $description) Return ProjectActivity objects filtered by the description column
 * @method array findByDate(string $date) Return ProjectActivity objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return ProjectActivity objects filtered by the expirationDate column
 * @method array findByCompleted(boolean $completed) Return ProjectActivity objects filtered by the completed column
 * @method array findByUpdated(string $updated) Return ProjectActivity objects filtered by the updated column
 * @method array findByUniquegoalnumeric(int $uniqueGoalNumeric) Return ProjectActivity objects filtered by the uniqueGoalNumeric column
 * @method array findByGoalprogress(int $goalProgress) Return ProjectActivity objects filtered by the goalProgress column
 * @method array findByNotes(string $notes) Return ProjectActivity objects filtered by the notes column
 * @method array findByUserid(int $userId) Return ProjectActivity objects filtered by the userId column
 * @method array findByLastmodification(string $lastModification) Return ProjectActivity objects filtered by the lastModification column
 * @method array findByChanges(int $changes) Return ProjectActivity objects filtered by the changes column
 * @method array findByPlannedstart(string $plannedStart) Return ProjectActivity objects filtered by the plannedStart column
 * @method array findByPlannedend(string $plannedEnd) Return ProjectActivity objects filtered by the plannedEnd column
 * @method array findByRealstart(string $realStart) Return ProjectActivity objects filtered by the realStart column
 * @method array findByRealend(string $realEnd) Return ProjectActivity objects filtered by the realEnd column
 * @method array findByCancelled(boolean $cancelled) Return ProjectActivity objects filtered by the cancelled column
 * @method array findByStartingyear(int $startingYear) Return ProjectActivity objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return ProjectActivity objects filtered by the endingYear column
 * @method array findByPress(boolean $press) Return ProjectActivity objects filtered by the press column
 * @method array findByBudget(double $budget) Return ProjectActivity objects filtered by the budget column
 * @method array findByResponsiblecode(int $responsibleCode) Return ProjectActivity objects filtered by the responsibleCode column
 * @method array findByDeletedAt(string $deleted_at) Return ProjectActivity objects filtered by the deleted_at column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectActivityQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseProjectActivityQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectActivity', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectActivityQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectActivityQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectActivityQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectActivityQuery) {
            return $criteria;
        }
        $query = new ProjectActivityQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectActivity|ProjectActivity[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectActivityPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectActivity A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `PROJECTID`, `NAME`, `DESCRIPTION`, `DATE`, `EXPIRATIONDATE`, `COMPLETED`, `UPDATED`, `UNIQUEGOALNUMERIC`, `GOALPROGRESS`, `NOTES`, `USERID`, `LASTMODIFICATION`, `CHANGES`, `PLANNEDSTART`, `PLANNEDEND`, `REALSTART`, `REALEND`, `CANCELLED`, `STARTINGYEAR`, `ENDINGYEAR`, `PRESS`, `BUDGET`, `RESPONSIBLECODE`, `DELETED_AT` FROM `projects_activity` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectActivity();
            $obj->hydrate($row);
            ProjectActivityPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectActivity|ProjectActivity[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectActivity[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectActivityPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectActivityPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectActivityPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(true); // WHERE completed = true
     * $query->filterByCompleted('yes'); // WHERE completed = true
     * </code>
     *
     * @param     boolean|string $completed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, $comparison = null)
    {
        if (is_string($completed)) {
            $completed = in_array(strtolower($completed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityPeer::COMPLETED, $completed, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the uniqueGoalNumeric column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoalnumeric(1234); // WHERE uniqueGoalNumeric = 1234
     * $query->filterByUniquegoalnumeric(array(12, 34)); // WHERE uniqueGoalNumeric IN (12, 34)
     * $query->filterByUniquegoalnumeric(array('min' => 12)); // WHERE uniqueGoalNumeric > 12
     * </code>
     *
     * @param     mixed $uniquegoalnumeric The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByUniquegoalnumeric($uniquegoalnumeric = null, $comparison = null)
    {
        if (is_array($uniquegoalnumeric)) {
            $useMinMax = false;
            if (isset($uniquegoalnumeric['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uniquegoalnumeric['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric, $comparison);
    }

    /**
     * Filter the query on the goalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalprogress(1234); // WHERE goalProgress = 1234
     * $query->filterByGoalprogress(array(12, 34)); // WHERE goalProgress IN (12, 34)
     * $query->filterByGoalprogress(array('min' => 12)); // WHERE goalProgress > 12
     * </code>
     *
     * @param     mixed $goalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByGoalprogress($goalprogress = null, $comparison = null)
    {
        if (is_array($goalprogress)) {
            $useMinMax = false;
            if (isset($goalprogress['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::GOALPROGRESS, $goalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalprogress['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::GOALPROGRESS, $goalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::GOALPROGRESS, $goalprogress, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the lastModification column
     *
     * Example usage:
     * <code>
     * $query->filterByLastmodification('2011-03-14'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification('now'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification(array('max' => 'yesterday')); // WHERE lastModification > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastmodification The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByLastmodification($lastmodification = null, $comparison = null)
    {
        if (is_array($lastmodification)) {
            $useMinMax = false;
            if (isset($lastmodification['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::LASTMODIFICATION, $lastmodification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastmodification['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::LASTMODIFICATION, $lastmodification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::LASTMODIFICATION, $lastmodification, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the plannedStart column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedstart('2011-03-14'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart('now'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart(array('max' => 'yesterday')); // WHERE plannedStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByPlannedstart($plannedstart = null, $comparison = null)
    {
        if (is_array($plannedstart)) {
            $useMinMax = false;
            if (isset($plannedstart['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::PLANNEDSTART, $plannedstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedstart['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::PLANNEDSTART, $plannedstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::PLANNEDSTART, $plannedstart, $comparison);
    }

    /**
     * Filter the query on the plannedEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedend('2011-03-14'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend('now'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend(array('max' => 'yesterday')); // WHERE plannedEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByPlannedend($plannedend = null, $comparison = null)
    {
        if (is_array($plannedend)) {
            $useMinMax = false;
            if (isset($plannedend['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::PLANNEDEND, $plannedend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedend['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::PLANNEDEND, $plannedend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::PLANNEDEND, $plannedend, $comparison);
    }

    /**
     * Filter the query on the realStart column
     *
     * Example usage:
     * <code>
     * $query->filterByRealstart('2011-03-14'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart('now'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart(array('max' => 'yesterday')); // WHERE realStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $realstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByRealstart($realstart = null, $comparison = null)
    {
        if (is_array($realstart)) {
            $useMinMax = false;
            if (isset($realstart['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::REALSTART, $realstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realstart['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::REALSTART, $realstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::REALSTART, $realstart, $comparison);
    }

    /**
     * Filter the query on the realEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByRealend('2011-03-14'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend('now'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend(array('max' => 'yesterday')); // WHERE realEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $realend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByRealend($realend = null, $comparison = null)
    {
        if (is_array($realend)) {
            $useMinMax = false;
            if (isset($realend['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::REALEND, $realend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realend['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::REALEND, $realend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::REALEND, $realend, $comparison);
    }

    /**
     * Filter the query on the cancelled column
     *
     * Example usage:
     * <code>
     * $query->filterByCancelled(true); // WHERE cancelled = true
     * $query->filterByCancelled('yes'); // WHERE cancelled = true
     * </code>
     *
     * @param     boolean|string $cancelled The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByCancelled($cancelled = null, $comparison = null)
    {
        if (is_string($cancelled)) {
            $cancelled = in_array(strtolower($cancelled), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityPeer::CANCELLED, $cancelled, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the press column
     *
     * Example usage:
     * <code>
     * $query->filterByPress(true); // WHERE press = true
     * $query->filterByPress('yes'); // WHERE press = true
     * </code>
     *
     * @param     boolean|string $press The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByPress($press = null, $comparison = null)
    {
        if (is_string($press)) {
            $press = in_array(strtolower($press), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityPeer::PRESS, $press, $comparison);
    }

    /**
     * Filter the query on the budget column
     *
     * Example usage:
     * <code>
     * $query->filterByBudget(1234); // WHERE budget = 1234
     * $query->filterByBudget(array(12, 34)); // WHERE budget IN (12, 34)
     * $query->filterByBudget(array('min' => 12)); // WHERE budget > 12
     * </code>
     *
     * @param     mixed $budget The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByBudget($budget = null, $comparison = null)
    {
        if (is_array($budget)) {
            $useMinMax = false;
            if (isset($budget['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::BUDGET, $budget['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budget['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::BUDGET, $budget['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::BUDGET, $budget, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ProjectActivityPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ProjectActivityPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectActivityPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ProjectActivityPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ProjectActivityPeer::RESPONSIBLECODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityPeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Filter the query by a related ActivityDocument object
     *
     * @param   ActivityDocument|PropelObjectCollection $activityDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActivityDocument($activityDocument, $comparison = null)
    {
        if ($activityDocument instanceof ActivityDocument) {
            return $this
                ->addUsingAlias(ProjectActivityPeer::ID, $activityDocument->getActivityId(), $comparison);
        } elseif ($activityDocument instanceof PropelObjectCollection) {
            return $this
                ->useActivityDocumentQuery()
                ->filterByPrimaryKeys($activityDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActivityDocument() only accepts arguments of type ActivityDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActivityDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function joinActivityDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActivityDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActivityDocument');
        }

        return $this;
    }

    /**
     * Use the ActivityDocument relation ActivityDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActivityDocumentQuery A secondary query class using the current class as primary query
     */
    public function useActivityDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActivityDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActivityDocument', 'ActivityDocumentQuery');
    }

    /**
     * Filter the query by a related ProjectActivityLog object
     *
     * @param   ProjectActivityLog|PropelObjectCollection $projectActivityLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivityLog($projectActivityLog, $comparison = null)
    {
        if ($projectActivityLog instanceof ProjectActivityLog) {
            return $this
                ->addUsingAlias(ProjectActivityPeer::ID, $projectActivityLog->getActivityid(), $comparison);
        } elseif ($projectActivityLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectActivityLogQuery()
                ->filterByPrimaryKeys($projectActivityLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectActivityLog() only accepts arguments of type ProjectActivityLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivityLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function joinProjectActivityLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivityLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivityLog');
        }

        return $this;
    }

    /**
     * Use the ProjectActivityLog relation ProjectActivityLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectActivityLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivityLog', 'ProjectActivityLogQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the projects_activityDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useActivityDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectActivity $projectActivity Object to remove from the list of results
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function prune($projectActivity = null)
    {
        if ($projectActivity) {
            $this->addUsingAlias(ProjectActivityPeer::ID, $projectActivity->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ProjectActivityPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ProjectActivityPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ProjectActivityQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ProjectActivityQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ProjectActivityQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ProjectActivityPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ProjectActivityPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
