<?php
/**
 * ProjectsListAction
 *
 * Listado de proyectos extendiendo BaseListAction
 *
 * @package projects
 * @author Pais Digital
 * @copyright Copyright (c) 2016, Egytca
 */

class ProjectsListAction extends BaseListAction {

	/**
 	* Constructor
 	*/
	function __construct($entityClassName = 'Project') {
		parent::__construct($entityClassName);
	}

	function preList() {
		parent::preList();


		if (!empty($_GET['filters']['dateFrom']))
			$this->query->filterByDateFrom($_GET['filters']['dateFrom']);
		
		if (!empty($_GET['filters']['dateTo']))
			$this->query->filterByDateTo($_GET['filters']['dateTo']);

		if (!empty($_GET['filters']['status']))
			$this->query->filterByStatus($_GET['filters']['status']);

		// filtro por region uso ProjectRegionQuery
		if (!empty($_GET['filters']['region']))
			$this->query->useProjectRegionQuery()
							->filterByRegionId($_GET['filters']['region'])
						->endUse();

		// filtro que incluye dependencias
		// es importante controlar que venga el responsibleCode porque el findOneByCode, va a devolver un resultado
		// por mas que no se le haya pasado nada.
		if (!empty($_GET['filters']['includeDependents']) && isset($_GET['filters']['responsibleCode'])) {			
			$position = PositionQuery::create()->findOneByCode($_GET['filters']['responsibleCode']);
			$this->query->filterByResponsiblecode($position->getCodeWithDescendants(), Criteria::IN);

			// elimino filtro por position.
			unset($this->filters['responsibleCode']);
		}
			
	}

	function postList() {
		parent::postList();			

		if (ConfigModule::get("projects","useRegions"))
			$this->smarty->assign("regions", RegionQuery::create()->find());

		if ($this->module['useComunes']['value'] == "YES")
		 	$this->smarty->assign("communes",TableroCommuneQuery::create()->find());

		$this->smarty->assign("priorityTypes", Project::getPriorities());

		$this->smarty->assign("positions", PositionQuery::create()->find());

		if ($this->filters['fromObjectives']){
			$objective = ObjectiveQuery::create()->findPk($this->filters['objective']);
			if (is_object($objective))
				$this->smarty->assign("parentObject",$objective);
		}

		$this->smarty->assign('includeJQuery', true);
	}

}
