<?php


/**
 * Base static class for performing query and update operations on the 'positions_position' table.
 *
 * Cargos
 *
 * @package propel.generator.positions.classes.om
 */
abstract class BasePositionPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'positions_position';

    /** the related Propel class for this table */
    const OM_CLASS = 'Position';

    /** the related TableMap class for this table */
    const TM_CLASS = 'PositionTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 23;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 23;

    /** the column name for the ID field */
    const ID = 'positions_position.ID';

    /** the column name for the NAME field */
    const NAME = 'positions_position.NAME';

    /** the column name for the CODE field */
    const CODE = 'positions_position.CODE';

    /** the column name for the USERGROUPID field */
    const USERGROUPID = 'positions_position.USERGROUPID';

    /** the column name for the VERSIONID field */
    const VERSIONID = 'positions_position.VERSIONID';

    /** the column name for the INTERNALCODE field */
    const INTERNALCODE = 'positions_position.INTERNALCODE';

    /** the column name for the OWNERNAME field */
    const OWNERNAME = 'positions_position.OWNERNAME';

    /** the column name for the OWNERNAMEFEMALE field */
    const OWNERNAMEFEMALE = 'positions_position.OWNERNAMEFEMALE';

    /** the column name for the TYPE field */
    const TYPE = 'positions_position.TYPE';

    /** the column name for the KIND field */
    const KIND = 'positions_position.KIND';

    /** the column name for the ADDRESS field */
    const ADDRESS = 'positions_position.ADDRESS';

    /** the column name for the TELEPHONE field */
    const TELEPHONE = 'positions_position.TELEPHONE';

    /** the column name for the EMAIL field */
    const EMAIL = 'positions_position.EMAIL';

    /** the column name for the BUDGET field */
    const BUDGET = 'positions_position.BUDGET';

    /** the column name for the PERSONNEL field */
    const PERSONNEL = 'positions_position.PERSONNEL';

    /** the column name for the HIRED field */
    const HIRED = 'positions_position.HIRED';

    /** the column name for the CONSULTANT field */
    const CONSULTANT = 'positions_position.CONSULTANT';

    /** the column name for the OTHER field */
    const OTHER = 'positions_position.OTHER';

    /** the column name for the PLANNING field */
    const PLANNING = 'positions_position.PLANNING';

    /** the column name for the ORDER field */
    const ORDER = 'positions_position.ORDER';

    /** the column name for the TREE_LEFT field */
    const TREE_LEFT = 'positions_position.TREE_LEFT';

    /** the column name for the TREE_RIGHT field */
    const TREE_RIGHT = 'positions_position.TREE_RIGHT';

    /** the column name for the TREE_LEVEL field */
    const TREE_LEVEL = 'positions_position.TREE_LEVEL';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Position objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Position[]
     */
    public static $instances = array();


    // nested_set behavior

    /**
     * Left column for the set
     */
    const LEFT_COL = 'positions_position.TREE_LEFT';

    /**
     * Right column for the set
     */
    const RIGHT_COL = 'positions_position.TREE_RIGHT';

    /**
     * Level column for the set
     */
    const LEVEL_COL = 'positions_position.TREE_LEVEL';

    /**
     * Scope column for the set
     */
    const SCOPE_COL = 'positions_position.VERSIONID';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. PositionPeer::$fieldNames[PositionPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Code', 'Usergroupid', 'Versionid', 'Internalcode', 'Ownername', 'Ownernamefemale', 'Type', 'Kind', 'Address', 'Telephone', 'Email', 'Budget', 'Personnel', 'Hired', 'Consultant', 'Other', 'Planning', 'Order', 'TreeLeft', 'TreeRight', 'TreeLevel', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'code', 'usergroupid', 'versionid', 'internalcode', 'ownername', 'ownernamefemale', 'type', 'kind', 'address', 'telephone', 'email', 'budget', 'personnel', 'hired', 'consultant', 'other', 'planning', 'order', 'treeLeft', 'treeRight', 'treeLevel', ),
        BasePeer::TYPE_COLNAME => array (PositionPeer::ID, PositionPeer::NAME, PositionPeer::CODE, PositionPeer::USERGROUPID, PositionPeer::VERSIONID, PositionPeer::INTERNALCODE, PositionPeer::OWNERNAME, PositionPeer::OWNERNAMEFEMALE, PositionPeer::TYPE, PositionPeer::KIND, PositionPeer::ADDRESS, PositionPeer::TELEPHONE, PositionPeer::EMAIL, PositionPeer::BUDGET, PositionPeer::PERSONNEL, PositionPeer::HIRED, PositionPeer::CONSULTANT, PositionPeer::OTHER, PositionPeer::PLANNING, PositionPeer::ORDER, PositionPeer::TREE_LEFT, PositionPeer::TREE_RIGHT, PositionPeer::TREE_LEVEL, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'CODE', 'USERGROUPID', 'VERSIONID', 'INTERNALCODE', 'OWNERNAME', 'OWNERNAMEFEMALE', 'TYPE', 'KIND', 'ADDRESS', 'TELEPHONE', 'EMAIL', 'BUDGET', 'PERSONNEL', 'HIRED', 'CONSULTANT', 'OTHER', 'PLANNING', 'ORDER', 'TREE_LEFT', 'TREE_RIGHT', 'TREE_LEVEL', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'code', 'userGroupId', 'versionId', 'internalCode', 'ownerName', 'ownerNameFemale', 'type', 'kind', 'address', 'telephone', 'email', 'budget', 'personnel', 'hired', 'consultant', 'other', 'planning', 'order', 'tree_left', 'tree_right', 'tree_level', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. PositionPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Code' => 2, 'Usergroupid' => 3, 'Versionid' => 4, 'Internalcode' => 5, 'Ownername' => 6, 'Ownernamefemale' => 7, 'Type' => 8, 'Kind' => 9, 'Address' => 10, 'Telephone' => 11, 'Email' => 12, 'Budget' => 13, 'Personnel' => 14, 'Hired' => 15, 'Consultant' => 16, 'Other' => 17, 'Planning' => 18, 'Order' => 19, 'TreeLeft' => 20, 'TreeRight' => 21, 'TreeLevel' => 22, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'code' => 2, 'usergroupid' => 3, 'versionid' => 4, 'internalcode' => 5, 'ownername' => 6, 'ownernamefemale' => 7, 'type' => 8, 'kind' => 9, 'address' => 10, 'telephone' => 11, 'email' => 12, 'budget' => 13, 'personnel' => 14, 'hired' => 15, 'consultant' => 16, 'other' => 17, 'planning' => 18, 'order' => 19, 'treeLeft' => 20, 'treeRight' => 21, 'treeLevel' => 22, ),
        BasePeer::TYPE_COLNAME => array (PositionPeer::ID => 0, PositionPeer::NAME => 1, PositionPeer::CODE => 2, PositionPeer::USERGROUPID => 3, PositionPeer::VERSIONID => 4, PositionPeer::INTERNALCODE => 5, PositionPeer::OWNERNAME => 6, PositionPeer::OWNERNAMEFEMALE => 7, PositionPeer::TYPE => 8, PositionPeer::KIND => 9, PositionPeer::ADDRESS => 10, PositionPeer::TELEPHONE => 11, PositionPeer::EMAIL => 12, PositionPeer::BUDGET => 13, PositionPeer::PERSONNEL => 14, PositionPeer::HIRED => 15, PositionPeer::CONSULTANT => 16, PositionPeer::OTHER => 17, PositionPeer::PLANNING => 18, PositionPeer::ORDER => 19, PositionPeer::TREE_LEFT => 20, PositionPeer::TREE_RIGHT => 21, PositionPeer::TREE_LEVEL => 22, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'CODE' => 2, 'USERGROUPID' => 3, 'VERSIONID' => 4, 'INTERNALCODE' => 5, 'OWNERNAME' => 6, 'OWNERNAMEFEMALE' => 7, 'TYPE' => 8, 'KIND' => 9, 'ADDRESS' => 10, 'TELEPHONE' => 11, 'EMAIL' => 12, 'BUDGET' => 13, 'PERSONNEL' => 14, 'HIRED' => 15, 'CONSULTANT' => 16, 'OTHER' => 17, 'PLANNING' => 18, 'ORDER' => 19, 'TREE_LEFT' => 20, 'TREE_RIGHT' => 21, 'TREE_LEVEL' => 22, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'code' => 2, 'userGroupId' => 3, 'versionId' => 4, 'internalCode' => 5, 'ownerName' => 6, 'ownerNameFemale' => 7, 'type' => 8, 'kind' => 9, 'address' => 10, 'telephone' => 11, 'email' => 12, 'budget' => 13, 'personnel' => 14, 'hired' => 15, 'consultant' => 16, 'other' => 17, 'planning' => 18, 'order' => 19, 'tree_left' => 20, 'tree_right' => 21, 'tree_level' => 22, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = PositionPeer::getFieldNames($toType);
        $key = isset(PositionPeer::$fieldKeys[$fromType][$name]) ? PositionPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(PositionPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, PositionPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return PositionPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. PositionPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(PositionPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PositionPeer::ID);
            $criteria->addSelectColumn(PositionPeer::NAME);
            $criteria->addSelectColumn(PositionPeer::CODE);
            $criteria->addSelectColumn(PositionPeer::USERGROUPID);
            $criteria->addSelectColumn(PositionPeer::VERSIONID);
            $criteria->addSelectColumn(PositionPeer::INTERNALCODE);
            $criteria->addSelectColumn(PositionPeer::OWNERNAME);
            $criteria->addSelectColumn(PositionPeer::OWNERNAMEFEMALE);
            $criteria->addSelectColumn(PositionPeer::TYPE);
            $criteria->addSelectColumn(PositionPeer::KIND);
            $criteria->addSelectColumn(PositionPeer::ADDRESS);
            $criteria->addSelectColumn(PositionPeer::TELEPHONE);
            $criteria->addSelectColumn(PositionPeer::EMAIL);
            $criteria->addSelectColumn(PositionPeer::BUDGET);
            $criteria->addSelectColumn(PositionPeer::PERSONNEL);
            $criteria->addSelectColumn(PositionPeer::HIRED);
            $criteria->addSelectColumn(PositionPeer::CONSULTANT);
            $criteria->addSelectColumn(PositionPeer::OTHER);
            $criteria->addSelectColumn(PositionPeer::PLANNING);
            $criteria->addSelectColumn(PositionPeer::ORDER);
            $criteria->addSelectColumn(PositionPeer::TREE_LEFT);
            $criteria->addSelectColumn(PositionPeer::TREE_RIGHT);
            $criteria->addSelectColumn(PositionPeer::TREE_LEVEL);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.CODE');
            $criteria->addSelectColumn($alias . '.USERGROUPID');
            $criteria->addSelectColumn($alias . '.VERSIONID');
            $criteria->addSelectColumn($alias . '.INTERNALCODE');
            $criteria->addSelectColumn($alias . '.OWNERNAME');
            $criteria->addSelectColumn($alias . '.OWNERNAMEFEMALE');
            $criteria->addSelectColumn($alias . '.TYPE');
            $criteria->addSelectColumn($alias . '.KIND');
            $criteria->addSelectColumn($alias . '.ADDRESS');
            $criteria->addSelectColumn($alias . '.TELEPHONE');
            $criteria->addSelectColumn($alias . '.EMAIL');
            $criteria->addSelectColumn($alias . '.BUDGET');
            $criteria->addSelectColumn($alias . '.PERSONNEL');
            $criteria->addSelectColumn($alias . '.HIRED');
            $criteria->addSelectColumn($alias . '.CONSULTANT');
            $criteria->addSelectColumn($alias . '.OTHER');
            $criteria->addSelectColumn($alias . '.PLANNING');
            $criteria->addSelectColumn($alias . '.ORDER');
            $criteria->addSelectColumn($alias . '.TREE_LEFT');
            $criteria->addSelectColumn($alias . '.TREE_RIGHT');
            $criteria->addSelectColumn($alias . '.TREE_LEVEL');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(PositionPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Position
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = PositionPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return PositionPeer::populateObjects(PositionPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            PositionPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Position $obj A Position object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            PositionPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Position object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Position) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Position object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(PositionPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Position Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(PositionPeer::$instances[$key])) {
                return PositionPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        PositionPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to positions_position
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in IndicatorPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorPeer::clearInstancePool();
        // Invalidate objects in PositionDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PositionDocumentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = PositionPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = PositionPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PositionPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Position object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = PositionPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + PositionPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PositionPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            PositionPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Group table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinGroup(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PositionVersion table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPositionVersion(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Position objects pre-filled with their Group objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Position objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinGroup(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PositionPeer::DATABASE_NAME);
        }

        PositionPeer::addSelectColumns($criteria);
        $startcol = PositionPeer::NUM_HYDRATE_COLUMNS;
        GroupPeer::addSelectColumns($criteria);

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PositionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = PositionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PositionPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = GroupPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = GroupPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = GroupPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    GroupPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Position) to $obj2 (Group)
                $obj2->addPosition($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Position objects pre-filled with their PositionVersion objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Position objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPositionVersion(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PositionPeer::DATABASE_NAME);
        }

        PositionPeer::addSelectColumns($criteria);
        $startcol = PositionPeer::NUM_HYDRATE_COLUMNS;
        PositionVersionPeer::addSelectColumns($criteria);

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PositionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = PositionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PositionPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionVersionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionVersionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionVersionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionVersionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Position) to $obj2 (PositionVersion)
                $obj2->addPosition($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Position objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Position objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PositionPeer::DATABASE_NAME);
        }

        PositionPeer::addSelectColumns($criteria);
        $startcol2 = PositionPeer::NUM_HYDRATE_COLUMNS;

        GroupPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + GroupPeer::NUM_HYDRATE_COLUMNS;

        PositionVersionPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PositionVersionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PositionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = PositionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PositionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Group rows

            $key2 = GroupPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = GroupPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = GroupPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    GroupPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Position) to the collection in $obj2 (Group)
                $obj2->addPosition($obj1);
            } // if joined row not null

            // Add objects for joined PositionVersion rows

            $key3 = PositionVersionPeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = PositionVersionPeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = PositionVersionPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PositionVersionPeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (Position) to the collection in $obj3 (PositionVersion)
                $obj3->addPosition($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Group table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptGroup(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PositionVersion table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPositionVersion(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(PositionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            PositionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Position objects pre-filled with all related objects except Group.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Position objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptGroup(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PositionPeer::DATABASE_NAME);
        }

        PositionPeer::addSelectColumns($criteria);
        $startcol2 = PositionPeer::NUM_HYDRATE_COLUMNS;

        PositionVersionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + PositionVersionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(PositionPeer::VERSIONID, PositionVersionPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PositionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = PositionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PositionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined PositionVersion rows

                $key2 = PositionVersionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = PositionVersionPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = PositionVersionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    PositionVersionPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Position) to the collection in $obj2 (PositionVersion)
                $obj2->addPosition($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Position objects pre-filled with all related objects except PositionVersion.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Position objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPositionVersion(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(PositionPeer::DATABASE_NAME);
        }

        PositionPeer::addSelectColumns($criteria);
        $startcol2 = PositionPeer::NUM_HYDRATE_COLUMNS;

        GroupPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + GroupPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(PositionPeer::USERGROUPID, GroupPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = PositionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = PositionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                PositionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Group rows

                $key2 = GroupPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = GroupPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = GroupPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    GroupPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Position) to the collection in $obj2 (Group)
                $obj2->addPosition($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(PositionPeer::DATABASE_NAME)->getTable(PositionPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BasePositionPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BasePositionPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new PositionTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return PositionPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a Position or Criteria object.
     *
     * @param      mixed $values Criteria or Position object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Position object
        }

        if ($criteria->containsKey(PositionPeer::ID) && $criteria->keyContainsValue(PositionPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PositionPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Position or Criteria object.
     *
     * @param      mixed $values Criteria or Position object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(PositionPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(PositionPeer::ID);
            $value = $criteria->remove(PositionPeer::ID);
            if ($value) {
                $selectCriteria->add(PositionPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(PositionPeer::TABLE_NAME);
            }

        } else { // $values is Position object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the positions_position table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += PositionPeer::doOnDeleteCascade(new Criteria(PositionPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(PositionPeer::TABLE_NAME, $con, PositionPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PositionPeer::clearInstancePool();
            PositionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Position or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Position object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Position) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PositionPeer::DATABASE_NAME);
            $criteria->add(PositionPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(PositionPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += PositionPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                PositionPeer::clearInstancePool();
            } elseif ($values instanceof Position) { // it's a model object
                PositionPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    PositionPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            PositionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = PositionPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related Indicator objects
            $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);

            $criteria->add(IndicatorPeer::POSITIONID, $obj->getId());
            $affectedRows += IndicatorPeer::doDelete($criteria, $con);

            // delete related PositionDocument objects
            $criteria = new Criteria(PositionDocumentPeer::DATABASE_NAME);

            $criteria->add(PositionDocumentPeer::POSITIONID, $obj->getId());
            $affectedRows += PositionDocumentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Position object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Position $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(PositionPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(PositionPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(PositionPeer::DATABASE_NAME, PositionPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Position
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = PositionPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(PositionPeer::DATABASE_NAME);
        $criteria->add(PositionPeer::ID, $pk);

        $v = PositionPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Position[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(PositionPeer::DATABASE_NAME);
            $criteria->add(PositionPeer::ID, $pks, Criteria::IN);
            $objs = PositionPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // nested_set behavior

    /**
     * Returns the root nodes for the tree
     *
     * @param      PropelPDO $con	Connection to use.
     * @return     Position			Propel object for root node
     */
    public static function retrieveRoots(Criteria $criteria = null, PropelPDO $con = null)
    {
        if ($criteria === null) {
            $criteria = new Criteria(PositionPeer::DATABASE_NAME);
        }
        $criteria->add(PositionPeer::LEFT_COL, 1, Criteria::EQUAL);

        return PositionPeer::doSelect($criteria, $con);
    }

    /**
     * Returns the root node for a given scope
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     * @return     Position			Propel object for root node
     */
    public static function retrieveRoot($scope = null, PropelPDO $con = null)
    {
        $c = new Criteria(PositionPeer::DATABASE_NAME);
        $c->add(PositionPeer::LEFT_COL, 1, Criteria::EQUAL);
        $c->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return PositionPeer::doSelectOne($c, $con);
    }

    /**
     * Returns the whole tree node for a given scope
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      Criteria $criteria	Optional Criteria to filter the query
     * @param      PropelPDO $con	Connection to use.
     * @return     Position			Propel object for root node
     */
    public static function retrieveTree($scope = null, Criteria $criteria = null, PropelPDO $con = null)
    {
        if ($criteria === null) {
            $criteria = new Criteria(PositionPeer::DATABASE_NAME);
        }
        $criteria->addAscendingOrderByColumn(PositionPeer::LEFT_COL);
        $criteria->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return PositionPeer::doSelect($criteria, $con);
    }

    /**
     * Tests if node is valid
     *
     * @param      Position $node	Propel object for src node
     * @return     bool
     */
    public static function isValid(Position $node = null)
    {
        if (is_object($node) && $node->getRightValue() > $node->getLeftValue()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Delete an entire tree
     *
     * @param      int $scope		Scope to determine which tree to delete
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     int  The number of deleted nodes
     */
    public static function deleteTree($scope = null, PropelPDO $con = null)
    {
        $c = new Criteria(PositionPeer::DATABASE_NAME);
        $c->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return PositionPeer::doDelete($c, $con);
    }

    /**
     * Adds $delta to all L and R values that are >= $first and <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted (optional)
     * @param      int $scope		Scope to use for the shift
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftRLValues($delta, $first, $last = null, $scope = null, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        // Shift left column values
        $whereCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(PositionPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(PositionPeer::LEFT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);
        $whereCriteria->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $valuesCriteria->add(PositionPeer::LEFT_COL, array('raw' => PositionPeer::LEFT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);

        // Shift right column values
        $whereCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(PositionPeer::RIGHT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(PositionPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);
        $whereCriteria->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $valuesCriteria->add(PositionPeer::RIGHT_COL, array('raw' => PositionPeer::RIGHT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Adds $delta to level for nodes having left value >= $first and right value <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted
     * @param      int $scope		Scope to use for the shift
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftLevel($delta, $first, $last, $scope = null, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $whereCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $whereCriteria->add(PositionPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        $whereCriteria->add(PositionPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL);
        $whereCriteria->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(PositionPeer::DATABASE_NAME);
        $valuesCriteria->add(PositionPeer::LEVEL_COL, array('raw' => PositionPeer::LEVEL_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Reload all already loaded nodes to sync them with updated db
     *
     * @param      Position $prune		Object to prune from the update
     * @param      PropelPDO $con		Connection to use.
     */
    public static function updateLoadedNodes($prune = null, PropelPDO $con = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            $keys = array();
            foreach (PositionPeer::$instances as $obj) {
                if (!$prune || !$prune->equals($obj)) {
                    $keys[] = $obj->getPrimaryKey();
                }
            }

            if (!empty($keys)) {
                // We don't need to alter the object instance pool; we're just modifying these ones
                // already in the pool.
                $criteria = new Criteria(PositionPeer::DATABASE_NAME);
                $criteria->add(PositionPeer::ID, $keys, Criteria::IN);
                $stmt = PositionPeer::doSelectStmt($criteria, $con);
                while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
                    $key = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
                    if (null !== ($object = PositionPeer::getInstanceFromPool($key))) {
                        $object->setLeftValue($row[20]);
                        $object->setRightValue($row[21]);
                        $object->setLevel($row[22]);
                        $object->clearNestedSetChildren();
                    }
                }
                $stmt->closeCursor();
            }
        }
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      int $left	left column value
     * @param      integer $scope	scope column value
     * @param      mixed $prune	Object to prune from the shift
     * @param      PropelPDO $con	Connection to use.
     */
    public static function makeRoomForLeaf($left, $scope, $prune = null, PropelPDO $con = null)
    {
        // Update database nodes
        PositionPeer::shiftRLValues(2, $left, null, $scope, $con);

        // Update all loaded nodes
        PositionPeer::updateLoadedNodes($prune, $con);
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      integer $scope	scope column value
     * @param      PropelPDO $con	Connection to use.
     */
    public static function fixLevels($scope, PropelPDO $con = null)
    {
        $c = new Criteria();
        $c->add(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);
        $c->addAscendingOrderByColumn(PositionPeer::LEFT_COL);
        $stmt = PositionPeer::doSelectStmt($c, $con);

        // set the class once to avoid overhead in the loop
        $cls = PositionPeer::getOMClass(false);
        $level = null;
        // iterate over the statement
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {

            // hydrate object
            $key = PositionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null === ($obj = PositionPeer::getInstanceFromPool($key))) {
                $obj = new $cls();
                $obj->hydrate($row);
                PositionPeer::addInstanceToPool($obj, $key);
            }

            // compute level
            // Algorithm shamelessly stolen from sfPropelActAsNestedSetBehaviorPlugin
            // Probably authored by Tristan Rivoallan
            if ($level === null) {
                $level = 0;
                $i = 0;
                $prev = array($obj->getRightValue());
            } else {
                while ($obj->getRightValue() > $prev[$i]) {
                    $i--;
                }
                $level = ++$i;
                $prev[$i] = $obj->getRightValue();
            }

            // update level in node if necessary
            if ($obj->getLevel() !== $level) {
                $obj->setLevel($level);
                $obj->save($con);
            }
        }
        $stmt->closeCursor();
    }

} // BasePositionPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BasePositionPeer::buildTableMap();

