<?php



/**
 * This class defines the structure of the 'panel_guarantee' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.panel.classes.map
 */
class GuaranteeTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'panel.classes.map.GuaranteeTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('panel_guarantee');
        $this->setPhpName('Guarantee');
        $this->setClassname('Guarantee');
        $this->setPackage('panel.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('CODE', 'Code', 'CHAR', false, 80, null);
        $this->addColumn('TYPE', 'Type', 'INTEGER', false, null, null);
        $this->addForeignKey('PROJECTID', 'Projectid', 'INTEGER', 'projects_project', 'ID', false, null, null);
        $this->addForeignKey('CONTRACTORID', 'Contractorid', 'INTEGER', 'panel_contractor', 'ID', false, null, null);
        $this->addColumn('ISSUER', 'Issuer', 'CHAR', true, 125, null);
        $this->addColumn('CURRENCY', 'Currency', 'INTEGER', false, null, null);
        $this->addColumn('AMMOUNT', 'Ammount', 'DECIMAL', false, 12, null);
        $this->addColumn('ISSUEDATE', 'Issuedate', 'DATE', true, null, null);
        $this->addColumn('EXPIRATIONTYPE', 'Expirationtype', 'INTEGER', false, null, null);
        $this->addColumn('EXPIRATIONDATE', 'Expirationdate', 'DATE', false, null, null);
        $this->addColumn('EXPIRATIONTERMS', 'Expirationterms', 'CHAR', false, 80, null);
        $this->addColumn('RETURNED', 'Returned', 'BOOLEAN', false, 1, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_ONE, array('projectId' => 'id', ), 'SET NULL', null);
        $this->addRelation('Contractor', 'Contractor', RelationMap::MANY_TO_ONE, array('contractorId' => 'id', ), 'SET NULL', null);
        $this->addRelation('GuaranteeDocument', 'GuaranteeDocument', RelationMap::ONE_TO_MANY, array('id' => 'guaranteeId', ), 'CASCADE', null, 'GuaranteeDocuments');
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // GuaranteeTableMap
