<?php



/**
 * This class defines the structure of the 'objectives_objective' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.objectives.classes.map
 */
class ObjectiveTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'objectives.classes.map.ObjectiveTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('objectives_objective');
        $this->setPhpName('Objective');
        $this->setClassname('Objective');
        $this->setPackage('objectives.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addForeignKey('POLICYGUIDELINEID', 'Policyguidelineid', 'INTEGER', 'objectives_policyGuideline', 'ID', true, null, null);
        $this->addForeignKey('STRATEGICOBJECTIVEID', 'Strategicobjectiveid', 'INTEGER', 'objectives_strategic', 'ID', true, null, null);
        $this->addColumn('AFFILIATEID', 'Affiliateid', 'INTEGER', true, null, 0);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('DATE', 'Date', 'DATE', false, null, null);
        $this->addColumn('EXPIRATIONDATE', 'Expirationdate', 'DATE', false, null, null);
        $this->addColumn('ACHIEVED', 'Achieved', 'BOOLEAN', false, 1, null);
        $this->addColumn('NOTES', 'Notes', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('RESPONSIBLECODE', 'Responsiblecode', 'INTEGER', 'positions_position', 'CODE', false, null, null);
        $this->addForeignKey('USERID', 'Userid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addColumn('USERBYAFFILIATESID', 'Userbyaffiliatesid', 'INTEGER', false, null, null);
        $this->addColumn('UPDATED', 'Updated', 'TIMESTAMP', false, null, null);
        $this->addColumn('CHANGES', 'Changes', 'INTEGER', false, null, null);
        $this->addColumn('OLDID', 'Oldid', 'INTEGER', false, null, null);
        $this->addColumn('STARTINGYEAR', 'Startingyear', 'INTEGER', false, null, null);
        $this->addColumn('ENDINGYEAR', 'Endingyear', 'INTEGER', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('StrategicObjective', 'StrategicObjective', RelationMap::MANY_TO_ONE, array('strategicObjectiveId' => 'id', ), null, null);
        $this->addRelation('PolicyGuideline', 'PolicyGuideline', RelationMap::MANY_TO_ONE, array('policyGuidelineId' => 'id', ), null, null);
        $this->addRelation('User', 'User', RelationMap::MANY_TO_ONE, array('userId' => 'id', ), null, null);
        $this->addRelation('Position', 'Position', RelationMap::MANY_TO_ONE, array('responsibleCode' => 'code', ), null, null);
        $this->addRelation('Indicator', 'Indicator', RelationMap::ONE_TO_MANY, array('id' => 'objectiveId', ), 'CASCADE', null, 'Indicators');
        $this->addRelation('ObjectiveRegion', 'ObjectiveRegion', RelationMap::ONE_TO_MANY, array('id' => 'objectiveId', ), null, null, 'ObjectiveRegions');
        $this->addRelation('ObjectiveLog', 'ObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'objectiveId', ), null, null, 'ObjectiveLogs');
        $this->addRelation('Project', 'Project', RelationMap::ONE_TO_MANY, array('id' => 'objectiveId', ), null, null, 'Projects');
        $this->addRelation('ProjectLog', 'ProjectLog', RelationMap::ONE_TO_MANY, array('id' => 'objectiveId', ), null, null, 'ProjectLogs');
        $this->addRelation('Region', 'Region', RelationMap::MANY_TO_MANY, array(), null, null, 'Regions');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // ObjectiveTableMap
