<?php


/**
 * Base static class for performing query and update operations on the 'indicators_graph' table.
 *
 * Indicators graph
 *
 * @package propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorGraphPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'indicators_graph';

    /** the related Propel class for this table */
    const OM_CLASS = 'IndicatorGraph';

    /** the related TableMap class for this table */
    const TM_CLASS = 'IndicatorGraphTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 13;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 13;

    /** the column name for the ID field */
    const ID = 'indicators_graph.ID';

    /** the column name for the NAME field */
    const NAME = 'indicators_graph.NAME';

    /** the column name for the GRAPHTYPE field */
    const GRAPHTYPE = 'indicators_graph.GRAPHTYPE';

    /** the column name for the DECIMALS field */
    const DECIMALS = 'indicators_graph.DECIMALS';

    /** the column name for the VALUETYPE field */
    const VALUETYPE = 'indicators_graph.VALUETYPE';

    /** the column name for the SHOWVALUE field */
    const SHOWVALUE = 'indicators_graph.SHOWVALUE';

    /** the column name for the MINX field */
    const MINX = 'indicators_graph.MINX';

    /** the column name for the MAXX field */
    const MAXX = 'indicators_graph.MAXX';

    /** the column name for the MINY field */
    const MINY = 'indicators_graph.MINY';

    /** the column name for the MAXY field */
    const MAXY = 'indicators_graph.MAXY';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'indicators_graph.DESCRIPTION';

    /** the column name for the MINDATE field */
    const MINDATE = 'indicators_graph.MINDATE';

    /** the column name for the MAXDATE field */
    const MAXDATE = 'indicators_graph.MAXDATE';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of IndicatorGraph objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array IndicatorGraph[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. IndicatorGraphPeer::$fieldNames[IndicatorGraphPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Graphtype', 'Decimals', 'Valuetype', 'Showvalue', 'Minx', 'Maxx', 'Miny', 'Maxy', 'Description', 'Mindate', 'Maxdate', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'graphtype', 'decimals', 'valuetype', 'showvalue', 'minx', 'maxx', 'miny', 'maxy', 'description', 'mindate', 'maxdate', ),
        BasePeer::TYPE_COLNAME => array (IndicatorGraphPeer::ID, IndicatorGraphPeer::NAME, IndicatorGraphPeer::GRAPHTYPE, IndicatorGraphPeer::DECIMALS, IndicatorGraphPeer::VALUETYPE, IndicatorGraphPeer::SHOWVALUE, IndicatorGraphPeer::MINX, IndicatorGraphPeer::MAXX, IndicatorGraphPeer::MINY, IndicatorGraphPeer::MAXY, IndicatorGraphPeer::DESCRIPTION, IndicatorGraphPeer::MINDATE, IndicatorGraphPeer::MAXDATE, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'GRAPHTYPE', 'DECIMALS', 'VALUETYPE', 'SHOWVALUE', 'MINX', 'MAXX', 'MINY', 'MAXY', 'DESCRIPTION', 'MINDATE', 'MAXDATE', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'graphType', 'decimals', 'valueType', 'showValue', 'minX', 'maxX', 'minY', 'maxY', 'description', 'minDate', 'maxDate', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. IndicatorGraphPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Graphtype' => 2, 'Decimals' => 3, 'Valuetype' => 4, 'Showvalue' => 5, 'Minx' => 6, 'Maxx' => 7, 'Miny' => 8, 'Maxy' => 9, 'Description' => 10, 'Mindate' => 11, 'Maxdate' => 12, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'graphtype' => 2, 'decimals' => 3, 'valuetype' => 4, 'showvalue' => 5, 'minx' => 6, 'maxx' => 7, 'miny' => 8, 'maxy' => 9, 'description' => 10, 'mindate' => 11, 'maxdate' => 12, ),
        BasePeer::TYPE_COLNAME => array (IndicatorGraphPeer::ID => 0, IndicatorGraphPeer::NAME => 1, IndicatorGraphPeer::GRAPHTYPE => 2, IndicatorGraphPeer::DECIMALS => 3, IndicatorGraphPeer::VALUETYPE => 4, IndicatorGraphPeer::SHOWVALUE => 5, IndicatorGraphPeer::MINX => 6, IndicatorGraphPeer::MAXX => 7, IndicatorGraphPeer::MINY => 8, IndicatorGraphPeer::MAXY => 9, IndicatorGraphPeer::DESCRIPTION => 10, IndicatorGraphPeer::MINDATE => 11, IndicatorGraphPeer::MAXDATE => 12, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'GRAPHTYPE' => 2, 'DECIMALS' => 3, 'VALUETYPE' => 4, 'SHOWVALUE' => 5, 'MINX' => 6, 'MAXX' => 7, 'MINY' => 8, 'MAXY' => 9, 'DESCRIPTION' => 10, 'MINDATE' => 11, 'MAXDATE' => 12, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'graphType' => 2, 'decimals' => 3, 'valueType' => 4, 'showValue' => 5, 'minX' => 6, 'maxX' => 7, 'minY' => 8, 'maxY' => 9, 'description' => 10, 'minDate' => 11, 'maxDate' => 12, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = IndicatorGraphPeer::getFieldNames($toType);
        $key = isset(IndicatorGraphPeer::$fieldKeys[$fromType][$name]) ? IndicatorGraphPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(IndicatorGraphPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, IndicatorGraphPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return IndicatorGraphPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. IndicatorGraphPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(IndicatorGraphPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(IndicatorGraphPeer::ID);
            $criteria->addSelectColumn(IndicatorGraphPeer::NAME);
            $criteria->addSelectColumn(IndicatorGraphPeer::GRAPHTYPE);
            $criteria->addSelectColumn(IndicatorGraphPeer::DECIMALS);
            $criteria->addSelectColumn(IndicatorGraphPeer::VALUETYPE);
            $criteria->addSelectColumn(IndicatorGraphPeer::SHOWVALUE);
            $criteria->addSelectColumn(IndicatorGraphPeer::MINX);
            $criteria->addSelectColumn(IndicatorGraphPeer::MAXX);
            $criteria->addSelectColumn(IndicatorGraphPeer::MINY);
            $criteria->addSelectColumn(IndicatorGraphPeer::MAXY);
            $criteria->addSelectColumn(IndicatorGraphPeer::DESCRIPTION);
            $criteria->addSelectColumn(IndicatorGraphPeer::MINDATE);
            $criteria->addSelectColumn(IndicatorGraphPeer::MAXDATE);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.GRAPHTYPE');
            $criteria->addSelectColumn($alias . '.DECIMALS');
            $criteria->addSelectColumn($alias . '.VALUETYPE');
            $criteria->addSelectColumn($alias . '.SHOWVALUE');
            $criteria->addSelectColumn($alias . '.MINX');
            $criteria->addSelectColumn($alias . '.MAXX');
            $criteria->addSelectColumn($alias . '.MINY');
            $criteria->addSelectColumn($alias . '.MAXY');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.MINDATE');
            $criteria->addSelectColumn($alias . '.MAXDATE');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(IndicatorGraphPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            IndicatorGraphPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(IndicatorGraphPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 IndicatorGraph
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = IndicatorGraphPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return IndicatorGraphPeer::populateObjects(IndicatorGraphPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            IndicatorGraphPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(IndicatorGraphPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      IndicatorGraph $obj A IndicatorGraph object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            IndicatorGraphPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A IndicatorGraph object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof IndicatorGraph) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or IndicatorGraph object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(IndicatorGraphPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   IndicatorGraph Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(IndicatorGraphPeer::$instances[$key])) {
                return IndicatorGraphPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        IndicatorGraphPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to indicators_graph
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in IndicatorGraphSeriePeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorGraphSeriePeer::clearInstancePool();
        // Invalidate objects in IndicatorGraphCommentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorGraphCommentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = IndicatorGraphPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = IndicatorGraphPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = IndicatorGraphPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                IndicatorGraphPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (IndicatorGraph object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = IndicatorGraphPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = IndicatorGraphPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + IndicatorGraphPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = IndicatorGraphPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            IndicatorGraphPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(IndicatorGraphPeer::DATABASE_NAME)->getTable(IndicatorGraphPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseIndicatorGraphPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseIndicatorGraphPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new IndicatorGraphTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return IndicatorGraphPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a IndicatorGraph or Criteria object.
     *
     * @param      mixed $values Criteria or IndicatorGraph object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from IndicatorGraph object
        }

        if ($criteria->containsKey(IndicatorGraphPeer::ID) && $criteria->keyContainsValue(IndicatorGraphPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.IndicatorGraphPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(IndicatorGraphPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a IndicatorGraph or Criteria object.
     *
     * @param      mixed $values Criteria or IndicatorGraph object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(IndicatorGraphPeer::ID);
            $value = $criteria->remove(IndicatorGraphPeer::ID);
            if ($value) {
                $selectCriteria->add(IndicatorGraphPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(IndicatorGraphPeer::TABLE_NAME);
            }

        } else { // $values is IndicatorGraph object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(IndicatorGraphPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the indicators_graph table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += IndicatorGraphPeer::doOnDeleteCascade(new Criteria(IndicatorGraphPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(IndicatorGraphPeer::TABLE_NAME, $con, IndicatorGraphPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            IndicatorGraphPeer::clearInstancePool();
            IndicatorGraphPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a IndicatorGraph or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or IndicatorGraph object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof IndicatorGraph) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);
            $criteria->add(IndicatorGraphPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(IndicatorGraphPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += IndicatorGraphPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                IndicatorGraphPeer::clearInstancePool();
            } elseif ($values instanceof IndicatorGraph) { // it's a model object
                IndicatorGraphPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    IndicatorGraphPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            IndicatorGraphPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = IndicatorGraphPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related IndicatorGraphSerie objects
            $criteria = new Criteria(IndicatorGraphSeriePeer::DATABASE_NAME);

            $criteria->add(IndicatorGraphSeriePeer::GRAPHID, $obj->getId());
            $affectedRows += IndicatorGraphSeriePeer::doDelete($criteria, $con);

            // delete related IndicatorGraphComment objects
            $criteria = new Criteria(IndicatorGraphCommentPeer::DATABASE_NAME);

            $criteria->add(IndicatorGraphCommentPeer::GRAPHID, $obj->getId());
            $affectedRows += IndicatorGraphCommentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given IndicatorGraph object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      IndicatorGraph $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(IndicatorGraphPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(IndicatorGraphPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(IndicatorGraphPeer::DATABASE_NAME, IndicatorGraphPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return IndicatorGraph
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = IndicatorGraphPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);
        $criteria->add(IndicatorGraphPeer::ID, $pk);

        $v = IndicatorGraphPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return IndicatorGraph[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(IndicatorGraphPeer::DATABASE_NAME);
            $criteria->add(IndicatorGraphPeer::ID, $pks, Criteria::IN);
            $objs = IndicatorGraphPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseIndicatorGraphPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseIndicatorGraphPeer::buildTableMap();

