<?php


/**
 * Base class that represents a row from the 'constructions_construction' table.
 *
 * Seguimiento de obras
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseConstruction extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ConstructionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ConstructionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the proyectid field.
     * @var        int
     */
    protected $proyectid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the categoryid field.
     * @var        int
     */
    protected $categoryid;

    /**
     * The value for the latitude field.
     * @var        string
     */
    protected $latitude;

    /**
     * The value for the longitude field.
     * @var        string
     */
    protected $longitude;

    /**
     * The value for the street field.
     * @var        string
     */
    protected $street;

    /**
     * The value for the number field.
     * @var        int
     */
    protected $number;

    /**
     * The value for the regionid field.
     * @var        int
     */
    protected $regionid;

    /**
     * The value for the enddate field.
     * @var        string
     */
    protected $enddate;

    /**
     * The value for the inaugurated field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $inaugurated;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        Category
     */
    protected $aCategory;

    /**
     * @var        Region
     */
    protected $aRegion;

    /**
     * @var        PropelObjectCollection|Inspection[] Collection to store aggregation of Inspection objects.
     */
    protected $collInspections;
    protected $collInspectionsPartial;

    /**
     * @var        PropelObjectCollection|ConstructionProgress[] Collection to store aggregation of ConstructionProgress objects.
     */
    protected $collConstructionProgresss;
    protected $collConstructionProgresssPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $inspectionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $constructionProgresssScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->inaugurated = false;
    }

    /**
     * Initializes internal state of BaseConstruction object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Id obra
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [proyectid] column value.
     * ID del evento
     * @return int
     */
    public function getProyectid()
    {
        return $this->proyectid;
    }

    /**
     * Get the [name] column value.
     * Nombre de la obra
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Descripcion de la obra
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [categoryid] column value.
     * Jurisdiccion
     * @return int
     */
    public function getCategoryid()
    {
        return $this->categoryid;
    }

    /**
     * Get the [latitude] column value.
     * latitud
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Get the [longitude] column value.
     * longitud
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Get the [street] column value.
     * Nombre de la calle
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Get the [number] column value.
     * Numero de la calle
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Get the [regionid] column value.
     * Region
     * @return int
     */
    public function getRegionid()
    {
        return $this->regionid;
    }

    /**
     * Get the [optionally formatted] temporal [enddate] column value.
     * Fecha fin
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getEnddate($format = '%Y/%m/%d')
    {
        if ($this->enddate === null) {
            return null;
        }

        if ($this->enddate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->enddate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->enddate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [inaugurated] column value.
     * Inaugurada
     * @return boolean
     */
    public function getInaugurated()
    {
        return $this->inaugurated;
    }

    /**
     * Set the value of [id] column.
     * Id obra
     * @param int $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ConstructionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [proyectid] column.
     * ID del evento
     * @param int $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setProyectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->proyectid !== $v) {
            $this->proyectid = $v;
            $this->modifiedColumns[] = ConstructionPeer::PROYECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProyectid()

    /**
     * Set the value of [name] column.
     * Nombre de la obra
     * @param string $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ConstructionPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Descripcion de la obra
     * @param string $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ConstructionPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [categoryid] column.
     * Jurisdiccion
     * @param int $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setCategoryid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->categoryid !== $v) {
            $this->categoryid = $v;
            $this->modifiedColumns[] = ConstructionPeer::CATEGORYID;
        }

        if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
            $this->aCategory = null;
        }


        return $this;
    } // setCategoryid()

    /**
     * Set the value of [latitude] column.
     * latitud
     * @param string $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setLatitude($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->latitude !== $v) {
            $this->latitude = $v;
            $this->modifiedColumns[] = ConstructionPeer::LATITUDE;
        }


        return $this;
    } // setLatitude()

    /**
     * Set the value of [longitude] column.
     * longitud
     * @param string $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setLongitude($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->longitude !== $v) {
            $this->longitude = $v;
            $this->modifiedColumns[] = ConstructionPeer::LONGITUDE;
        }


        return $this;
    } // setLongitude()

    /**
     * Set the value of [street] column.
     * Nombre de la calle
     * @param string $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setStreet($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->street !== $v) {
            $this->street = $v;
            $this->modifiedColumns[] = ConstructionPeer::STREET;
        }


        return $this;
    } // setStreet()

    /**
     * Set the value of [number] column.
     * Numero de la calle
     * @param int $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setNumber($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->number !== $v) {
            $this->number = $v;
            $this->modifiedColumns[] = ConstructionPeer::NUMBER;
        }


        return $this;
    } // setNumber()

    /**
     * Set the value of [regionid] column.
     * Region
     * @param int $v new value
     * @return Construction The current object (for fluent API support)
     */
    public function setRegionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->regionid !== $v) {
            $this->regionid = $v;
            $this->modifiedColumns[] = ConstructionPeer::REGIONID;
        }

        if ($this->aRegion !== null && $this->aRegion->getId() !== $v) {
            $this->aRegion = null;
        }


        return $this;
    } // setRegionid()

    /**
     * Sets the value of [enddate] column to a normalized version of the date/time value specified.
     * Fecha fin
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Construction The current object (for fluent API support)
     */
    public function setEnddate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->enddate !== null || $dt !== null) {
            $currentDateAsString = ($this->enddate !== null && $tmpDt = new DateTime($this->enddate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->enddate = $newDateAsString;
                $this->modifiedColumns[] = ConstructionPeer::ENDDATE;
            }
        } // if either are not null


        return $this;
    } // setEnddate()

    /**
     * Sets the value of the [inaugurated] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Inaugurada
     * @param boolean|integer|string $v The new value
     * @return Construction The current object (for fluent API support)
     */
    public function setInaugurated($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->inaugurated !== $v) {
            $this->inaugurated = $v;
            $this->modifiedColumns[] = ConstructionPeer::INAUGURATED;
        }


        return $this;
    } // setInaugurated()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->inaugurated !== false) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->proyectid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->description = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->categoryid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->latitude = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->longitude = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->street = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->number = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->regionid = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->enddate = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->inaugurated = ($row[$startcol + 11] !== null) ? (boolean) $row[$startcol + 11] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = ConstructionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Construction object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->proyectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
        if ($this->aCategory !== null && $this->categoryid !== $this->aCategory->getId()) {
            $this->aCategory = null;
        }
        if ($this->aRegion !== null && $this->regionid !== $this->aRegion->getId()) {
            $this->aRegion = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ConstructionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->aCategory = null;
            $this->aRegion = null;
            $this->collInspections = null;

            $this->collConstructionProgresss = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ConstructionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ConstructionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->aCategory !== null) {
                if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
                    $affectedRows += $this->aCategory->save($con);
                }
                $this->setCategory($this->aCategory);
            }

            if ($this->aRegion !== null) {
                if ($this->aRegion->isModified() || $this->aRegion->isNew()) {
                    $affectedRows += $this->aRegion->save($con);
                }
                $this->setRegion($this->aRegion);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->inspectionsScheduledForDeletion !== null) {
                if (!$this->inspectionsScheduledForDeletion->isEmpty()) {
                    InspectionQuery::create()
                        ->filterByPrimaryKeys($this->inspectionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->inspectionsScheduledForDeletion = null;
                }
            }

            if ($this->collInspections !== null) {
                foreach ($this->collInspections as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->constructionProgresssScheduledForDeletion !== null) {
                if (!$this->constructionProgresssScheduledForDeletion->isEmpty()) {
                    foreach ($this->constructionProgresssScheduledForDeletion as $constructionProgress) {
                        // need to save related object because we set the relation to null
                        $constructionProgress->save($con);
                    }
                    $this->constructionProgresssScheduledForDeletion = null;
                }
            }

            if ($this->collConstructionProgresss !== null) {
                foreach ($this->collConstructionProgresss as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ConstructionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ConstructionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ConstructionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ConstructionPeer::PROYECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROYECTID`';
        }
        if ($this->isColumnModified(ConstructionPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ConstructionPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ConstructionPeer::CATEGORYID)) {
            $modifiedColumns[':p' . $index++]  = '`CATEGORYID`';
        }
        if ($this->isColumnModified(ConstructionPeer::LATITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LATITUDE`';
        }
        if ($this->isColumnModified(ConstructionPeer::LONGITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LONGITUDE`';
        }
        if ($this->isColumnModified(ConstructionPeer::STREET)) {
            $modifiedColumns[':p' . $index++]  = '`STREET`';
        }
        if ($this->isColumnModified(ConstructionPeer::NUMBER)) {
            $modifiedColumns[':p' . $index++]  = '`NUMBER`';
        }
        if ($this->isColumnModified(ConstructionPeer::REGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`REGIONID`';
        }
        if ($this->isColumnModified(ConstructionPeer::ENDDATE)) {
            $modifiedColumns[':p' . $index++]  = '`ENDDATE`';
        }
        if ($this->isColumnModified(ConstructionPeer::INAUGURATED)) {
            $modifiedColumns[':p' . $index++]  = '`INAUGURATED`';
        }

        $sql = sprintf(
            'INSERT INTO `constructions_construction` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`PROYECTID`':
                        $stmt->bindValue($identifier, $this->proyectid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`CATEGORYID`':
                        $stmt->bindValue($identifier, $this->categoryid, PDO::PARAM_INT);
                        break;
                    case '`LATITUDE`':
                        $stmt->bindValue($identifier, $this->latitude, PDO::PARAM_INT);
                        break;
                    case '`LONGITUDE`':
                        $stmt->bindValue($identifier, $this->longitude, PDO::PARAM_INT);
                        break;
                    case '`STREET`':
                        $stmt->bindValue($identifier, $this->street, PDO::PARAM_STR);
                        break;
                    case '`NUMBER`':
                        $stmt->bindValue($identifier, $this->number, PDO::PARAM_INT);
                        break;
                    case '`REGIONID`':
                        $stmt->bindValue($identifier, $this->regionid, PDO::PARAM_INT);
                        break;
                    case '`ENDDATE`':
                        $stmt->bindValue($identifier, $this->enddate, PDO::PARAM_STR);
                        break;
                    case '`INAUGURATED`':
                        $stmt->bindValue($identifier, (int) $this->inaugurated, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }

            if ($this->aCategory !== null) {
                if (!$this->aCategory->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aCategory->getValidationFailures());
                }
            }

            if ($this->aRegion !== null) {
                if (!$this->aRegion->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aRegion->getValidationFailures());
                }
            }


            if (($retval = ConstructionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collInspections !== null) {
                    foreach ($this->collInspections as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collConstructionProgresss !== null) {
                    foreach ($this->collConstructionProgresss as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ConstructionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getProyectid();
                break;
            case 2:
                return $this->getName();
                break;
            case 3:
                return $this->getDescription();
                break;
            case 4:
                return $this->getCategoryid();
                break;
            case 5:
                return $this->getLatitude();
                break;
            case 6:
                return $this->getLongitude();
                break;
            case 7:
                return $this->getStreet();
                break;
            case 8:
                return $this->getNumber();
                break;
            case 9:
                return $this->getRegionid();
                break;
            case 10:
                return $this->getEnddate();
                break;
            case 11:
                return $this->getInaugurated();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Construction'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Construction'][$this->getPrimaryKey()] = true;
        $keys = ConstructionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getProyectid(),
            $keys[2] => $this->getName(),
            $keys[3] => $this->getDescription(),
            $keys[4] => $this->getCategoryid(),
            $keys[5] => $this->getLatitude(),
            $keys[6] => $this->getLongitude(),
            $keys[7] => $this->getStreet(),
            $keys[8] => $this->getNumber(),
            $keys[9] => $this->getRegionid(),
            $keys[10] => $this->getEnddate(),
            $keys[11] => $this->getInaugurated(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCategory) {
                $result['Category'] = $this->aCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aRegion) {
                $result['Region'] = $this->aRegion->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collInspections) {
                $result['Inspections'] = $this->collInspections->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collConstructionProgresss) {
                $result['ConstructionProgresss'] = $this->collConstructionProgresss->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ConstructionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setProyectid($value);
                break;
            case 2:
                $this->setName($value);
                break;
            case 3:
                $this->setDescription($value);
                break;
            case 4:
                $this->setCategoryid($value);
                break;
            case 5:
                $this->setLatitude($value);
                break;
            case 6:
                $this->setLongitude($value);
                break;
            case 7:
                $this->setStreet($value);
                break;
            case 8:
                $this->setNumber($value);
                break;
            case 9:
                $this->setRegionid($value);
                break;
            case 10:
                $this->setEnddate($value);
                break;
            case 11:
                $this->setInaugurated($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ConstructionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setProyectid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDescription($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setCategoryid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setLatitude($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setLongitude($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setStreet($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setNumber($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setRegionid($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setEnddate($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setInaugurated($arr[$keys[11]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ConstructionPeer::DATABASE_NAME);

        if ($this->isColumnModified(ConstructionPeer::ID)) $criteria->add(ConstructionPeer::ID, $this->id);
        if ($this->isColumnModified(ConstructionPeer::PROYECTID)) $criteria->add(ConstructionPeer::PROYECTID, $this->proyectid);
        if ($this->isColumnModified(ConstructionPeer::NAME)) $criteria->add(ConstructionPeer::NAME, $this->name);
        if ($this->isColumnModified(ConstructionPeer::DESCRIPTION)) $criteria->add(ConstructionPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ConstructionPeer::CATEGORYID)) $criteria->add(ConstructionPeer::CATEGORYID, $this->categoryid);
        if ($this->isColumnModified(ConstructionPeer::LATITUDE)) $criteria->add(ConstructionPeer::LATITUDE, $this->latitude);
        if ($this->isColumnModified(ConstructionPeer::LONGITUDE)) $criteria->add(ConstructionPeer::LONGITUDE, $this->longitude);
        if ($this->isColumnModified(ConstructionPeer::STREET)) $criteria->add(ConstructionPeer::STREET, $this->street);
        if ($this->isColumnModified(ConstructionPeer::NUMBER)) $criteria->add(ConstructionPeer::NUMBER, $this->number);
        if ($this->isColumnModified(ConstructionPeer::REGIONID)) $criteria->add(ConstructionPeer::REGIONID, $this->regionid);
        if ($this->isColumnModified(ConstructionPeer::ENDDATE)) $criteria->add(ConstructionPeer::ENDDATE, $this->enddate);
        if ($this->isColumnModified(ConstructionPeer::INAUGURATED)) $criteria->add(ConstructionPeer::INAUGURATED, $this->inaugurated);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ConstructionPeer::DATABASE_NAME);
        $criteria->add(ConstructionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Construction (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setProyectid($this->getProyectid());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setCategoryid($this->getCategoryid());
        $copyObj->setLatitude($this->getLatitude());
        $copyObj->setLongitude($this->getLongitude());
        $copyObj->setStreet($this->getStreet());
        $copyObj->setNumber($this->getNumber());
        $copyObj->setRegionid($this->getRegionid());
        $copyObj->setEnddate($this->getEnddate());
        $copyObj->setInaugurated($this->getInaugurated());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getInspections() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addInspection($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getConstructionProgresss() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addConstructionProgress($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Construction Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ConstructionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ConstructionPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return Construction The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProyectid(NULL);
        } else {
            $this->setProyectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addConstruction($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->proyectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->proyectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addConstructions($this);
             */
        }

        return $this->aProject;
    }

    /**
     * Declares an association between this object and a Category object.
     *
     * @param             Category $v
     * @return Construction The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCategory(Category $v = null)
    {
        if ($v === null) {
            $this->setCategoryid(NULL);
        } else {
            $this->setCategoryid($v->getId());
        }

        $this->aCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Category object, it will not be re-added.
        if ($v !== null) {
            $v->addConstruction($this);
        }


        return $this;
    }


    /**
     * Get the associated Category object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Category The associated Category object.
     * @throws PropelException
     */
    public function getCategory(PropelPDO $con = null)
    {
        if ($this->aCategory === null && ($this->categoryid !== null)) {
            $this->aCategory = CategoryQuery::create()->findPk($this->categoryid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCategory->addConstructions($this);
             */
        }

        return $this->aCategory;
    }

    /**
     * Declares an association between this object and a Region object.
     *
     * @param             Region $v
     * @return Construction The current object (for fluent API support)
     * @throws PropelException
     */
    public function setRegion(Region $v = null)
    {
        if ($v === null) {
            $this->setRegionid(NULL);
        } else {
            $this->setRegionid($v->getId());
        }

        $this->aRegion = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Region object, it will not be re-added.
        if ($v !== null) {
            $v->addConstruction($this);
        }


        return $this;
    }


    /**
     * Get the associated Region object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Region The associated Region object.
     * @throws PropelException
     */
    public function getRegion(PropelPDO $con = null)
    {
        if ($this->aRegion === null && ($this->regionid !== null)) {
            $this->aRegion = RegionQuery::create()->findPk($this->regionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aRegion->addConstructions($this);
             */
        }

        return $this->aRegion;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Inspection' == $relationName) {
            $this->initInspections();
        }
        if ('ConstructionProgress' == $relationName) {
            $this->initConstructionProgresss();
        }
    }

    /**
     * Clears out the collInspections collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addInspections()
     */
    public function clearInspections()
    {
        $this->collInspections = null; // important to set this to null since that means it is uninitialized
        $this->collInspectionsPartial = null;
    }

    /**
     * reset is the collInspections collection loaded partially
     *
     * @return void
     */
    public function resetPartialInspections($v = true)
    {
        $this->collInspectionsPartial = $v;
    }

    /**
     * Initializes the collInspections collection.
     *
     * By default this just sets the collInspections collection to an empty array (like clearcollInspections());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initInspections($overrideExisting = true)
    {
        if (null !== $this->collInspections && !$overrideExisting) {
            return;
        }
        $this->collInspections = new PropelObjectCollection();
        $this->collInspections->setModel('Inspection');
    }

    /**
     * Gets an array of Inspection objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Construction is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Inspection[] List of Inspection objects
     * @throws PropelException
     */
    public function getInspections($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collInspectionsPartial && !$this->isNew();
        if (null === $this->collInspections || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collInspections) {
                // return empty collection
                $this->initInspections();
            } else {
                $collInspections = InspectionQuery::create(null, $criteria)
                    ->filterByConstruction($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collInspectionsPartial && count($collInspections)) {
                      $this->initInspections(false);

                      foreach($collInspections as $obj) {
                        if (false == $this->collInspections->contains($obj)) {
                          $this->collInspections->append($obj);
                        }
                      }

                      $this->collInspectionsPartial = true;
                    }

                    return $collInspections;
                }

                if($partial && $this->collInspections) {
                    foreach($this->collInspections as $obj) {
                        if($obj->isNew()) {
                            $collInspections[] = $obj;
                        }
                    }
                }

                $this->collInspections = $collInspections;
                $this->collInspectionsPartial = false;
            }
        }

        return $this->collInspections;
    }

    /**
     * Sets a collection of Inspection objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $inspections A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setInspections(PropelCollection $inspections, PropelPDO $con = null)
    {
        $this->inspectionsScheduledForDeletion = $this->getInspections(new Criteria(), $con)->diff($inspections);

        foreach ($this->inspectionsScheduledForDeletion as $inspectionRemoved) {
            $inspectionRemoved->setConstruction(null);
        }

        $this->collInspections = null;
        foreach ($inspections as $inspection) {
            $this->addInspection($inspection);
        }

        $this->collInspections = $inspections;
        $this->collInspectionsPartial = false;
    }

    /**
     * Returns the number of related Inspection objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Inspection objects.
     * @throws PropelException
     */
    public function countInspections(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collInspectionsPartial && !$this->isNew();
        if (null === $this->collInspections || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collInspections) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getInspections());
                }
                $query = InspectionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByConstruction($this)
                    ->count($con);
            }
        } else {
            return count($this->collInspections);
        }
    }

    /**
     * Method called to associate a Inspection object to this object
     * through the Inspection foreign key attribute.
     *
     * @param    Inspection $l Inspection
     * @return Construction The current object (for fluent API support)
     */
    public function addInspection(Inspection $l)
    {
        if ($this->collInspections === null) {
            $this->initInspections();
            $this->collInspectionsPartial = true;
        }
        if (!$this->collInspections->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddInspection($l);
        }

        return $this;
    }

    /**
     * @param	Inspection $inspection The inspection object to add.
     */
    protected function doAddInspection($inspection)
    {
        $this->collInspections[]= $inspection;
        $inspection->setConstruction($this);
    }

    /**
     * @param	Inspection $inspection The inspection object to remove.
     */
    public function removeInspection($inspection)
    {
        if ($this->getInspections()->contains($inspection)) {
            $this->collInspections->remove($this->collInspections->search($inspection));
            if (null === $this->inspectionsScheduledForDeletion) {
                $this->inspectionsScheduledForDeletion = clone $this->collInspections;
                $this->inspectionsScheduledForDeletion->clear();
            }
            $this->inspectionsScheduledForDeletion[]= $inspection;
            $inspection->setConstruction(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Construction is new, it will return
     * an empty collection; or if this Construction has previously
     * been saved, it will retrieve related Inspections from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Construction.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Inspection[] List of Inspection objects
     */
    public function getInspectionsJoinInspector($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = InspectionQuery::create(null, $criteria);
        $query->joinWith('Inspector', $join_behavior);

        return $this->getInspections($query, $con);
    }

    /**
     * Clears out the collConstructionProgresss collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addConstructionProgresss()
     */
    public function clearConstructionProgresss()
    {
        $this->collConstructionProgresss = null; // important to set this to null since that means it is uninitialized
        $this->collConstructionProgresssPartial = null;
    }

    /**
     * reset is the collConstructionProgresss collection loaded partially
     *
     * @return void
     */
    public function resetPartialConstructionProgresss($v = true)
    {
        $this->collConstructionProgresssPartial = $v;
    }

    /**
     * Initializes the collConstructionProgresss collection.
     *
     * By default this just sets the collConstructionProgresss collection to an empty array (like clearcollConstructionProgresss());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initConstructionProgresss($overrideExisting = true)
    {
        if (null !== $this->collConstructionProgresss && !$overrideExisting) {
            return;
        }
        $this->collConstructionProgresss = new PropelObjectCollection();
        $this->collConstructionProgresss->setModel('ConstructionProgress');
    }

    /**
     * Gets an array of ConstructionProgress objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Construction is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ConstructionProgress[] List of ConstructionProgress objects
     * @throws PropelException
     */
    public function getConstructionProgresss($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collConstructionProgresssPartial && !$this->isNew();
        if (null === $this->collConstructionProgresss || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collConstructionProgresss) {
                // return empty collection
                $this->initConstructionProgresss();
            } else {
                $collConstructionProgresss = ConstructionProgressQuery::create(null, $criteria)
                    ->filterByConstruction($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collConstructionProgresssPartial && count($collConstructionProgresss)) {
                      $this->initConstructionProgresss(false);

                      foreach($collConstructionProgresss as $obj) {
                        if (false == $this->collConstructionProgresss->contains($obj)) {
                          $this->collConstructionProgresss->append($obj);
                        }
                      }

                      $this->collConstructionProgresssPartial = true;
                    }

                    return $collConstructionProgresss;
                }

                if($partial && $this->collConstructionProgresss) {
                    foreach($this->collConstructionProgresss as $obj) {
                        if($obj->isNew()) {
                            $collConstructionProgresss[] = $obj;
                        }
                    }
                }

                $this->collConstructionProgresss = $collConstructionProgresss;
                $this->collConstructionProgresssPartial = false;
            }
        }

        return $this->collConstructionProgresss;
    }

    /**
     * Sets a collection of ConstructionProgress objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $constructionProgresss A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setConstructionProgresss(PropelCollection $constructionProgresss, PropelPDO $con = null)
    {
        $this->constructionProgresssScheduledForDeletion = $this->getConstructionProgresss(new Criteria(), $con)->diff($constructionProgresss);

        foreach ($this->constructionProgresssScheduledForDeletion as $constructionProgressRemoved) {
            $constructionProgressRemoved->setConstruction(null);
        }

        $this->collConstructionProgresss = null;
        foreach ($constructionProgresss as $constructionProgress) {
            $this->addConstructionProgress($constructionProgress);
        }

        $this->collConstructionProgresss = $constructionProgresss;
        $this->collConstructionProgresssPartial = false;
    }

    /**
     * Returns the number of related ConstructionProgress objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ConstructionProgress objects.
     * @throws PropelException
     */
    public function countConstructionProgresss(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collConstructionProgresssPartial && !$this->isNew();
        if (null === $this->collConstructionProgresss || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collConstructionProgresss) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getConstructionProgresss());
                }
                $query = ConstructionProgressQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByConstruction($this)
                    ->count($con);
            }
        } else {
            return count($this->collConstructionProgresss);
        }
    }

    /**
     * Method called to associate a ConstructionProgress object to this object
     * through the ConstructionProgress foreign key attribute.
     *
     * @param    ConstructionProgress $l ConstructionProgress
     * @return Construction The current object (for fluent API support)
     */
    public function addConstructionProgress(ConstructionProgress $l)
    {
        if ($this->collConstructionProgresss === null) {
            $this->initConstructionProgresss();
            $this->collConstructionProgresssPartial = true;
        }
        if (!$this->collConstructionProgresss->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddConstructionProgress($l);
        }

        return $this;
    }

    /**
     * @param	ConstructionProgress $constructionProgress The constructionProgress object to add.
     */
    protected function doAddConstructionProgress($constructionProgress)
    {
        $this->collConstructionProgresss[]= $constructionProgress;
        $constructionProgress->setConstruction($this);
    }

    /**
     * @param	ConstructionProgress $constructionProgress The constructionProgress object to remove.
     */
    public function removeConstructionProgress($constructionProgress)
    {
        if ($this->getConstructionProgresss()->contains($constructionProgress)) {
            $this->collConstructionProgresss->remove($this->collConstructionProgresss->search($constructionProgress));
            if (null === $this->constructionProgresssScheduledForDeletion) {
                $this->constructionProgresssScheduledForDeletion = clone $this->collConstructionProgresss;
                $this->constructionProgresssScheduledForDeletion->clear();
            }
            $this->constructionProgresssScheduledForDeletion[]= $constructionProgress;
            $constructionProgress->setConstruction(null);
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->proyectid = null;
        $this->name = null;
        $this->description = null;
        $this->categoryid = null;
        $this->latitude = null;
        $this->longitude = null;
        $this->street = null;
        $this->number = null;
        $this->regionid = null;
        $this->enddate = null;
        $this->inaugurated = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collInspections) {
                foreach ($this->collInspections as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collConstructionProgresss) {
                foreach ($this->collConstructionProgresss as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collInspections instanceof PropelCollection) {
            $this->collInspections->clearIterator();
        }
        $this->collInspections = null;
        if ($this->collConstructionProgresss instanceof PropelCollection) {
            $this->collConstructionProgresss->clearIterator();
        }
        $this->collConstructionProgresss = null;
        $this->aProject = null;
        $this->aCategory = null;
        $this->aRegion = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
