<?php



/**
 * This class defines the structure of the 'constructions_inspection' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.constructions.classes.map
 */
class InspectionTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'constructions.classes.map.InspectionTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('constructions_inspection');
        $this->setPhpName('Inspection');
        $this->setClassname('Inspection');
        $this->setPackage('constructions.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('CONSTRUCTIONID', 'Constructionid', 'INTEGER', 'constructions_construction', 'ID', true, null, null);
        $this->addForeignKey('INSPECTORID', 'Inspectorid', 'INTEGER', 'constructions_inspector', 'ID', true, null, null);
        $this->addColumn('VISITDATE', 'Visitdate', 'DATE', false, null, null);
        $this->addColumn('ENDDATE', 'Enddate', 'DATE', false, null, null);
        $this->addColumn('ENDDATEMINISTRY', 'Enddateministry', 'DATE', false, null, null);
        $this->addColumn('WORKSHOP', 'Workshop', 'BOOLEAN', false, 1, false);
        $this->addColumn('PROGRESSINSPECTOR', 'Progressinspector', 'INTEGER', false, 3, null);
        $this->addColumn('WORKINGRATE', 'Workingrate', 'INTEGER', false, 6, 0);
        $this->addColumn('PROGRESS', 'Progress', 'LONGVARCHAR', false, null, null);
        $this->addColumn('CONCLUSION', 'Conclusion', 'LONGVARCHAR', false, null, null);
        $this->addColumn('WORKERS', 'Workers', 'INTEGER', false, 6, null);
        $this->addColumn('STATUS', 'Status', 'INTEGER', false, 1, 0);
        $this->addColumn('OTHERCOMMENTS', 'Othercomments', 'LONGVARCHAR', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Construction', 'Construction', RelationMap::MANY_TO_ONE, array('constructionId' => 'id', ), 'CASCADE', null);
        $this->addRelation('Inspector', 'Inspector', RelationMap::MANY_TO_ONE, array('inspectorId' => 'id', ), 'CASCADE', null);
        $this->addRelation('InspectionPhoto', 'InspectionPhoto', RelationMap::ONE_TO_MANY, array('id' => 'inspectionId', ), 'CASCADE', null, 'InspectionPhotos');
        $this->addRelation('Resource', 'Resource', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Resources');
    } // buildRelations()

} // InspectionTableMap
