<?php



/**
 * Skeleton subclass for representing a row from the 'constructions_construction' table.
 *
 * Seguimiento de obras
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.constructions.classes
 */
class Construction extends BaseConstruction {
	
	static function createFromProject($project) {
		$construction = new Construction();
		return $construction->setProject($project)
			->updateFromProject();
	}
	
	function updateFromProject() {
		$project = $this->getProject();
		return $this->setName($project->getName())
			->setLatitude($project->getLatitude())
			->setLongitude($project->getLongitude());
	}

	/**
	 * Devuelve la ultima inspeccion cargada en el sistema relacionada con la obra.
	 * En caso de no existir devuelve un Inspection nuevo al usar findOneOrCreate
	 * @return object Inspection
	 */
	public function getLastInspection() {
		return InspectionQuery::create()
	      ->filterByConstruction($this)
	      ->orderByVisitdate(Criteria::DESC)
	      ->findOneOrCreate();
	}

} // Construction
