<?php


/**
 * Base class that represents a row from the 'actors_profileForm' table.
 *
 * Base de Formularios de Perfiles
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseProfileForm extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProfileFormPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProfileFormPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the relationship field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $relationship;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the question field.
     * @var        string
     */
    protected $question;

    /**
     * The value for the questiontype field.
     * @var        int
     */
    protected $questiontype;

    /**
     * The value for the label field.
     * @var        string
     */
    protected $label;

    /**
     * The value for the inanalysis field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $inanalysis;

    /**
     * The value for the tree_left field.
     * @var        int
     */
    protected $tree_left;

    /**
     * The value for the tree_right field.
     * @var        int
     */
    protected $tree_right;

    /**
     * The value for the tree_level field.
     * @var        int
     */
    protected $tree_level;

    /**
     * The value for the scope field.
     * @var        int
     */
    protected $scope;

    /**
     * @var        PropelObjectCollection|QuestionOption[] Collection to store aggregation of QuestionOption objects.
     */
    protected $collQuestionOptions;
    protected $collQuestionOptionsPartial;

    /**
     * @var        PropelObjectCollection|ActorRelation[] Collection to store aggregation of ActorRelation objects.
     */
    protected $collActorRelations;
    protected $collActorRelationsPartial;

    /**
     * @var        PropelObjectCollection|ActorActiveQuestion[] Collection to store aggregation of ActorActiveQuestion objects.
     */
    protected $collActorActiveQuestions;
    protected $collActorActiveQuestionsPartial;

    /**
     * @var        PropelObjectCollection|ActorActiveRelationQuestion[] Collection to store aggregation of ActorActiveRelationQuestion objects.
     */
    protected $collActorActiveRelationQuestions;
    protected $collActorActiveRelationQuestionsPartial;

    /**
     * @var        PropelObjectCollection|ActorFormAnswer[] Collection to store aggregation of ActorFormAnswer objects.
     */
    protected $collActorFormAnswers;
    protected $collActorFormAnswersPartial;

    /**
     * @var        PropelObjectCollection|Actor[] Collection to store aggregation of Actor objects.
     */
    protected $collActors;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    // nested_set behavior

    /**
     * Queries to be executed in the save transaction
     * @var        array
     */
    protected $nestedSetQueries = array();

    /**
     * Internal cache for children nodes
     * @var        null|PropelObjectCollection
     */
    protected $collNestedSetChildren = null;

    /**
     * Internal cache for parent node
     * @var        null|ProfileForm
     */
    protected $aNestedSetParent = null;


    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $questionOptionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorActiveQuestionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorActiveRelationQuestionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorFormAnswersScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->relationship = false;
        $this->inanalysis = false;
    }

    /**
     * Initializes internal state of BaseProfileForm object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Identificacion del formulario de perfil
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [relationship] column value.
     * Is this form a relationship form?
     * @return boolean
     */
    public function getRelationship()
    {
        return $this->relationship;
    }

    /**
     * Get the [type] column value.
     * Tipo de elemento
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [question] column value.
     * Texto de la pregunta
     * @return string
     */
    public function getQuestion()
    {
        return $this->question;
    }

    /**
     * Get the [questiontype] column value.
     * Tipo de pregunta
     * @return int
     */
    public function getQuestiontype()
    {
        return $this->questiontype;
    }

    /**
     * Get the [label] column value.
     * Label de la pregunta
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Get the [inanalysis] column value.
     * Aparece la pregunta en analysis?
     * @return boolean
     */
    public function getInanalysis()
    {
        return $this->inanalysis;
    }

    /**
     * Get the [tree_left] column value.
     *
     * @return int
     */
    public function getTreeLeft()
    {
        return $this->tree_left;
    }

    /**
     * Get the [tree_right] column value.
     *
     * @return int
     */
    public function getTreeRight()
    {
        return $this->tree_right;
    }

    /**
     * Get the [tree_level] column value.
     *
     * @return int
     */
    public function getTreeLevel()
    {
        return $this->tree_level;
    }

    /**
     * Get the [scope] column value.
     *
     * @return int
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Set the value of [id] column.
     * Identificacion del formulario de perfil
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProfileFormPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre
     * @param string $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProfileFormPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Sets the value of the [relationship] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Is this form a relationship form?
     * @param boolean|integer|string $v The new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setRelationship($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->relationship !== $v) {
            $this->relationship = $v;
            $this->modifiedColumns[] = ProfileFormPeer::RELATIONSHIP;
        }


        return $this;
    } // setRelationship()

    /**
     * Set the value of [type] column.
     * Tipo de elemento
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = ProfileFormPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Set the value of [question] column.
     * Texto de la pregunta
     * @param string $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setQuestion($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->question !== $v) {
            $this->question = $v;
            $this->modifiedColumns[] = ProfileFormPeer::QUESTION;
        }


        return $this;
    } // setQuestion()

    /**
     * Set the value of [questiontype] column.
     * Tipo de pregunta
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setQuestiontype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->questiontype !== $v) {
            $this->questiontype = $v;
            $this->modifiedColumns[] = ProfileFormPeer::QUESTIONTYPE;
        }


        return $this;
    } // setQuestiontype()

    /**
     * Set the value of [label] column.
     * Label de la pregunta
     * @param string $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setLabel($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->label !== $v) {
            $this->label = $v;
            $this->modifiedColumns[] = ProfileFormPeer::LABEL;
        }


        return $this;
    } // setLabel()

    /**
     * Sets the value of the [inanalysis] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Aparece la pregunta en analysis?
     * @param boolean|integer|string $v The new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setInanalysis($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->inanalysis !== $v) {
            $this->inanalysis = $v;
            $this->modifiedColumns[] = ProfileFormPeer::INANALYSIS;
        }


        return $this;
    } // setInanalysis()

    /**
     * Set the value of [tree_left] column.
     *
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setTreeLeft($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_left !== $v) {
            $this->tree_left = $v;
            $this->modifiedColumns[] = ProfileFormPeer::TREE_LEFT;
        }


        return $this;
    } // setTreeLeft()

    /**
     * Set the value of [tree_right] column.
     *
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setTreeRight($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_right !== $v) {
            $this->tree_right = $v;
            $this->modifiedColumns[] = ProfileFormPeer::TREE_RIGHT;
        }


        return $this;
    } // setTreeRight()

    /**
     * Set the value of [tree_level] column.
     *
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setTreeLevel($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_level !== $v) {
            $this->tree_level = $v;
            $this->modifiedColumns[] = ProfileFormPeer::TREE_LEVEL;
        }


        return $this;
    } // setTreeLevel()

    /**
     * Set the value of [scope] column.
     *
     * @param int $v new value
     * @return ProfileForm The current object (for fluent API support)
     */
    public function setScope($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->scope !== $v) {
            $this->scope = $v;
            $this->modifiedColumns[] = ProfileFormPeer::SCOPE;
        }


        return $this;
    } // setScope()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->relationship !== false) {
                return false;
            }

            if ($this->inanalysis !== false) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->relationship = ($row[$startcol + 2] !== null) ? (boolean) $row[$startcol + 2] : null;
            $this->type = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->question = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->questiontype = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->label = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->inanalysis = ($row[$startcol + 7] !== null) ? (boolean) $row[$startcol + 7] : null;
            $this->tree_left = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->tree_right = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->tree_level = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->scope = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = ProfileFormPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ProfileForm object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProfileFormPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collQuestionOptions = null;

            $this->collActorRelations = null;

            $this->collActorActiveQuestions = null;

            $this->collActorActiveRelationQuestions = null;

            $this->collActorFormAnswers = null;

            $this->collActors = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProfileFormQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // nested_set behavior
            if ($this->isRoot()) {
                throw new PropelException('Deletion of a root node is disabled for nested sets. Use ProfileFormPeer::deleteTree($scope) instead to delete an entire tree');
            }

            if ($this->isInTree()) {
                $this->deleteDescendants($con);
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                // nested_set behavior
                if ($this->isInTree()) {
                    // fill up the room that was used by the node
                    ProfileFormPeer::shiftRLValues(-2, $this->getRightValue() + 1, null, $this->getScopeValue(), $con);
                }

                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            // nested_set behavior
            if ($this->isNew() && $this->isRoot()) {
                // check if no other root exist in, the tree
                $nbRoots = ProfileFormQuery::create()
                    ->addUsingAlias(ProfileFormPeer::LEFT_COL, 1, Criteria::EQUAL)
                    ->addUsingAlias(ProfileFormPeer::SCOPE_COL, $this->getScopeValue(), Criteria::EQUAL)
                    ->count($con);
                if ($nbRoots > 0) {
                        throw new PropelException(sprintf('A root node already exists in this tree with scope "%s".', $this->getScopeValue()));
                }
            }
            $this->processNestedSetQueries($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProfileFormPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->actorsScheduledForDeletion !== null) {
                if (!$this->actorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->actorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ActorActiveRelationQuestionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->actorsScheduledForDeletion = null;
                }

                foreach ($this->getActors() as $actor) {
                    if ($actor->isModified()) {
                        $actor->save($con);
                    }
                }
            }

            if ($this->questionOptionsScheduledForDeletion !== null) {
                if (!$this->questionOptionsScheduledForDeletion->isEmpty()) {
                    QuestionOptionQuery::create()
                        ->filterByPrimaryKeys($this->questionOptionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->questionOptionsScheduledForDeletion = null;
                }
            }

            if ($this->collQuestionOptions !== null) {
                foreach ($this->collQuestionOptions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorRelationsScheduledForDeletion !== null) {
                if (!$this->actorRelationsScheduledForDeletion->isEmpty()) {
                    ActorRelationQuery::create()
                        ->filterByPrimaryKeys($this->actorRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collActorRelations !== null) {
                foreach ($this->collActorRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorActiveQuestionsScheduledForDeletion !== null) {
                if (!$this->actorActiveQuestionsScheduledForDeletion->isEmpty()) {
                    ActorActiveQuestionQuery::create()
                        ->filterByPrimaryKeys($this->actorActiveQuestionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorActiveQuestionsScheduledForDeletion = null;
                }
            }

            if ($this->collActorActiveQuestions !== null) {
                foreach ($this->collActorActiveQuestions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorActiveRelationQuestionsScheduledForDeletion !== null) {
                if (!$this->actorActiveRelationQuestionsScheduledForDeletion->isEmpty()) {
                    ActorActiveRelationQuestionQuery::create()
                        ->filterByPrimaryKeys($this->actorActiveRelationQuestionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorActiveRelationQuestionsScheduledForDeletion = null;
                }
            }

            if ($this->collActorActiveRelationQuestions !== null) {
                foreach ($this->collActorActiveRelationQuestions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorFormAnswersScheduledForDeletion !== null) {
                if (!$this->actorFormAnswersScheduledForDeletion->isEmpty()) {
                    ActorFormAnswerQuery::create()
                        ->filterByPrimaryKeys($this->actorFormAnswersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorFormAnswersScheduledForDeletion = null;
                }
            }

            if ($this->collActorFormAnswers !== null) {
                foreach ($this->collActorFormAnswers as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProfileFormPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProfileFormPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProfileFormPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProfileFormPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProfileFormPeer::RELATIONSHIP)) {
            $modifiedColumns[':p' . $index++]  = '`RELATIONSHIP`';
        }
        if ($this->isColumnModified(ProfileFormPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(ProfileFormPeer::QUESTION)) {
            $modifiedColumns[':p' . $index++]  = '`QUESTION`';
        }
        if ($this->isColumnModified(ProfileFormPeer::QUESTIONTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`QUESTIONTYPE`';
        }
        if ($this->isColumnModified(ProfileFormPeer::LABEL)) {
            $modifiedColumns[':p' . $index++]  = '`LABEL`';
        }
        if ($this->isColumnModified(ProfileFormPeer::INANALYSIS)) {
            $modifiedColumns[':p' . $index++]  = '`INANALYSIS`';
        }
        if ($this->isColumnModified(ProfileFormPeer::TREE_LEFT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEFT`';
        }
        if ($this->isColumnModified(ProfileFormPeer::TREE_RIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_RIGHT`';
        }
        if ($this->isColumnModified(ProfileFormPeer::TREE_LEVEL)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEVEL`';
        }
        if ($this->isColumnModified(ProfileFormPeer::SCOPE)) {
            $modifiedColumns[':p' . $index++]  = '`SCOPE`';
        }

        $sql = sprintf(
            'INSERT INTO `actors_profileForm` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`RELATIONSHIP`':
                        $stmt->bindValue($identifier, (int) $this->relationship, PDO::PARAM_INT);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`QUESTION`':
                        $stmt->bindValue($identifier, $this->question, PDO::PARAM_STR);
                        break;
                    case '`QUESTIONTYPE`':
                        $stmt->bindValue($identifier, $this->questiontype, PDO::PARAM_INT);
                        break;
                    case '`LABEL`':
                        $stmt->bindValue($identifier, $this->label, PDO::PARAM_STR);
                        break;
                    case '`INANALYSIS`':
                        $stmt->bindValue($identifier, (int) $this->inanalysis, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEFT`':
                        $stmt->bindValue($identifier, $this->tree_left, PDO::PARAM_INT);
                        break;
                    case '`TREE_RIGHT`':
                        $stmt->bindValue($identifier, $this->tree_right, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEVEL`':
                        $stmt->bindValue($identifier, $this->tree_level, PDO::PARAM_INT);
                        break;
                    case '`SCOPE`':
                        $stmt->bindValue($identifier, $this->scope, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = ProfileFormPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collQuestionOptions !== null) {
                    foreach ($this->collQuestionOptions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorRelations !== null) {
                    foreach ($this->collActorRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorActiveQuestions !== null) {
                    foreach ($this->collActorActiveQuestions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorActiveRelationQuestions !== null) {
                    foreach ($this->collActorActiveRelationQuestions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorFormAnswers !== null) {
                    foreach ($this->collActorFormAnswers as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProfileFormPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getRelationship();
                break;
            case 3:
                return $this->getType();
                break;
            case 4:
                return $this->getQuestion();
                break;
            case 5:
                return $this->getQuestiontype();
                break;
            case 6:
                return $this->getLabel();
                break;
            case 7:
                return $this->getInanalysis();
                break;
            case 8:
                return $this->getTreeLeft();
                break;
            case 9:
                return $this->getTreeRight();
                break;
            case 10:
                return $this->getTreeLevel();
                break;
            case 11:
                return $this->getScope();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ProfileForm'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ProfileForm'][$this->getPrimaryKey()] = true;
        $keys = ProfileFormPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getRelationship(),
            $keys[3] => $this->getType(),
            $keys[4] => $this->getQuestion(),
            $keys[5] => $this->getQuestiontype(),
            $keys[6] => $this->getLabel(),
            $keys[7] => $this->getInanalysis(),
            $keys[8] => $this->getTreeLeft(),
            $keys[9] => $this->getTreeRight(),
            $keys[10] => $this->getTreeLevel(),
            $keys[11] => $this->getScope(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collQuestionOptions) {
                $result['QuestionOptions'] = $this->collQuestionOptions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorRelations) {
                $result['ActorRelations'] = $this->collActorRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorActiveQuestions) {
                $result['ActorActiveQuestions'] = $this->collActorActiveQuestions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorActiveRelationQuestions) {
                $result['ActorActiveRelationQuestions'] = $this->collActorActiveRelationQuestions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorFormAnswers) {
                $result['ActorFormAnswers'] = $this->collActorFormAnswers->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProfileFormPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setRelationship($value);
                break;
            case 3:
                $this->setType($value);
                break;
            case 4:
                $this->setQuestion($value);
                break;
            case 5:
                $this->setQuestiontype($value);
                break;
            case 6:
                $this->setLabel($value);
                break;
            case 7:
                $this->setInanalysis($value);
                break;
            case 8:
                $this->setTreeLeft($value);
                break;
            case 9:
                $this->setTreeRight($value);
                break;
            case 10:
                $this->setTreeLevel($value);
                break;
            case 11:
                $this->setScope($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProfileFormPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setRelationship($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setType($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setQuestion($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setQuestiontype($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setLabel($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setInanalysis($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setTreeLeft($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setTreeRight($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setTreeLevel($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setScope($arr[$keys[11]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProfileFormPeer::DATABASE_NAME);

        if ($this->isColumnModified(ProfileFormPeer::ID)) $criteria->add(ProfileFormPeer::ID, $this->id);
        if ($this->isColumnModified(ProfileFormPeer::NAME)) $criteria->add(ProfileFormPeer::NAME, $this->name);
        if ($this->isColumnModified(ProfileFormPeer::RELATIONSHIP)) $criteria->add(ProfileFormPeer::RELATIONSHIP, $this->relationship);
        if ($this->isColumnModified(ProfileFormPeer::TYPE)) $criteria->add(ProfileFormPeer::TYPE, $this->type);
        if ($this->isColumnModified(ProfileFormPeer::QUESTION)) $criteria->add(ProfileFormPeer::QUESTION, $this->question);
        if ($this->isColumnModified(ProfileFormPeer::QUESTIONTYPE)) $criteria->add(ProfileFormPeer::QUESTIONTYPE, $this->questiontype);
        if ($this->isColumnModified(ProfileFormPeer::LABEL)) $criteria->add(ProfileFormPeer::LABEL, $this->label);
        if ($this->isColumnModified(ProfileFormPeer::INANALYSIS)) $criteria->add(ProfileFormPeer::INANALYSIS, $this->inanalysis);
        if ($this->isColumnModified(ProfileFormPeer::TREE_LEFT)) $criteria->add(ProfileFormPeer::TREE_LEFT, $this->tree_left);
        if ($this->isColumnModified(ProfileFormPeer::TREE_RIGHT)) $criteria->add(ProfileFormPeer::TREE_RIGHT, $this->tree_right);
        if ($this->isColumnModified(ProfileFormPeer::TREE_LEVEL)) $criteria->add(ProfileFormPeer::TREE_LEVEL, $this->tree_level);
        if ($this->isColumnModified(ProfileFormPeer::SCOPE)) $criteria->add(ProfileFormPeer::SCOPE, $this->scope);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProfileFormPeer::DATABASE_NAME);
        $criteria->add(ProfileFormPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ProfileForm (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setRelationship($this->getRelationship());
        $copyObj->setType($this->getType());
        $copyObj->setQuestion($this->getQuestion());
        $copyObj->setQuestiontype($this->getQuestiontype());
        $copyObj->setLabel($this->getLabel());
        $copyObj->setInanalysis($this->getInanalysis());
        $copyObj->setTreeLeft($this->getTreeLeft());
        $copyObj->setTreeRight($this->getTreeRight());
        $copyObj->setTreeLevel($this->getTreeLevel());
        $copyObj->setScope($this->getScope());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getQuestionOptions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addQuestionOption($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorActiveQuestions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorActiveQuestion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorActiveRelationQuestions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorActiveRelationQuestion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorFormAnswers() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorFormAnswer($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ProfileForm Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProfileFormPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProfileFormPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('QuestionOption' == $relationName) {
            $this->initQuestionOptions();
        }
        if ('ActorRelation' == $relationName) {
            $this->initActorRelations();
        }
        if ('ActorActiveQuestion' == $relationName) {
            $this->initActorActiveQuestions();
        }
        if ('ActorActiveRelationQuestion' == $relationName) {
            $this->initActorActiveRelationQuestions();
        }
        if ('ActorFormAnswer' == $relationName) {
            $this->initActorFormAnswers();
        }
    }

    /**
     * Clears out the collQuestionOptions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addQuestionOptions()
     */
    public function clearQuestionOptions()
    {
        $this->collQuestionOptions = null; // important to set this to null since that means it is uninitialized
        $this->collQuestionOptionsPartial = null;
    }

    /**
     * reset is the collQuestionOptions collection loaded partially
     *
     * @return void
     */
    public function resetPartialQuestionOptions($v = true)
    {
        $this->collQuestionOptionsPartial = $v;
    }

    /**
     * Initializes the collQuestionOptions collection.
     *
     * By default this just sets the collQuestionOptions collection to an empty array (like clearcollQuestionOptions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initQuestionOptions($overrideExisting = true)
    {
        if (null !== $this->collQuestionOptions && !$overrideExisting) {
            return;
        }
        $this->collQuestionOptions = new PropelObjectCollection();
        $this->collQuestionOptions->setModel('QuestionOption');
    }

    /**
     * Gets an array of QuestionOption objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|QuestionOption[] List of QuestionOption objects
     * @throws PropelException
     */
    public function getQuestionOptions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collQuestionOptionsPartial && !$this->isNew();
        if (null === $this->collQuestionOptions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collQuestionOptions) {
                // return empty collection
                $this->initQuestionOptions();
            } else {
                $collQuestionOptions = QuestionOptionQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collQuestionOptionsPartial && count($collQuestionOptions)) {
                      $this->initQuestionOptions(false);

                      foreach($collQuestionOptions as $obj) {
                        if (false == $this->collQuestionOptions->contains($obj)) {
                          $this->collQuestionOptions->append($obj);
                        }
                      }

                      $this->collQuestionOptionsPartial = true;
                    }

                    return $collQuestionOptions;
                }

                if($partial && $this->collQuestionOptions) {
                    foreach($this->collQuestionOptions as $obj) {
                        if($obj->isNew()) {
                            $collQuestionOptions[] = $obj;
                        }
                    }
                }

                $this->collQuestionOptions = $collQuestionOptions;
                $this->collQuestionOptionsPartial = false;
            }
        }

        return $this->collQuestionOptions;
    }

    /**
     * Sets a collection of QuestionOption objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $questionOptions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setQuestionOptions(PropelCollection $questionOptions, PropelPDO $con = null)
    {
        $this->questionOptionsScheduledForDeletion = $this->getQuestionOptions(new Criteria(), $con)->diff($questionOptions);

        foreach ($this->questionOptionsScheduledForDeletion as $questionOptionRemoved) {
            $questionOptionRemoved->setProfileForm(null);
        }

        $this->collQuestionOptions = null;
        foreach ($questionOptions as $questionOption) {
            $this->addQuestionOption($questionOption);
        }

        $this->collQuestionOptions = $questionOptions;
        $this->collQuestionOptionsPartial = false;
    }

    /**
     * Returns the number of related QuestionOption objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related QuestionOption objects.
     * @throws PropelException
     */
    public function countQuestionOptions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collQuestionOptionsPartial && !$this->isNew();
        if (null === $this->collQuestionOptions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collQuestionOptions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getQuestionOptions());
                }
                $query = QuestionOptionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collQuestionOptions);
        }
    }

    /**
     * Method called to associate a QuestionOption object to this object
     * through the QuestionOption foreign key attribute.
     *
     * @param    QuestionOption $l QuestionOption
     * @return ProfileForm The current object (for fluent API support)
     */
    public function addQuestionOption(QuestionOption $l)
    {
        if ($this->collQuestionOptions === null) {
            $this->initQuestionOptions();
            $this->collQuestionOptionsPartial = true;
        }
        if (!$this->collQuestionOptions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddQuestionOption($l);
        }

        return $this;
    }

    /**
     * @param	QuestionOption $questionOption The questionOption object to add.
     */
    protected function doAddQuestionOption($questionOption)
    {
        $this->collQuestionOptions[]= $questionOption;
        $questionOption->setProfileForm($this);
    }

    /**
     * @param	QuestionOption $questionOption The questionOption object to remove.
     */
    public function removeQuestionOption($questionOption)
    {
        if ($this->getQuestionOptions()->contains($questionOption)) {
            $this->collQuestionOptions->remove($this->collQuestionOptions->search($questionOption));
            if (null === $this->questionOptionsScheduledForDeletion) {
                $this->questionOptionsScheduledForDeletion = clone $this->collQuestionOptions;
                $this->questionOptionsScheduledForDeletion->clear();
            }
            $this->questionOptionsScheduledForDeletion[]= $questionOption;
            $questionOption->setProfileForm(null);
        }
    }

    /**
     * Clears out the collActorRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorRelations()
     */
    public function clearActorRelations()
    {
        $this->collActorRelations = null; // important to set this to null since that means it is uninitialized
        $this->collActorRelationsPartial = null;
    }

    /**
     * reset is the collActorRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorRelations($v = true)
    {
        $this->collActorRelationsPartial = $v;
    }

    /**
     * Initializes the collActorRelations collection.
     *
     * By default this just sets the collActorRelations collection to an empty array (like clearcollActorRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorRelations($overrideExisting = true)
    {
        if (null !== $this->collActorRelations && !$overrideExisting) {
            return;
        }
        $this->collActorRelations = new PropelObjectCollection();
        $this->collActorRelations->setModel('ActorRelation');
    }

    /**
     * Gets an array of ActorRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorRelation[] List of ActorRelation objects
     * @throws PropelException
     */
    public function getActorRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorRelationsPartial && !$this->isNew();
        if (null === $this->collActorRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorRelations) {
                // return empty collection
                $this->initActorRelations();
            } else {
                $collActorRelations = ActorRelationQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorRelationsPartial && count($collActorRelations)) {
                      $this->initActorRelations(false);

                      foreach($collActorRelations as $obj) {
                        if (false == $this->collActorRelations->contains($obj)) {
                          $this->collActorRelations->append($obj);
                        }
                      }

                      $this->collActorRelationsPartial = true;
                    }

                    return $collActorRelations;
                }

                if($partial && $this->collActorRelations) {
                    foreach($this->collActorRelations as $obj) {
                        if($obj->isNew()) {
                            $collActorRelations[] = $obj;
                        }
                    }
                }

                $this->collActorRelations = $collActorRelations;
                $this->collActorRelationsPartial = false;
            }
        }

        return $this->collActorRelations;
    }

    /**
     * Sets a collection of ActorRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorRelations(PropelCollection $actorRelations, PropelPDO $con = null)
    {
        $this->actorRelationsScheduledForDeletion = $this->getActorRelations(new Criteria(), $con)->diff($actorRelations);

        foreach ($this->actorRelationsScheduledForDeletion as $actorRelationRemoved) {
            $actorRelationRemoved->setProfileForm(null);
        }

        $this->collActorRelations = null;
        foreach ($actorRelations as $actorRelation) {
            $this->addActorRelation($actorRelation);
        }

        $this->collActorRelations = $actorRelations;
        $this->collActorRelationsPartial = false;
    }

    /**
     * Returns the number of related ActorRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorRelation objects.
     * @throws PropelException
     */
    public function countActorRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorRelationsPartial && !$this->isNew();
        if (null === $this->collActorRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorRelations());
                }
                $query = ActorRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorRelations);
        }
    }

    /**
     * Method called to associate a ActorRelation object to this object
     * through the ActorRelation foreign key attribute.
     *
     * @param    ActorRelation $l ActorRelation
     * @return ProfileForm The current object (for fluent API support)
     */
    public function addActorRelation(ActorRelation $l)
    {
        if ($this->collActorRelations === null) {
            $this->initActorRelations();
            $this->collActorRelationsPartial = true;
        }
        if (!$this->collActorRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorRelation($l);
        }

        return $this;
    }

    /**
     * @param	ActorRelation $actorRelation The actorRelation object to add.
     */
    protected function doAddActorRelation($actorRelation)
    {
        $this->collActorRelations[]= $actorRelation;
        $actorRelation->setProfileForm($this);
    }

    /**
     * @param	ActorRelation $actorRelation The actorRelation object to remove.
     */
    public function removeActorRelation($actorRelation)
    {
        if ($this->getActorRelations()->contains($actorRelation)) {
            $this->collActorRelations->remove($this->collActorRelations->search($actorRelation));
            if (null === $this->actorRelationsScheduledForDeletion) {
                $this->actorRelationsScheduledForDeletion = clone $this->collActorRelations;
                $this->actorRelationsScheduledForDeletion->clear();
            }
            $this->actorRelationsScheduledForDeletion[]= $actorRelation;
            $actorRelation->setProfileForm(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProfileForm is new, it will return
     * an empty collection; or if this ProfileForm has previously
     * been saved, it will retrieve related ActorRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProfileForm.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorRelation[] List of ActorRelation objects
     */
    public function getActorRelationsJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorRelationQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getActorRelations($query, $con);
    }

    /**
     * Clears out the collActorActiveQuestions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorActiveQuestions()
     */
    public function clearActorActiveQuestions()
    {
        $this->collActorActiveQuestions = null; // important to set this to null since that means it is uninitialized
        $this->collActorActiveQuestionsPartial = null;
    }

    /**
     * reset is the collActorActiveQuestions collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorActiveQuestions($v = true)
    {
        $this->collActorActiveQuestionsPartial = $v;
    }

    /**
     * Initializes the collActorActiveQuestions collection.
     *
     * By default this just sets the collActorActiveQuestions collection to an empty array (like clearcollActorActiveQuestions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorActiveQuestions($overrideExisting = true)
    {
        if (null !== $this->collActorActiveQuestions && !$overrideExisting) {
            return;
        }
        $this->collActorActiveQuestions = new PropelObjectCollection();
        $this->collActorActiveQuestions->setModel('ActorActiveQuestion');
    }

    /**
     * Gets an array of ActorActiveQuestion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorActiveQuestion[] List of ActorActiveQuestion objects
     * @throws PropelException
     */
    public function getActorActiveQuestions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveQuestions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorActiveQuestions) {
                // return empty collection
                $this->initActorActiveQuestions();
            } else {
                $collActorActiveQuestions = ActorActiveQuestionQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorActiveQuestionsPartial && count($collActorActiveQuestions)) {
                      $this->initActorActiveQuestions(false);

                      foreach($collActorActiveQuestions as $obj) {
                        if (false == $this->collActorActiveQuestions->contains($obj)) {
                          $this->collActorActiveQuestions->append($obj);
                        }
                      }

                      $this->collActorActiveQuestionsPartial = true;
                    }

                    return $collActorActiveQuestions;
                }

                if($partial && $this->collActorActiveQuestions) {
                    foreach($this->collActorActiveQuestions as $obj) {
                        if($obj->isNew()) {
                            $collActorActiveQuestions[] = $obj;
                        }
                    }
                }

                $this->collActorActiveQuestions = $collActorActiveQuestions;
                $this->collActorActiveQuestionsPartial = false;
            }
        }

        return $this->collActorActiveQuestions;
    }

    /**
     * Sets a collection of ActorActiveQuestion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorActiveQuestions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorActiveQuestions(PropelCollection $actorActiveQuestions, PropelPDO $con = null)
    {
        $this->actorActiveQuestionsScheduledForDeletion = $this->getActorActiveQuestions(new Criteria(), $con)->diff($actorActiveQuestions);

        foreach ($this->actorActiveQuestionsScheduledForDeletion as $actorActiveQuestionRemoved) {
            $actorActiveQuestionRemoved->setProfileForm(null);
        }

        $this->collActorActiveQuestions = null;
        foreach ($actorActiveQuestions as $actorActiveQuestion) {
            $this->addActorActiveQuestion($actorActiveQuestion);
        }

        $this->collActorActiveQuestions = $actorActiveQuestions;
        $this->collActorActiveQuestionsPartial = false;
    }

    /**
     * Returns the number of related ActorActiveQuestion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorActiveQuestion objects.
     * @throws PropelException
     */
    public function countActorActiveQuestions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveQuestions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorActiveQuestions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorActiveQuestions());
                }
                $query = ActorActiveQuestionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorActiveQuestions);
        }
    }

    /**
     * Method called to associate a ActorActiveQuestion object to this object
     * through the ActorActiveQuestion foreign key attribute.
     *
     * @param    ActorActiveQuestion $l ActorActiveQuestion
     * @return ProfileForm The current object (for fluent API support)
     */
    public function addActorActiveQuestion(ActorActiveQuestion $l)
    {
        if ($this->collActorActiveQuestions === null) {
            $this->initActorActiveQuestions();
            $this->collActorActiveQuestionsPartial = true;
        }
        if (!$this->collActorActiveQuestions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorActiveQuestion($l);
        }

        return $this;
    }

    /**
     * @param	ActorActiveQuestion $actorActiveQuestion The actorActiveQuestion object to add.
     */
    protected function doAddActorActiveQuestion($actorActiveQuestion)
    {
        $this->collActorActiveQuestions[]= $actorActiveQuestion;
        $actorActiveQuestion->setProfileForm($this);
    }

    /**
     * @param	ActorActiveQuestion $actorActiveQuestion The actorActiveQuestion object to remove.
     */
    public function removeActorActiveQuestion($actorActiveQuestion)
    {
        if ($this->getActorActiveQuestions()->contains($actorActiveQuestion)) {
            $this->collActorActiveQuestions->remove($this->collActorActiveQuestions->search($actorActiveQuestion));
            if (null === $this->actorActiveQuestionsScheduledForDeletion) {
                $this->actorActiveQuestionsScheduledForDeletion = clone $this->collActorActiveQuestions;
                $this->actorActiveQuestionsScheduledForDeletion->clear();
            }
            $this->actorActiveQuestionsScheduledForDeletion[]= $actorActiveQuestion;
            $actorActiveQuestion->setProfileForm(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProfileForm is new, it will return
     * an empty collection; or if this ProfileForm has previously
     * been saved, it will retrieve related ActorActiveQuestions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProfileForm.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorActiveQuestion[] List of ActorActiveQuestion objects
     */
    public function getActorActiveQuestionsJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorActiveQuestionQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getActorActiveQuestions($query, $con);
    }

    /**
     * Clears out the collActorActiveRelationQuestions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorActiveRelationQuestions()
     */
    public function clearActorActiveRelationQuestions()
    {
        $this->collActorActiveRelationQuestions = null; // important to set this to null since that means it is uninitialized
        $this->collActorActiveRelationQuestionsPartial = null;
    }

    /**
     * reset is the collActorActiveRelationQuestions collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorActiveRelationQuestions($v = true)
    {
        $this->collActorActiveRelationQuestionsPartial = $v;
    }

    /**
     * Initializes the collActorActiveRelationQuestions collection.
     *
     * By default this just sets the collActorActiveRelationQuestions collection to an empty array (like clearcollActorActiveRelationQuestions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorActiveRelationQuestions($overrideExisting = true)
    {
        if (null !== $this->collActorActiveRelationQuestions && !$overrideExisting) {
            return;
        }
        $this->collActorActiveRelationQuestions = new PropelObjectCollection();
        $this->collActorActiveRelationQuestions->setModel('ActorActiveRelationQuestion');
    }

    /**
     * Gets an array of ActorActiveRelationQuestion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorActiveRelationQuestion[] List of ActorActiveRelationQuestion objects
     * @throws PropelException
     */
    public function getActorActiveRelationQuestions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveRelationQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveRelationQuestions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorActiveRelationQuestions) {
                // return empty collection
                $this->initActorActiveRelationQuestions();
            } else {
                $collActorActiveRelationQuestions = ActorActiveRelationQuestionQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorActiveRelationQuestionsPartial && count($collActorActiveRelationQuestions)) {
                      $this->initActorActiveRelationQuestions(false);

                      foreach($collActorActiveRelationQuestions as $obj) {
                        if (false == $this->collActorActiveRelationQuestions->contains($obj)) {
                          $this->collActorActiveRelationQuestions->append($obj);
                        }
                      }

                      $this->collActorActiveRelationQuestionsPartial = true;
                    }

                    return $collActorActiveRelationQuestions;
                }

                if($partial && $this->collActorActiveRelationQuestions) {
                    foreach($this->collActorActiveRelationQuestions as $obj) {
                        if($obj->isNew()) {
                            $collActorActiveRelationQuestions[] = $obj;
                        }
                    }
                }

                $this->collActorActiveRelationQuestions = $collActorActiveRelationQuestions;
                $this->collActorActiveRelationQuestionsPartial = false;
            }
        }

        return $this->collActorActiveRelationQuestions;
    }

    /**
     * Sets a collection of ActorActiveRelationQuestion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorActiveRelationQuestions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorActiveRelationQuestions(PropelCollection $actorActiveRelationQuestions, PropelPDO $con = null)
    {
        $this->actorActiveRelationQuestionsScheduledForDeletion = $this->getActorActiveRelationQuestions(new Criteria(), $con)->diff($actorActiveRelationQuestions);

        foreach ($this->actorActiveRelationQuestionsScheduledForDeletion as $actorActiveRelationQuestionRemoved) {
            $actorActiveRelationQuestionRemoved->setProfileForm(null);
        }

        $this->collActorActiveRelationQuestions = null;
        foreach ($actorActiveRelationQuestions as $actorActiveRelationQuestion) {
            $this->addActorActiveRelationQuestion($actorActiveRelationQuestion);
        }

        $this->collActorActiveRelationQuestions = $actorActiveRelationQuestions;
        $this->collActorActiveRelationQuestionsPartial = false;
    }

    /**
     * Returns the number of related ActorActiveRelationQuestion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorActiveRelationQuestion objects.
     * @throws PropelException
     */
    public function countActorActiveRelationQuestions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveRelationQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveRelationQuestions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorActiveRelationQuestions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorActiveRelationQuestions());
                }
                $query = ActorActiveRelationQuestionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorActiveRelationQuestions);
        }
    }

    /**
     * Method called to associate a ActorActiveRelationQuestion object to this object
     * through the ActorActiveRelationQuestion foreign key attribute.
     *
     * @param    ActorActiveRelationQuestion $l ActorActiveRelationQuestion
     * @return ProfileForm The current object (for fluent API support)
     */
    public function addActorActiveRelationQuestion(ActorActiveRelationQuestion $l)
    {
        if ($this->collActorActiveRelationQuestions === null) {
            $this->initActorActiveRelationQuestions();
            $this->collActorActiveRelationQuestionsPartial = true;
        }
        if (!$this->collActorActiveRelationQuestions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorActiveRelationQuestion($l);
        }

        return $this;
    }

    /**
     * @param	ActorActiveRelationQuestion $actorActiveRelationQuestion The actorActiveRelationQuestion object to add.
     */
    protected function doAddActorActiveRelationQuestion($actorActiveRelationQuestion)
    {
        $this->collActorActiveRelationQuestions[]= $actorActiveRelationQuestion;
        $actorActiveRelationQuestion->setProfileForm($this);
    }

    /**
     * @param	ActorActiveRelationQuestion $actorActiveRelationQuestion The actorActiveRelationQuestion object to remove.
     */
    public function removeActorActiveRelationQuestion($actorActiveRelationQuestion)
    {
        if ($this->getActorActiveRelationQuestions()->contains($actorActiveRelationQuestion)) {
            $this->collActorActiveRelationQuestions->remove($this->collActorActiveRelationQuestions->search($actorActiveRelationQuestion));
            if (null === $this->actorActiveRelationQuestionsScheduledForDeletion) {
                $this->actorActiveRelationQuestionsScheduledForDeletion = clone $this->collActorActiveRelationQuestions;
                $this->actorActiveRelationQuestionsScheduledForDeletion->clear();
            }
            $this->actorActiveRelationQuestionsScheduledForDeletion[]= $actorActiveRelationQuestion;
            $actorActiveRelationQuestion->setProfileForm(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProfileForm is new, it will return
     * an empty collection; or if this ProfileForm has previously
     * been saved, it will retrieve related ActorActiveRelationQuestions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProfileForm.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorActiveRelationQuestion[] List of ActorActiveRelationQuestion objects
     */
    public function getActorActiveRelationQuestionsJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorActiveRelationQuestionQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getActorActiveRelationQuestions($query, $con);
    }

    /**
     * Clears out the collActorFormAnswers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorFormAnswers()
     */
    public function clearActorFormAnswers()
    {
        $this->collActorFormAnswers = null; // important to set this to null since that means it is uninitialized
        $this->collActorFormAnswersPartial = null;
    }

    /**
     * reset is the collActorFormAnswers collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorFormAnswers($v = true)
    {
        $this->collActorFormAnswersPartial = $v;
    }

    /**
     * Initializes the collActorFormAnswers collection.
     *
     * By default this just sets the collActorFormAnswers collection to an empty array (like clearcollActorFormAnswers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorFormAnswers($overrideExisting = true)
    {
        if (null !== $this->collActorFormAnswers && !$overrideExisting) {
            return;
        }
        $this->collActorFormAnswers = new PropelObjectCollection();
        $this->collActorFormAnswers->setModel('ActorFormAnswer');
    }

    /**
     * Gets an array of ActorFormAnswer objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorFormAnswer[] List of ActorFormAnswer objects
     * @throws PropelException
     */
    public function getActorFormAnswers($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorFormAnswersPartial && !$this->isNew();
        if (null === $this->collActorFormAnswers || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorFormAnswers) {
                // return empty collection
                $this->initActorFormAnswers();
            } else {
                $collActorFormAnswers = ActorFormAnswerQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorFormAnswersPartial && count($collActorFormAnswers)) {
                      $this->initActorFormAnswers(false);

                      foreach($collActorFormAnswers as $obj) {
                        if (false == $this->collActorFormAnswers->contains($obj)) {
                          $this->collActorFormAnswers->append($obj);
                        }
                      }

                      $this->collActorFormAnswersPartial = true;
                    }

                    return $collActorFormAnswers;
                }

                if($partial && $this->collActorFormAnswers) {
                    foreach($this->collActorFormAnswers as $obj) {
                        if($obj->isNew()) {
                            $collActorFormAnswers[] = $obj;
                        }
                    }
                }

                $this->collActorFormAnswers = $collActorFormAnswers;
                $this->collActorFormAnswersPartial = false;
            }
        }

        return $this->collActorFormAnswers;
    }

    /**
     * Sets a collection of ActorFormAnswer objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorFormAnswers A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorFormAnswers(PropelCollection $actorFormAnswers, PropelPDO $con = null)
    {
        $this->actorFormAnswersScheduledForDeletion = $this->getActorFormAnswers(new Criteria(), $con)->diff($actorFormAnswers);

        foreach ($this->actorFormAnswersScheduledForDeletion as $actorFormAnswerRemoved) {
            $actorFormAnswerRemoved->setProfileForm(null);
        }

        $this->collActorFormAnswers = null;
        foreach ($actorFormAnswers as $actorFormAnswer) {
            $this->addActorFormAnswer($actorFormAnswer);
        }

        $this->collActorFormAnswers = $actorFormAnswers;
        $this->collActorFormAnswersPartial = false;
    }

    /**
     * Returns the number of related ActorFormAnswer objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorFormAnswer objects.
     * @throws PropelException
     */
    public function countActorFormAnswers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorFormAnswersPartial && !$this->isNew();
        if (null === $this->collActorFormAnswers || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorFormAnswers) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorFormAnswers());
                }
                $query = ActorFormAnswerQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorFormAnswers);
        }
    }

    /**
     * Method called to associate a ActorFormAnswer object to this object
     * through the ActorFormAnswer foreign key attribute.
     *
     * @param    ActorFormAnswer $l ActorFormAnswer
     * @return ProfileForm The current object (for fluent API support)
     */
    public function addActorFormAnswer(ActorFormAnswer $l)
    {
        if ($this->collActorFormAnswers === null) {
            $this->initActorFormAnswers();
            $this->collActorFormAnswersPartial = true;
        }
        if (!$this->collActorFormAnswers->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorFormAnswer($l);
        }

        return $this;
    }

    /**
     * @param	ActorFormAnswer $actorFormAnswer The actorFormAnswer object to add.
     */
    protected function doAddActorFormAnswer($actorFormAnswer)
    {
        $this->collActorFormAnswers[]= $actorFormAnswer;
        $actorFormAnswer->setProfileForm($this);
    }

    /**
     * @param	ActorFormAnswer $actorFormAnswer The actorFormAnswer object to remove.
     */
    public function removeActorFormAnswer($actorFormAnswer)
    {
        if ($this->getActorFormAnswers()->contains($actorFormAnswer)) {
            $this->collActorFormAnswers->remove($this->collActorFormAnswers->search($actorFormAnswer));
            if (null === $this->actorFormAnswersScheduledForDeletion) {
                $this->actorFormAnswersScheduledForDeletion = clone $this->collActorFormAnswers;
                $this->actorFormAnswersScheduledForDeletion->clear();
            }
            $this->actorFormAnswersScheduledForDeletion[]= $actorFormAnswer;
            $actorFormAnswer->setProfileForm(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProfileForm is new, it will return
     * an empty collection; or if this ProfileForm has previously
     * been saved, it will retrieve related ActorFormAnswers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProfileForm.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorFormAnswer[] List of ActorFormAnswer objects
     */
    public function getActorFormAnswersJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorFormAnswerQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getActorFormAnswers($query, $con);
    }

    /**
     * Clears out the collActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActors()
     */
    public function clearActors()
    {
        $this->collActors = null; // important to set this to null since that means it is uninitialized
        $this->collActorsPartial = null;
    }

    /**
     * Initializes the collActors collection.
     *
     * By default this just sets the collActors collection to an empty collection (like clearActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initActors()
    {
        $this->collActors = new PropelObjectCollection();
        $this->collActors->setModel('Actor');
    }

    /**
     * Gets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProfileForm is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Actor[] List of Actor objects
     */
    public function getActors($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                // return empty collection
                $this->initActors();
            } else {
                $collActors = ActorQuery::create(null, $criteria)
                    ->filterByProfileForm($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collActors;
                }
                $this->collActors = $collActors;
            }
        }

        return $this->collActors;
    }

    /**
     * Sets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActors(PropelCollection $actors, PropelPDO $con = null)
    {
        $this->clearActors();
        $currentActors = $this->getActors();

        $this->actorsScheduledForDeletion = $currentActors->diff($actors);

        foreach ($actors as $actor) {
            if (!$currentActors->contains($actor)) {
                $this->doAddActor($actor);
            }
        }

        $this->collActors = $actors;
    }

    /**
     * Gets the number of Actor objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Actor objects
     */
    public function countActors($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                return 0;
            } else {
                $query = ActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProfileForm($this)
                    ->count($con);
            }
        } else {
            return count($this->collActors);
        }
    }

    /**
     * Associate a Actor object to this object
     * through the actors_activeRelationQuestions cross reference table.
     *
     * @param  Actor $actor The ActorActiveRelationQuestion object to relate
     * @return void
     */
    public function addActor(Actor $actor)
    {
        if ($this->collActors === null) {
            $this->initActors();
        }
        if (!$this->collActors->contains($actor)) { // only add it if the **same** object is not already associated
            $this->doAddActor($actor);

            $this->collActors[]= $actor;
        }
    }

    /**
     * @param	Actor $actor The actor object to add.
     */
    protected function doAddActor($actor)
    {
        $actorActiveRelationQuestion = new ActorActiveRelationQuestion();
        $actorActiveRelationQuestion->setActor($actor);
        $this->addActorActiveRelationQuestion($actorActiveRelationQuestion);
    }

    /**
     * Remove a Actor object to this object
     * through the actors_activeRelationQuestions cross reference table.
     *
     * @param Actor $actor The ActorActiveRelationQuestion object to relate
     * @return void
     */
    public function removeActor(Actor $actor)
    {
        if ($this->getActors()->contains($actor)) {
            $this->collActors->remove($this->collActors->search($actor));
            if (null === $this->actorsScheduledForDeletion) {
                $this->actorsScheduledForDeletion = clone $this->collActors;
                $this->actorsScheduledForDeletion->clear();
            }
            $this->actorsScheduledForDeletion[]= $actor;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->relationship = null;
        $this->type = null;
        $this->question = null;
        $this->questiontype = null;
        $this->label = null;
        $this->inanalysis = null;
        $this->tree_left = null;
        $this->tree_right = null;
        $this->tree_level = null;
        $this->scope = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collQuestionOptions) {
                foreach ($this->collQuestionOptions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorRelations) {
                foreach ($this->collActorRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorActiveQuestions) {
                foreach ($this->collActorActiveQuestions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorActiveRelationQuestions) {
                foreach ($this->collActorActiveRelationQuestions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorFormAnswers) {
                foreach ($this->collActorFormAnswers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActors) {
                foreach ($this->collActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        // nested_set behavior
        $this->collNestedSetChildren = null;
        $this->aNestedSetParent = null;
        if ($this->collQuestionOptions instanceof PropelCollection) {
            $this->collQuestionOptions->clearIterator();
        }
        $this->collQuestionOptions = null;
        if ($this->collActorRelations instanceof PropelCollection) {
            $this->collActorRelations->clearIterator();
        }
        $this->collActorRelations = null;
        if ($this->collActorActiveQuestions instanceof PropelCollection) {
            $this->collActorActiveQuestions->clearIterator();
        }
        $this->collActorActiveQuestions = null;
        if ($this->collActorActiveRelationQuestions instanceof PropelCollection) {
            $this->collActorActiveRelationQuestions->clearIterator();
        }
        $this->collActorActiveRelationQuestions = null;
        if ($this->collActorFormAnswers instanceof PropelCollection) {
            $this->collActorFormAnswers->clearIterator();
        }
        $this->collActorFormAnswers = null;
        if ($this->collActors instanceof PropelCollection) {
            $this->collActors->clearIterator();
        }
        $this->collActors = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ProfileFormPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // nested_set behavior

    /**
     * Execute queries that were saved to be run inside the save transaction
     */
    protected function processNestedSetQueries($con)
    {
        foreach ($this->nestedSetQueries as $query) {
            $query['arguments'][]= $con;
            call_user_func_array($query['callable'], $query['arguments']);
        }
        $this->nestedSetQueries = array();
    }

    /**
     * Proxy getter method for the left value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set left value
     */
    public function getLeftValue()
    {
        return $this->tree_left;
    }

    /**
     * Proxy getter method for the right value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set right value
     */
    public function getRightValue()
    {
        return $this->tree_right;
    }

    /**
     * Proxy getter method for the level value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set level value
     */
    public function getLevel()
    {
        return $this->tree_level;
    }

    /**
     * Proxy getter method for the scope value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set scope value
     */
    public function getScopeValue()
    {
        return $this->scope;
    }

    /**
     * Proxy setter method for the left value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set left value
     * @return     ProfileForm The current object (for fluent API support)
     */
    public function setLeftValue($v)
    {
        return $this->setTreeLeft($v);
    }

    /**
     * Proxy setter method for the right value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set right value
     * @return     ProfileForm The current object (for fluent API support)
     */
    public function setRightValue($v)
    {
        return $this->setTreeRight($v);
    }

    /**
     * Proxy setter method for the level value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set level value
     * @return     ProfileForm The current object (for fluent API support)
     */
    public function setLevel($v)
    {
        return $this->setTreeLevel($v);
    }

    /**
     * Proxy setter method for the scope value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set scope value
     * @return     ProfileForm The current object (for fluent API support)
     */
    public function setScopeValue($v)
    {
        return $this->setScope($v);
    }

    /**
     * Creates the supplied node as the root node.
     *
     * @return     ProfileForm The current object (for fluent API support)
     * @throws     PropelException
     */
    public function makeRoot()
    {
        if ($this->getLeftValue() || $this->getRightValue()) {
            throw new PropelException('Cannot turn an existing node into a root node.');
        }

        $this->setLeftValue(1);
        $this->setRightValue(2);
        $this->setLevel(0);

        return $this;
    }

    /**
     * Tests if onbject is a node, i.e. if it is inserted in the tree
     *
     * @return     bool
     */
    public function isInTree()
    {
        return $this->getLeftValue() > 0 && $this->getRightValue() > $this->getLeftValue();
    }

    /**
     * Tests if node is a root
     *
     * @return     bool
     */
    public function isRoot()
    {
        return $this->isInTree() && $this->getLeftValue() == 1;
    }

    /**
     * Tests if node is a leaf
     *
     * @return     bool
     */
    public function isLeaf()
    {
        return $this->isInTree() &&  ($this->getRightValue() - $this->getLeftValue()) == 1;
    }

    /**
     * Tests if node is a descendant of another node
     *
     * @param      ProfileForm $node Propel node object
     * @return     bool
     */
    public function isDescendantOf($parent)
    {
        if ($this->getScopeValue() !== $parent->getScopeValue()) {
            throw new PropelException('Comparing two nodes of different trees');
        }

        return $this->isInTree() && $this->getLeftValue() > $parent->getLeftValue() && $this->getRightValue() < $parent->getRightValue();
    }

    /**
     * Tests if node is a ancestor of another node
     *
     * @param      ProfileForm $node Propel node object
     * @return     bool
     */
    public function isAncestorOf($child)
    {
        return $child->isDescendantOf($this);
    }

    /**
     * Tests if object has an ancestor
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasParent(PropelPDO $con = null)
    {
        return $this->getLevel() > 0;
    }

    /**
     * Sets the cache for parent node of the current object.
     * Warning: this does not move the current object in the tree.
     * Use moveTofirstChildOf() or moveToLastChildOf() for that purpose
     *
     * @param      ProfileForm $parent
     * @return     ProfileForm The current object, for fluid interface
     */
    public function setParent($parent = null)
    {
        $this->aNestedSetParent = $parent;

        return $this;
    }

    /**
     * Gets parent node for the current object if it exists
     * The result is cached so further calls to the same method don't issue any queries
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getParent(PropelPDO $con = null)
    {
        if ($this->aNestedSetParent === null && $this->hasParent()) {
            $this->aNestedSetParent = ProfileFormQuery::create()
                ->ancestorsOf($this)
                ->orderByLevel(true)
                ->findOne($con);
        }

        return $this->aNestedSetParent;
    }

    /**
     * Determines if the node has previous sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasPrevSibling(PropelPDO $con = null)
    {
        if (!ProfileFormPeer::isValid($this)) {
            return false;
        }

        return ProfileFormQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets previous sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getPrevSibling(PropelPDO $con = null)
    {
        return ProfileFormQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Determines if the node has next sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasNextSibling(PropelPDO $con = null)
    {
        if (!ProfileFormPeer::isValid($this)) {
            return false;
        }

        return ProfileFormQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets next sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getNextSibling(PropelPDO $con = null)
    {
        return ProfileFormQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Clears out the $collNestedSetChildren collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return     void
     */
    public function clearNestedSetChildren()
    {
        $this->collNestedSetChildren = null;
    }

    /**
     * Initializes the $collNestedSetChildren collection.
     *
     * @return     void
     */
    public function initNestedSetChildren()
    {
        $this->collNestedSetChildren = new PropelObjectCollection();
        $this->collNestedSetChildren->setModel('ProfileForm');
    }

    /**
     * Adds an element to the internal $collNestedSetChildren collection.
     * Beware that this doesn't insert a node in the tree.
     * This method is only used to facilitate children hydration.
     *
     * @param      ProfileForm $profileForm
     *
     * @return     void
     */
    public function addNestedSetChild($profileForm)
    {
        if ($this->collNestedSetChildren === null) {
            $this->initNestedSetChildren();
        }
        if (!$this->collNestedSetChildren->contains($profileForm)) { // only add it if the **same** object is not already associated
            $this->collNestedSetChildren[]= $profileForm;
            $profileForm->setParent($this);
        }
    }

    /**
     * Tests if node has children
     *
     * @return     bool
     */
    public function hasChildren()
    {
        return ($this->getRightValue() - $this->getLeftValue()) > 1;
    }

    /**
     * Gets the children of the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array     List of ProfileForm objects
     */
    public function getChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                // return empty collection
                $this->initNestedSetChildren();
            } else {
                $collNestedSetChildren = ProfileFormQuery::create(null, $criteria)
                  ->childrenOf($this)
                  ->orderByBranch()
                    ->find($con);
                if (null !== $criteria) {
                    return $collNestedSetChildren;
                }
                $this->collNestedSetChildren = $collNestedSetChildren;
            }
        }

        return $this->collNestedSetChildren;
    }

    /**
     * Gets number of children for the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int       Number of children
     */
    public function countChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                return 0;
            } else {
                return ProfileFormQuery::create(null, $criteria)
                    ->childrenOf($this)
                    ->count($con);
            }
        } else {
            return count($this->collNestedSetChildren);
        }
    }

    /**
     * Gets the first child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ProfileForm objects
     */
    public function getFirstChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ProfileFormQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch()
                ->findOne($con);
        }
    }

    /**
     * Gets the last child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ProfileForm objects
     */
    public function getLastChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ProfileFormQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch(true)
                ->findOne($con);
        }
    }

    /**
     * Gets the siblings of the given node
     *
     * @param      bool			$includeNode Whether to include the current node or not
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     *
     * @return     array 		List of ProfileForm objects
     */
    public function getSiblings($includeNode = false, $query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            return array();
        } else {
             $query = ProfileFormQuery::create(null, $query)
                    ->childrenOf($this->getParent($con))
                    ->orderByBranch();
            if (!$includeNode) {
                $query->prune($this);
            }

            return $query->find($con);
        }
    }

    /**
     * Gets descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ProfileForm objects
     */
    public function getDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ProfileFormQuery::create(null, $query)
                ->descendantsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Gets number of descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int 		Number of descendants
     */
    public function countDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return 0;
        } else {
            return ProfileFormQuery::create(null, $query)
                ->descendantsOf($this)
                ->count($con);
        }
    }

    /**
     * Gets descendants for the given node, plus the current node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ProfileForm objects
     */
    public function getBranch($query = null, PropelPDO $con = null)
    {
        return ProfileFormQuery::create(null, $query)
            ->branchOf($this)
            ->orderByBranch()
            ->find($con);
    }

    /**
     * Gets ancestors for the given node, starting with the root node
     * Use it for breadcrumb paths for instance
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ProfileForm objects
     */
    public function getAncestors($query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            // save one query
            return array();
        } else {
            return ProfileFormQuery::create(null, $query)
                ->ancestorsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Inserts the given $child node as first child of current
     * The modifications in the current object and the tree
     * are not persisted until the child object is saved.
     *
     * @param      ProfileForm $child	Propel object for child node
     *
     * @return     ProfileForm The current Propel object
     */
    public function addChild(ProfileForm $child)
    {
        if ($this->isNew()) {
            throw new PropelException('A ProfileForm object must not be new to accept children.');
        }
        $child->insertAsFirstChildOf($this);

        return $this;
    }

    /**
     * Inserts the current node as first child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ProfileForm $parent	Propel object for parent node
     *
     * @return     ProfileForm The current Propel object
     */
    public function insertAsFirstChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ProfileForm object must not already be in the tree to be inserted. Use the moveToFirstChildOf() instead.');
        }
        $left = $parent->getLeftValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ProfileFormPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as last child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ProfileForm $parent	Propel object for parent node
     *
     * @return     ProfileForm The current Propel object
     */
    public function insertAsLastChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ProfileForm object must not already be in the tree to be inserted. Use the moveToLastChildOf() instead.');
        }
        $left = $parent->getRightValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ProfileFormPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as prev sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ProfileForm $sibling	Propel object for parent node
     *
     * @return     ProfileForm The current Propel object
     */
    public function insertAsPrevSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ProfileForm object must not already be in the tree to be inserted. Use the moveToPrevSiblingOf() instead.');
        }
        $left = $sibling->getLeftValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ProfileFormPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as next sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ProfileForm $sibling	Propel object for parent node
     *
     * @return     ProfileForm The current Propel object
     */
    public function insertAsNextSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ProfileForm object must not already be in the tree to be inserted. Use the moveToNextSiblingOf() instead.');
        }
        $left = $sibling->getRightValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ProfileFormPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Moves current node and its subtree to be the first child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      ProfileForm $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ProfileForm The current Propel object
     */
    public function moveToFirstChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ProfileForm object must be already in the tree to be moved. Use the insertAsFirstChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getLeftValue() + 1, $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the last child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      ProfileForm $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ProfileForm The current Propel object
     */
    public function moveToLastChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ProfileForm object must be already in the tree to be moved. Use the insertAsLastChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getRightValue(), $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the previous sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      ProfileForm $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ProfileForm The current Propel object
     */
    public function moveToPrevSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ProfileForm object must be already in the tree to be moved. Use the insertAsPrevSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to previous sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getLeftValue(), $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the next sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      ProfileForm $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ProfileForm The current Propel object
     */
    public function moveToNextSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ProfileForm object must be already in the tree to be moved. Use the insertAsNextSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to next sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getRightValue() + 1, $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Move current node and its children to location $destLeft and updates rest of tree
     *
     * @param      int	$destLeft Destination left value
     * @param      int	$levelDelta Delta to add to the levels
     * @param      PropelPDO $con		Connection to use.
     */
    protected function moveSubtreeTo($destLeft, $levelDelta, PropelPDO $con = null)
    {
        $left  = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();

        $treeSize = $right - $left +1;

        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            // make room next to the target for the subtree
            ProfileFormPeer::shiftRLValues($treeSize, $destLeft, null, $scope, $con);

            if ($left >= $destLeft) { // src was shifted too?
                $left += $treeSize;
                $right += $treeSize;
            }

            if ($levelDelta) {
                // update the levels of the subtree
                ProfileFormPeer::shiftLevel($levelDelta, $left, $right, $scope, $con);
            }

            // move the subtree to the target
            ProfileFormPeer::shiftRLValues($destLeft - $left, $left, $right, $scope, $con);

            // remove the empty room at the previous location of the subtree
            ProfileFormPeer::shiftRLValues(-$treeSize, $right + 1, null, $scope, $con);

            // update all loaded nodes
            ProfileFormPeer::updateLoadedNodes(null, $con);

            $con->commit();
        } catch (PropelException $e) {
            $con->rollback();
            throw $e;
        }
    }

    /**
     * Deletes all descendants for the given node
     * Instance pooling is wiped out by this command,
     * so existing ProfileForm instances are probably invalid (except for the current one)
     *
     * @param      PropelPDO $con Connection to use.
     *
     * @return     int 		number of deleted nodes
     */
    public function deleteDescendants(PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $left = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();
        $con->beginTransaction();
        try {
            // delete descendant nodes (will empty the instance pool)
            $ret = ProfileFormQuery::create()
                ->descendantsOf($this)
                ->delete($con);

            // fill up the room that was used by descendants
            ProfileFormPeer::shiftRLValues($left - $right + 1, $right, null, $scope, $con);

            // fix the right value for the current node, which is now a leaf
            $this->setRightValue($left + 1);

            $con->commit();
        } catch (Exception $e) {
            $con->rollback();
            throw $e;
        }

        return $ret;
    }

    /**
     * Returns a pre-order iterator for this node and its children.
     *
     * @return     RecursiveIterator
     */
    public function getIterator()
    {
        return new NestedSetRecursiveIterator($this);
    }

}
