<?php


/**
 * Base class that represents a query for the 'actors_actor' table.
 *
 * Base de Actores
 *
 * @method ActorQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ActorQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method ActorQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ActorQuery orderBySurname($order = Criteria::ASC) Order by the surname column
 * @method ActorQuery orderByInstitution($order = Criteria::ASC) Order by the institution column
 * @method ActorQuery orderByMailaddress($order = Criteria::ASC) Order by the mailAddress column
 * @method ActorQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ActorQuery groupById() Group by the id column
 * @method ActorQuery groupByTitle() Group by the title column
 * @method ActorQuery groupByName() Group by the name column
 * @method ActorQuery groupBySurname() Group by the surname column
 * @method ActorQuery groupByInstitution() Group by the institution column
 * @method ActorQuery groupByMailaddress() Group by the mailAddress column
 * @method ActorQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ActorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ActorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ActorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ActorQuery leftJoinActorCategoryRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorCategoryRelation relation
 * @method ActorQuery rightJoinActorCategoryRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorCategoryRelation relation
 * @method ActorQuery innerJoinActorCategoryRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorCategoryRelation relation
 *
 * @method ActorQuery leftJoinActorRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorRelation relation
 * @method ActorQuery rightJoinActorRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorRelation relation
 * @method ActorQuery innerJoinActorRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorRelation relation
 *
 * @method ActorQuery leftJoinActorActiveQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorActiveQuestion relation
 * @method ActorQuery rightJoinActorActiveQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorActiveQuestion relation
 * @method ActorQuery innerJoinActorActiveQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorActiveQuestion relation
 *
 * @method ActorQuery leftJoinActorActiveRelationQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorActiveRelationQuestion relation
 * @method ActorQuery rightJoinActorActiveRelationQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorActiveRelationQuestion relation
 * @method ActorQuery innerJoinActorActiveRelationQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorActiveRelationQuestion relation
 *
 * @method ActorQuery leftJoinActorFormAnswer($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorFormAnswer relation
 * @method ActorQuery rightJoinActorFormAnswer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorFormAnswer relation
 * @method ActorQuery innerJoinActorFormAnswer($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorFormAnswer relation
 *
 * @method Actor findOne(PropelPDO $con = null) Return the first Actor matching the query
 * @method Actor findOneOrCreate(PropelPDO $con = null) Return the first Actor matching the query, or a new Actor object populated from the query conditions when no match is found
 *
 * @method Actor findOneById(int $id) Return the first Actor filtered by the id column
 * @method Actor findOneByTitle(string $title) Return the first Actor filtered by the title column
 * @method Actor findOneByName(string $name) Return the first Actor filtered by the name column
 * @method Actor findOneBySurname(string $surname) Return the first Actor filtered by the surname column
 * @method Actor findOneByInstitution(string $institution) Return the first Actor filtered by the institution column
 * @method Actor findOneByMailaddress(string $mailAddress) Return the first Actor filtered by the mailAddress column
 * @method Actor findOneByDeletedAt(string $deleted_at) Return the first Actor filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Actor objects filtered by the id column
 * @method array findByTitle(string $title) Return Actor objects filtered by the title column
 * @method array findByName(string $name) Return Actor objects filtered by the name column
 * @method array findBySurname(string $surname) Return Actor objects filtered by the surname column
 * @method array findByInstitution(string $institution) Return Actor objects filtered by the institution column
 * @method array findByMailaddress(string $mailAddress) Return Actor objects filtered by the mailAddress column
 * @method array findByDeletedAt(string $deleted_at) Return Actor objects filtered by the deleted_at column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseActorQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseActorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Actor', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ActorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ActorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ActorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ActorQuery) {
            return $criteria;
        }
        $query = new ActorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Actor|Actor[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ActorPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ActorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Actor A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `TITLE`, `NAME`, `SURNAME`, `INSTITUTION`, `MAILADDRESS`, `DELETED_AT` FROM `actors_actor` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Actor();
            $obj->hydrate($row);
            ActorPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Actor|Actor[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Actor[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ActorPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ActorPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%'); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $title)) {
                $title = str_replace('*', '%', $title);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorPeer::TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the surname column
     *
     * Example usage:
     * <code>
     * $query->filterBySurname('fooValue');   // WHERE surname = 'fooValue'
     * $query->filterBySurname('%fooValue%'); // WHERE surname LIKE '%fooValue%'
     * </code>
     *
     * @param     string $surname The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterBySurname($surname = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($surname)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $surname)) {
                $surname = str_replace('*', '%', $surname);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorPeer::SURNAME, $surname, $comparison);
    }

    /**
     * Filter the query on the institution column
     *
     * Example usage:
     * <code>
     * $query->filterByInstitution('fooValue');   // WHERE institution = 'fooValue'
     * $query->filterByInstitution('%fooValue%'); // WHERE institution LIKE '%fooValue%'
     * </code>
     *
     * @param     string $institution The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByInstitution($institution = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($institution)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $institution)) {
                $institution = str_replace('*', '%', $institution);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorPeer::INSTITUTION, $institution, $comparison);
    }

    /**
     * Filter the query on the mailAddress column
     *
     * Example usage:
     * <code>
     * $query->filterByMailaddress('fooValue');   // WHERE mailAddress = 'fooValue'
     * $query->filterByMailaddress('%fooValue%'); // WHERE mailAddress LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mailaddress The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByMailaddress($mailaddress = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mailaddress)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $mailaddress)) {
                $mailaddress = str_replace('*', '%', $mailaddress);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorPeer::MAILADDRESS, $mailaddress, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ActorPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ActorPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ActorPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related ActorCategoryRelation object
     *
     * @param   ActorCategoryRelation|PropelObjectCollection $actorCategoryRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorCategoryRelation($actorCategoryRelation, $comparison = null)
    {
        if ($actorCategoryRelation instanceof ActorCategoryRelation) {
            return $this
                ->addUsingAlias(ActorPeer::ID, $actorCategoryRelation->getActorid(), $comparison);
        } elseif ($actorCategoryRelation instanceof PropelObjectCollection) {
            return $this
                ->useActorCategoryRelationQuery()
                ->filterByPrimaryKeys($actorCategoryRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorCategoryRelation() only accepts arguments of type ActorCategoryRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorCategoryRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function joinActorCategoryRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorCategoryRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorCategoryRelation');
        }

        return $this;
    }

    /**
     * Use the ActorCategoryRelation relation ActorCategoryRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorCategoryRelationQuery A secondary query class using the current class as primary query
     */
    public function useActorCategoryRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorCategoryRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorCategoryRelation', 'ActorCategoryRelationQuery');
    }

    /**
     * Filter the query by a related ActorRelation object
     *
     * @param   ActorRelation|PropelObjectCollection $actorRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorRelation($actorRelation, $comparison = null)
    {
        if ($actorRelation instanceof ActorRelation) {
            return $this
                ->addUsingAlias(ActorPeer::ID, $actorRelation->getActortoid(), $comparison);
        } else {
            throw new PropelException('filterByActorRelation() only accepts arguments of type ActorRelation');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function joinActorRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorRelation');
        }

        return $this;
    }

    /**
     * Use the ActorRelation relation ActorRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorRelationQuery A secondary query class using the current class as primary query
     */
    public function useActorRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorRelation', 'ActorRelationQuery');
    }

    /**
     * Filter the query by a related ActorActiveQuestion object
     *
     * @param   ActorActiveQuestion|PropelObjectCollection $actorActiveQuestion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorActiveQuestion($actorActiveQuestion, $comparison = null)
    {
        if ($actorActiveQuestion instanceof ActorActiveQuestion) {
            return $this
                ->addUsingAlias(ActorPeer::ID, $actorActiveQuestion->getActorid(), $comparison);
        } elseif ($actorActiveQuestion instanceof PropelObjectCollection) {
            return $this
                ->useActorActiveQuestionQuery()
                ->filterByPrimaryKeys($actorActiveQuestion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorActiveQuestion() only accepts arguments of type ActorActiveQuestion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorActiveQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function joinActorActiveQuestion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorActiveQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorActiveQuestion');
        }

        return $this;
    }

    /**
     * Use the ActorActiveQuestion relation ActorActiveQuestion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorActiveQuestionQuery A secondary query class using the current class as primary query
     */
    public function useActorActiveQuestionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorActiveQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorActiveQuestion', 'ActorActiveQuestionQuery');
    }

    /**
     * Filter the query by a related ActorActiveRelationQuestion object
     *
     * @param   ActorActiveRelationQuestion|PropelObjectCollection $actorActiveRelationQuestion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorActiveRelationQuestion($actorActiveRelationQuestion, $comparison = null)
    {
        if ($actorActiveRelationQuestion instanceof ActorActiveRelationQuestion) {
            return $this
                ->addUsingAlias(ActorPeer::ID, $actorActiveRelationQuestion->getActortoid(), $comparison);
        } else {
            throw new PropelException('filterByActorActiveRelationQuestion() only accepts arguments of type ActorActiveRelationQuestion');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorActiveRelationQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function joinActorActiveRelationQuestion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorActiveRelationQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorActiveRelationQuestion');
        }

        return $this;
    }

    /**
     * Use the ActorActiveRelationQuestion relation ActorActiveRelationQuestion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorActiveRelationQuestionQuery A secondary query class using the current class as primary query
     */
    public function useActorActiveRelationQuestionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorActiveRelationQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorActiveRelationQuestion', 'ActorActiveRelationQuestionQuery');
    }

    /**
     * Filter the query by a related ActorFormAnswer object
     *
     * @param   ActorFormAnswer|PropelObjectCollection $actorFormAnswer  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorFormAnswer($actorFormAnswer, $comparison = null)
    {
        if ($actorFormAnswer instanceof ActorFormAnswer) {
            return $this
                ->addUsingAlias(ActorPeer::ID, $actorFormAnswer->getActorid(), $comparison);
        } elseif ($actorFormAnswer instanceof PropelObjectCollection) {
            return $this
                ->useActorFormAnswerQuery()
                ->filterByPrimaryKeys($actorFormAnswer->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorFormAnswer() only accepts arguments of type ActorFormAnswer or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorFormAnswer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function joinActorFormAnswer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorFormAnswer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorFormAnswer');
        }

        return $this;
    }

    /**
     * Use the ActorFormAnswer relation ActorFormAnswer object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorFormAnswerQuery A secondary query class using the current class as primary query
     */
    public function useActorFormAnswerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorFormAnswer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorFormAnswer', 'ActorFormAnswerQuery');
    }

    /**
     * Filter the query by a related ActorCategory object
     * using the actors_actorsCategory table as cross reference
     *
     * @param   ActorCategory $actorCategory the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     */
    public function filterByActorCategory($actorCategory, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useActorCategoryRelationQuery()
            ->filterByActorCategory($actorCategory, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related ProfileForm object
     * using the actors_activeRelationQuestions table as cross reference
     *
     * @param   ProfileForm $profileForm the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorQuery The current query, for fluid interface
     */
    public function filterByProfileForm($profileForm, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useActorActiveRelationQuestionQuery()
            ->filterByProfileForm($profileForm, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Actor $actor Object to remove from the list of results
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function prune($actor = null)
    {
        if ($actor) {
            $this->addUsingAlias(ActorPeer::ID, $actor->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ActorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ActorPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ActorPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ActorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ActorQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ActorQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ActorPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ActorPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
