<?php

namespace Egytca\ParamChecker\Conditions;

use Exception;

class ConditionFactory {

	static function create($descriptor) {

		if (is_string($descriptor)) {

			if (preg_match("/^(\w+)OrArray$/", $descriptor, $matches))
				return self::createIndividualOrArrayCondition($matches[1]);
			else
				return self::createCondition($descriptor);

		} else if (is_array($descriptor)) {

			return new CustomCondition($descriptor);

		} else {

			throw new Exception('bad condition descriptor');

		}
	}

	static function createCondition($conditionName) {
		// class name generated at runtime so namespace is required to select the right class. I think
		$descriptionClass = __NAMESPACE__.'\\'.ucfirst($conditionName).'Condition';
		return new $descriptionClass();
	}

	static function createIndividualOrArrayCondition($conditionName) {
		$condition = self::createCondition($conditionName);
		return new IndividualOrArrayCondition($condition);
	}
}