if (typeof Egytca == 'undefined')
	Egytca = {};

Egytca.ChainedSelect = function(params) {

	var _this = this;

	_this.init = function(params) {
		_this.select = $(params.id);
		_this.block = $(params.blockId);
		_this.selectName = _this.select.name;
		_this.url = params.url;
		_this.noOptionText = params.noOptionText;
		_this.paramsCallback = params.paramsCallback;
		
		_this.select.observe('change', function(event) {
			
//			if (this.value == '' && _this.parent !== undefined)
//				_this.parent.activate();
//			else
//				_this.activate();
			
			if (_this.child !== undefined)
				_this.child.update(this.value);
		});
	};

	_this.setParent = function(parent) {

		_this.parent = parent;

		if (!_this.childOf(_this.parent))
			_this.parent.setChild(_this);
	};

	_this.setChild = function(child) {

		_this.child = child;

		if (!_this.parentOf(_this.child))
			_this.child.setParent(_this);
	};

	_this.childOf = function(chainedSelect) {
		return _this === chainedSelect.child;
	};

	_this.parentOf = function(chainedSelect) {
		return _this === chainedSelect.parent;
	};

	_this.update = function(parentValue) {

		_this.erase();

		if (parentValue == '') {

			_this.hide();

		} else {

			if (_this.child !== undefined)
				_this.child.hide();

			_this.select.innerHTML = '<option value="" selected="selected">'+(_this.noOptionText || 'select an item')+'</option>';

			new Ajax.Updater(_this.select.id, _this.url, {
				method: 'GET',
				parameters: _this.paramsCallback(parentValue),
				insertion: 'bottom',
				onComplete: function() {
					_this.select.selectedIndex = 0;
					_this.block.show();
				}
			});
		}
	};

	_this.hide = function() {
		_this.block.hide();
		if (_this.child !== undefined)
			_this.child.hide();
	};

	_this.erase = function() {
		_this.select.innerHTML = '';
		if (_this.child !== undefined)
			_this.child.erase();
	};
	
	_this.activate = function() {
		_this.excludeUp(false);
		_this.includeDown();
	}
	
	_this.excludeUp = function(inclusive) {
		
		if (inclusive === undefined)
			var inclusive = true;
		
		if (inclusive)
			_this.select.name = '';
		
		if (_this.parent !== undefined)
			_this.parent.excludeUp();
	};
	
	_this.includeDown = function(inclusive) {
		
		if (inclusive === undefined)
			var inclusive = true;
		
		if (inclusive)
			_this.select.name = _this.selectName;
		
		if (_this.child !== undefined)
			_this.child.includeDown();
	};

	_this.init(params);
};