
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- constructions_construction
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `constructions_construction`;

CREATE TABLE `constructions_construction`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id obra',
    `proyectId` INTEGER COMMENT 'ID del evento',
    `name` VARCHAR(255) COMMENT 'Nombre de la obra',
    `description` TEXT COMMENT 'Descripcion de la obra',
    `categoryId` INTEGER COMMENT 'Jurisdiccion',
    `latitude` DECIMAL(12,9) COMMENT 'latitud',
    `longitude` DECIMAL(12,9) COMMENT 'longitud',
    `street` VARCHAR(100) COMMENT 'Nombre de la calle',
    `number` INTEGER COMMENT 'Numero de la calle',
    `regionId` INTEGER COMMENT 'Region',
    `endDate` DATE COMMENT 'Fecha fin',
    `stage` TINYINT COMMENT 'Etapa de obra',
    `inaugurated` BOOL DEFAULT 0 COMMENT 'Inaugurada',
    `company` VARCHAR(255) COMMENT 'Empresa',
    PRIMARY KEY (`id`),
    INDEX `constructions_construction_FI_1` (`proyectId`),
    INDEX `constructions_construction_FI_2` (`categoryId`),
    INDEX `constructions_construction_FI_3` (`regionId`),
    CONSTRAINT `constructions_construction_FK_1`
        FOREIGN KEY (`proyectId`)
        REFERENCES `projects_project` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `constructions_construction_FK_2`
        FOREIGN KEY (`categoryId`)
        REFERENCES `categories_category` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `constructions_construction_FK_3`
        FOREIGN KEY (`regionId`)
        REFERENCES `regions_region` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Seguimiento de obras';

-- ---------------------------------------------------------------------
-- constructions_inspector
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `constructions_inspector`;

CREATE TABLE `constructions_inspector`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id del relevador',
    `userId` INTEGER COMMENT 'Id del usuario relevador',
    `name` VARCHAR(100) NOT NULL COMMENT 'Nombre del relevador',
    PRIMARY KEY (`id`),
    INDEX `constructions_inspector_FI_1` (`userId`),
    CONSTRAINT `constructions_inspector_FK_1`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Media del calendario';

-- ---------------------------------------------------------------------
-- constructions_inspection
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `constructions_inspection`;

CREATE TABLE `constructions_inspection`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id del relevador',
    `constructionId` INTEGER NOT NULL COMMENT 'ID de construccion',
    `inspectorId` INTEGER NOT NULL COMMENT 'ID de relevador',
    `visitDate` DATE COMMENT 'Fecha fin segun visita',
    `endDate` DATE COMMENT 'Fecha fin',
    `endDateMinistry` DATE COMMENT 'Fecha fin segun Ministerio',
    `workshop` BOOL DEFAULT 0 COMMENT 'Obrador presente',
    `progressInspector` INTEGER(3) COMMENT 'Progreso segun relevador',
    `workingRate` INTEGER(6) DEFAULT 0 COMMENT 'Ritmo de trabajo',
    `progress` TEXT COMMENT 'Progreso',
    `conclusion` TEXT COMMENT 'Conclusion',
    `workers` INTEGER(6) COMMENT 'Trabajadores',
    `status` INTEGER(1) DEFAULT 0 COMMENT 'Semaforo',
    `otherComments` TEXT COMMENT 'Otros comentarios',
    PRIMARY KEY (`id`),
    INDEX `constructions_inspection_FI_1` (`constructionId`),
    INDEX `constructions_inspection_FI_2` (`inspectorId`),
    CONSTRAINT `constructions_inspection_FK_1`
        FOREIGN KEY (`constructionId`)
        REFERENCES `constructions_construction` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `constructions_inspection_FK_2`
        FOREIGN KEY (`inspectorId`)
        REFERENCES `constructions_inspector` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Inspecciones a la obra';

-- ---------------------------------------------------------------------
-- constructions_inspectionPhoto
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `constructions_inspectionPhoto`;

CREATE TABLE `constructions_inspectionPhoto`
(
    `inspectionId` INTEGER NOT NULL COMMENT 'Inspection ID',
    `photoId` INTEGER NOT NULL COMMENT 'Photo ID',
    PRIMARY KEY (`inspectionId`,`photoId`),
    INDEX `constructions_inspectionPhoto_FI_2` (`photoId`),
    CONSTRAINT `constructions_inspectionPhoto_FK_1`
        FOREIGN KEY (`inspectionId`)
        REFERENCES `constructions_inspection` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `constructions_inspectionPhoto_FK_2`
        FOREIGN KEY (`photoId`)
        REFERENCES `resources_resource` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion de inspecciones y fotos';

-- ---------------------------------------------------------------------
-- constructions_progress
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `constructions_progress`;

CREATE TABLE `constructions_progress`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `constructionId` INTEGER COMMENT 'Id de obra',
    `year` INTEGER COMMENT 'Ano',
    `month` INTEGER COMMENT 'Mes',
    `physicalProgress` DECIMAL(12,2) COMMENT 'Avance fisico de la Obra',
    `financialProgress` DECIMAL(12,2) COMMENT 'Avance financiero de la Obra',
    `realPhysicalProgress` DECIMAL(12,2) COMMENT 'Avance fisico real de la Obra',
    `realFinancialProgress` DECIMAL(12,2) COMMENT 'Avance financiero real de la Obra',
    `certificateNumber` INTEGER COMMENT 'Numero de certificado',
    PRIMARY KEY (`id`),
    INDEX `constructions_progress_FI_1` (`constructionId`),
    CONSTRAINT `constructions_progress_FK_1`
        FOREIGN KEY (`constructionId`)
        REFERENCES `constructions_construction` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Ejecucion fisico/financiera';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
