<?php

class SystemhealthConvertActorsIntoUsersAction extends BaseAction {

	const DEFAULT_PASSWORD = 'pass_mund1al';

	function exec() {

		if (parent::exec() === false) {
			return false;
		}
		
		$group = GroupQuery::create()
				 ->filterByName('FormerActors')
				 ->findOneOrCreate();
				 
		if ($group->isNew()){
			$group->save();
		}
		
		$actors = ActorQuery::create()->find();
		$converted = [];

		$count = 0;
		foreach ($actors as $actor) {
			$count++;
			$username = "converted$count";
			$user = $this->createUserFromActor($username, $actor);
			$converted[] = [
				'actor' => $actor,
				'user' => $user
			];

			if ($_POST['go']) {
				
				$user->addGroup($group);
				
				$user->save();

				$tenure = PositionTenureQuery::create()
					->filterByObjectId($actor->getId())
					->findOne();

				if ($tenure) {
					$tenure->setObjectType('User')
						->setObjectId($user->getId())
						->setUserId($user->getId())
						->setDateTo(null);
					$tenure->save();
				}

				$this->smarty->assign('go', true);
			}
		}

		$this->smarty->assign('converted', $converted);
	}

	function createUserFromActor($username, $actor) {

		$user = new User();

		global $system;
		$debugMails = explode(',', $system['config']['system']['parameters']['debugMail']);
		$debugMail = $debugMails[0];

		$user->setUsername($username)
			->setMailAddress($debugMail)
			->setName($actor->getName())
			->setSurname($actor->getSurname())
			->setActive(true)
			->setLevelId(3); // usuario comun
		$user->setPasswordString(self::DEFAULT_PASSWORD);

		return $user;
	}
}
