<?php



/**
 * Skeleton subclass for performing query and update operations on the 'security_blockedIp' table.
 *
 * IPs bloqueadas
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.security.classes
 */
class BlockedIpQuery extends BaseBlockedIpQuery
{
	/**
	 * Busca direcciones IP con una fraccion
	 *
	 * @param   type string $filterValue texto a buscar
	 * @return condicion de filtrado por texto a buscar
	 */
	public function searchString($filterValue) {
		return $this->filterByIp("%$filterValue%", Criteria::LIKE);
	}

	/**
	 * Agrega filtro de solo IPs diferentes 
	 *
	 * @param  $distinct bool indica si se quiere que sean o no IPs distintas
	 * @return condicion de filtrado de distintas por IP
	 */
	function selectDistinctIp($distinct){
		if($distinct)
			$this->groupByIp();
			
		return $this;
	}
}
