<?php


/**
 * Base class that represents a query for the 'projects_activityLog' table.
 *
 * Activity Log
 *
 * @method ProjectActivityLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectActivityLogQuery orderByActivityid($order = Criteria::ASC) Order by the activityId column
 * @method ProjectActivityLogQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectActivityLogQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectActivityLogQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ProjectActivityLogQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectActivityLogQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ProjectActivityLogQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 * @method ProjectActivityLogQuery orderByUniquegoalnumeric($order = Criteria::ASC) Order by the uniqueGoalNumeric column
 * @method ProjectActivityLogQuery orderByGoalprogress($order = Criteria::ASC) Order by the goalProgress column
 * @method ProjectActivityLogQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectActivityLogQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ProjectActivityLogQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method ProjectActivityLogQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ProjectActivityLogQuery orderByLastmodification($order = Criteria::ASC) Order by the lastModification column
 * @method ProjectActivityLogQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method ProjectActivityLogQuery orderByPlannedstart($order = Criteria::ASC) Order by the plannedStart column
 * @method ProjectActivityLogQuery orderByPlannedend($order = Criteria::ASC) Order by the plannedEnd column
 * @method ProjectActivityLogQuery orderByRealstart($order = Criteria::ASC) Order by the realStart column
 * @method ProjectActivityLogQuery orderByRealend($order = Criteria::ASC) Order by the realEnd column
 * @method ProjectActivityLogQuery orderByCancelled($order = Criteria::ASC) Order by the cancelled column
 * @method ProjectActivityLogQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ProjectActivityLogQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method ProjectActivityLogQuery orderByPress($order = Criteria::ASC) Order by the press column
 * @method ProjectActivityLogQuery orderByBudget($order = Criteria::ASC) Order by the budget column
 * @method ProjectActivityLogQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 *
 * @method ProjectActivityLogQuery groupById() Group by the id column
 * @method ProjectActivityLogQuery groupByActivityid() Group by the activityId column
 * @method ProjectActivityLogQuery groupByProjectid() Group by the projectId column
 * @method ProjectActivityLogQuery groupByName() Group by the name column
 * @method ProjectActivityLogQuery groupByDescription() Group by the description column
 * @method ProjectActivityLogQuery groupByDate() Group by the date column
 * @method ProjectActivityLogQuery groupByExpirationdate() Group by the expirationDate column
 * @method ProjectActivityLogQuery groupByCompleted() Group by the completed column
 * @method ProjectActivityLogQuery groupByUniquegoalnumeric() Group by the uniqueGoalNumeric column
 * @method ProjectActivityLogQuery groupByGoalprogress() Group by the goalProgress column
 * @method ProjectActivityLogQuery groupByNotes() Group by the notes column
 * @method ProjectActivityLogQuery groupByUserid() Group by the userId column
 * @method ProjectActivityLogQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method ProjectActivityLogQuery groupByUpdated() Group by the updated column
 * @method ProjectActivityLogQuery groupByLastmodification() Group by the lastModification column
 * @method ProjectActivityLogQuery groupByChanges() Group by the changes column
 * @method ProjectActivityLogQuery groupByPlannedstart() Group by the plannedStart column
 * @method ProjectActivityLogQuery groupByPlannedend() Group by the plannedEnd column
 * @method ProjectActivityLogQuery groupByRealstart() Group by the realStart column
 * @method ProjectActivityLogQuery groupByRealend() Group by the realEnd column
 * @method ProjectActivityLogQuery groupByCancelled() Group by the cancelled column
 * @method ProjectActivityLogQuery groupByStartingyear() Group by the startingYear column
 * @method ProjectActivityLogQuery groupByEndingyear() Group by the endingYear column
 * @method ProjectActivityLogQuery groupByPress() Group by the press column
 * @method ProjectActivityLogQuery groupByBudget() Group by the budget column
 * @method ProjectActivityLogQuery groupByResponsiblecode() Group by the responsibleCode column
 *
 * @method ProjectActivityLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectActivityLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectActivityLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectActivityLogQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectActivityLogQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectActivityLogQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectActivityLogQuery leftJoinProjectActivity($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivity relation
 * @method ProjectActivityLogQuery rightJoinProjectActivity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivity relation
 * @method ProjectActivityLogQuery innerJoinProjectActivity($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivity relation
 *
 * @method ProjectActivityLogQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ProjectActivityLogQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ProjectActivityLogQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ProjectActivityLogQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ProjectActivityLogQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ProjectActivityLogQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ProjectActivityLog findOne(PropelPDO $con = null) Return the first ProjectActivityLog matching the query
 * @method ProjectActivityLog findOneOrCreate(PropelPDO $con = null) Return the first ProjectActivityLog matching the query, or a new ProjectActivityLog object populated from the query conditions when no match is found
 *
 * @method ProjectActivityLog findOneById(int $id) Return the first ProjectActivityLog filtered by the id column
 * @method ProjectActivityLog findOneByActivityid(int $activityId) Return the first ProjectActivityLog filtered by the activityId column
 * @method ProjectActivityLog findOneByProjectid(int $projectId) Return the first ProjectActivityLog filtered by the projectId column
 * @method ProjectActivityLog findOneByName(string $name) Return the first ProjectActivityLog filtered by the name column
 * @method ProjectActivityLog findOneByDescription(string $description) Return the first ProjectActivityLog filtered by the description column
 * @method ProjectActivityLog findOneByDate(string $date) Return the first ProjectActivityLog filtered by the date column
 * @method ProjectActivityLog findOneByExpirationdate(string $expirationDate) Return the first ProjectActivityLog filtered by the expirationDate column
 * @method ProjectActivityLog findOneByCompleted(boolean $completed) Return the first ProjectActivityLog filtered by the completed column
 * @method ProjectActivityLog findOneByUniquegoalnumeric(int $uniqueGoalNumeric) Return the first ProjectActivityLog filtered by the uniqueGoalNumeric column
 * @method ProjectActivityLog findOneByGoalprogress(int $goalProgress) Return the first ProjectActivityLog filtered by the goalProgress column
 * @method ProjectActivityLog findOneByNotes(string $notes) Return the first ProjectActivityLog filtered by the notes column
 * @method ProjectActivityLog findOneByUserid(int $userId) Return the first ProjectActivityLog filtered by the userId column
 * @method ProjectActivityLog findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first ProjectActivityLog filtered by the userByAffiliatesId column
 * @method ProjectActivityLog findOneByUpdated(string $updated) Return the first ProjectActivityLog filtered by the updated column
 * @method ProjectActivityLog findOneByLastmodification(string $lastModification) Return the first ProjectActivityLog filtered by the lastModification column
 * @method ProjectActivityLog findOneByChanges(int $changes) Return the first ProjectActivityLog filtered by the changes column
 * @method ProjectActivityLog findOneByPlannedstart(string $plannedStart) Return the first ProjectActivityLog filtered by the plannedStart column
 * @method ProjectActivityLog findOneByPlannedend(string $plannedEnd) Return the first ProjectActivityLog filtered by the plannedEnd column
 * @method ProjectActivityLog findOneByRealstart(string $realStart) Return the first ProjectActivityLog filtered by the realStart column
 * @method ProjectActivityLog findOneByRealend(string $realEnd) Return the first ProjectActivityLog filtered by the realEnd column
 * @method ProjectActivityLog findOneByCancelled(boolean $cancelled) Return the first ProjectActivityLog filtered by the cancelled column
 * @method ProjectActivityLog findOneByStartingyear(int $startingYear) Return the first ProjectActivityLog filtered by the startingYear column
 * @method ProjectActivityLog findOneByEndingyear(int $endingYear) Return the first ProjectActivityLog filtered by the endingYear column
 * @method ProjectActivityLog findOneByPress(boolean $press) Return the first ProjectActivityLog filtered by the press column
 * @method ProjectActivityLog findOneByBudget(double $budget) Return the first ProjectActivityLog filtered by the budget column
 * @method ProjectActivityLog findOneByResponsiblecode(int $responsibleCode) Return the first ProjectActivityLog filtered by the responsibleCode column
 *
 * @method array findById(int $id) Return ProjectActivityLog objects filtered by the id column
 * @method array findByActivityid(int $activityId) Return ProjectActivityLog objects filtered by the activityId column
 * @method array findByProjectid(int $projectId) Return ProjectActivityLog objects filtered by the projectId column
 * @method array findByName(string $name) Return ProjectActivityLog objects filtered by the name column
 * @method array findByDescription(string $description) Return ProjectActivityLog objects filtered by the description column
 * @method array findByDate(string $date) Return ProjectActivityLog objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return ProjectActivityLog objects filtered by the expirationDate column
 * @method array findByCompleted(boolean $completed) Return ProjectActivityLog objects filtered by the completed column
 * @method array findByUniquegoalnumeric(int $uniqueGoalNumeric) Return ProjectActivityLog objects filtered by the uniqueGoalNumeric column
 * @method array findByGoalprogress(int $goalProgress) Return ProjectActivityLog objects filtered by the goalProgress column
 * @method array findByNotes(string $notes) Return ProjectActivityLog objects filtered by the notes column
 * @method array findByUserid(int $userId) Return ProjectActivityLog objects filtered by the userId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return ProjectActivityLog objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return ProjectActivityLog objects filtered by the updated column
 * @method array findByLastmodification(string $lastModification) Return ProjectActivityLog objects filtered by the lastModification column
 * @method array findByChanges(int $changes) Return ProjectActivityLog objects filtered by the changes column
 * @method array findByPlannedstart(string $plannedStart) Return ProjectActivityLog objects filtered by the plannedStart column
 * @method array findByPlannedend(string $plannedEnd) Return ProjectActivityLog objects filtered by the plannedEnd column
 * @method array findByRealstart(string $realStart) Return ProjectActivityLog objects filtered by the realStart column
 * @method array findByRealend(string $realEnd) Return ProjectActivityLog objects filtered by the realEnd column
 * @method array findByCancelled(boolean $cancelled) Return ProjectActivityLog objects filtered by the cancelled column
 * @method array findByStartingyear(int $startingYear) Return ProjectActivityLog objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return ProjectActivityLog objects filtered by the endingYear column
 * @method array findByPress(boolean $press) Return ProjectActivityLog objects filtered by the press column
 * @method array findByBudget(double $budget) Return ProjectActivityLog objects filtered by the budget column
 * @method array findByResponsiblecode(int $responsibleCode) Return ProjectActivityLog objects filtered by the responsibleCode column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectActivityLogQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProjectActivityLogQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectActivityLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectActivityLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectActivityLogQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectActivityLogQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectActivityLogQuery) {
            return $criteria;
        }
        $query = new ProjectActivityLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectActivityLog|ProjectActivityLog[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectActivityLogPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectActivityLog A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `ACTIVITYID`, `PROJECTID`, `NAME`, `DESCRIPTION`, `DATE`, `EXPIRATIONDATE`, `COMPLETED`, `UNIQUEGOALNUMERIC`, `GOALPROGRESS`, `NOTES`, `USERID`, `USERBYAFFILIATESID`, `UPDATED`, `LASTMODIFICATION`, `CHANGES`, `PLANNEDSTART`, `PLANNEDEND`, `REALSTART`, `REALEND`, `CANCELLED`, `STARTINGYEAR`, `ENDINGYEAR`, `PRESS`, `BUDGET`, `RESPONSIBLECODE` FROM `projects_activityLog` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectActivityLog();
            $obj->hydrate($row);
            ProjectActivityLogPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectActivityLog|ProjectActivityLog[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectActivityLog[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectActivityLogPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectActivityLogPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the activityId column
     *
     * Example usage:
     * <code>
     * $query->filterByActivityid(1234); // WHERE activityId = 1234
     * $query->filterByActivityid(array(12, 34)); // WHERE activityId IN (12, 34)
     * $query->filterByActivityid(array('min' => 12)); // WHERE activityId > 12
     * </code>
     *
     * @see       filterByProjectActivity()
     *
     * @param     mixed $activityid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByActivityid($activityid = null, $comparison = null)
    {
        if (is_array($activityid)) {
            $useMinMax = false;
            if (isset($activityid['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::ACTIVITYID, $activityid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($activityid['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::ACTIVITYID, $activityid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::ACTIVITYID, $activityid, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(true); // WHERE completed = true
     * $query->filterByCompleted('yes'); // WHERE completed = true
     * </code>
     *
     * @param     boolean|string $completed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, $comparison = null)
    {
        if (is_string($completed)) {
            $completed = in_array(strtolower($completed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::COMPLETED, $completed, $comparison);
    }

    /**
     * Filter the query on the uniqueGoalNumeric column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoalnumeric(1234); // WHERE uniqueGoalNumeric = 1234
     * $query->filterByUniquegoalnumeric(array(12, 34)); // WHERE uniqueGoalNumeric IN (12, 34)
     * $query->filterByUniquegoalnumeric(array('min' => 12)); // WHERE uniqueGoalNumeric > 12
     * </code>
     *
     * @param     mixed $uniquegoalnumeric The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByUniquegoalnumeric($uniquegoalnumeric = null, $comparison = null)
    {
        if (is_array($uniquegoalnumeric)) {
            $useMinMax = false;
            if (isset($uniquegoalnumeric['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uniquegoalnumeric['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric, $comparison);
    }

    /**
     * Filter the query on the goalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalprogress(1234); // WHERE goalProgress = 1234
     * $query->filterByGoalprogress(array(12, 34)); // WHERE goalProgress IN (12, 34)
     * $query->filterByGoalprogress(array('min' => 12)); // WHERE goalProgress > 12
     * </code>
     *
     * @param     mixed $goalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByGoalprogress($goalprogress = null, $comparison = null)
    {
        if (is_array($goalprogress)) {
            $useMinMax = false;
            if (isset($goalprogress['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::GOALPROGRESS, $goalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalprogress['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::GOALPROGRESS, $goalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::GOALPROGRESS, $goalprogress, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the lastModification column
     *
     * Example usage:
     * <code>
     * $query->filterByLastmodification('2011-03-14'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification('now'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification(array('max' => 'yesterday')); // WHERE lastModification > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastmodification The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByLastmodification($lastmodification = null, $comparison = null)
    {
        if (is_array($lastmodification)) {
            $useMinMax = false;
            if (isset($lastmodification['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::LASTMODIFICATION, $lastmodification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastmodification['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::LASTMODIFICATION, $lastmodification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::LASTMODIFICATION, $lastmodification, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the plannedStart column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedstart('2011-03-14'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart('now'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart(array('max' => 'yesterday')); // WHERE plannedStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByPlannedstart($plannedstart = null, $comparison = null)
    {
        if (is_array($plannedstart)) {
            $useMinMax = false;
            if (isset($plannedstart['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDSTART, $plannedstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedstart['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDSTART, $plannedstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDSTART, $plannedstart, $comparison);
    }

    /**
     * Filter the query on the plannedEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedend('2011-03-14'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend('now'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend(array('max' => 'yesterday')); // WHERE plannedEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByPlannedend($plannedend = null, $comparison = null)
    {
        if (is_array($plannedend)) {
            $useMinMax = false;
            if (isset($plannedend['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDEND, $plannedend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedend['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDEND, $plannedend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::PLANNEDEND, $plannedend, $comparison);
    }

    /**
     * Filter the query on the realStart column
     *
     * Example usage:
     * <code>
     * $query->filterByRealstart('2011-03-14'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart('now'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart(array('max' => 'yesterday')); // WHERE realStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $realstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByRealstart($realstart = null, $comparison = null)
    {
        if (is_array($realstart)) {
            $useMinMax = false;
            if (isset($realstart['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::REALSTART, $realstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realstart['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::REALSTART, $realstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::REALSTART, $realstart, $comparison);
    }

    /**
     * Filter the query on the realEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByRealend('2011-03-14'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend('now'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend(array('max' => 'yesterday')); // WHERE realEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $realend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByRealend($realend = null, $comparison = null)
    {
        if (is_array($realend)) {
            $useMinMax = false;
            if (isset($realend['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::REALEND, $realend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realend['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::REALEND, $realend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::REALEND, $realend, $comparison);
    }

    /**
     * Filter the query on the cancelled column
     *
     * Example usage:
     * <code>
     * $query->filterByCancelled(true); // WHERE cancelled = true
     * $query->filterByCancelled('yes'); // WHERE cancelled = true
     * </code>
     *
     * @param     boolean|string $cancelled The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByCancelled($cancelled = null, $comparison = null)
    {
        if (is_string($cancelled)) {
            $cancelled = in_array(strtolower($cancelled), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::CANCELLED, $cancelled, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the press column
     *
     * Example usage:
     * <code>
     * $query->filterByPress(true); // WHERE press = true
     * $query->filterByPress('yes'); // WHERE press = true
     * </code>
     *
     * @param     boolean|string $press The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByPress($press = null, $comparison = null)
    {
        if (is_string($press)) {
            $press = in_array(strtolower($press), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::PRESS, $press, $comparison);
    }

    /**
     * Filter the query on the budget column
     *
     * Example usage:
     * <code>
     * $query->filterByBudget(1234); // WHERE budget = 1234
     * $query->filterByBudget(array(12, 34)); // WHERE budget IN (12, 34)
     * $query->filterByBudget(array('min' => 12)); // WHERE budget > 12
     * </code>
     *
     * @param     mixed $budget The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByBudget($budget = null, $comparison = null)
    {
        if (is_array($budget)) {
            $useMinMax = false;
            if (isset($budget['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::BUDGET, $budget['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budget['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::BUDGET, $budget['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::BUDGET, $budget, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ProjectActivityLogPeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectActivityLogPeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectActivityLogPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityLogPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related ProjectActivity object
     *
     * @param   ProjectActivity|PropelObjectCollection $projectActivity The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivity($projectActivity, $comparison = null)
    {
        if ($projectActivity instanceof ProjectActivity) {
            return $this
                ->addUsingAlias(ProjectActivityLogPeer::ACTIVITYID, $projectActivity->getId(), $comparison);
        } elseif ($projectActivity instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityLogPeer::ACTIVITYID, $projectActivity->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProjectActivity() only accepts arguments of type ProjectActivity or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivity relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function joinProjectActivity($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivity');
        }

        return $this;
    }

    /**
     * Use the ProjectActivity relation ProjectActivity object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectActivity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivity', 'ProjectActivityQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ProjectActivityLogPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityLogPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectActivityLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ProjectActivityLogPeer::RESPONSIBLECODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectActivityLogPeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectActivityLog $projectActivityLog Object to remove from the list of results
     *
     * @return ProjectActivityLogQuery The current query, for fluid interface
     */
    public function prune($projectActivityLog = null)
    {
        if ($projectActivityLog) {
            $this->addUsingAlias(ProjectActivityLogPeer::ID, $projectActivityLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
