<?php


/**
 * Base class that represents a query for the 'positions_position' table.
 *
 * Cargos
 *
 * @method PositionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method PositionQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method PositionQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method PositionQuery orderByUsergroupid($order = Criteria::ASC) Order by the userGroupId column
 * @method PositionQuery orderByVersionid($order = Criteria::ASC) Order by the versionId column
 * @method PositionQuery orderByInternalcode($order = Criteria::ASC) Order by the internalCode column
 * @method PositionQuery orderByOwnername($order = Criteria::ASC) Order by the ownerName column
 * @method PositionQuery orderByOwnernamefemale($order = Criteria::ASC) Order by the ownerNameFemale column
 * @method PositionQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method PositionQuery orderByKind($order = Criteria::ASC) Order by the kind column
 * @method PositionQuery orderByAddress($order = Criteria::ASC) Order by the address column
 * @method PositionQuery orderByTelephone($order = Criteria::ASC) Order by the telephone column
 * @method PositionQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method PositionQuery orderByBudget($order = Criteria::ASC) Order by the budget column
 * @method PositionQuery orderByPersonnel($order = Criteria::ASC) Order by the personnel column
 * @method PositionQuery orderByHired($order = Criteria::ASC) Order by the hired column
 * @method PositionQuery orderByConsultant($order = Criteria::ASC) Order by the consultant column
 * @method PositionQuery orderByOther($order = Criteria::ASC) Order by the other column
 * @method PositionQuery orderByPlanning($order = Criteria::ASC) Order by the planning column
 * @method PositionQuery orderByOrder($order = Criteria::ASC) Order by the order column
 * @method PositionQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method PositionQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method PositionQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 *
 * @method PositionQuery groupById() Group by the id column
 * @method PositionQuery groupByName() Group by the name column
 * @method PositionQuery groupByCode() Group by the code column
 * @method PositionQuery groupByUsergroupid() Group by the userGroupId column
 * @method PositionQuery groupByVersionid() Group by the versionId column
 * @method PositionQuery groupByInternalcode() Group by the internalCode column
 * @method PositionQuery groupByOwnername() Group by the ownerName column
 * @method PositionQuery groupByOwnernamefemale() Group by the ownerNameFemale column
 * @method PositionQuery groupByType() Group by the type column
 * @method PositionQuery groupByKind() Group by the kind column
 * @method PositionQuery groupByAddress() Group by the address column
 * @method PositionQuery groupByTelephone() Group by the telephone column
 * @method PositionQuery groupByEmail() Group by the email column
 * @method PositionQuery groupByBudget() Group by the budget column
 * @method PositionQuery groupByPersonnel() Group by the personnel column
 * @method PositionQuery groupByHired() Group by the hired column
 * @method PositionQuery groupByConsultant() Group by the consultant column
 * @method PositionQuery groupByOther() Group by the other column
 * @method PositionQuery groupByPlanning() Group by the planning column
 * @method PositionQuery groupByOrder() Group by the order column
 * @method PositionQuery groupByTreeLeft() Group by the tree_left column
 * @method PositionQuery groupByTreeRight() Group by the tree_right column
 * @method PositionQuery groupByTreeLevel() Group by the tree_level column
 *
 * @method PositionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method PositionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method PositionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method PositionQuery leftJoinGroup($relationAlias = null) Adds a LEFT JOIN clause to the query using the Group relation
 * @method PositionQuery rightJoinGroup($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Group relation
 * @method PositionQuery innerJoinGroup($relationAlias = null) Adds a INNER JOIN clause to the query using the Group relation
 *
 * @method PositionQuery leftJoinPositionVersion($relationAlias = null) Adds a LEFT JOIN clause to the query using the PositionVersion relation
 * @method PositionQuery rightJoinPositionVersion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PositionVersion relation
 * @method PositionQuery innerJoinPositionVersion($relationAlias = null) Adds a INNER JOIN clause to the query using the PositionVersion relation
 *
 * @method PositionQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method PositionQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method PositionQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method PositionQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method PositionQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method PositionQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method PositionQuery leftJoinObjectivePosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectivePosition relation
 * @method PositionQuery rightJoinObjectivePosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectivePosition relation
 * @method PositionQuery innerJoinObjectivePosition($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectivePosition relation
 *
 * @method PositionQuery leftJoinObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveLog relation
 * @method PositionQuery rightJoinObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveLog relation
 * @method PositionQuery innerJoinObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveLog relation
 *
 * @method PositionQuery leftJoinAlertDigest($relationAlias = null) Adds a LEFT JOIN clause to the query using the AlertDigest relation
 * @method PositionQuery rightJoinAlertDigest($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AlertDigest relation
 * @method PositionQuery innerJoinAlertDigest($relationAlias = null) Adds a INNER JOIN clause to the query using the AlertDigest relation
 *
 * @method PositionQuery leftJoinPositionTenure($relationAlias = null) Adds a LEFT JOIN clause to the query using the PositionTenure relation
 * @method PositionQuery rightJoinPositionTenure($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PositionTenure relation
 * @method PositionQuery innerJoinPositionTenure($relationAlias = null) Adds a INNER JOIN clause to the query using the PositionTenure relation
 *
 * @method PositionQuery leftJoinPositionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the PositionDocument relation
 * @method PositionQuery rightJoinPositionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PositionDocument relation
 * @method PositionQuery innerJoinPositionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the PositionDocument relation
 *
 * @method PositionQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method PositionQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method PositionQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method PositionQuery leftJoinProjectActivity($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivity relation
 * @method PositionQuery rightJoinProjectActivity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivity relation
 * @method PositionQuery innerJoinProjectActivity($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivity relation
 *
 * @method PositionQuery leftJoinProjectLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectLog relation
 * @method PositionQuery rightJoinProjectLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectLog relation
 * @method PositionQuery innerJoinProjectLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectLog relation
 *
 * @method PositionQuery leftJoinProjectActivityLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivityLog relation
 * @method PositionQuery rightJoinProjectActivityLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivityLog relation
 * @method PositionQuery innerJoinProjectActivityLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivityLog relation
 *
 * @method Position findOne(PropelPDO $con = null) Return the first Position matching the query
 * @method Position findOneOrCreate(PropelPDO $con = null) Return the first Position matching the query, or a new Position object populated from the query conditions when no match is found
 *
 * @method Position findOneById(int $id) Return the first Position filtered by the id column
 * @method Position findOneByName(string $name) Return the first Position filtered by the name column
 * @method Position findOneByCode(int $code) Return the first Position filtered by the code column
 * @method Position findOneByUsergroupid(int $userGroupId) Return the first Position filtered by the userGroupId column
 * @method Position findOneByVersionid(int $versionId) Return the first Position filtered by the versionId column
 * @method Position findOneByInternalcode(string $internalCode) Return the first Position filtered by the internalCode column
 * @method Position findOneByOwnername(string $ownerName) Return the first Position filtered by the ownerName column
 * @method Position findOneByOwnernamefemale(string $ownerNameFemale) Return the first Position filtered by the ownerNameFemale column
 * @method Position findOneByType(int $type) Return the first Position filtered by the type column
 * @method Position findOneByKind(string $kind) Return the first Position filtered by the kind column
 * @method Position findOneByAddress(string $address) Return the first Position filtered by the address column
 * @method Position findOneByTelephone(string $telephone) Return the first Position filtered by the telephone column
 * @method Position findOneByEmail(string $email) Return the first Position filtered by the email column
 * @method Position findOneByBudget(double $budget) Return the first Position filtered by the budget column
 * @method Position findOneByPersonnel(int $personnel) Return the first Position filtered by the personnel column
 * @method Position findOneByHired(int $hired) Return the first Position filtered by the hired column
 * @method Position findOneByConsultant(int $consultant) Return the first Position filtered by the consultant column
 * @method Position findOneByOther(int $other) Return the first Position filtered by the other column
 * @method Position findOneByPlanning(boolean $planning) Return the first Position filtered by the planning column
 * @method Position findOneByOrder(int $order) Return the first Position filtered by the order column
 * @method Position findOneByTreeLeft(int $tree_left) Return the first Position filtered by the tree_left column
 * @method Position findOneByTreeRight(int $tree_right) Return the first Position filtered by the tree_right column
 * @method Position findOneByTreeLevel(int $tree_level) Return the first Position filtered by the tree_level column
 *
 * @method array findById(int $id) Return Position objects filtered by the id column
 * @method array findByName(string $name) Return Position objects filtered by the name column
 * @method array findByCode(int $code) Return Position objects filtered by the code column
 * @method array findByUsergroupid(int $userGroupId) Return Position objects filtered by the userGroupId column
 * @method array findByVersionid(int $versionId) Return Position objects filtered by the versionId column
 * @method array findByInternalcode(string $internalCode) Return Position objects filtered by the internalCode column
 * @method array findByOwnername(string $ownerName) Return Position objects filtered by the ownerName column
 * @method array findByOwnernamefemale(string $ownerNameFemale) Return Position objects filtered by the ownerNameFemale column
 * @method array findByType(int $type) Return Position objects filtered by the type column
 * @method array findByKind(string $kind) Return Position objects filtered by the kind column
 * @method array findByAddress(string $address) Return Position objects filtered by the address column
 * @method array findByTelephone(string $telephone) Return Position objects filtered by the telephone column
 * @method array findByEmail(string $email) Return Position objects filtered by the email column
 * @method array findByBudget(double $budget) Return Position objects filtered by the budget column
 * @method array findByPersonnel(int $personnel) Return Position objects filtered by the personnel column
 * @method array findByHired(int $hired) Return Position objects filtered by the hired column
 * @method array findByConsultant(int $consultant) Return Position objects filtered by the consultant column
 * @method array findByOther(int $other) Return Position objects filtered by the other column
 * @method array findByPlanning(boolean $planning) Return Position objects filtered by the planning column
 * @method array findByOrder(int $order) Return Position objects filtered by the order column
 * @method array findByTreeLeft(int $tree_left) Return Position objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return Position objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return Position objects filtered by the tree_level column
 *
 * @package    propel.generator.positions.classes.om
 */
abstract class BasePositionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BasePositionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Position', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new PositionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     PositionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return PositionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof PositionQuery) {
            return $criteria;
        }
        $query = new PositionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Position|Position[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = PositionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Position A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `CODE`, `USERGROUPID`, `VERSIONID`, `INTERNALCODE`, `OWNERNAME`, `OWNERNAMEFEMALE`, `TYPE`, `KIND`, `ADDRESS`, `TELEPHONE`, `EMAIL`, `BUDGET`, `PERSONNEL`, `HIRED`, `CONSULTANT`, `OTHER`, `PLANNING`, `ORDER`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL` FROM `positions_position` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Position();
            $obj->hydrate($row);
            PositionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Position|Position[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Position[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PositionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PositionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(PositionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode(1234); // WHERE code = 1234
     * $query->filterByCode(array(12, 34)); // WHERE code IN (12, 34)
     * $query->filterByCode(array('min' => 12)); // WHERE code > 12
     * </code>
     *
     * @param     mixed $code The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (is_array($code)) {
            $useMinMax = false;
            if (isset($code['min'])) {
                $this->addUsingAlias(PositionPeer::CODE, $code['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($code['max'])) {
                $this->addUsingAlias(PositionPeer::CODE, $code['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::CODE, $code, $comparison);
    }

    /**
     * Filter the query on the userGroupId column
     *
     * Example usage:
     * <code>
     * $query->filterByUsergroupid(1234); // WHERE userGroupId = 1234
     * $query->filterByUsergroupid(array(12, 34)); // WHERE userGroupId IN (12, 34)
     * $query->filterByUsergroupid(array('min' => 12)); // WHERE userGroupId > 12
     * </code>
     *
     * @see       filterByGroup()
     *
     * @param     mixed $usergroupid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByUsergroupid($usergroupid = null, $comparison = null)
    {
        if (is_array($usergroupid)) {
            $useMinMax = false;
            if (isset($usergroupid['min'])) {
                $this->addUsingAlias(PositionPeer::USERGROUPID, $usergroupid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($usergroupid['max'])) {
                $this->addUsingAlias(PositionPeer::USERGROUPID, $usergroupid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::USERGROUPID, $usergroupid, $comparison);
    }

    /**
     * Filter the query on the versionId column
     *
     * Example usage:
     * <code>
     * $query->filterByVersionid(1234); // WHERE versionId = 1234
     * $query->filterByVersionid(array(12, 34)); // WHERE versionId IN (12, 34)
     * $query->filterByVersionid(array('min' => 12)); // WHERE versionId > 12
     * </code>
     *
     * @see       filterByPositionVersion()
     *
     * @param     mixed $versionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByVersionid($versionid = null, $comparison = null)
    {
        if (is_array($versionid)) {
            $useMinMax = false;
            if (isset($versionid['min'])) {
                $this->addUsingAlias(PositionPeer::VERSIONID, $versionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($versionid['max'])) {
                $this->addUsingAlias(PositionPeer::VERSIONID, $versionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::VERSIONID, $versionid, $comparison);
    }

    /**
     * Filter the query on the internalCode column
     *
     * Example usage:
     * <code>
     * $query->filterByInternalcode('fooValue');   // WHERE internalCode = 'fooValue'
     * $query->filterByInternalcode('%fooValue%'); // WHERE internalCode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $internalcode The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByInternalcode($internalcode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($internalcode)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $internalcode)) {
                $internalcode = str_replace('*', '%', $internalcode);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::INTERNALCODE, $internalcode, $comparison);
    }

    /**
     * Filter the query on the ownerName column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnername('fooValue');   // WHERE ownerName = 'fooValue'
     * $query->filterByOwnername('%fooValue%'); // WHERE ownerName LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ownername The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByOwnername($ownername = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ownername)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ownername)) {
                $ownername = str_replace('*', '%', $ownername);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::OWNERNAME, $ownername, $comparison);
    }

    /**
     * Filter the query on the ownerNameFemale column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnernamefemale('fooValue');   // WHERE ownerNameFemale = 'fooValue'
     * $query->filterByOwnernamefemale('%fooValue%'); // WHERE ownerNameFemale LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ownernamefemale The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByOwnernamefemale($ownernamefemale = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ownernamefemale)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ownernamefemale)) {
                $ownernamefemale = str_replace('*', '%', $ownernamefemale);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::OWNERNAMEFEMALE, $ownernamefemale, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(PositionPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(PositionPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the kind column
     *
     * Example usage:
     * <code>
     * $query->filterByKind('fooValue');   // WHERE kind = 'fooValue'
     * $query->filterByKind('%fooValue%'); // WHERE kind LIKE '%fooValue%'
     * </code>
     *
     * @param     string $kind The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByKind($kind = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($kind)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $kind)) {
                $kind = str_replace('*', '%', $kind);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::KIND, $kind, $comparison);
    }

    /**
     * Filter the query on the address column
     *
     * Example usage:
     * <code>
     * $query->filterByAddress('fooValue');   // WHERE address = 'fooValue'
     * $query->filterByAddress('%fooValue%'); // WHERE address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $address The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByAddress($address = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($address)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $address)) {
                $address = str_replace('*', '%', $address);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::ADDRESS, $address, $comparison);
    }

    /**
     * Filter the query on the telephone column
     *
     * Example usage:
     * <code>
     * $query->filterByTelephone('fooValue');   // WHERE telephone = 'fooValue'
     * $query->filterByTelephone('%fooValue%'); // WHERE telephone LIKE '%fooValue%'
     * </code>
     *
     * @param     string $telephone The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByTelephone($telephone = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($telephone)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $telephone)) {
                $telephone = str_replace('*', '%', $telephone);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::TELEPHONE, $telephone, $comparison);
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%'); // WHERE email LIKE '%fooValue%'
     * </code>
     *
     * @param     string $email The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByEmail($email = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $email)) {
                $email = str_replace('*', '%', $email);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionPeer::EMAIL, $email, $comparison);
    }

    /**
     * Filter the query on the budget column
     *
     * Example usage:
     * <code>
     * $query->filterByBudget(1234); // WHERE budget = 1234
     * $query->filterByBudget(array(12, 34)); // WHERE budget IN (12, 34)
     * $query->filterByBudget(array('min' => 12)); // WHERE budget > 12
     * </code>
     *
     * @param     mixed $budget The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByBudget($budget = null, $comparison = null)
    {
        if (is_array($budget)) {
            $useMinMax = false;
            if (isset($budget['min'])) {
                $this->addUsingAlias(PositionPeer::BUDGET, $budget['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budget['max'])) {
                $this->addUsingAlias(PositionPeer::BUDGET, $budget['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::BUDGET, $budget, $comparison);
    }

    /**
     * Filter the query on the personnel column
     *
     * Example usage:
     * <code>
     * $query->filterByPersonnel(1234); // WHERE personnel = 1234
     * $query->filterByPersonnel(array(12, 34)); // WHERE personnel IN (12, 34)
     * $query->filterByPersonnel(array('min' => 12)); // WHERE personnel > 12
     * </code>
     *
     * @param     mixed $personnel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByPersonnel($personnel = null, $comparison = null)
    {
        if (is_array($personnel)) {
            $useMinMax = false;
            if (isset($personnel['min'])) {
                $this->addUsingAlias(PositionPeer::PERSONNEL, $personnel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($personnel['max'])) {
                $this->addUsingAlias(PositionPeer::PERSONNEL, $personnel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::PERSONNEL, $personnel, $comparison);
    }

    /**
     * Filter the query on the hired column
     *
     * Example usage:
     * <code>
     * $query->filterByHired(1234); // WHERE hired = 1234
     * $query->filterByHired(array(12, 34)); // WHERE hired IN (12, 34)
     * $query->filterByHired(array('min' => 12)); // WHERE hired > 12
     * </code>
     *
     * @param     mixed $hired The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByHired($hired = null, $comparison = null)
    {
        if (is_array($hired)) {
            $useMinMax = false;
            if (isset($hired['min'])) {
                $this->addUsingAlias(PositionPeer::HIRED, $hired['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($hired['max'])) {
                $this->addUsingAlias(PositionPeer::HIRED, $hired['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::HIRED, $hired, $comparison);
    }

    /**
     * Filter the query on the consultant column
     *
     * Example usage:
     * <code>
     * $query->filterByConsultant(1234); // WHERE consultant = 1234
     * $query->filterByConsultant(array(12, 34)); // WHERE consultant IN (12, 34)
     * $query->filterByConsultant(array('min' => 12)); // WHERE consultant > 12
     * </code>
     *
     * @param     mixed $consultant The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByConsultant($consultant = null, $comparison = null)
    {
        if (is_array($consultant)) {
            $useMinMax = false;
            if (isset($consultant['min'])) {
                $this->addUsingAlias(PositionPeer::CONSULTANT, $consultant['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($consultant['max'])) {
                $this->addUsingAlias(PositionPeer::CONSULTANT, $consultant['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::CONSULTANT, $consultant, $comparison);
    }

    /**
     * Filter the query on the other column
     *
     * Example usage:
     * <code>
     * $query->filterByOther(1234); // WHERE other = 1234
     * $query->filterByOther(array(12, 34)); // WHERE other IN (12, 34)
     * $query->filterByOther(array('min' => 12)); // WHERE other > 12
     * </code>
     *
     * @param     mixed $other The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByOther($other = null, $comparison = null)
    {
        if (is_array($other)) {
            $useMinMax = false;
            if (isset($other['min'])) {
                $this->addUsingAlias(PositionPeer::OTHER, $other['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($other['max'])) {
                $this->addUsingAlias(PositionPeer::OTHER, $other['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::OTHER, $other, $comparison);
    }

    /**
     * Filter the query on the planning column
     *
     * Example usage:
     * <code>
     * $query->filterByPlanning(true); // WHERE planning = true
     * $query->filterByPlanning('yes'); // WHERE planning = true
     * </code>
     *
     * @param     boolean|string $planning The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByPlanning($planning = null, $comparison = null)
    {
        if (is_string($planning)) {
            $planning = in_array(strtolower($planning), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(PositionPeer::PLANNING, $planning, $comparison);
    }

    /**
     * Filter the query on the order column
     *
     * Example usage:
     * <code>
     * $query->filterByOrder(1234); // WHERE order = 1234
     * $query->filterByOrder(array(12, 34)); // WHERE order IN (12, 34)
     * $query->filterByOrder(array('min' => 12)); // WHERE order > 12
     * </code>
     *
     * @param     mixed $order The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByOrder($order = null, $comparison = null)
    {
        if (is_array($order)) {
            $useMinMax = false;
            if (isset($order['min'])) {
                $this->addUsingAlias(PositionPeer::ORDER, $order['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($order['max'])) {
                $this->addUsingAlias(PositionPeer::ORDER, $order['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::ORDER, $order, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(PositionPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(PositionPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(PositionPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(PositionPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(PositionPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(PositionPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query by a related Group object
     *
     * @param   Group|PropelObjectCollection $group The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByGroup($group, $comparison = null)
    {
        if ($group instanceof Group) {
            return $this
                ->addUsingAlias(PositionPeer::USERGROUPID, $group->getId(), $comparison);
        } elseif ($group instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionPeer::USERGROUPID, $group->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByGroup() only accepts arguments of type Group or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Group relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinGroup($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Group');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Group');
        }

        return $this;
    }

    /**
     * Use the Group relation Group object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   GroupQuery A secondary query class using the current class as primary query
     */
    public function useGroupQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinGroup($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Group', 'GroupQuery');
    }

    /**
     * Filter the query by a related PositionVersion object
     *
     * @param   PositionVersion|PropelObjectCollection $positionVersion The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPositionVersion($positionVersion, $comparison = null)
    {
        if ($positionVersion instanceof PositionVersion) {
            return $this
                ->addUsingAlias(PositionPeer::VERSIONID, $positionVersion->getId(), $comparison);
        } elseif ($positionVersion instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionPeer::VERSIONID, $positionVersion->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPositionVersion() only accepts arguments of type PositionVersion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PositionVersion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinPositionVersion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PositionVersion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PositionVersion');
        }

        return $this;
    }

    /**
     * Use the PositionVersion relation PositionVersion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionVersionQuery A secondary query class using the current class as primary query
     */
    public function usePositionVersionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPositionVersion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PositionVersion', 'PositionVersionQuery');
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(PositionPeer::ID, $indicator->getPositionid(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorQuery()
                ->filterByPrimaryKeys($indicator->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $objective->getResponsiblecode(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveQuery()
                ->filterByPrimaryKeys($objective->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related ObjectivePosition object
     *
     * @param   ObjectivePosition|PropelObjectCollection $objectivePosition  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectivePosition($objectivePosition, $comparison = null)
    {
        if ($objectivePosition instanceof ObjectivePosition) {
            return $this
                ->addUsingAlias(PositionPeer::ID, $objectivePosition->getPositionid(), $comparison);
        } elseif ($objectivePosition instanceof PropelObjectCollection) {
            return $this
                ->useObjectivePositionQuery()
                ->filterByPrimaryKeys($objectivePosition->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectivePosition() only accepts arguments of type ObjectivePosition or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectivePosition relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinObjectivePosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectivePosition');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectivePosition');
        }

        return $this;
    }

    /**
     * Use the ObjectivePosition relation ObjectivePosition object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectivePositionQuery A secondary query class using the current class as primary query
     */
    public function useObjectivePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjectivePosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectivePosition', 'ObjectivePositionQuery');
    }

    /**
     * Filter the query by a related ObjectiveLog object
     *
     * @param   ObjectiveLog|PropelObjectCollection $objectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveLog($objectiveLog, $comparison = null)
    {
        if ($objectiveLog instanceof ObjectiveLog) {
            return $this
                ->addUsingAlias(PositionPeer::ID, $objectiveLog->getResponsiblecode(), $comparison);
        } elseif ($objectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveLogQuery()
                ->filterByPrimaryKeys($objectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveLog() only accepts arguments of type ObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinObjectiveLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the ObjectiveLog relation ObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveLog', 'ObjectiveLogQuery');
    }

    /**
     * Filter the query by a related AlertDigest object
     *
     * @param   AlertDigest|PropelObjectCollection $alertDigest  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAlertDigest($alertDigest, $comparison = null)
    {
        if ($alertDigest instanceof AlertDigest) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $alertDigest->getPositioncode(), $comparison);
        } elseif ($alertDigest instanceof PropelObjectCollection) {
            return $this
                ->useAlertDigestQuery()
                ->filterByPrimaryKeys($alertDigest->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAlertDigest() only accepts arguments of type AlertDigest or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AlertDigest relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinAlertDigest($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AlertDigest');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AlertDigest');
        }

        return $this;
    }

    /**
     * Use the AlertDigest relation AlertDigest object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AlertDigestQuery A secondary query class using the current class as primary query
     */
    public function useAlertDigestQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinAlertDigest($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AlertDigest', 'AlertDigestQuery');
    }

    /**
     * Filter the query by a related PositionTenure object
     *
     * @param   PositionTenure|PropelObjectCollection $positionTenure  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPositionTenure($positionTenure, $comparison = null)
    {
        if ($positionTenure instanceof PositionTenure) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $positionTenure->getPositioncode(), $comparison);
        } elseif ($positionTenure instanceof PropelObjectCollection) {
            return $this
                ->usePositionTenureQuery()
                ->filterByPrimaryKeys($positionTenure->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPositionTenure() only accepts arguments of type PositionTenure or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PositionTenure relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinPositionTenure($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PositionTenure');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PositionTenure');
        }

        return $this;
    }

    /**
     * Use the PositionTenure relation PositionTenure object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionTenureQuery A secondary query class using the current class as primary query
     */
    public function usePositionTenureQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPositionTenure($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PositionTenure', 'PositionTenureQuery');
    }

    /**
     * Filter the query by a related PositionDocument object
     *
     * @param   PositionDocument|PropelObjectCollection $positionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPositionDocument($positionDocument, $comparison = null)
    {
        if ($positionDocument instanceof PositionDocument) {
            return $this
                ->addUsingAlias(PositionPeer::ID, $positionDocument->getPositionid(), $comparison);
        } elseif ($positionDocument instanceof PropelObjectCollection) {
            return $this
                ->usePositionDocumentQuery()
                ->filterByPrimaryKeys($positionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPositionDocument() only accepts arguments of type PositionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PositionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinPositionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PositionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PositionDocument');
        }

        return $this;
    }

    /**
     * Use the PositionDocument relation PositionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionDocumentQuery A secondary query class using the current class as primary query
     */
    public function usePositionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPositionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PositionDocument', 'PositionDocumentQuery');
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $project->getResponsiblecode(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            return $this
                ->useProjectQuery()
                ->filterByPrimaryKeys($project->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related ProjectActivity object
     *
     * @param   ProjectActivity|PropelObjectCollection $projectActivity  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivity($projectActivity, $comparison = null)
    {
        if ($projectActivity instanceof ProjectActivity) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $projectActivity->getResponsiblecode(), $comparison);
        } elseif ($projectActivity instanceof PropelObjectCollection) {
            return $this
                ->useProjectActivityQuery()
                ->filterByPrimaryKeys($projectActivity->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectActivity() only accepts arguments of type ProjectActivity or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivity relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinProjectActivity($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivity');
        }

        return $this;
    }

    /**
     * Use the ProjectActivity relation ProjectActivity object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectActivity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivity', 'ProjectActivityQuery');
    }

    /**
     * Filter the query by a related ProjectLog object
     *
     * @param   ProjectLog|PropelObjectCollection $projectLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectLog($projectLog, $comparison = null)
    {
        if ($projectLog instanceof ProjectLog) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $projectLog->getResponsiblecode(), $comparison);
        } elseif ($projectLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectLogQuery()
                ->filterByPrimaryKeys($projectLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectLog() only accepts arguments of type ProjectLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinProjectLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectLog');
        }

        return $this;
    }

    /**
     * Use the ProjectLog relation ProjectLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectLog', 'ProjectLogQuery');
    }

    /**
     * Filter the query by a related ProjectActivityLog object
     *
     * @param   ProjectActivityLog|PropelObjectCollection $projectActivityLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivityLog($projectActivityLog, $comparison = null)
    {
        if ($projectActivityLog instanceof ProjectActivityLog) {
            return $this
                ->addUsingAlias(PositionPeer::CODE, $projectActivityLog->getResponsiblecode(), $comparison);
        } elseif ($projectActivityLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectActivityLogQuery()
                ->filterByPrimaryKeys($projectActivityLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectActivityLog() only accepts arguments of type ProjectActivityLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivityLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function joinProjectActivityLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivityLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivityLog');
        }

        return $this;
    }

    /**
     * Use the ProjectActivityLog relation ProjectActivityLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectActivityLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivityLog', 'ProjectActivityLogQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the positions_document table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->usePositionDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Position $position Object to remove from the list of results
     *
     * @return PositionQuery The current query, for fluid interface
     */
    public function prune($position = null)
    {
        if ($position) {
            $this->addUsingAlias(PositionPeer::ID, $position->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to root objects
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function treeRoots()
    {
        return $this->addUsingAlias(PositionPeer::LEFT_COL, 1, Criteria::EQUAL);
    }

    /**
     * Returns the objects in a certain tree, from the tree scope
     *
     * @param     int $scope		Scope to determine which objects node to return
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function inTree($scope = null)
    {
        return $this->addUsingAlias(PositionPeer::SCOPE_COL, $scope, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     Position $position The object to use for descendant search
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function descendantsOf($position)
    {
        return $this
            ->inTree($position->getScopeValue())
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     Position $position The object to use for branch search
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function branchOf($position)
    {
        return $this
            ->inTree($position->getScopeValue())
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     Position $position The object to use for child search
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function childrenOf($position)
    {
        return $this
            ->descendantsOf($position)
            ->addUsingAlias(PositionPeer::LEVEL_COL, $position->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     Position $position The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function siblingsOf($position, PropelPDO $con = null)
    {
        if ($position->isRoot()) {
            return $this->
                add(PositionPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($position->getParent($con))
                ->prune($position);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     Position $position The object to use for ancestors search
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function ancestorsOf($position)
    {
        return $this
            ->inTree($position->getScopeValue())
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(PositionPeer::RIGHT_COL, $position->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     Position $position The object to use for roots search
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function rootsOf($position)
    {
        return $this
            ->inTree($position->getScopeValue())
            ->addUsingAlias(PositionPeer::LEFT_COL, $position->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(PositionPeer::RIGHT_COL, $position->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(PositionPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(PositionPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    PositionQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(PositionPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(PositionPeer::RIGHT_COL);
        }
    }

    /**
     * Returns a root node for the tree
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Position The tree root object
     */
    public function findRoot($scope = null, $con = null)
    {
        return $this
            ->addUsingAlias(PositionPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->inTree($scope)
            ->findOne($con);
    }

    /**
     * Returns the root objects for all trees.
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return    mixed the list of results, formatted by the current formatter
     */
    public function findRoots($con = null)
    {
        return $this
            ->treeRoots()
            ->find($con);
    }

    /**
     * Returns a tree of objects
     *
     * @param      int $scope		Scope to determine which tree node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($scope = null, $con = null)
    {
        return $this
            ->inTree($scope)
            ->orderByBranch()
            ->find($con);
    }

}
