<?php


/**
 * Base class that represents a query for the 'panel_resultFrameIndicator' table.
 *
 * Indicador del Marco de Resultados
 *
 * @method ResultFrameIndicatorQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ResultFrameIndicatorQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ResultFrameIndicatorQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method ResultFrameIndicatorQuery orderByUsedata($order = Criteria::ASC) Order by the useData column
 * @method ResultFrameIndicatorQuery orderByValuetype($order = Criteria::ASC) Order by the valueType column
 * @method ResultFrameIndicatorQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method ResultFrameIndicatorQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method ResultFrameIndicatorQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method ResultFrameIndicatorQuery orderByFrequency($order = Criteria::ASC) Order by the frequency column
 * @method ResultFrameIndicatorQuery orderByBasevalue($order = Criteria::ASC) Order by the baseValue column
 * @method ResultFrameIndicatorQuery orderByDatarecolectioninstrument($order = Criteria::ASC) Order by the dataRecolectionInstrument column
 * @method ResultFrameIndicatorQuery orderByDatarecolectionresponsible($order = Criteria::ASC) Order by the dataRecolectionResponsible column
 * @method ResultFrameIndicatorQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ResultFrameIndicatorQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method ResultFrameIndicatorQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method ResultFrameIndicatorQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 * @method ResultFrameIndicatorQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ResultFrameIndicatorQuery groupById() Group by the id column
 * @method ResultFrameIndicatorQuery groupByName() Group by the name column
 * @method ResultFrameIndicatorQuery groupByType() Group by the type column
 * @method ResultFrameIndicatorQuery groupByUsedata() Group by the useData column
 * @method ResultFrameIndicatorQuery groupByValuetype() Group by the valueType column
 * @method ResultFrameIndicatorQuery groupByContent() Group by the content column
 * @method ResultFrameIndicatorQuery groupByObjecttype() Group by the objectType column
 * @method ResultFrameIndicatorQuery groupByObjectid() Group by the objectId column
 * @method ResultFrameIndicatorQuery groupByFrequency() Group by the frequency column
 * @method ResultFrameIndicatorQuery groupByBasevalue() Group by the baseValue column
 * @method ResultFrameIndicatorQuery groupByDatarecolectioninstrument() Group by the dataRecolectionInstrument column
 * @method ResultFrameIndicatorQuery groupByDatarecolectionresponsible() Group by the dataRecolectionResponsible column
 * @method ResultFrameIndicatorQuery groupByUpdated() Group by the updated column
 * @method ResultFrameIndicatorQuery groupByTreeLeft() Group by the tree_left column
 * @method ResultFrameIndicatorQuery groupByTreeRight() Group by the tree_right column
 * @method ResultFrameIndicatorQuery groupByTreeLevel() Group by the tree_level column
 * @method ResultFrameIndicatorQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ResultFrameIndicatorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ResultFrameIndicatorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ResultFrameIndicatorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ResultFrameIndicatorQuery leftJoinResultFrameValue($relationAlias = null) Adds a LEFT JOIN clause to the query using the ResultFrameValue relation
 * @method ResultFrameIndicatorQuery rightJoinResultFrameValue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ResultFrameValue relation
 * @method ResultFrameIndicatorQuery innerJoinResultFrameValue($relationAlias = null) Adds a INNER JOIN clause to the query using the ResultFrameValue relation
 *
 * @method ResultFrameIndicator findOne(PropelPDO $con = null) Return the first ResultFrameIndicator matching the query
 * @method ResultFrameIndicator findOneOrCreate(PropelPDO $con = null) Return the first ResultFrameIndicator matching the query, or a new ResultFrameIndicator object populated from the query conditions when no match is found
 *
 * @method ResultFrameIndicator findOneById(int $id) Return the first ResultFrameIndicator filtered by the id column
 * @method ResultFrameIndicator findOneByName(string $name) Return the first ResultFrameIndicator filtered by the name column
 * @method ResultFrameIndicator findOneByType(int $type) Return the first ResultFrameIndicator filtered by the type column
 * @method ResultFrameIndicator findOneByUsedata(boolean $useData) Return the first ResultFrameIndicator filtered by the useData column
 * @method ResultFrameIndicator findOneByValuetype(int $valueType) Return the first ResultFrameIndicator filtered by the valueType column
 * @method ResultFrameIndicator findOneByContent(string $content) Return the first ResultFrameIndicator filtered by the content column
 * @method ResultFrameIndicator findOneByObjecttype(string $objectType) Return the first ResultFrameIndicator filtered by the objectType column
 * @method ResultFrameIndicator findOneByObjectid(int $objectId) Return the first ResultFrameIndicator filtered by the objectId column
 * @method ResultFrameIndicator findOneByFrequency(int $frequency) Return the first ResultFrameIndicator filtered by the frequency column
 * @method ResultFrameIndicator findOneByBasevalue(string $baseValue) Return the first ResultFrameIndicator filtered by the baseValue column
 * @method ResultFrameIndicator findOneByDatarecolectioninstrument(string $dataRecolectionInstrument) Return the first ResultFrameIndicator filtered by the dataRecolectionInstrument column
 * @method ResultFrameIndicator findOneByDatarecolectionresponsible(string $dataRecolectionResponsible) Return the first ResultFrameIndicator filtered by the dataRecolectionResponsible column
 * @method ResultFrameIndicator findOneByUpdated(string $updated) Return the first ResultFrameIndicator filtered by the updated column
 * @method ResultFrameIndicator findOneByTreeLeft(int $tree_left) Return the first ResultFrameIndicator filtered by the tree_left column
 * @method ResultFrameIndicator findOneByTreeRight(int $tree_right) Return the first ResultFrameIndicator filtered by the tree_right column
 * @method ResultFrameIndicator findOneByTreeLevel(int $tree_level) Return the first ResultFrameIndicator filtered by the tree_level column
 * @method ResultFrameIndicator findOneByDeletedAt(string $deleted_at) Return the first ResultFrameIndicator filtered by the deleted_at column
 *
 * @method array findById(int $id) Return ResultFrameIndicator objects filtered by the id column
 * @method array findByName(string $name) Return ResultFrameIndicator objects filtered by the name column
 * @method array findByType(int $type) Return ResultFrameIndicator objects filtered by the type column
 * @method array findByUsedata(boolean $useData) Return ResultFrameIndicator objects filtered by the useData column
 * @method array findByValuetype(int $valueType) Return ResultFrameIndicator objects filtered by the valueType column
 * @method array findByContent(string $content) Return ResultFrameIndicator objects filtered by the content column
 * @method array findByObjecttype(string $objectType) Return ResultFrameIndicator objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return ResultFrameIndicator objects filtered by the objectId column
 * @method array findByFrequency(int $frequency) Return ResultFrameIndicator objects filtered by the frequency column
 * @method array findByBasevalue(string $baseValue) Return ResultFrameIndicator objects filtered by the baseValue column
 * @method array findByDatarecolectioninstrument(string $dataRecolectionInstrument) Return ResultFrameIndicator objects filtered by the dataRecolectionInstrument column
 * @method array findByDatarecolectionresponsible(string $dataRecolectionResponsible) Return ResultFrameIndicator objects filtered by the dataRecolectionResponsible column
 * @method array findByUpdated(string $updated) Return ResultFrameIndicator objects filtered by the updated column
 * @method array findByTreeLeft(int $tree_left) Return ResultFrameIndicator objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return ResultFrameIndicator objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return ResultFrameIndicator objects filtered by the tree_level column
 * @method array findByDeletedAt(string $deleted_at) Return ResultFrameIndicator objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseResultFrameIndicatorQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseResultFrameIndicatorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ResultFrameIndicator', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ResultFrameIndicatorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ResultFrameIndicatorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ResultFrameIndicatorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ResultFrameIndicatorQuery) {
            return $criteria;
        }
        $query = new ResultFrameIndicatorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ResultFrameIndicator|ResultFrameIndicator[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ResultFrameIndicatorPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ResultFrameIndicator A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `TYPE`, `USEDATA`, `VALUETYPE`, `CONTENT`, `OBJECTTYPE`, `OBJECTID`, `FREQUENCY`, `BASEVALUE`, `DATARECOLECTIONINSTRUMENT`, `DATARECOLECTIONRESPONSIBLE`, `UPDATED`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL`, `DELETED_AT` FROM `panel_resultFrameIndicator` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ResultFrameIndicator();
            $obj->hydrate($row);
            ResultFrameIndicatorPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ResultFrameIndicator|ResultFrameIndicator[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ResultFrameIndicator[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ResultFrameIndicatorPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ResultFrameIndicatorPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the useData column
     *
     * Example usage:
     * <code>
     * $query->filterByUsedata(true); // WHERE useData = true
     * $query->filterByUsedata('yes'); // WHERE useData = true
     * </code>
     *
     * @param     boolean|string $usedata The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByUsedata($usedata = null, $comparison = null)
    {
        if (is_string($usedata)) {
            $useData = in_array(strtolower($usedata), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::USEDATA, $usedata, $comparison);
    }

    /**
     * Filter the query on the valueType column
     *
     * Example usage:
     * <code>
     * $query->filterByValuetype(1234); // WHERE valueType = 1234
     * $query->filterByValuetype(array(12, 34)); // WHERE valueType IN (12, 34)
     * $query->filterByValuetype(array('min' => 12)); // WHERE valueType > 12
     * </code>
     *
     * @param     mixed $valuetype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByValuetype($valuetype = null, $comparison = null)
    {
        if (is_array($valuetype)) {
            $useMinMax = false;
            if (isset($valuetype['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::VALUETYPE, $valuetype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($valuetype['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::VALUETYPE, $valuetype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::VALUETYPE, $valuetype, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%'); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $content)) {
                $content = str_replace('*', '%', $content);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::CONTENT, $content, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the frequency column
     *
     * Example usage:
     * <code>
     * $query->filterByFrequency(1234); // WHERE frequency = 1234
     * $query->filterByFrequency(array(12, 34)); // WHERE frequency IN (12, 34)
     * $query->filterByFrequency(array('min' => 12)); // WHERE frequency > 12
     * </code>
     *
     * @param     mixed $frequency The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByFrequency($frequency = null, $comparison = null)
    {
        if (is_array($frequency)) {
            $useMinMax = false;
            if (isset($frequency['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::FREQUENCY, $frequency['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($frequency['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::FREQUENCY, $frequency['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::FREQUENCY, $frequency, $comparison);
    }

    /**
     * Filter the query on the baseValue column
     *
     * Example usage:
     * <code>
     * $query->filterByBasevalue('fooValue');   // WHERE baseValue = 'fooValue'
     * $query->filterByBasevalue('%fooValue%'); // WHERE baseValue LIKE '%fooValue%'
     * </code>
     *
     * @param     string $basevalue The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByBasevalue($basevalue = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($basevalue)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $basevalue)) {
                $basevalue = str_replace('*', '%', $basevalue);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::BASEVALUE, $basevalue, $comparison);
    }

    /**
     * Filter the query on the dataRecolectionInstrument column
     *
     * Example usage:
     * <code>
     * $query->filterByDatarecolectioninstrument('fooValue');   // WHERE dataRecolectionInstrument = 'fooValue'
     * $query->filterByDatarecolectioninstrument('%fooValue%'); // WHERE dataRecolectionInstrument LIKE '%fooValue%'
     * </code>
     *
     * @param     string $datarecolectioninstrument The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByDatarecolectioninstrument($datarecolectioninstrument = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($datarecolectioninstrument)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $datarecolectioninstrument)) {
                $datarecolectioninstrument = str_replace('*', '%', $datarecolectioninstrument);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT, $datarecolectioninstrument, $comparison);
    }

    /**
     * Filter the query on the dataRecolectionResponsible column
     *
     * Example usage:
     * <code>
     * $query->filterByDatarecolectionresponsible('fooValue');   // WHERE dataRecolectionResponsible = 'fooValue'
     * $query->filterByDatarecolectionresponsible('%fooValue%'); // WHERE dataRecolectionResponsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $datarecolectionresponsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByDatarecolectionresponsible($datarecolectionresponsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($datarecolectionresponsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $datarecolectionresponsible)) {
                $datarecolectionresponsible = str_replace('*', '%', $datarecolectionresponsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE, $datarecolectionresponsible, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ResultFrameIndicatorPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameIndicatorPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related ResultFrameValue object
     *
     * @param   ResultFrameValue|PropelObjectCollection $resultFrameValue  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ResultFrameIndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByResultFrameValue($resultFrameValue, $comparison = null)
    {
        if ($resultFrameValue instanceof ResultFrameValue) {
            return $this
                ->addUsingAlias(ResultFrameIndicatorPeer::ID, $resultFrameValue->getResultframeindicatorid(), $comparison);
        } elseif ($resultFrameValue instanceof PropelObjectCollection) {
            return $this
                ->useResultFrameValueQuery()
                ->filterByPrimaryKeys($resultFrameValue->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByResultFrameValue() only accepts arguments of type ResultFrameValue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ResultFrameValue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function joinResultFrameValue($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ResultFrameValue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ResultFrameValue');
        }

        return $this;
    }

    /**
     * Use the ResultFrameValue relation ResultFrameValue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ResultFrameValueQuery A secondary query class using the current class as primary query
     */
    public function useResultFrameValueQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinResultFrameValue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ResultFrameValue', 'ResultFrameValueQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ResultFrameIndicator $resultFrameIndicator Object to remove from the list of results
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function prune($resultFrameIndicator = null)
    {
        if ($resultFrameIndicator) {
            $this->addUsingAlias(ResultFrameIndicatorPeer::ID, $resultFrameIndicator->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ResultFrameIndicatorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ResultFrameIndicatorPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameIndicatorPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ResultFrameIndicatorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for descendant search
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function descendantsOf($resultFrameIndicator)
    {
        return $this
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for branch search
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function branchOf($resultFrameIndicator)
    {
        return $this
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for child search
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function childrenOf($resultFrameIndicator)
    {
        return $this
            ->descendantsOf($resultFrameIndicator)
            ->addUsingAlias(ResultFrameIndicatorPeer::LEVEL_COL, $resultFrameIndicator->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function siblingsOf($resultFrameIndicator, PropelPDO $con = null)
    {
        if ($resultFrameIndicator->isRoot()) {
            return $this->
                add(ResultFrameIndicatorPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($resultFrameIndicator->getParent($con))
                ->prune($resultFrameIndicator);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for ancestors search
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function ancestorsOf($resultFrameIndicator)
    {
        return $this
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(ResultFrameIndicatorPeer::RIGHT_COL, $resultFrameIndicator->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ResultFrameIndicator $resultFrameIndicator The object to use for roots search
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function rootsOf($resultFrameIndicator)
    {
        return $this
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, $resultFrameIndicator->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(ResultFrameIndicatorPeer::RIGHT_COL, $resultFrameIndicator->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(ResultFrameIndicatorPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(ResultFrameIndicatorPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(ResultFrameIndicatorPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(ResultFrameIndicatorPeer::RIGHT_COL);
        }
    }

    /**
     * Returns the root node for the tree
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ResultFrameIndicator The tree root object
     */
    public function findRoot($con = null)
    {
        return $this
            ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->findOne($con);
    }

    /**
     * Returns the tree of objects
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($con = null)
    {
        return $this
            ->orderByBranch()
            ->find($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ResultFrameIndicatorQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ResultFrameIndicatorQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ResultFrameIndicatorPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ResultFrameIndicatorPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
