<?php


/**
 * Base class that represents a row from the 'panel_guarantee' table.
 *
 * Base de Garantias
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseGuarantee extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'GuaranteePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        GuaranteePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the code field.
     * @var        string
     */
    protected $code;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the contractorid field.
     * @var        int
     */
    protected $contractorid;

    /**
     * The value for the issuer field.
     * @var        string
     */
    protected $issuer;

    /**
     * The value for the currency field.
     * @var        int
     */
    protected $currency;

    /**
     * The value for the ammount field.
     * @var        string
     */
    protected $ammount;

    /**
     * The value for the issuedate field.
     * @var        string
     */
    protected $issuedate;

    /**
     * The value for the expirationtype field.
     * @var        int
     */
    protected $expirationtype;

    /**
     * The value for the expirationdate field.
     * @var        string
     */
    protected $expirationdate;

    /**
     * The value for the expirationterms field.
     * @var        string
     */
    protected $expirationterms;

    /**
     * The value for the returned field.
     * @var        boolean
     */
    protected $returned;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        Contractor
     */
    protected $aContractor;

    /**
     * @var        PropelObjectCollection|GuaranteeDocument[] Collection to store aggregation of GuaranteeDocument objects.
     */
    protected $collGuaranteeDocuments;
    protected $collGuaranteeDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $guaranteeDocumentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion de la garantia
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [code] column value.
     * Numero o codigo
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Get the [type] column value.
     * Tipo de garantia
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [projectid] column value.
     * Id del proyecto
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [contractorid] column value.
     * Id del contratista
     * @return int
     */
    public function getContractorid()
    {
        return $this->contractorid;
    }

    /**
     * Get the [issuer] column value.
     * Emisor
     * @return string
     */
    public function getIssuer()
    {
        return $this->issuer;
    }

    /**
     * Get the [currency] column value.
     * Moneda
     * @return int
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * Get the [ammount] column value.
     * Monto
     * @return string
     */
    public function getAmmount()
    {
        return $this->ammount;
    }

    /**
     * Get the [optionally formatted] temporal [issuedate] column value.
     * Fecha emision
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getIssuedate($format = '%Y/%m/%d')
    {
        if ($this->issuedate === null) {
            return null;
        }

        if ($this->issuedate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->issuedate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->issuedate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [expirationtype] column value.
     * Tipo de vencimiento
     * @return int
     */
    public function getExpirationtype()
    {
        return $this->expirationtype;
    }

    /**
     * Get the [optionally formatted] temporal [expirationdate] column value.
     * Fecha de vencimiento
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getExpirationdate($format = '%Y/%m/%d')
    {
        if ($this->expirationdate === null) {
            return null;
        }

        if ($this->expirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->expirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->expirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [expirationterms] column value.
     * Terminos de vencimiento
     * @return string
     */
    public function getExpirationterms()
    {
        return $this->expirationterms;
    }

    /**
     * Get the [returned] column value.
     * Garantia devuelta
     * @return boolean
     */
    public function getReturned()
    {
        return $this->returned;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion de la garantia
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = GuaranteePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [code] column.
     * Numero o codigo
     * @param string $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setCode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->code !== $v) {
            $this->code = $v;
            $this->modifiedColumns[] = GuaranteePeer::CODE;
        }


        return $this;
    } // setCode()

    /**
     * Set the value of [type] column.
     * Tipo de garantia
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = GuaranteePeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Set the value of [projectid] column.
     * Id del proyecto
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = GuaranteePeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Set the value of [contractorid] column.
     * Id del contratista
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setContractorid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->contractorid !== $v) {
            $this->contractorid = $v;
            $this->modifiedColumns[] = GuaranteePeer::CONTRACTORID;
        }

        if ($this->aContractor !== null && $this->aContractor->getId() !== $v) {
            $this->aContractor = null;
        }


        return $this;
    } // setContractorid()

    /**
     * Set the value of [issuer] column.
     * Emisor
     * @param string $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setIssuer($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->issuer !== $v) {
            $this->issuer = $v;
            $this->modifiedColumns[] = GuaranteePeer::ISSUER;
        }


        return $this;
    } // setIssuer()

    /**
     * Set the value of [currency] column.
     * Moneda
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setCurrency($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->currency !== $v) {
            $this->currency = $v;
            $this->modifiedColumns[] = GuaranteePeer::CURRENCY;
        }


        return $this;
    } // setCurrency()

    /**
     * Set the value of [ammount] column.
     * Monto
     * @param string $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setAmmount($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ammount !== $v) {
            $this->ammount = $v;
            $this->modifiedColumns[] = GuaranteePeer::AMMOUNT;
        }


        return $this;
    } // setAmmount()

    /**
     * Sets the value of [issuedate] column to a normalized version of the date/time value specified.
     * Fecha emision
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Guarantee The current object (for fluent API support)
     */
    public function setIssuedate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->issuedate !== null || $dt !== null) {
            $currentDateAsString = ($this->issuedate !== null && $tmpDt = new DateTime($this->issuedate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->issuedate = $newDateAsString;
                $this->modifiedColumns[] = GuaranteePeer::ISSUEDATE;
            }
        } // if either are not null


        return $this;
    } // setIssuedate()

    /**
     * Set the value of [expirationtype] column.
     * Tipo de vencimiento
     * @param int $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setExpirationtype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->expirationtype !== $v) {
            $this->expirationtype = $v;
            $this->modifiedColumns[] = GuaranteePeer::EXPIRATIONTYPE;
        }


        return $this;
    } // setExpirationtype()

    /**
     * Sets the value of [expirationdate] column to a normalized version of the date/time value specified.
     * Fecha de vencimiento
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Guarantee The current object (for fluent API support)
     */
    public function setExpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->expirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->expirationdate !== null && $tmpDt = new DateTime($this->expirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->expirationdate = $newDateAsString;
                $this->modifiedColumns[] = GuaranteePeer::EXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setExpirationdate()

    /**
     * Set the value of [expirationterms] column.
     * Terminos de vencimiento
     * @param string $v new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setExpirationterms($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->expirationterms !== $v) {
            $this->expirationterms = $v;
            $this->modifiedColumns[] = GuaranteePeer::EXPIRATIONTERMS;
        }


        return $this;
    } // setExpirationterms()

    /**
     * Sets the value of the [returned] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Garantia devuelta
     * @param boolean|integer|string $v The new value
     * @return Guarantee The current object (for fluent API support)
     */
    public function setReturned($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->returned !== $v) {
            $this->returned = $v;
            $this->modifiedColumns[] = GuaranteePeer::RETURNED;
        }


        return $this;
    } // setReturned()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Guarantee The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = GuaranteePeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->code = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->type = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->projectid = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->contractorid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->issuer = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->currency = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->ammount = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->issuedate = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->expirationtype = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->expirationdate = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->expirationterms = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->returned = ($row[$startcol + 12] !== null) ? (boolean) $row[$startcol + 12] : null;
            $this->deleted_at = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = GuaranteePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Guarantee object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
        if ($this->aContractor !== null && $this->contractorid !== $this->aContractor->getId()) {
            $this->aContractor = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = GuaranteePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->aContractor = null;
            $this->collGuaranteeDocuments = null;

            $this->collDocuments = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = GuaranteeQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && GuaranteeQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                GuaranteePeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                GuaranteePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->aContractor !== null) {
                if ($this->aContractor->isModified() || $this->aContractor->isNew()) {
                    $affectedRows += $this->aContractor->save($con);
                }
                $this->setContractor($this->aContractor);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    GuaranteeDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->guaranteeDocumentsScheduledForDeletion !== null) {
                if (!$this->guaranteeDocumentsScheduledForDeletion->isEmpty()) {
                    GuaranteeDocumentQuery::create()
                        ->filterByPrimaryKeys($this->guaranteeDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->guaranteeDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collGuaranteeDocuments !== null) {
                foreach ($this->collGuaranteeDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = GuaranteePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . GuaranteePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(GuaranteePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(GuaranteePeer::CODE)) {
            $modifiedColumns[':p' . $index++]  = '`CODE`';
        }
        if ($this->isColumnModified(GuaranteePeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(GuaranteePeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(GuaranteePeer::CONTRACTORID)) {
            $modifiedColumns[':p' . $index++]  = '`CONTRACTORID`';
        }
        if ($this->isColumnModified(GuaranteePeer::ISSUER)) {
            $modifiedColumns[':p' . $index++]  = '`ISSUER`';
        }
        if ($this->isColumnModified(GuaranteePeer::CURRENCY)) {
            $modifiedColumns[':p' . $index++]  = '`CURRENCY`';
        }
        if ($this->isColumnModified(GuaranteePeer::AMMOUNT)) {
            $modifiedColumns[':p' . $index++]  = '`AMMOUNT`';
        }
        if ($this->isColumnModified(GuaranteePeer::ISSUEDATE)) {
            $modifiedColumns[':p' . $index++]  = '`ISSUEDATE`';
        }
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONTYPE`';
        }
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONDATE`';
        }
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONTERMS)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONTERMS`';
        }
        if ($this->isColumnModified(GuaranteePeer::RETURNED)) {
            $modifiedColumns[':p' . $index++]  = '`RETURNED`';
        }
        if ($this->isColumnModified(GuaranteePeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_guarantee` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`CODE`':
                        $stmt->bindValue($identifier, $this->code, PDO::PARAM_STR);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`CONTRACTORID`':
                        $stmt->bindValue($identifier, $this->contractorid, PDO::PARAM_INT);
                        break;
                    case '`ISSUER`':
                        $stmt->bindValue($identifier, $this->issuer, PDO::PARAM_STR);
                        break;
                    case '`CURRENCY`':
                        $stmt->bindValue($identifier, $this->currency, PDO::PARAM_INT);
                        break;
                    case '`AMMOUNT`':
                        $stmt->bindValue($identifier, $this->ammount, PDO::PARAM_STR);
                        break;
                    case '`ISSUEDATE`':
                        $stmt->bindValue($identifier, $this->issuedate, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONTYPE`':
                        $stmt->bindValue($identifier, $this->expirationtype, PDO::PARAM_INT);
                        break;
                    case '`EXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->expirationdate, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONTERMS`':
                        $stmt->bindValue($identifier, $this->expirationterms, PDO::PARAM_STR);
                        break;
                    case '`RETURNED`':
                        $stmt->bindValue($identifier, (int) $this->returned, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }

            if ($this->aContractor !== null) {
                if (!$this->aContractor->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aContractor->getValidationFailures());
                }
            }


            if (($retval = GuaranteePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collGuaranteeDocuments !== null) {
                    foreach ($this->collGuaranteeDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = GuaranteePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getCode();
                break;
            case 2:
                return $this->getType();
                break;
            case 3:
                return $this->getProjectid();
                break;
            case 4:
                return $this->getContractorid();
                break;
            case 5:
                return $this->getIssuer();
                break;
            case 6:
                return $this->getCurrency();
                break;
            case 7:
                return $this->getAmmount();
                break;
            case 8:
                return $this->getIssuedate();
                break;
            case 9:
                return $this->getExpirationtype();
                break;
            case 10:
                return $this->getExpirationdate();
                break;
            case 11:
                return $this->getExpirationterms();
                break;
            case 12:
                return $this->getReturned();
                break;
            case 13:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Guarantee'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Guarantee'][$this->getPrimaryKey()] = true;
        $keys = GuaranteePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getCode(),
            $keys[2] => $this->getType(),
            $keys[3] => $this->getProjectid(),
            $keys[4] => $this->getContractorid(),
            $keys[5] => $this->getIssuer(),
            $keys[6] => $this->getCurrency(),
            $keys[7] => $this->getAmmount(),
            $keys[8] => $this->getIssuedate(),
            $keys[9] => $this->getExpirationtype(),
            $keys[10] => $this->getExpirationdate(),
            $keys[11] => $this->getExpirationterms(),
            $keys[12] => $this->getReturned(),
            $keys[13] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aContractor) {
                $result['Contractor'] = $this->aContractor->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collGuaranteeDocuments) {
                $result['GuaranteeDocuments'] = $this->collGuaranteeDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = GuaranteePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setCode($value);
                break;
            case 2:
                $this->setType($value);
                break;
            case 3:
                $this->setProjectid($value);
                break;
            case 4:
                $this->setContractorid($value);
                break;
            case 5:
                $this->setIssuer($value);
                break;
            case 6:
                $this->setCurrency($value);
                break;
            case 7:
                $this->setAmmount($value);
                break;
            case 8:
                $this->setIssuedate($value);
                break;
            case 9:
                $this->setExpirationtype($value);
                break;
            case 10:
                $this->setExpirationdate($value);
                break;
            case 11:
                $this->setExpirationterms($value);
                break;
            case 12:
                $this->setReturned($value);
                break;
            case 13:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = GuaranteePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setCode($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setType($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setProjectid($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setContractorid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setIssuer($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setCurrency($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setAmmount($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setIssuedate($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setExpirationtype($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setExpirationdate($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setExpirationterms($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setReturned($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setDeletedAt($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(GuaranteePeer::DATABASE_NAME);

        if ($this->isColumnModified(GuaranteePeer::ID)) $criteria->add(GuaranteePeer::ID, $this->id);
        if ($this->isColumnModified(GuaranteePeer::CODE)) $criteria->add(GuaranteePeer::CODE, $this->code);
        if ($this->isColumnModified(GuaranteePeer::TYPE)) $criteria->add(GuaranteePeer::TYPE, $this->type);
        if ($this->isColumnModified(GuaranteePeer::PROJECTID)) $criteria->add(GuaranteePeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(GuaranteePeer::CONTRACTORID)) $criteria->add(GuaranteePeer::CONTRACTORID, $this->contractorid);
        if ($this->isColumnModified(GuaranteePeer::ISSUER)) $criteria->add(GuaranteePeer::ISSUER, $this->issuer);
        if ($this->isColumnModified(GuaranteePeer::CURRENCY)) $criteria->add(GuaranteePeer::CURRENCY, $this->currency);
        if ($this->isColumnModified(GuaranteePeer::AMMOUNT)) $criteria->add(GuaranteePeer::AMMOUNT, $this->ammount);
        if ($this->isColumnModified(GuaranteePeer::ISSUEDATE)) $criteria->add(GuaranteePeer::ISSUEDATE, $this->issuedate);
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONTYPE)) $criteria->add(GuaranteePeer::EXPIRATIONTYPE, $this->expirationtype);
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONDATE)) $criteria->add(GuaranteePeer::EXPIRATIONDATE, $this->expirationdate);
        if ($this->isColumnModified(GuaranteePeer::EXPIRATIONTERMS)) $criteria->add(GuaranteePeer::EXPIRATIONTERMS, $this->expirationterms);
        if ($this->isColumnModified(GuaranteePeer::RETURNED)) $criteria->add(GuaranteePeer::RETURNED, $this->returned);
        if ($this->isColumnModified(GuaranteePeer::DELETED_AT)) $criteria->add(GuaranteePeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(GuaranteePeer::DATABASE_NAME);
        $criteria->add(GuaranteePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Guarantee (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setCode($this->getCode());
        $copyObj->setType($this->getType());
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setContractorid($this->getContractorid());
        $copyObj->setIssuer($this->getIssuer());
        $copyObj->setCurrency($this->getCurrency());
        $copyObj->setAmmount($this->getAmmount());
        $copyObj->setIssuedate($this->getIssuedate());
        $copyObj->setExpirationtype($this->getExpirationtype());
        $copyObj->setExpirationdate($this->getExpirationdate());
        $copyObj->setExpirationterms($this->getExpirationterms());
        $copyObj->setReturned($this->getReturned());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getGuaranteeDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addGuaranteeDocument($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Guarantee Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return GuaranteePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new GuaranteePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return Guarantee The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addGuarantee($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addGuarantees($this);
             */
        }

        return $this->aProject;
    }

    /**
     * Declares an association between this object and a Contractor object.
     *
     * @param             Contractor $v
     * @return Guarantee The current object (for fluent API support)
     * @throws PropelException
     */
    public function setContractor(Contractor $v = null)
    {
        if ($v === null) {
            $this->setContractorid(NULL);
        } else {
            $this->setContractorid($v->getId());
        }

        $this->aContractor = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Contractor object, it will not be re-added.
        if ($v !== null) {
            $v->addGuarantee($this);
        }


        return $this;
    }


    /**
     * Get the associated Contractor object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Contractor The associated Contractor object.
     * @throws PropelException
     */
    public function getContractor(PropelPDO $con = null)
    {
        if ($this->aContractor === null && ($this->contractorid !== null)) {
            $this->aContractor = ContractorQuery::create()->findPk($this->contractorid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aContractor->addGuarantees($this);
             */
        }

        return $this->aContractor;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('GuaranteeDocument' == $relationName) {
            $this->initGuaranteeDocuments();
        }
    }

    /**
     * Clears out the collGuaranteeDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGuaranteeDocuments()
     */
    public function clearGuaranteeDocuments()
    {
        $this->collGuaranteeDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collGuaranteeDocumentsPartial = null;
    }

    /**
     * reset is the collGuaranteeDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialGuaranteeDocuments($v = true)
    {
        $this->collGuaranteeDocumentsPartial = $v;
    }

    /**
     * Initializes the collGuaranteeDocuments collection.
     *
     * By default this just sets the collGuaranteeDocuments collection to an empty array (like clearcollGuaranteeDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initGuaranteeDocuments($overrideExisting = true)
    {
        if (null !== $this->collGuaranteeDocuments && !$overrideExisting) {
            return;
        }
        $this->collGuaranteeDocuments = new PropelObjectCollection();
        $this->collGuaranteeDocuments->setModel('GuaranteeDocument');
    }

    /**
     * Gets an array of GuaranteeDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Guarantee is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|GuaranteeDocument[] List of GuaranteeDocument objects
     * @throws PropelException
     */
    public function getGuaranteeDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteeDocumentsPartial && !$this->isNew();
        if (null === $this->collGuaranteeDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collGuaranteeDocuments) {
                // return empty collection
                $this->initGuaranteeDocuments();
            } else {
                $collGuaranteeDocuments = GuaranteeDocumentQuery::create(null, $criteria)
                    ->filterByGuarantee($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collGuaranteeDocumentsPartial && count($collGuaranteeDocuments)) {
                      $this->initGuaranteeDocuments(false);

                      foreach($collGuaranteeDocuments as $obj) {
                        if (false == $this->collGuaranteeDocuments->contains($obj)) {
                          $this->collGuaranteeDocuments->append($obj);
                        }
                      }

                      $this->collGuaranteeDocumentsPartial = true;
                    }

                    return $collGuaranteeDocuments;
                }

                if($partial && $this->collGuaranteeDocuments) {
                    foreach($this->collGuaranteeDocuments as $obj) {
                        if($obj->isNew()) {
                            $collGuaranteeDocuments[] = $obj;
                        }
                    }
                }

                $this->collGuaranteeDocuments = $collGuaranteeDocuments;
                $this->collGuaranteeDocumentsPartial = false;
            }
        }

        return $this->collGuaranteeDocuments;
    }

    /**
     * Sets a collection of GuaranteeDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $guaranteeDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGuaranteeDocuments(PropelCollection $guaranteeDocuments, PropelPDO $con = null)
    {
        $this->guaranteeDocumentsScheduledForDeletion = $this->getGuaranteeDocuments(new Criteria(), $con)->diff($guaranteeDocuments);

        foreach ($this->guaranteeDocumentsScheduledForDeletion as $guaranteeDocumentRemoved) {
            $guaranteeDocumentRemoved->setGuarantee(null);
        }

        $this->collGuaranteeDocuments = null;
        foreach ($guaranteeDocuments as $guaranteeDocument) {
            $this->addGuaranteeDocument($guaranteeDocument);
        }

        $this->collGuaranteeDocuments = $guaranteeDocuments;
        $this->collGuaranteeDocumentsPartial = false;
    }

    /**
     * Returns the number of related GuaranteeDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related GuaranteeDocument objects.
     * @throws PropelException
     */
    public function countGuaranteeDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteeDocumentsPartial && !$this->isNew();
        if (null === $this->collGuaranteeDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collGuaranteeDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getGuaranteeDocuments());
                }
                $query = GuaranteeDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByGuarantee($this)
                    ->count($con);
            }
        } else {
            return count($this->collGuaranteeDocuments);
        }
    }

    /**
     * Method called to associate a GuaranteeDocument object to this object
     * through the GuaranteeDocument foreign key attribute.
     *
     * @param    GuaranteeDocument $l GuaranteeDocument
     * @return Guarantee The current object (for fluent API support)
     */
    public function addGuaranteeDocument(GuaranteeDocument $l)
    {
        if ($this->collGuaranteeDocuments === null) {
            $this->initGuaranteeDocuments();
            $this->collGuaranteeDocumentsPartial = true;
        }
        if (!$this->collGuaranteeDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddGuaranteeDocument($l);
        }

        return $this;
    }

    /**
     * @param	GuaranteeDocument $guaranteeDocument The guaranteeDocument object to add.
     */
    protected function doAddGuaranteeDocument($guaranteeDocument)
    {
        $this->collGuaranteeDocuments[]= $guaranteeDocument;
        $guaranteeDocument->setGuarantee($this);
    }

    /**
     * @param	GuaranteeDocument $guaranteeDocument The guaranteeDocument object to remove.
     */
    public function removeGuaranteeDocument($guaranteeDocument)
    {
        if ($this->getGuaranteeDocuments()->contains($guaranteeDocument)) {
            $this->collGuaranteeDocuments->remove($this->collGuaranteeDocuments->search($guaranteeDocument));
            if (null === $this->guaranteeDocumentsScheduledForDeletion) {
                $this->guaranteeDocumentsScheduledForDeletion = clone $this->collGuaranteeDocuments;
                $this->guaranteeDocumentsScheduledForDeletion->clear();
            }
            $this->guaranteeDocumentsScheduledForDeletion[]= $guaranteeDocument;
            $guaranteeDocument->setGuarantee(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Guarantee is new, it will return
     * an empty collection; or if this Guarantee has previously
     * been saved, it will retrieve related GuaranteeDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Guarantee.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|GuaranteeDocument[] List of GuaranteeDocument objects
     */
    public function getGuaranteeDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = GuaranteeDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getGuaranteeDocuments($query, $con);
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Guarantee is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByGuarantee($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByGuarantee($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the panel_guaranteeDocument cross reference table.
     *
     * @param  Document $document The GuaranteeDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $guaranteeDocument = new GuaranteeDocument();
        $guaranteeDocument->setDocument($document);
        $this->addGuaranteeDocument($guaranteeDocument);
    }

    /**
     * Remove a Document object to this object
     * through the panel_guaranteeDocument cross reference table.
     *
     * @param Document $document The GuaranteeDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->code = null;
        $this->type = null;
        $this->projectid = null;
        $this->contractorid = null;
        $this->issuer = null;
        $this->currency = null;
        $this->ammount = null;
        $this->issuedate = null;
        $this->expirationtype = null;
        $this->expirationdate = null;
        $this->expirationterms = null;
        $this->returned = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collGuaranteeDocuments) {
                foreach ($this->collGuaranteeDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collGuaranteeDocuments instanceof PropelCollection) {
            $this->collGuaranteeDocuments->clearIterator();
        }
        $this->collGuaranteeDocuments = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        $this->aProject = null;
        $this->aContractor = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(GuaranteePeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = GuaranteePeer::isSoftDeleteEnabled()) {
            GuaranteePeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            GuaranteePeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
