<?php
/**
 * PanelSendAlertAction
 *
 */

set_time_limit(720);

require_once 'AlertManager.php';

/**
 * Esta acción está pensada para ser corrida con cron.
 * Para ello se puede usar las siguientes lineas:
 *
 * cd /ruta/del/main/; php Main.php do=panelSendAlert 1>> alert_log 2>> alert_log;
 *
 * Con eso redireccionamos la salida estandar y la de errores al archivo alert_log.
 *
 * Recordar comentar la linea $manager->setTestMode(); cuando se quiera activar efectivamente.
 */

class PanelSendAlertAction extends BaseAction {

	private $debugMode = true;

	function exec() {

		$this->debugMode = $_REQUEST['debug'];

		if ( (!$this->debugMode && empty($_POST['do'])) || !Common::getLoggedUser()->isSupervisor()) {
			die('inaccesible');
		}

		if (parent::exec() === false) {
			return false;
		}

		if ($this->debugMode) {
			echo '<h3 style="color: red;">------ Ejecutando en modo debug ------</h3>';
		}

		$this->template->template = "TemplatePlain.tpl";

		$allRecipients = [];
		$alertManager = new AlertManager();

		$positions = PositionQuery::create()
			->filterByLastVersion()
			->find();

		foreach ($positions as $position) {

			$alertMail = $alertManager->createAlertMail($position);
			if ($alertMail === null) {
				continue;
			}

			$allRecipients[] = $alertMail->getMailTo();

			if ($this->debugMode) {
				$this->printDebugInfo($position, $alertMail);
			} else {
				$result = $alertMail->send();
			}
		}

		if ($this->debugMode) {
			die('<h3  style="color: red;">------ Final modo debug ------</h3>');
		}

		$this->smarty->assign('timestamp', new DateTime());
		$this->smarty->assign('recipientsCount', count($allRecipients));
	}

	private function printDebugInfo($position, $alertMail) {
		echo '<hr>';
		echo '<h2>Alerta para cargo: "'.$position->getName().'"</h2>';
		echo '<h4 style="color: brown;">Email: '.$alertMail->getMailTo().'</h4>';
		echo '<h4 style="color: brown;">Asunto: '.$alertMail->getSubject().'</h4>';
		echo '<div style="border: 1px dashed gray; padding: 0.5em;">';
		echo $alertMail->getBody();
		echo '</div>';
	}

}
