<?php

class PanelReportFilteredAction extends BaseAction {

	function PanelReportFilteredAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);

		//////////
		// Access the Smarty PlugIn instance
		// Note the reference "=&"
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$module = "Panel";
		$section = "Report";

    	$smarty->assign("module",$module);
    	$smarty->assign("section",$section);

		$moduleConfig = Common::getModuleConfiguration($module);
		$smarty->assign("moduleConfig",$moduleConfig);

		if (!empty($_GET["page"])){
			$page = $_GET["page"];
			$smarty->assign("page",$page);
		}
		if (!empty($_GET["filters"])){
			$filters = $_GET["filters"];
			$smarty->assign("filters",$filters);
		}
		if (!empty($_GET["hideActivities"]))
			$smarty->assign("hideActivities",$_GET["hideActivities"]);

		$positionsLatetsVersion = PositionPeer::getLatestVersion();
		$positionPeer = new PositionPeer();
		$positionPeer->setSearchType(11);
		$positionPeer->setSearchVersion($positionsLatetsVersion);
		$positionsFilters = $positionPeer->getAllFiltered();

		$positionsLatetsVersion = PositionPeer::getLatestVersion();

		$positionQuery = PositionQuery::create()->filterByVersionId($positionsLatetsVersion)
										->filterByType(11)
											->_or()
										->filterByPlanning(1)
										->filterByHasObjective();

		if (ConfigModule::get('users', 'useFilterByUserGroup')) {
			$user = Common::getAdminLogged();
			if (!empty($user) && !$user->isAdmin() && !$user->isSupervisor()) {
				$userGroupsIds = Common::getAdminGroupsIds();
				$positionQuery->filterByUsergroupid($userGroupsIds, Criteria::IN);
			}
		}

		$smarty->assign("positionsFilters", $positionQuery->find());

		if ($_GET["toPrint"]) {
			$this->template->template = "TemplateReport.tpl";
			$smarty->assign("toPrint",true);
		}
		if ($_GET["filters"]["positions"]) {
			$positionsLatetsVersion = PositionPeer::getLatestVersion();
			$positionPeer = new PositionPeer();
			$positionPeer->setSearchType(11);
			$positionPeer->setSearchVersion($positionsLatetsVersion);
			$positions = $positionPeer->getAllFiltered();
			$smarty->assign("positions",$positionQuery->find());
		}
		if (isset($_GET["filters"]["positionCode"])) {
			$positions[1] = PositionPeer::getLastByCode($_GET["filters"]["positionCode"]);
			$smarty->assign("positions",$positions);
		}
		if ($_GET["filters"]["objectives"]) {
			$objectives = ObjectivePeer::getAll();
			$smarty->assign("objectives",$objectives);
		}
		if ($_GET["filters"]["strategicObjectives"]) {
			$strategicObjectives = StrategicObjectivePeer::getAll();
			$smarty->assign("strategicObjectives",$strategicObjectives);
		}

		if ($_GET["filters"]["policyGuideline"]) {
			$policyGuidelines = PolicyGuidelinePeer::getAll();
			$smarty->assign("policyGuidelines",$policyGuidelines);
			$policyGuideline = PolicyGuidelinePeer::get($_GET["filters"]["policyGuideline"]);
			$smarty->assign("policyGuideline",$policyGuideline);
		}

		if (!empty($_GET["allExpanded"]))
			$smarty->assign("allExpanded",true);

		if ($_GET["toPdf"]) {
			$this->template->template = "TemplateReport.tpl";
			$smarty->assign("toPdf",true);
			$forwardConfig = $mapping->findForwardConfig('success');
			//obtengo el template
			$template = $forwardConfig->getPath();

			$html_result = $smarty->fetch($template);

			require_once("dompdf/dompdf_config.inc.php");

			$dompdf = new DOMPDF();
			$dompdf->set_paper('A4','landscape');
			$dompdf->load_html($html_result);
			$dompdf->render();
			$dompdf->stream("sample.pdf", array("Attachment" => 0));

			exit;

		}

		return $mapping->findForwardConfig('success');
	}

}
