<?php


/**
 * Base class that represents a query for the 'objectives_policyGuidelineIndicators' table.
 *
 * Relacion PolicyGuideline e Indicadores
 *
 * @method PolicyGuidelineIndicatorsQuery orderByIndicatorid($order = Criteria::ASC) Order by the indicatorId column
 * @method PolicyGuidelineIndicatorsQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 *
 * @method PolicyGuidelineIndicatorsQuery groupByIndicatorid() Group by the indicatorId column
 * @method PolicyGuidelineIndicatorsQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 *
 * @method PolicyGuidelineIndicatorsQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method PolicyGuidelineIndicatorsQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method PolicyGuidelineIndicatorsQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method PolicyGuidelineIndicatorsQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method PolicyGuidelineIndicatorsQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method PolicyGuidelineIndicatorsQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method PolicyGuidelineIndicatorsQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method PolicyGuidelineIndicatorsQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method PolicyGuidelineIndicatorsQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method PolicyGuidelineIndicators findOne(PropelPDO $con = null) Return the first PolicyGuidelineIndicators matching the query
 * @method PolicyGuidelineIndicators findOneOrCreate(PropelPDO $con = null) Return the first PolicyGuidelineIndicators matching the query, or a new PolicyGuidelineIndicators object populated from the query conditions when no match is found
 *
 * @method PolicyGuidelineIndicators findOneByIndicatorid(int $indicatorId) Return the first PolicyGuidelineIndicators filtered by the indicatorId column
 * @method PolicyGuidelineIndicators findOneByPolicyguidelineid(int $policyGuidelineId) Return the first PolicyGuidelineIndicators filtered by the policyGuidelineId column
 *
 * @method array findByIndicatorid(int $indicatorId) Return PolicyGuidelineIndicators objects filtered by the indicatorId column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return PolicyGuidelineIndicators objects filtered by the policyGuidelineId column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BasePolicyGuidelineIndicatorsQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BasePolicyGuidelineIndicatorsQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'PolicyGuidelineIndicators', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new PolicyGuidelineIndicatorsQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     PolicyGuidelineIndicatorsQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return PolicyGuidelineIndicatorsQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof PolicyGuidelineIndicatorsQuery) {
            return $criteria;
        }
        $query = new PolicyGuidelineIndicatorsQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$indicatorId, $policyGuidelineId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   PolicyGuidelineIndicators|PolicyGuidelineIndicators[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = PolicyGuidelineIndicatorsPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelineIndicatorsPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   PolicyGuidelineIndicators A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `INDICATORID`, `POLICYGUIDELINEID` FROM `objectives_policyGuidelineIndicators` WHERE `INDICATORID` = :p0 AND `POLICYGUIDELINEID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new PolicyGuidelineIndicators();
            $obj->hydrate($row);
            PolicyGuidelineIndicatorsPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return PolicyGuidelineIndicators|PolicyGuidelineIndicators[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|PolicyGuidelineIndicators[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(PolicyGuidelineIndicatorsPeer::INDICATORID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(PolicyGuidelineIndicatorsPeer::INDICATORID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the indicatorId column
     *
     * Example usage:
     * <code>
     * $query->filterByIndicatorid(1234); // WHERE indicatorId = 1234
     * $query->filterByIndicatorid(array(12, 34)); // WHERE indicatorId IN (12, 34)
     * $query->filterByIndicatorid(array('min' => 12)); // WHERE indicatorId > 12
     * </code>
     *
     * @see       filterByIndicator()
     *
     * @param     mixed $indicatorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function filterByIndicatorid($indicatorid = null, $comparison = null)
    {
        if (is_array($indicatorid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(PolicyGuidelineIndicatorsPeer::INDICATORID, $indicatorid, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(PolicyGuidelineIndicatorsPeer::INDICATORID, $indicator->getId(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PolicyGuidelineIndicatorsPeer::INDICATORID, $indicator->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   PolicyGuidelineIndicators $policyGuidelineIndicators Object to remove from the list of results
     *
     * @return PolicyGuidelineIndicatorsQuery The current query, for fluid interface
     */
    public function prune($policyGuidelineIndicators = null)
    {
        if ($policyGuidelineIndicators) {
            $this->addCond('pruneCond0', $this->getAliasedColName(PolicyGuidelineIndicatorsPeer::INDICATORID), $policyGuidelineIndicators->getIndicatorid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(PolicyGuidelineIndicatorsPeer::POLICYGUIDELINEID), $policyGuidelineIndicators->getPolicyguidelineid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
