<?php

require_once('ExcelManagement.php');

/**
*
*/
class ObjectivesStrategicObjectivesDoExportAction extends BaseAction
{

	function exec() {
		parent::exec();

		$excelMgmnt = new ExcelManagement;

		$excelMgmnt->removeSheet(0);
		$excelMgmnt->createSheet('Ejes de gestión');
		$excelMgmnt->createSheet('Objetivos');
		$excelMgmnt->createSheet('Proyectos');

		// estilos

		$header = [
			'font' => [
				'size' => 11,
				'bold' => true
			],
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
				'wrap' => true,
				'shrinkToFit' => true,
			],
			'fill' => [
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => ['argb' => 'FF6ECEFC']
			],
			'borders' => [
				'allborders' => [
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => ['rgb' => '000000']
				]
			]
		];

		$title = [
			'font' => [
				'size' => 14,
				'bold' => true
			],
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
				'wrap' => true,
				'shrinkToFit' => true,
			],
		];

		$data = [
			'alignment' => [
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'wrap' => true,
				'shrinkToFit' => true,
			],
			'font' => [
				'size' => 14,
			],
		];

		// Ejes de gestion

		$strategicObjectivesData = [
			['Resumen de Planificación - Ejes de gestión'],
			[],
			[
				'Eje de Gestión',
				'Descripción',
				'Planeamiento Desde',
				'Planeamiento Hasta'
			]
		];

		$strategicObjectivesColumns = [
			['B', 'C', 49],
			['C', 'C', 46],
			['D', 'E', 25]
		];


		// Objetivos

		$objectivesData = [
			['Resumen de Planificación - Objetivos'],
			[],
			[
				'Eje de Gestión',
				'Objetivo',
				'Descripción',
				'Fecha',
				'Vencimiento',
				'Planeamiento Desde',
				'Planeamiento Hasta',
				'Dependencias Comprometidas'
			]
		];

		$objectivesColumns = [
			['B', 'B', 49],
			['C', 'D', 46],
			['E', 'H', 25],
			['I', 'I', 50]
		];


		$projectsData = [
			['Resumen de Planificación - Proyectos'],
			[],
			[
				'Nombre del Proyecto',
				'Responsable',
				'Eje de Gestión',
				'Objetivo',
				'Código Expediente',
				'Descripción',
				'Planeamiento Desde',
				'Planeamiento Hasta',
				'Inicio Planificado',
				'Final Planificado',
				'Inicio Real',
				'Final Real',
				'Objetivo específico',
				'Meta producto',
				'Meta numerica',
				'Prioridad',
				'Impacto',
				'Beneficiario',
				'Visibilidad',
				'Factores de riesgo',
				'Presupuesto',
				'Financiamiento propio',
				'Financiamiento provincial',
				'Financiamiento nacional',
				'Otro financiamiento',
				'Detalle de financiamiento',
				'¿Este proyecto implica compra y/o contratación?',
				'Tipo de compra',
				'¿Este proyecto implica contratación extra de personal?',
				'Frecuencia',
				'Dirección/zona',
				'Terminado',
				'Interés prensa',
				'Progreso',
				'Comentarios adicionales',
				'Es Obra'
			]
		];

		$projectsColumns = [
			['B', 'B', 55],
			['C', 'C', 55],
			['D', 'E', 46],
			['F', 'F', 20],
			['G', 'G', 60],
			['H', 'O', 20],
			['P', 'P', 35],
			['Q', 'Z', 25],
			['AA', 'AB', 25],
			['AC', 'AC', 35],
			['AD', 'AD', 10],
			['AE', 'AE', 30],
			['AF', 'AK', 30],
		];


		$strategicObjectives = StrategicObjectiveQuery::create()->find();

		// defino lo tipos de compra de proyectos
		$projectPurchaseTypes = Project::getPurchaseTypes();

		$strategicObjectivesCount = 0;
		$objectivesCount = 0;
		$projectsCount = 0;

		foreach ($strategicObjectives as $strategicObjective) {
			$strategicObjectivesCount++;

			$strategicObjectiveFormated = [
				$strategicObjective->getName(),
				$strategicObjective->getDescription(),
				$strategicObjective->getStartingYear(),
				$strategicObjective->getEndingYear()
			];

			$strategicObjectivesData[] = $strategicObjectiveFormated;

			$objectives = $strategicObjective->getObjectives();

			foreach ($objectives as $objective) {
				$objectivesCount++;

				$objectiveFormated = [
					$strategicObjective->getName(),
					$objective->getName(),
					$objective->getdescription(),
					$objective->getdate(),
					(!is_null($objective->getexpirationDate()) ? date('d-m-Y', strtotime( $objective->getexpirationDate() )) : null),
					$objective->getStartingYear(),
					$objective->getEndingYear()
				];

				// busco las dependencias asociadas al objetivo y las agrego.
				$relatedPositions = $objective->getRelatedPositions();
				$relatedPositionsFormated = '';

				foreach ($relatedPositions as $objectivePosition) {
					$position = $objectivePosition->getPosition();
					$relatedPositionsFormated = $relatedPositionsFormated . $position->getName() . ', ';
				}

				// agrego las dependencias al array formateado
				array_push($objectiveFormated, $relatedPositionsFormated);

				$objectivesData[] = $objectiveFormated;

				$projects = $objective->getProjects();

				foreach ($projects as $project) {
					$projectsCount++;

					$projectFormated = [
						$project->getname(),
						$project->getResponsibleName(),
						$strategicObjective->getName(),
						$objective->getName(),
						$project->getCode(),
						$project->getdescription(),
						$project->getStartingYear(),
						$project->getEndingYear(),
						(!is_null($project->getplannedStart()) ? date('d-m-Y', strtotime( $project->getplannedStart() )) : null),
						(!is_null($project->getplannedEnd()) ? date('d-m-Y', strtotime( $project->getplannedEnd() )) : null),
						(!is_null($project->getrealStart()) ? date('d-m-Y', strtotime( $project->getrealStart() )) : null),
						(!is_null($project->getrealEnd()) ? date('d-m-Y', strtotime( $project->getrealEnd() )) : null),

						$project->getuniqueGoal(),
						$project->getGoal(),
						$project->getuniqueGoalNumeric(),
						$project->getPriority(),
						$project->getimpact(),
						$project->getBeneficiario(),
						$project->getVisibility(),
						$project->getRiskfactors(),
						$project->getBudgetPlanned(),

						$project->getOwnfinance(),
						$project->getProvincefinance(),
						$project->getNationfinance(),
						$project->getOtherfinance(),
						$project->getFinancedetail(),

						$project->getRequirecontractor() ? 'Si' : 'No',
						$projectPurchaseTypes[$project->getPurchasetype()],

						$project->getRequireexraresources() ? 'Si' : 'No',
						$project->getFrequency(),
						$project->getAddress(),
						$project->getFinished() ? 'Si' : 'No',
						$project->getpress() ? 'Si' : 'No',
						$project->getgoalProgress().'%',
						$project->getNotes(),
						$project->getConstruction() ? 'Si' : 'No'
					];

					$projectsData[] = $projectFormated;
				}
			}
		}

		// agrego columnas que corresponden a titulos y espacios
		$strategicObjectivesCount += 4;
		$objectivesCount += 4;
		$projectsCount += 4;

		// cargo los ejes de gestion
		$excelMgmnt->setActiveSheet(0);
		$excelMgmnt->setRowHeight(4, 30);
		$excelMgmnt->setRowHeight(2, 30);
		$excelMgmnt->applyFormat('B2', 'B2', $title);
		$excelMgmnt->applyFormat('B4', 'E4', $header);
		$excelMgmnt->applyFormat('B4', "E$strategicObjectivesCount", $data);
		$excelMgmnt->setColumnInfoFromArray($strategicObjectivesColumns);

		$excelMgmnt->setDataFromArray($strategicObjectivesData, 'B2');

		// cargo los datos de objetivos
		$excelMgmnt->setActiveSheet(1);
		$excelMgmnt->setRowHeight(4, 30);
		$excelMgmnt->setRowHeight(2, 30);
		$excelMgmnt->applyFormat('B2', 'B2', $title);
		$excelMgmnt->applyFormat('B4', 'I4', $header);
		$excelMgmnt->applyFormat('B4', "I$objectivesCount", $data);
		$excelMgmnt->setColumnInfoFromArray($objectivesColumns);

		$excelMgmnt->setDataFromArray($objectivesData, 'B2');

		// cargo los datos de proyectos
		$excelMgmnt->setActiveSheet(2);
		$excelMgmnt->setRowHeight(4, 30);
		$excelMgmnt->setRowHeight(2, 30);
		$excelMgmnt->applyFormat('B2', 'B2', $title);
		$excelMgmnt->applyFormat('B4', 'AK4', $header);
		$excelMgmnt->applyFormat('B4', "AK$projectsCount", $data);
		$excelMgmnt->setColumnInfoFromArray($projectsColumns);

		$excelMgmnt->setDataFromArray($projectsData, 'B2');

		// defino el nombre y mando el excel al browser
		$fileName = 'Reporte de Planificacion'.date('d-m-Y');
		$excelMgmnt->setActiveSheet(0);
		$excelMgmnt->sendToBrowser($fileName.'.xlsx');
		die;
	}
}